/*
 * Decompiled with CFR 0.152.
 */
package structurevis.data;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import structurevis.data.CollateData;
import structurevis.data.SparseMatrix;

public class CompareCoevolution {
    public static final DecimalFormat df = new DecimalFormat("0.0");
    static double emptyVal = -1000.0;

    public static void printTable(double[][] table, int n, int m) {
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < m; ++j) {
                System.out.print(df.format(table[i][j]) + "\t");
            }
            System.out.println();
        }
    }

    public static double[][] expected(double[][] observed, int n, int m) {
        int j;
        int i;
        double[] t1 = new double[m];
        double[] t2 = new double[n];
        double total = 0.0;
        double[][] expected = new double[n][m];
        for (i = 0; i < n; ++i) {
            for (j = 0; j < m; ++j) {
                int n2 = j;
                t1[n2] = t1[n2] + observed[i][j];
                int n3 = i;
                t2[n3] = t2[n3] + observed[i][j];
                total += observed[i][j];
            }
        }
        for (i = 0; i < n; ++i) {
            for (j = 0; j < m; ++j) {
                expected[i][j] = t1[j] * t2[i] / total;
            }
        }
        return expected;
    }

    public static double chi2(double[][] observed, double[][] expected, int n, int m) {
        double chi2 = 0.0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < m; ++j) {
                if (expected[i][j] == 0.0) continue;
                chi2 += Math.pow(observed[i][j] - expected[i][j], 2.0) / expected[i][j];
            }
        }
        return chi2;
    }

    public static SparseMatrix getCoevolutionMatrix(File coevolutionDir, int parameter) {
        int n = 12000;
        SparseMatrix coevolutionMatrix = new SparseMatrix(n, emptyVal);
        ArrayList<File> files = CollateData.recursivelyListFiles(coevolutionDir);
        for (int i = 0; i < files.size(); ++i) {
            CompareCoevolution.readCoevolutionIntoMatrix(files.get(i), coevolutionMatrix, parameter);
        }
        return coevolutionMatrix;
    }

    public static void readCoevolutionIntoMatrix(File coevolutionFile, SparseMatrix coevolutionMatrix, int parameter) {
        try {
            BufferedReader buffer = new BufferedReader(new FileReader(coevolutionFile));
            if (!coevolutionFile.getName().endsWith(".txt")) {
                return;
            }
            buffer.readLine();
            buffer.readLine();
            String textline = null;
            while ((textline = buffer.readLine()) != null) {
                double dlogl;
                String[] split = textline.split("(\t)+");
                int i = Integer.parseInt(split[0]);
                int j = Integer.parseInt(split[1]);
                if (split.length < 11 || split[4].equals("I") || split[5].equals("I")) continue;
                if (!split[4].equals("NA") && !split[5].equals("NA")) {
                    dlogl = Double.parseDouble(split[4]);
                    double pval = Double.parseDouble(split[5]);
                    double rgained = Double.parseDouble(split[7]);
                    switch (parameter) {
                        case 0: {
                            coevolutionMatrix.set(i, j, pval);
                            break;
                        }
                        case 1: {
                            coevolutionMatrix.set(i, j, dlogl);
                            break;
                        }
                        case 2: {
                            coevolutionMatrix.set(i, j, rgained);
                            break;
                        }
                        case 3: {
                            if (!(rgained > 1.0)) break;
                            coevolutionMatrix.set(i, j, pval);
                            break;
                        }
                        case 4: {
                            if (!(rgained < 1.0)) break;
                            coevolutionMatrix.set(i, j, pval);
                        }
                    }
                    continue;
                }
                dlogl = Double.parseDouble(split[4]);
                double rgained = Double.parseDouble(split[7]);
                switch (parameter) {
                    case 0: {
                        coevolutionMatrix.set(i, j, 1.0);
                        break;
                    }
                    case 1: {
                        coevolutionMatrix.set(i, j, dlogl);
                        break;
                    }
                    case 2: {
                        coevolutionMatrix.set(i, j, rgained);
                    }
                }
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

