/*
 * Decompiled with CFR 0.152.
 */
package structurevis.data;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import structurevis.data.SparseMatrix;

public class CollateData {
    public static final double emptyVal = -1000.0;

    public static void main(String[] args) {
        double[] fa = new double[]{0.6, 0.1, 0.0, 0.3};
        double[] ha = CollateData.getSequenceLogo(fa, 10);
        System.out.println(ha[0] + "\t" + ha[1] + "\t" + ha[2] + "\t" + ha[3] + "\t");
    }

    public static void impute(ArrayList<String> sequences, int end) {
        double[][] distanceMatrix = CollateData.getDistanceMatrix(sequences);
        for (int i = 0; (i < end || end == -1) && i < sequences.size(); ++i) {
            for (int pos = 0; pos < sequences.get(i).length(); ++pos) {
                double minDistance = -1.0;
                int closestSeq = -1;
                if (sequences.get(i).charAt(pos) != '-') continue;
                for (int j = 0; j < sequences.size(); ++j) {
                    if (pos >= sequences.get(j).length() || sequences.get(j).charAt(pos) == '-' || closestSeq != -1 && !(distanceMatrix[i][j] < minDistance)) continue;
                    minDistance = distanceMatrix[i][j];
                    closestSeq = j;
                }
                StringBuffer buf = new StringBuffer(sequences.get(i));
                if (closestSeq == -1) continue;
                buf.setCharAt(pos, sequences.get(closestSeq).charAt(pos));
                sequences.set(i, buf.toString());
            }
        }
    }

    public static double[] getWeights(ArrayList<String> sequences) {
        double[][] distanceMatrix = CollateData.getDistanceMatrix(sequences);
        double[] weights = new double[sequences.size()];
        int i = 0;
        while (i < weights.length) {
            for (int j = 0; j < weights.length; ++j) {
                int n = i;
                weights[n] = weights[n] + distanceMatrix[i][j];
            }
            int n = i++;
            weights[n] = weights[n] / (double)weights.length;
        }
        return weights;
    }

    public static double[][] getNucleotideComposition(ArrayList<String> sequences, double[] weights) {
        int i;
        int seqLength = sequences.get(0).length();
        double[][] nucleotideComposition = new double[seqLength][5];
        for (i = 0; i < seqLength; ++i) {
            block7: for (int j = 0; j < sequences.size(); ++j) {
                char c = sequences.get(j).charAt(i);
                switch (c) {
                    case 'A': {
                        double[] dArray = nucleotideComposition[i];
                        dArray[0] = dArray[0] + weights[j];
                        continue block7;
                    }
                    case 'C': {
                        double[] dArray = nucleotideComposition[i];
                        dArray[1] = dArray[1] + weights[j];
                        continue block7;
                    }
                    case 'G': {
                        double[] dArray = nucleotideComposition[i];
                        dArray[2] = dArray[2] + weights[j];
                        continue block7;
                    }
                    case 'T': {
                        double[] dArray = nucleotideComposition[i];
                        dArray[3] = dArray[3] + weights[j];
                        continue block7;
                    }
                    default: {
                        double[] dArray = nucleotideComposition[i];
                        dArray[4] = dArray[4] + weights[j];
                    }
                }
            }
        }
        for (i = 0; i < seqLength; ++i) {
            int j;
            double gapsum = 0.0;
            double sum = 0.0;
            for (int j2 = 0; j2 < 5; ++j2) {
                gapsum += nucleotideComposition[i][j2];
                if (j2 == 4) continue;
                sum += nucleotideComposition[i][j2];
            }
            String s = i + "\t";
            for (j = 0; j < 5; ++j) {
                s = s + nucleotideComposition[i][j] / gapsum + "\t";
            }
            for (j = 0; j < 5; ++j) {
                s = s + nucleotideComposition[i][j] / sum + "\t";
            }
        }
        return nucleotideComposition;
    }

    public static double[] getSequenceLogoAtI(ArrayList<String> sequences, int i, double[] weights) {
        int n = 0;
        for (int j = 0; j < sequences.size(); ++j) {
            if (sequences.get(j).charAt(i) == '-') continue;
            ++n;
        }
        double[] fa = CollateData.getFrequenciesAtI(sequences, i, weights);
        return CollateData.getSequenceLogo(fa, n);
    }

    public static double[] getFrequenciesAtI(ArrayList<String> sequences, int i, double[] weights) {
        double[] fa = new double[4];
        block6: for (int j = 0; j < sequences.size(); ++j) {
            char c = sequences.get(j).charAt(i);
            switch (c) {
                case 'A': {
                    fa[0] = fa[0] + weights[j];
                    continue block6;
                }
                case 'C': {
                    fa[1] = fa[1] + weights[j];
                    continue block6;
                }
                case 'G': {
                    fa[2] = fa[2] + weights[j];
                    continue block6;
                }
                case 'T': {
                    fa[3] = fa[3] + weights[j];
                }
            }
        }
        double t = fa[0] + fa[1] + fa[2] + fa[3];
        for (int k = 0; k < 4; ++k) {
            fa[k] = fa[k] / t;
        }
        return fa;
    }

    public static double[] getSequenceLogo(double[] fa, int n) {
        double[] ha = new double[4];
        double Hi = 0.0;
        double en = 3.0 / (2.0 * Math.log(2.0) * (double)n);
        en = 0.0;
        for (int a = 0; a < 4; ++a) {
            double log2fa = Math.log(fa[a]) / Math.log(2.0);
            if (fa[a] == 0.0) {
                Hi += 0.0;
                continue;
            }
            Hi += -(log2fa * fa[a]);
        }
        double Ri = 2.0 - (Hi + en);
        for (int a = 0; a < 4; ++a) {
            ha[a] = fa[a] * Ri;
        }
        return ha;
    }

    public static double[][] getDistanceMatrix(ArrayList<String> sequences) {
        int len = sequences.size();
        double[][] distanceMatrix = new double[len][len];
        for (int i = 0; i < len; ++i) {
            for (int j = 0; j < len; ++j) {
                distanceMatrix[i][j] = CollateData.distanceIgnoringGaps(sequences.get(i), sequences.get(j));
            }
        }
        return distanceMatrix;
    }

    public static int distanceIgnoringGaps(String seq1, String seq2) {
        int dist = 0;
        int length = Math.min(seq1.length(), seq2.length());
        for (int i = 0; i < length; ++i) {
            if (seq1.charAt(i) == '-' || seq2.charAt(i) == '-' || seq1.charAt(i) == seq2.charAt(i)) continue;
            ++dist;
        }
        return dist;
    }

    public static void loadFastaSequences(File file, ArrayList<String> sequences, ArrayList<String> sequenceNames) {
        int newMaxSequenceLength = 0;
        try {
            BufferedReader buffer = new BufferedReader(new FileReader(file));
            String textline = null;
            String sequence = "";
            while ((textline = buffer.readLine()) != null) {
                if (textline.startsWith(">")) {
                    sequenceNames.add(textline.substring(1));
                    if (sequence.equals("")) continue;
                    sequences.add(sequence);
                    sequence = "";
                    continue;
                }
                sequence = sequence + textline.trim();
            }
            buffer.close();
            if (!sequence.equals("")) {
                newMaxSequenceLength = Math.max(newMaxSequenceLength, sequence.length());
                sequences.add(sequence);
            }
        }
        catch (IOException ex) {
            // empty catch block
        }
    }

    public static SparseMatrix getNaspMatrix(File naspMatrixFile) {
        try {
            BufferedReader buffer = new BufferedReader(new FileReader(naspMatrixFile));
            int n = buffer.readLine().split(",").length - 1;
            SparseMatrix naspMatrix = new SparseMatrix(n, -1000.0);
            String textline = null;
            int i = 0;
            while ((textline = buffer.readLine()) != null) {
                String[] split = textline.split(",");
                for (int j = 1; j < n && j < split.length; ++j) {
                    double nasp = Double.parseDouble(split[j]);
                    if (nasp == 0.0) continue;
                    naspMatrix.set(i, j - 1, nasp);
                }
                ++i;
            }
            buffer.close();
            return naspMatrix;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static ArrayList<File> recursivelyListFiles(File dir) {
        ArrayList<File> files = new ArrayList<File>();
        CollateData.recursivelyListFiles(dir, files);
        return files;
    }

    public static void recursivelyListFiles(File dir, ArrayList<File> files) {
        File[] list = dir.listFiles();
        for (int i = 0; i < list.length; ++i) {
            if (list[i].isFile()) {
                files.add(list[i]);
                continue;
            }
            if (!list[i].isDirectory()) continue;
            CollateData.recursivelyListFiles(list[i], files);
        }
    }

    public static SparseMatrix getCoevolutionMatrix(File coevolutionDir, boolean pvals) {
        int n = 12000;
        SparseMatrix coevolutionMatrix = new SparseMatrix(n, -1000.0);
        ArrayList<File> files = CollateData.recursivelyListFiles(coevolutionDir);
        for (int i = 0; i < files.size(); ++i) {
            CollateData.readCoevolutionIntoMatrix(files.get(i), coevolutionMatrix, pvals);
        }
        return coevolutionMatrix;
    }

    public static SparseMatrix readCoevolutionIntoMatrix2(File coevolutionFile) {
        SparseMatrix coevolutionMatrix = new SparseMatrix(12000, -1000.0);
        try {
            BufferedReader buffer = new BufferedReader(new FileReader(coevolutionFile));
            buffer.readLine();
            buffer.readLine();
            String textline = null;
            while ((textline = buffer.readLine()) != null) {
                String[] split = textline.split("(\t)+");
                int i = Integer.parseInt(split[0]);
                int j = Integer.parseInt(split[1]);
                if (split[4].equals("I") || split[5].equals("I") || split[4].equals("NA") || split[5].equals("NA")) continue;
                double pval = Double.parseDouble(split[4]);
                coevolutionMatrix.set(i, j, pval);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return coevolutionMatrix;
    }

    public static void readCoevolutionIntoMatrix(File coevolutionFile, SparseMatrix coevolutionMatrix, boolean pvals) {
        try {
            BufferedReader buffer = new BufferedReader(new FileReader(coevolutionFile));
            buffer.readLine();
            buffer.readLine();
            String textline = null;
            while ((textline = buffer.readLine()) != null) {
                String[] split = textline.split("(\t)+");
                int i = Integer.parseInt(split[0]);
                int j = Integer.parseInt(split[1]);
                if (split.length < 6 || split[4].equals("I") || split[5].equals("I") || split[4].equals("NA") || split[5].equals("NA")) continue;
                double dlogl = Double.parseDouble(split[4]);
                double pval = Double.parseDouble(split[5]);
                if (pvals) {
                    coevolutionMatrix.set(i, j, pval);
                    continue;
                }
                coevolutionMatrix.set(i, j, dlogl);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static int[][] readNaspCtFile(File naspCtFile) {
        Object pairs = new int[][]{};
        try {
            BufferedReader buffer = new BufferedReader(new FileReader(naspCtFile));
            String textline = buffer.readLine();
            String[] split = textline.split("\t");
            int len = Integer.parseInt(split[0]);
            pairs = new int[2][len];
            int i = 0;
            while ((textline = buffer.readLine()) != null) {
                split = textline.split("\t");
                pairs[0][i] = Integer.parseInt(split[5]);
                pairs[1][i] = Integer.parseInt(split[4]);
                ++i;
            }
            buffer.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return pairs;
    }
}

