/*
 * Decompiled with CFR 0.152.
 */
package jaligner.util;

import jaligner.Sequence;
import jaligner.util.SequenceParserException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SequenceParser {
    private static final Logger logger = Logger.getLogger((class$jaligner$util$SequenceParser == null ? (class$jaligner$util$SequenceParser = SequenceParser.class$("jaligner.util.SequenceParser")) : class$jaligner$util$SequenceParser).getName());
    static /* synthetic */ Class class$jaligner$util$SequenceParser;

    public static Sequence parse(String sequence) throws SequenceParserException {
        if (sequence == null) {
            throw new SequenceParserException("Null sequence");
        }
        if (sequence.trim().length() == 0) {
            throw new SequenceParserException("Empty sequence");
        }
        sequence = sequence.replaceAll("\r\n", "\n");
        String sequenceName = null;
        String sequenceDescription = null;
        if (sequence.startsWith(">")) {
            int index = sequence.indexOf("\n");
            if (index == -1) {
                throw new SequenceParserException("Invalid sequence format");
            }
            String first = sequence.substring(1, index);
            sequence = sequence.substring(index);
            index = 0;
            int i = 0;
            while (i < first.length() && first.charAt(i) != ' ' && first.charAt(i) != '\t') {
                ++i;
                ++index;
            }
            sequenceName = first.substring(0, index);
            StringTokenizer stringTokenizer = new StringTokenizer(sequenceName, "|");
            while (stringTokenizer.hasMoreTokens()) {
                sequenceName = stringTokenizer.nextToken();
            }
            sequenceDescription = index + 1 > first.length() ? "" : first.substring(index + 1);
        }
        Sequence s = new Sequence(SequenceParser.prepare(sequence), sequenceName, sequenceDescription, 1);
        return s;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Sequence parse(File file) throws SequenceParserException {
        Sequence sequence;
        String sequenceName = null;
        String sequenceDescription = null;
        BufferedReader reader = null;
        try {
            try {
                Sequence s;
                reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
                StringBuffer buffer = new StringBuffer();
                String line = reader.readLine();
                if (line.startsWith(">")) {
                    line = line.substring(1).trim();
                    int index = 0;
                    for (int i = 0; i < line.length() && line.charAt(i) != ' ' && line.charAt(i) != '\t'; ++i, ++index) {
                    }
                    sequenceName = line.substring(0, index);
                    StringTokenizer stringTokenizer = new StringTokenizer(sequenceName, "|");
                    while (stringTokenizer.hasMoreTokens()) {
                        sequenceName = stringTokenizer.nextToken();
                    }
                    sequenceDescription = index + 1 > line.length() ? "" : line.substring(index + 1);
                } else {
                    buffer.append(SequenceParser.prepare(line));
                }
                while ((line = reader.readLine()) != null) {
                    buffer.append(SequenceParser.prepare(line));
                }
                reader.close();
                sequence = s = new Sequence(buffer.toString(), sequenceName, sequenceDescription, 1);
                Object var9_11 = null;
                if (reader == null) return sequence;
            }
            catch (Exception e) {
                throw new SequenceParserException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            if (reader == null) throw throwable;
            try {
                reader.close();
                throw throwable;
            }
            catch (Exception silent) {
                logger.log(Level.WARNING, "Failed closing reader: " + silent.getMessage(), silent);
                throw throwable;
            }
        }
        try {}
        catch (Exception silent) {
            logger.log(Level.WARNING, "Failed closing reader: " + silent.getMessage(), silent);
            return sequence;
        }
        reader.close();
        return sequence;
    }

    private static String prepare(String sequence) throws SequenceParserException {
        StringBuffer buffer = new StringBuffer();
        String copy = sequence.trim().toUpperCase();
        int n = copy.length();
        block4: for (int i = 0; i < n; ++i) {
            switch (copy.charAt(i)) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block4;
                }
                case '*': 
                case '-': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': 
                case 'Z': {
                    buffer.append(copy.charAt(i));
                    continue block4;
                }
                default: {
                    throw new SequenceParserException("Invalid sequence character: '" + copy.charAt(i) + "'");
                }
            }
        }
        return buffer.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

