/*
 * Decompiled with CFR 0.152.
 */
package jaligner.ui.util;

import jaligner.ui.clipboard.ClipboardHandlerFactory;
import jaligner.ui.filechooser.FileChooserFactory;
import jaligner.ui.filechooser.NamedInputStream;
import jaligner.ui.util.PrintJobMointor;
import jaligner.ui.util.TextComponentUtilException;
import jaligner.util.Commons;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.ServiceUI;
import javax.print.SimpleDoc;
import javax.print.attribute.HashDocAttributeSet;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.DocumentName;
import javax.print.attribute.standard.JobName;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public class TextComponentUtil {
    private static final String EMPTY = "";
    private static final Logger logger = Logger.getLogger((class$jaligner$ui$util$TextComponentUtil == null ? (class$jaligner$ui$util$TextComponentUtil = TextComponentUtil.class$("jaligner.ui.util.TextComponentUtil")) : class$jaligner$ui$util$TextComponentUtil).getName());
    static /* synthetic */ Class class$jaligner$ui$util$TextComponentUtil;

    public static void cut(JTextComponent textComponent) {
        TextComponentUtil.copy(textComponent);
        TextComponentUtil.delete(textComponent);
    }

    public static void copy(JTextComponent textComponent) {
        ClipboardHandlerFactory.getClipboardHandler().setContents(textComponent.getSelectedText());
    }

    public static void paste(JTextComponent textComponent) {
        String contents = ClipboardHandlerFactory.getClipboardHandler().getContents();
        if (contents != null) {
            StringBuffer buffer = new StringBuffer();
            int n = contents.length();
            for (int i = 0; i < n; ++i) {
                char c = contents.charAt(i);
                if (c == '\u0000') continue;
                buffer.append(c);
            }
            textComponent.replaceSelection(buffer.toString());
        }
        if (!textComponent.hasFocus()) {
            textComponent.requestFocus();
        }
    }

    public static void delete(JTextComponent textComponent) {
        textComponent.replaceSelection(EMPTY);
    }

    public static void selectAll(JTextComponent textComponent) {
        if (!textComponent.hasFocus()) {
            textComponent.requestFocus();
        }
        textComponent.selectAll();
    }

    /*
     * Loose catch block
     */
    public static boolean open(JTextComponent textComponent) throws TextComponentUtilException {
        Exception e222;
        boolean bl;
        BufferedReader reader;
        InputStream is;
        block21: {
            block18: {
                Exception e222;
                boolean bl2;
                block19: {
                    String line;
                    is = null;
                    reader = null;
                    NamedInputStream selectedInputStream = FileChooserFactory.getFileChooser().open();
                    if (selectedInputStream == null) break block18;
                    is = selectedInputStream.getInputStream();
                    textComponent.setText(EMPTY);
                    reader = new BufferedReader(new InputStreamReader(is));
                    Document document = textComponent.getDocument();
                    while ((line = reader.readLine()) != null) {
                        document.insertString(document.getLength(), line + Commons.getLineSeparator(), null);
                    }
                    if (!textComponent.hasFocus()) {
                        textComponent.requestFocus();
                    }
                    bl2 = true;
                    Object var8_9 = null;
                    if (is == null) break block19;
                    try {
                        is.close();
                    }
                    catch (Exception e222) {
                        logger.log(Level.WARNING, "Failed closing input stream: " + e222.getMessage(), e222);
                    }
                }
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Exception e222) {
                        logger.log(Level.WARNING, "Failed closing reader: " + e222.getMessage(), e222);
                    }
                }
                return bl2;
            }
            bl = false;
            Object var8_10 = null;
            if (is == null) break block21;
            try {
                is.close();
            }
            catch (Exception e222) {
                logger.log(Level.WARNING, "Failed closing input stream: " + e222.getMessage(), e222);
            }
        }
        if (reader != null) {
            try {
                reader.close();
            }
            catch (Exception e222) {
                logger.log(Level.WARNING, "Failed closing reader: " + e222.getMessage(), e222);
            }
        }
        return bl;
        catch (Exception e3) {
            try {
                throw new TextComponentUtilException(e3.getMessage());
            }
            catch (Throwable throwable) {
                block23: {
                    Exception e222;
                    Object var8_11 = null;
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Exception e222) {
                            logger.log(Level.WARNING, "Failed closing input stream: " + e222.getMessage(), e222);
                        }
                    }
                    if (reader == null) break block23;
                    try {
                        reader.close();
                    }
                    catch (Exception e222) {
                        logger.log(Level.WARNING, "Failed closing reader: " + e222.getMessage(), e222);
                    }
                }
                throw throwable;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean save(JTextComponent textComponent, String fileName) throws TextComponentUtilException {
        boolean bl;
        ByteArrayInputStream is = null;
        try {
            try {
                is = new ByteArrayInputStream(textComponent.getText().getBytes());
                bl = FileChooserFactory.getFileChooser().save(is, fileName);
                Object var5_5 = null;
            }
            catch (Exception e) {
                throw new TextComponentUtilException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            try {
                ((InputStream)is).close();
                throw throwable;
            }
            catch (Exception e2) {
                logger.log(Level.WARNING, "Failed closing input stream: " + e2.getMessage(), e2);
                throw throwable;
            }
        }
        try {}
        catch (Exception e2) {
            logger.log(Level.WARNING, "Failed closing input stream: " + e2.getMessage(), e2);
            return bl;
        }
        ((InputStream)is).close();
        return bl;
    }

    public static boolean save(JTextComponent textComponent) throws TextComponentUtilException {
        return TextComponentUtil.save(textComponent, null);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void print(JTextComponent textComponent) throws TextComponentUtilException {
        InputStream is = null;
        PrintService[] printServices = PrintServiceLookup.lookupPrintServices(DocFlavor.INPUT_STREAM.AUTOSENSE, null);
        if (printServices.length <= 0) throw new TextComponentUtilException("No print service found!");
        HashPrintRequestAttributeSet printRequestAttributeSet = new HashPrintRequestAttributeSet();
        printRequestAttributeSet.add(new JobName("JAligner", null));
        PrintService service = ServiceUI.printDialog(null, 50, 50, printServices, PrintServiceLookup.lookupDefaultPrintService(), DocFlavor.INPUT_STREAM.AUTOSENSE, printRequestAttributeSet);
        if (service != null) {
            DocPrintJob printJob = service.createPrintJob();
            PrintJobMointor printJobMointor = new PrintJobMointor(printJob);
            is = new ByteArrayInputStream(textComponent.getText().getBytes());
            DocumentName documentName = new DocumentName("JAligner", null);
            HashDocAttributeSet docAttributeSet = new HashDocAttributeSet();
            docAttributeSet.add(documentName);
            SimpleDoc doc = new SimpleDoc(is, DocFlavor.INPUT_STREAM.AUTOSENSE, docAttributeSet);
            printJob.print(doc, printRequestAttributeSet);
            printJobMointor.waitForPrintJob();
        }
        Object var11_11 = null;
        if (is == null) return;
        try {
            is.close();
            return;
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Failed closing input stream: " + e.getMessage(), e);
        }
        return;
        {
            catch (Exception e) {
                throw new TextComponentUtilException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            if (is == null) throw throwable;
            try {
                is.close();
                throw throwable;
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Failed closing input stream: " + e.getMessage(), e);
            }
            throw throwable;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

