/*
 * Decompiled with CFR 0.152.
 */
package jaligner.ui.logging;

import jaligner.ui.logging.RecordFormatter;
import java.awt.Color;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.swing.JTextPane;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class DocumentHandler
extends Handler {
    private static final int MAXIMUM_DOCUMENT_SIZE = 524288;
    private JTextPane textPane = null;
    private Style infoStyle = null;
    private Style severStyle = null;

    public DocumentHandler(JTextPane textPane) {
        this.textPane = textPane;
        this.setFormatter(new RecordFormatter());
        StyledDocument document = (StyledDocument)this.textPane.getDocument();
        this.infoStyle = document.addStyle("INFO", null);
        StyleConstants.setFontFamily(this.infoStyle, "Monospaced");
        StyleConstants.setBackground(this.infoStyle, Color.white);
        StyleConstants.setForeground(this.infoStyle, Color.blue);
        this.severStyle = document.addStyle("SEVER", null);
        StyleConstants.setFontFamily(this.severStyle, "Monospaced");
        StyleConstants.setBackground(this.severStyle, Color.white);
        StyleConstants.setForeground(this.severStyle, Color.red);
    }

    public void close() {
    }

    public void flush() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(LogRecord record) {
        String message;
        if (!this.isLoggable(record)) {
            return;
        }
        try {
            message = this.getFormatter().format(record);
        }
        catch (Exception exception) {
            this.reportError(null, exception, 5);
            return;
        }
        JTextPane jTextPane = this.textPane;
        synchronized (jTextPane) {
            if (this.textPane.getDocument().getLength() >= 524288) {
                this.textPane.setText("");
            }
            try {
                if (record.getLevel() == Level.SEVERE) {
                    this.textPane.getDocument().insertString(this.textPane.getDocument().getLength(), message, this.severStyle);
                } else {
                    this.textPane.getDocument().insertString(this.textPane.getDocument().getLength(), message, this.infoStyle);
                }
                this.textPane.setCaretPosition(this.textPane.getDocument().getLength());
            }
            catch (Exception ex) {
                this.reportError(null, ex, 1);
            }
        }
    }
}

