/*
 * Decompiled with CFR 0.152.
 */
package jaligner.ui.clipboard;

import jaligner.ui.clipboard.ClipboardHandlerFactory;
import jaligner.ui.clipboard.ClipboardListener;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClipboardPoller
extends Thread {
    private static final int SLEEPING_TIME_IN_MILLISECONDS = 1500;
    private ClipboardListener listener = null;
    private boolean running = false;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    public ClipboardPoller(ClipboardListener listener) {
        this.listener = listener;
    }

    public void run() {
        this.logger.info("Started");
        while (this.running) {
            String contents = ClipboardHandlerFactory.getClipboardHandler().getContents();
            this.listener.clipboardCheck(contents);
            try {
                Thread.sleep(1500L);
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Failed sleeping: " + e.getMessage(), e);
                this.running = false;
            }
        }
        this.logger.info("Stopped");
    }

    public void start() {
        this.logger.info("Starting...");
        if (!this.running) {
            if (this.listener != null) {
                this.running = true;
            } else {
                this.logger.warning("No listener");
            }
        } else {
            this.logger.warning("Already started");
        }
        super.start();
    }
}

