/*
 * Decompiled with CFR 0.152.
 */
package jaligner.ui;

import jaligner.Alignment;
import jaligner.Sequence;
import jaligner.SmithWatermanGotoh;
import jaligner.formats.Pair;
import jaligner.matrix.Matrix;
import jaligner.matrix.MatrixLoader;
import jaligner.ui.AlignWindow;
import jaligner.util.Commons;
import jaligner.util.SequenceParser;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AlignCommandLine {
    private static final Logger logger = Logger.getLogger((class$jaligner$ui$AlignCommandLine == null ? (class$jaligner$ui$AlignCommandLine = AlignCommandLine.class$("jaligner.ui.AlignCommandLine")) : class$jaligner$ui$AlignCommandLine).getName());
    static /* synthetic */ Class class$jaligner$ui$AlignCommandLine;

    public static void main(String[] args) {
        logger.info(Commons.getJAlignerInfo());
        if (args.length == 0) {
            new AlignWindow().setVisible(true);
        } else if (args.length == 5) {
            try {
                String f1 = args[0];
                String f2 = args[1];
                String m = args[2];
                float o = Float.parseFloat(args[3]);
                float e = Float.parseFloat(args[4]);
                Sequence s1 = SequenceParser.parse(new File(f1));
                Sequence s2 = SequenceParser.parse(new File(f2));
                Matrix matrix = MatrixLoader.load(m);
                Alignment alignment = SmithWatermanGotoh.align(s1, s2, matrix, o, e);
                System.out.println(alignment.getSummary());
                System.out.println(new Pair().format(alignment));
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Failed processing the command line: " + e.getMessage(), e);
                System.exit(1);
            }
        } else {
            logger.severe("Invalid number of arguments: " + args.length);
            AlignCommandLine.printUsage();
            System.exit(1);
        }
    }

    private static void printUsage() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("\n");
        buffer.append("Usage:\n");
        buffer.append("------\n");
        buffer.append("[1] java -jar jaligner.jar <s1> <s2> <matrix> <open> <extend>\n");
        buffer.append("[2] java -jar jaligner.jar\n");
        buffer.append("\n");
        logger.info(buffer.toString());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

