/*
 * Decompiled with CFR 0.152.
 */
package jaligner.test;

import jaligner.Alignment;
import jaligner.Sequence;
import jaligner.SmithWatermanGotoh;
import jaligner.formats.Format;
import jaligner.formats.Pair;
import jaligner.matrix.Matrix;
import jaligner.matrix.MatrixLoader;
import jaligner.test.RandomSequenceGenerator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;

public class AlignmentScoreChecker {
    public static void main(String[] args) {
        int numberOfTests = Integer.parseInt(args[0]);
        int sequencesSize = Integer.parseInt(args[1]);
        Random random = new Random();
        Pair format = new Pair();
        try {
            ArrayList matrices = new ArrayList();
            Iterator i = MatrixLoader.list().iterator();
            while (i.hasNext()) {
                matrices.add(i.next());
            }
            int countOfMatrices = matrices.size();
            for (int i2 = 1; i2 <= numberOfTests; ++i2) {
                System.gc();
                String s1 = RandomSequenceGenerator.generate(sequencesSize);
                String s2 = RandomSequenceGenerator.generate(sequencesSize);
                int o = random.nextInt(50);
                int e = random.nextInt(10);
                if (s1.length() > 0 && s2.length() > 0 && o >= e) {
                    Sequence seq1 = new Sequence(s1);
                    Sequence seq2 = new Sequence(s2);
                    Matrix matrix = MatrixLoader.load((String)matrices.get(random.nextInt(countOfMatrices)));
                    Alignment alignment1 = SmithWatermanGotoh.align(seq1, seq2, matrix, o, e);
                    if (!alignment1.checkScore()) {
                        System.err.println("Invalid alignment found:");
                        System.err.println("Sequence 1 = " + s1);
                        System.err.println("Sequence 2 = " + s2);
                        System.err.println(((Format)format).format(alignment1));
                        System.err.println(alignment1.getSummary());
                        System.err.println("The score of the alignment above is: " + alignment1.calculateScore());
                        System.exit(1);
                    }
                    Alignment alignment2 = SmithWatermanGotoh.align(seq2, seq1, matrix, o, e);
                    if (!alignment1.checkScore()) {
                        System.err.println("Invalid alignment found:");
                        System.err.println("Sequence 1 = " + s2);
                        System.err.println("Sequence 2 = " + s1);
                        System.err.println(((Format)format).format(alignment2));
                        System.err.println(alignment2.getSummary());
                        System.err.println("The score of the alignment above is: " + alignment2.calculateScore());
                        System.exit(1);
                    }
                    if (alignment1.getScore() != alignment2.getScore()) {
                        System.err.println("Not symmetric alignment:");
                        System.err.println("Alignment #1: ");
                        System.err.println("Sequence 1 = " + s1);
                        System.err.println("Sequence 2 = " + s2);
                        System.err.println(((Format)format).format(alignment1));
                        System.err.println(alignment1.getSummary());
                        System.err.println();
                        System.err.println("Alignment #2: ");
                        System.err.println("Sequence 1 = " + s2);
                        System.err.println("Sequence 2 = " + s1);
                        System.err.println(((Format)format).format(alignment2));
                        System.err.println(alignment2.getSummary());
                        System.exit(1);
                    }
                }
                System.out.println("Processed " + i2 + "/" + numberOfTests);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

