/*
 * Decompiled with CFR 0.152.
 */
package jaligner.matrix;

import jaligner.matrix.MatricesCompartor;
import jaligner.matrix.Matrix;
import jaligner.matrix.MatrixLoaderException;
import jaligner.ui.filechooser.NamedInputStream;
import jaligner.util.Commons;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MatrixLoader {
    private static final char COMMENT_STARTER = '#';
    private static final int SIZE = 127;
    private static final String MATRICES_HOME = "jaligner/matrix/matrices/";
    private static final Logger logger = Logger.getLogger((class$jaligner$matrix$MatrixLoader == null ? (class$jaligner$matrix$MatrixLoader = MatrixLoader.class$("jaligner.matrix.MatrixLoader")) : class$jaligner$matrix$MatrixLoader).getName());
    static /* synthetic */ Class class$jaligner$matrix$MatrixLoader;

    public static Matrix load(String matrix) throws MatrixLoaderException {
        InputStream is = null;
        if (new StringTokenizer(matrix, Commons.getFileSeparator()).countTokens() == 1) {
            is = (class$jaligner$matrix$MatrixLoader == null ? (class$jaligner$matrix$MatrixLoader = MatrixLoader.class$("jaligner.matrix.MatrixLoader")) : class$jaligner$matrix$MatrixLoader).getClassLoader().getResourceAsStream(MATRICES_HOME + matrix);
        } else {
            try {
                is = new FileInputStream(matrix);
            }
            catch (Exception e) {
                String message = "Failed opening input stream: " + e.getMessage();
                logger.log(Level.SEVERE, message, e);
                throw new MatrixLoaderException(message);
            }
        }
        return MatrixLoader.load(new NamedInputStream(matrix, is));
    }

    public static Matrix load(NamedInputStream nis) throws MatrixLoaderException {
        String line;
        logger.info("Loading scoring matrix...");
        char[] acids = new char[127];
        for (int i = 0; i < 127; ++i) {
            acids[i] = '\u0000';
        }
        float[][] scores = new float[127][127];
        BufferedReader reader = new BufferedReader(new InputStreamReader(nis.getInputStream()));
        try {
            while ((line = reader.readLine()) != null && line.trim().charAt(0) == '#') {
            }
        }
        catch (Exception e) {
            String message = "Failed reading from input stream: " + e.getMessage();
            logger.log(Level.SEVERE, message, e);
            throw new MatrixLoaderException(message);
        }
        StringTokenizer tokenizer = new StringTokenizer(line.trim());
        int j = 0;
        while (tokenizer.hasMoreTokens()) {
            acids[j] = tokenizer.nextToken().charAt(0);
            ++j;
        }
        try {
            while ((line = reader.readLine()) != null) {
                tokenizer = new StringTokenizer(line.trim());
                char acid = tokenizer.nextToken().charAt(0);
                for (int i = 0; i < 127; ++i) {
                    if (acids[i] == '\u0000') continue;
                    scores[acid][acids[i]] = Float.parseFloat(tokenizer.nextToken());
                }
            }
        }
        catch (Exception e) {
            String message = "Failed reading from input stream: " + e.getMessage();
            logger.log(Level.SEVERE, message, e);
            throw new MatrixLoaderException(message);
        }
        logger.info("Finished loading scoring matrix");
        return new Matrix(nis.getName(), scores);
    }

    public static Collection list(boolean sort) throws MatrixLoaderException {
        logger.info("Loading list of scoring matrices...");
        ArrayList<String> matrices = new ArrayList<String>();
        URL url = (class$jaligner$matrix$MatrixLoader == null ? (class$jaligner$matrix$MatrixLoader = MatrixLoader.class$("jaligner.matrix.MatrixLoader")) : class$jaligner$matrix$MatrixLoader).getClassLoader().getResource(MATRICES_HOME);
        if (url.getFile().toString().indexOf("!") != -1) {
            JarURLConnection connection = null;
            JarFile jar = null;
            try {
                connection = (JarURLConnection)url.openConnection();
                jar = connection.getJarFile();
            }
            catch (Exception e) {
                String message = "Failed opening a connection to jar: " + e.getMessage();
                logger.log(Level.SEVERE, message, e);
                throw new MatrixLoaderException(message);
            }
            Enumeration<JarEntry> entries = jar.entries();
            int length = MATRICES_HOME.length();
            while (entries.hasMoreElements()) {
                String entryName;
                JarEntry entry = entries.nextElement();
                if (entry.isDirectory() || !(entryName = entry.getName()).startsWith(MATRICES_HOME)) continue;
                matrices.add(entryName.substring(length));
            }
        } else {
            String home = url.getFile();
            File dir = new File(home);
            String[] files = dir.list();
            int n = files.length;
            for (int i = 0; i < n; ++i) {
                File file = new File(home + files[i]);
                if (!file.isFile() || !file.canRead()) continue;
                matrices.add(file.getName());
            }
        }
        if (sort) {
            Collections.sort(matrices, new MatricesCompartor());
        }
        logger.info("Finished loading list of scoring matrices");
        return matrices;
    }

    public static Collection list() throws MatrixLoaderException {
        return MatrixLoader.list(false);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

