/*
 * Decompiled with CFR 0.152.
 */
package jaligner.formats;

import jaligner.Alignment;
import jaligner.formats.Format;
import jaligner.util.Commons;

public class Pair
extends Format {
    private static final int NAME_WIDTH = 13;
    private static final int POSITION_WIDTH = 6;
    private static final int SEQUENCE_WIDTH = 50;
    private static final String BLANK = " ";

    public Pair() {
        this.setId("Pair");
    }

    public String format(Alignment alignment) {
        char[] sequence1 = alignment.getSequence1();
        char[] sequence2 = alignment.getSequence2();
        char[] markup = alignment.getMarkupLine();
        int length = sequence1.length > sequence2.length ? sequence2.length : sequence1.length;
        String name1 = this.adjustName(alignment.getName1());
        String name2 = this.adjustName(alignment.getName2());
        StringBuffer buffer = new StringBuffer();
        StringBuffer preMarkup = new StringBuffer();
        for (int j = 0; j < 21; ++j) {
            preMarkup.append(BLANK);
        }
        int position1 = 1 + alignment.getStart1();
        int position2 = 1 + alignment.getStart2();
        int i = 0;
        while (i * 50 < length) {
            int oldPosition1 = position1;
            int oldPosition2 = position2;
            int line = (i + 1) * 50 < length ? (i + 1) * 50 : length;
            char[] subsequence1 = new char[line - i * 50];
            char[] subsequence2 = new char[line - i * 50];
            char[] submarkup = new char[line - i * 50];
            int j = i * 50;
            int k = 0;
            while (j < line) {
                subsequence1[k] = sequence1[j];
                subsequence2[k] = sequence2[j];
                submarkup[k] = markup[j];
                char c1 = subsequence1[k];
                char c2 = subsequence2[k];
                if (c1 == c2) {
                    ++position1;
                    ++position2;
                } else if (c1 == '-') {
                    ++position2;
                } else if (c2 == '-') {
                    ++position1;
                } else {
                    ++position1;
                    ++position2;
                }
                ++j;
                ++k;
            }
            buffer.append(name1);
            buffer.append(BLANK);
            buffer.append(this.adjustPosition(new Integer(oldPosition1).toString()));
            buffer.append(BLANK);
            buffer.append(subsequence1);
            buffer.append(BLANK);
            buffer.append(this.adjustPosition(new Integer(position1 - 1).toString()));
            buffer.append(Commons.getLineSeparator());
            buffer.append(preMarkup);
            buffer.append(submarkup);
            buffer.append(Commons.getLineSeparator());
            buffer.append(name2);
            buffer.append(BLANK);
            buffer.append(this.adjustPosition(new Integer(oldPosition2).toString()));
            buffer.append(BLANK);
            buffer.append(subsequence2);
            buffer.append(BLANK);
            buffer.append(this.adjustPosition(new Integer(position2 - 1).toString()));
            buffer.append(Commons.getLineSeparator());
            buffer.append(Commons.getLineSeparator());
            ++i;
        }
        return buffer.toString();
    }

    private String adjustName(String name) {
        StringBuffer buffer = new StringBuffer();
        if (name.length() > 13) {
            buffer.append(name.substring(0, 13));
        } else {
            buffer.append(name);
            for (int j = buffer.length(); j < 13; ++j) {
                buffer.append(BLANK);
            }
        }
        return buffer.toString();
    }

    private String adjustPosition(String position) {
        StringBuffer buffer1 = new StringBuffer();
        StringBuffer buffer2 = new StringBuffer();
        if (position.length() > 6) {
            buffer1.append(position.substring(position.length() - 6, position.length()));
        } else {
            buffer1.append(position);
        }
        int n = 6 - buffer1.length();
        for (int j = 0; j < n; ++j) {
            buffer2.append(BLANK);
        }
        buffer2.append(buffer1.toString());
        return buffer2.toString();
    }
}

