/*
 * Decompiled with CFR 0.152.
 */
package jaligner.formats;

import jaligner.Alignment;
import jaligner.Sequence;
import jaligner.formats.Format;

public class FASTA
extends Format {
    private static final int LINE_WIDTH = 60;

    public FASTA() {
        this.setId("FASTA");
    }

    public String format(Sequence sequence) {
        StringBuffer buffer = new StringBuffer(">");
        buffer.append(sequence.getId() == null ? "" : sequence.getId());
        buffer.append("\n");
        int i = 0;
        int n = sequence.length();
        while (i * 60 < n) {
            int m;
            int n2 = m = (i + 1) * 60 < n ? (i + 1) * 60 : n;
            for (int j = i * 60; j < m; ++j) {
                buffer.append(sequence.subsequence(j, 1));
            }
            buffer.append("\n");
            ++i;
        }
        return buffer.toString();
    }

    public String format(Alignment alignment) {
        StringBuffer buffer = new StringBuffer();
        StringBuffer s1 = new StringBuffer();
        StringBuffer s2 = new StringBuffer();
        s1.append(alignment.getSequence1());
        s2.append(alignment.getSequence2());
        buffer.append(this.format(new Sequence(s1.toString(), alignment.getName1(), "", 1)));
        buffer.append(this.format(new Sequence(s2.toString(), alignment.getName2(), "", 1)));
        return buffer.toString();
    }
}

