/*
 * Decompiled with CFR 0.152.
 */
package jaligner.example;

import jaligner.Alignment;
import jaligner.Sequence;
import jaligner.SmithWatermanGotoh;
import jaligner.formats.Pair;
import jaligner.matrix.MatrixLoader;
import jaligner.util.SequenceParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Example {
    private static final String SAMPLE_SEQUENCE_P35_HUMAN = "jaligner/example/sequences/p53_human.fasta";
    private static final String SAMPLE_SEQUENCE_P35_MOUSE = "jaligner/example/sequences/p53_mouse.fasta";
    private static final Logger logger = Logger.getLogger((class$jaligner$example$Example == null ? (class$jaligner$example$Example = Example.class$("jaligner.example.Example")) : class$jaligner$example$Example).getName());
    static /* synthetic */ Class class$jaligner$example$Example;

    public static void main(String[] args) {
        try {
            logger.info("Running example...");
            Sequence s1 = SequenceParser.parse(Example.loadP53Human());
            Sequence s2 = SequenceParser.parse(Example.loadP53Mouse());
            Alignment alignment = SmithWatermanGotoh.align(s1, s2, MatrixLoader.load("BLOSUM62"), 10.0f, 0.5f);
            System.out.println(alignment.getSummary());
            System.out.println(new Pair().format(alignment));
            logger.info("Finished running example");
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed running example: " + e.getMessage(), e);
        }
    }

    private static String loadSampleSequence(String path) throws IOException {
        int ch;
        InputStream inputStream = (class$jaligner$example$Example == null ? (class$jaligner$example$Example = Example.class$("jaligner.example.Example")) : class$jaligner$example$Example).getClassLoader().getResourceAsStream(path);
        StringBuffer buffer = new StringBuffer();
        while ((ch = inputStream.read()) != -1) {
            buffer.append((char)ch);
        }
        return buffer.toString();
    }

    public static String loadP53Human() throws IOException {
        return Example.loadSampleSequence(SAMPLE_SEQUENCE_P35_HUMAN);
    }

    public static String loadP53Mouse() throws IOException {
        return Example.loadSampleSequence(SAMPLE_SEQUENCE_P35_MOUSE);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

