/*
 * Decompiled with CFR 0.152.
 */
package jaligner;

import jaligner.Alignment;
import jaligner.Cell;
import jaligner.Sequence;
import jaligner.matrix.Matrix;
import java.util.logging.Logger;

public class SmithWatermanGotoh {
    private static final Logger logger = Logger.getLogger((class$jaligner$SmithWatermanGotoh == null ? (class$jaligner$SmithWatermanGotoh = SmithWatermanGotoh.class$("jaligner.SmithWatermanGotoh")) : class$jaligner$SmithWatermanGotoh).getName());
    static /* synthetic */ Class class$jaligner$SmithWatermanGotoh;

    private SmithWatermanGotoh() {
    }

    public static Alignment align(Sequence s1, Sequence s2, Matrix matrix, float o, float e) {
        logger.info("Started...");
        long start = System.currentTimeMillis();
        float[][] scores = matrix.getScores();
        SmithWatermanGotoh sw = new SmithWatermanGotoh();
        int m = s1.length() + 1;
        int n = s2.length() + 1;
        byte[] pointers = new byte[m * n];
        int i = 0;
        int k = 0;
        while (i < m) {
            pointers[k] = 0;
            ++i;
            k += n;
        }
        for (int j = 1; j < n; ++j) {
            pointers[j] = 0;
        }
        short[] sizesOfVerticalGaps = new short[m * n];
        short[] sizesOfHorizontalGaps = new short[m * n];
        int i2 = 0;
        int k2 = 0;
        while (i2 < m) {
            for (int j = 0; j < n; ++j) {
                sizesOfHorizontalGaps[k2 + j] = 1;
                sizesOfVerticalGaps[k2 + j] = 1;
            }
            ++i2;
            k2 += n;
        }
        Cell cell = sw.construct(s1, s2, scores, o, e, pointers, sizesOfVerticalGaps, sizesOfHorizontalGaps);
        Alignment alignment = sw.traceback(s1, s2, matrix, pointers, cell, sizesOfVerticalGaps, sizesOfHorizontalGaps);
        alignment.setName1(s1.getId());
        alignment.setName2(s2.getId());
        alignment.setMatrix(matrix);
        alignment.setOpen(o);
        alignment.setExtend(e);
        logger.info("Finished in " + (System.currentTimeMillis() - start) + " milliseconds");
        return alignment;
    }

    private Cell construct(Sequence s1, Sequence s2, float[][] matrix, float o, float e, byte[] pointers, short[] sizesOfVerticalGaps, short[] sizesOfHorizontalGaps) {
        logger.info("Started...");
        long start = System.currentTimeMillis();
        char[] a1 = s1.toArray();
        char[] a2 = s2.toArray();
        int m = s1.length() + 1;
        int n = s2.length() + 1;
        float[] g = new float[n];
        float[] v = new float[n];
        g[0] = Float.NEGATIVE_INFINITY;
        float h = Float.NEGATIVE_INFINITY;
        v[0] = 0.0f;
        for (int j = 1; j < n; ++j) {
            g[j] = Float.NEGATIVE_INFINITY;
            v[j] = 0.0f;
        }
        Cell cell = new Cell();
        int i = 1;
        int k = n;
        while (i < m) {
            h = Float.NEGATIVE_INFINITY;
            float vDiagonal = v[0];
            int j = 1;
            int l = k + 1;
            while (j < n) {
                float similarityScore = matrix[a1[i - 1]][a2[j - 1]];
                float f = vDiagonal + similarityScore;
                float g1 = g[j] - e;
                float g2 = v[j] - o;
                if (g1 > g2) {
                    g[j] = g1;
                    sizesOfVerticalGaps[l] = (short)(sizesOfVerticalGaps[l - n] + 1);
                } else {
                    g[j] = g2;
                }
                float h1 = h - e;
                float h2 = v[j - 1] - o;
                if (h1 > h2) {
                    h = h1;
                    sizesOfHorizontalGaps[l] = (short)(sizesOfHorizontalGaps[l - 1] + 1);
                } else {
                    h = h2;
                }
                vDiagonal = v[j];
                v[j] = SmithWatermanGotoh.maximum(f, g[j], h, 0.0f);
                pointers[l] = v[j] == 0.0f ? 0 : (v[j] == f ? 2 : (v[j] == g[j] ? 3 : 1));
                if (v[j] > cell.getScore()) {
                    cell.set(i, j, v[j]);
                }
                ++j;
                ++l;
            }
            ++i;
            k += n;
        }
        logger.info("Finished in " + (System.currentTimeMillis() - start) + " milliseconds");
        return cell;
    }

    private Alignment traceback(Sequence s1, Sequence s2, Matrix m, byte[] pointers, Cell cell, short[] sizesOfVerticalGaps, short[] sizesOfHorizontalGaps) {
        logger.info("Started...");
        long start = System.currentTimeMillis();
        char[] a1 = s1.toArray();
        char[] a2 = s2.toArray();
        float[][] scores = m.getScores();
        int n = s2.length() + 1;
        Alignment alignment = new Alignment();
        alignment.setScore(cell.getScore());
        int maxlen = s1.length() + s2.length();
        char[] reversed1 = new char[maxlen];
        char[] reversed2 = new char[maxlen];
        char[] reversed3 = new char[maxlen];
        int len1 = 0;
        int len2 = 0;
        int len3 = 0;
        int identity = 0;
        int similarity = 0;
        int gaps = 0;
        int i = cell.getRow();
        int j = cell.getCol();
        int k = i * n;
        boolean stillGoing = true;
        block6: while (stillGoing) {
            switch (pointers[k + j]) {
                case 3: {
                    int l;
                    int len = sizesOfVerticalGaps[k + j];
                    for (l = 0; l < len; ++l) {
                        reversed1[len1++] = a1[--i];
                        reversed2[len2++] = 45;
                        reversed3[len3++] = 32;
                        k -= n;
                        ++gaps;
                    }
                    continue block6;
                }
                case 2: {
                    char c1 = a1[--i];
                    char c2 = a2[--j];
                    k -= n;
                    reversed1[len1++] = c1;
                    reversed2[len2++] = c2;
                    if (c1 == c2) {
                        reversed3[len3++] = 124;
                        ++identity;
                        ++similarity;
                        break;
                    }
                    if (scores[c1][c2] > 0.0f) {
                        reversed3[len3++] = 58;
                        ++similarity;
                        break;
                    }
                    reversed3[len3++] = 46;
                    break;
                }
                case 1: {
                    int l;
                    int len = sizesOfHorizontalGaps[k + j];
                    for (l = 0; l < len; ++l) {
                        reversed1[len1++] = 45;
                        reversed2[len2++] = a2[--j];
                        reversed3[len3++] = 32;
                        ++gaps;
                    }
                    continue block6;
                }
                case 0: {
                    stillGoing = false;
                }
            }
        }
        alignment.setSequence1(SmithWatermanGotoh.reverse(reversed1, len1));
        alignment.setStart1(i);
        alignment.setSequence2(SmithWatermanGotoh.reverse(reversed2, len2));
        alignment.setStart2(j);
        alignment.setMarkupLine(SmithWatermanGotoh.reverse(reversed3, len3));
        alignment.setIdentity(identity);
        alignment.setGaps(gaps);
        alignment.setSimilarity(similarity);
        logger.info("Finished in " + (System.currentTimeMillis() - start) + " milliseconds");
        return alignment;
    }

    private static float maximum(float a, float b, float c, float d) {
        if (a > b) {
            if (a > c) {
                return a > d ? a : d;
            }
            return c > d ? c : d;
        }
        if (b > c) {
            return b > d ? b : d;
        }
        return c > d ? c : d;
    }

    private static char[] reverse(char[] a, int len) {
        char[] b = new char[len];
        int i = len - 1;
        int j = 0;
        while (i >= 0) {
            b[j] = a[i];
            --i;
            ++j;
        }
        return b;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

