/*
 * Decompiled with CFR 0.152.
 */
package jaligner;

import jaligner.matrix.Matrix;
import jaligner.util.Commons;
import java.text.DecimalFormat;

public class Alignment {
    public static final char GAP = '-';
    private static final String DEFAULT_SEQUENCE1_NAME = "jaligner_1";
    private static final String DEFAULT_SEQUENCE2_NAME = "jaligner_2";
    private Matrix matrix;
    private float open;
    private float extend;
    private float score;
    private char[] sequence1;
    private String name1;
    private int start1;
    private char[] sequence2;
    private String name2;
    private int start2;
    private char[] markupLine;
    private int identity;
    private int similarity;
    private int gaps;

    public float getExtend() {
        return this.extend;
    }

    public void setExtend(float extend) {
        this.extend = extend;
    }

    public Matrix getMatrix() {
        return this.matrix;
    }

    public void setMatrix(Matrix matrix) {
        this.matrix = matrix;
    }

    public String getName1() {
        return this.name1 == null || this.name1.length() == 0 ? DEFAULT_SEQUENCE1_NAME : this.name1;
    }

    public void setName1(String name1) {
        this.name1 = name1;
    }

    public String getName2() {
        return this.name2 == null || this.name2.length() == 0 ? DEFAULT_SEQUENCE2_NAME : this.name2;
    }

    public void setName2(String name2) {
        this.name2 = name2;
    }

    public float getOpen() {
        return this.open;
    }

    public void setOpen(float open) {
        this.open = open;
    }

    public float getScore() {
        return this.score;
    }

    public void setScore(float score) {
        this.score = score;
    }

    public char[] getSequence1() {
        return this.sequence1;
    }

    public void setSequence1(char[] sequence1) {
        this.sequence1 = sequence1;
    }

    public char[] getSequence2() {
        return this.sequence2;
    }

    public void setSequence2(char[] sequence2) {
        this.sequence2 = sequence2;
    }

    public int getStart1() {
        return this.start1;
    }

    public void setStart1(int start1) {
        this.start1 = start1;
    }

    public int getStart2() {
        return this.start2;
    }

    public void setStart2(int start2) {
        this.start2 = start2;
    }

    public int getGaps() {
        return this.gaps;
    }

    public void setGaps(int gaps) {
        this.gaps = gaps;
    }

    public int getIdentity() {
        return this.identity;
    }

    public void setIdentity(int identity) {
        this.identity = identity;
    }

    public char[] getMarkupLine() {
        return this.markupLine;
    }

    public void setMarkupLine(char[] markupLine) {
        this.markupLine = markupLine;
    }

    public int getSimilarity() {
        return this.similarity;
    }

    public void setSimilarity(int similarity) {
        this.similarity = similarity;
    }

    public String getSummary() {
        StringBuffer buffer = new StringBuffer();
        DecimalFormat f1 = new DecimalFormat("0.00");
        DecimalFormat f2 = new DecimalFormat("0.00%");
        int length = this.getSequence1().length;
        buffer.append("Sequence #1: " + this.getName1());
        buffer.append(Commons.getLineSeparator());
        buffer.append("Sequence #2: " + this.getName2());
        buffer.append(Commons.getLineSeparator());
        buffer.append("Length #1: " + this.sequence1.length);
        buffer.append(Commons.getLineSeparator());
        buffer.append("Length #2: " + this.sequence2.length);
        buffer.append(Commons.getLineSeparator());
        buffer.append("Matrix: " + (this.matrix.getId() == null ? "" : this.matrix.getId()));
        buffer.append(Commons.getLineSeparator());
        buffer.append("Gap open: " + this.open);
        buffer.append(Commons.getLineSeparator());
        buffer.append("Gap extend: " + this.extend);
        buffer.append(Commons.getLineSeparator());
        buffer.append("Length: " + length);
        buffer.append(Commons.getLineSeparator());
        buffer.append("Identity: " + this.identity + "/" + length + " (" + f2.format((float)this.identity / (float)length) + ")");
        buffer.append(Commons.getLineSeparator());
        buffer.append("Similarity: " + this.similarity + "/" + length + " (" + f2.format((float)this.similarity / (float)length) + ")");
        buffer.append(Commons.getLineSeparator());
        buffer.append("Gaps: " + this.gaps + "/" + length + " (" + f2.format((float)this.gaps / (float)length) + ")");
        buffer.append(Commons.getLineSeparator());
        buffer.append("Score: " + f1.format(this.score));
        buffer.append(Commons.getLineSeparator());
        return buffer.toString();
    }

    public float calculateScore() {
        float calcScore = 0.0f;
        boolean previous1wasGap = false;
        boolean previous2wasGap = false;
        int n = this.sequence1.length;
        for (int i = 0; i < n; ++i) {
            char c1 = this.sequence1[i];
            char c2 = this.sequence2[i];
            if (c1 == '-') {
                calcScore = previous1wasGap ? (calcScore -= this.extend) : (calcScore -= this.open);
                previous1wasGap = true;
                previous2wasGap = false;
                continue;
            }
            if (c2 == '-') {
                calcScore = previous2wasGap ? (calcScore -= this.extend) : (calcScore -= this.open);
                previous1wasGap = false;
                previous2wasGap = true;
                continue;
            }
            calcScore += this.matrix.getScore(c1, c2);
            previous1wasGap = false;
            previous2wasGap = false;
        }
        return calcScore;
    }

    public boolean checkScore() {
        return this.calculateScore() == this.score;
    }
}

