/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.exportchooser;

import java.awt.Component;
import java.awt.Dimension;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.spi.ImageWriterSpi;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.freehep.graphics2d.VectorGraphics;
import org.freehep.graphicsio.ImageGraphics2D;
import org.freehep.graphicsio.exportchooser.AbstractExportFileType;
import org.freehep.graphicsio.exportchooser.BackgroundPanel;
import org.freehep.graphicsio.exportchooser.OptionCheckBox;
import org.freehep.graphicsio.exportchooser.OptionComboBox;
import org.freehep.graphicsio.exportchooser.OptionPanel;
import org.freehep.graphicsio.exportchooser.OptionTextField;
import org.freehep.util.UserProperties;

public class ImageExportFileType
extends AbstractExportFileType {
    protected String format;
    protected ImageWriterSpi spi;
    protected ImageWriteParam param;
    protected OptionCheckBox antialias;
    protected OptionCheckBox antialiasText;
    protected OptionCheckBox progressive;
    protected OptionCheckBox compress;
    protected OptionComboBox compressMode;
    protected OptionComboBox compressDescription;
    protected OptionTextField compressQuality;

    protected ImageExportFileType(String format) {
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersByFormatName(format);
        if (iterator.hasNext()) {
            ImageWriter writer = iterator.next();
            this.format = format;
            this.spi = writer.getOriginatingProvider();
            this.param = writer.getDefaultWriteParam();
            return;
        }
        throw new IllegalArgumentException(this.getClass() + ": Format not valid: " + format);
    }

    public ImageExportFileType(ImageWriterSpi spi) {
        this.format = spi.getFormatNames()[0];
        this.spi = spi;
        try {
            this.param = spi.createWriterInstance().getDefaultWriteParam();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create Writer instance", e);
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof ImageExportFileType) {
            ImageExportFileType type = (ImageExportFileType)obj;
            return this.spi.getClass().equals(type.spi.getClass());
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.spi.getClass().hashCode();
    }

    public static ImageExportFileType getInstance(String format) {
        if ((format = format.toLowerCase()).equals("GIF".toLowerCase())) {
            return ImageExportFileType.exportFileType("org.freehep.graphicsio.gif.GIFExportFileType");
        }
        if (format.equals("PNG".toLowerCase())) {
            return ImageExportFileType.exportFileType("org.freehep.graphicsio.png.PNGExportFileType");
        }
        if (format.equals("JPG".toLowerCase())) {
            return ImageExportFileType.exportFileType("org.freehep.graphicsio.jpg.JPGExportFileType");
        }
        if (format.equals("RAW".toLowerCase())) {
            return ImageExportFileType.exportFileType("org.freehep.graphicsio.raw.RawExportFileType");
        }
        if (format.equals("BMP".toLowerCase())) {
            return ImageExportFileType.exportFileType("org.freehep.graphicsio.bmp.BMPExportFileType");
        }
        if (format.equals("WBMP".toLowerCase())) {
            return ImageExportFileType.exportFileType("org.freehep.graphicsio.wbmp.WBMPExportFileType");
        }
        return null;
    }

    private static ImageExportFileType exportFileType(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            return (ImageExportFileType)clazz.newInstance();
        }
        catch (Exception e) {
            System.out.println(e);
            return null;
        }
    }

    public String getDescription() {
        return this.spi.getDescription(Locale.getDefault());
    }

    public String[] getExtensions() {
        return this.spi.getFileSuffixes();
    }

    public String[] getMIMETypes() {
        return this.spi.getMIMETypes();
    }

    public boolean hasOptionPanel() {
        return true;
    }

    public JPanel createOptionPanel(Properties user) {
        UserProperties options = new UserProperties(user, ImageGraphics2D.getDefaultProperties(this.format));
        OptionPanel panel = new OptionPanel(this.format.toUpperCase() + " Format");
        String formatKey = "org.freehep.graphicsio." + this.format;
        panel.add("0 * * 1 [5 15 5 15] w", new BackgroundPanel(options, formatKey, ImageGraphics2D.canWriteTransparent(this.format), null));
        this.antialias = new OptionCheckBox(options, formatKey + ".Antialias", "Antialias");
        panel.add("0 * * 1 [5 15 5 15] w", this.antialias);
        this.antialiasText = new OptionCheckBox(options, formatKey + ".AntialiasText", "Antialias Text");
        panel.add("0 * * 1 [5 15 5 15] w", this.antialiasText);
        this.progressive = new OptionCheckBox(options, formatKey + ".Progressive", "Progressive");
        if (this.param.canWriteProgressive()) {
            panel.add("0 * * 1 [5 15 5 15] w", this.progressive);
        }
        this.compress = new OptionCheckBox(options, formatKey + ".Compress", "Compress");
        if (this.param.canWriteCompressed() && ImageGraphics2D.canWriteUncompressed(this.format)) {
            panel.add("0 * * 1 [5 15 5 15] w", this.compress);
            this.param.setCompressionMode(options.isProperty(formatKey + ".Compress") ? 2 : 0);
        }
        if (this.param.canWriteCompressed() && this.param.getCompressionMode() == 2) {
            String[] compressionTypes = this.param.getCompressionTypes();
            JLabel compressModeLabel = new JLabel("Compression Mode");
            this.compressMode = new OptionComboBox(options, formatKey + ".CompressMode", compressionTypes);
            if (compressionTypes.length > 1) {
                panel.add("0 * [5 15 5 15] r", compressModeLabel);
                panel.add("1 * [5 15 5 15] lw", this.compressMode);
                this.compress.enables(compressModeLabel);
                this.compress.enables(this.compressMode);
            }
            JLabel compressQualityLabel = new JLabel("Quality Value");
            panel.add("0 * [5 15 5 15] r", compressQualityLabel);
            this.compressQuality = new OptionTextField(options, formatKey + ".CompressQuality", 5);
            panel.add("1 * [5 15 5 15] lw", this.compressQuality);
            this.compress.enables(compressQualityLabel);
            this.compress.enables(this.compressQuality);
        }
        return panel;
    }

    public VectorGraphics getGraphics(OutputStream os, Component target) throws IOException {
        return new ImageGraphics2D(os, target, this.format);
    }

    public VectorGraphics getGraphics(OutputStream os, Dimension dimension) throws IOException {
        return new ImageGraphics2D(os, dimension, this.format);
    }

    public String toString() {
        return super.toString() + " for " + this.format + " using " + this.spi;
    }
}

