/*
 * Decompiled with CFR 0.152.
 */
package iubio.readseq;

import flybase.AppResources;
import flybase.Args;
import flybase.Debug;
import flybase.Environ;
import flybase.FastVector;
import flybase.Utils;
import iubio.bioseq.SeqRange;
import iubio.bioseq.SeqRangeException;
import iubio.readseq.BioseqDoc;
import iubio.readseq.BioseqFormat;
import iubio.readseq.BioseqFormats;
import iubio.readseq.BioseqReader;
import iubio.readseq.BioseqRecord;
import iubio.readseq.BioseqWriter;
import iubio.readseq.BioseqWriterIface;
import iubio.readseq.CompareSeqWriter;
import iubio.readseq.InterleavedSeqWriter;
import iubio.readseq.OutBiobaseIntf;
import iubio.readseq.PlainSeqWriter;
import iubio.readseq.PrettySeqWriter;
import iubio.readseq.Readseq;
import iubio.readseq.ReadseqException;
import iubio.readseq.SeqFileInfo;
import iubio.readseq.ToAminoBase;
import iubio.readseq.ToDegappedBase;
import iubio.readseq.ToLowercaseBase;
import iubio.readseq.ToTranslatedBase;
import iubio.readseq.ToUppercaseBase;
import iubio.readseq.WriteseqOpts;
import iubio.readseq.XmlSeqWriter;
import iubio.readseq.help;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Hashtable;

public class run
implements Runnable {
    public static String kReadseqcHelp = "rez/Readseqc-help.html";
    static String kInputStringKey = "indata=";
    static boolean dowritemask = false;
    static boolean s_reportmemory = false;
    static Runtime s_rt = Runtime.getRuntime();
    boolean degap;
    boolean dolist;
    boolean docompare;
    boolean doall;
    boolean dochecksum;
    boolean dopipe;
    boolean dolowercase;
    boolean dohtml;
    boolean hasoutformat;
    boolean dotranslate;
    boolean doaminotrans;
    boolean douppercase;
    boolean doreverse;
    boolean doPairedDocNSeq;
    boolean doUnpairDocNSeq;
    boolean dotime;
    boolean noEmptyFiles;
    boolean doclassic;
    boolean verbose;
    boolean verboseClassic;
    boolean doformhelp;
    char degapc = (char)45;
    String informat;
    String outname;
    String outdirname;
    String indirname;
    String itemlist;
    String outformat;
    String featsubrange;
    String extractrange;
    String translates;
    String compareval;
    String featlist;
    String nofeatlist;
    String keepfeatures;
    Args argv;
    FastVector innames = new FastVector();
    Hashtable exfeatures = new Hashtable();
    SeqRange featSubrange;
    SeqRange extractRange;
    WriteseqOpts pretty = new WriteseqOpts();
    File outdir;
    File indir;
    static boolean bExtractRangeOkay = true;
    final boolean bUseLibdiff = true;
    static /* synthetic */ Class class$iubio$readseq$run;

    public static void main(String[] args) {
        new run(args);
    }

    public run() {
        this.initrun();
    }

    public run(String[] args) {
        this.initrun();
        System.err.println(Readseq.version);
        this.getargs(args);
        if (Debug.isOn) {
            this.verbose = true;
            this.dotime = true;
            s_reportmemory = true;
            bExtractRangeOkay = true;
        }
        if (s_reportmemory) {
            run.reportMemory("Free/total memory at start:", s_rt);
        }
        long tstart = System.currentTimeMillis();
        this.run();
        if (this.verbose || this.dotime || s_reportmemory) {
            long telapsed = System.currentTimeMillis() - tstart;
            System.err.println("time=" + telapsed);
            if (Debug.isOn) {
                System.err.println("checksum time=" + BioseqWriter.checksumTime);
            }
            if (s_reportmemory) {
                run.reportMemory("Free/total memory after processing:", s_rt);
                s_rt.gc();
                s_rt.runFinalization();
                s_rt.gc();
                run.reportMemory("Free/total memory after gc:", s_rt);
            }
        }
    }

    protected void initrun() {
        this.doformhelp = false;
        this.verbose = false;
        this.doclassic = false;
        this.dotime = false;
        this.doUnpairDocNSeq = false;
        this.doPairedDocNSeq = false;
        this.doreverse = false;
        this.douppercase = false;
        this.doaminotrans = false;
        this.dotranslate = false;
        this.hasoutformat = false;
        this.dohtml = false;
        this.dolowercase = false;
        this.dopipe = false;
        this.dochecksum = false;
        this.doall = false;
        this.docompare = false;
        this.dolist = false;
        this.degap = false;
        this.featlist = null;
        this.nofeatlist = null;
        this.keepfeatures = null;
        this.compareval = null;
        this.featsubrange = null;
        this.extractrange = null;
        this.translates = null;
        this.itemlist = null;
        this.indirname = null;
        this.outdirname = null;
        this.outname = null;
        this.informat = null;
        this.outformat = null;
        this.innames.removeAllElements();
        this.doclassic = true;
        XmlSeqWriter.dtdUrl = Environ.gEnv.get("APP_SOURCE_URL");
        XmlSeqWriter.includeDTD = Environ.gEnv.isTrue("XML_INCLUDE_DTD");
        String vers = Readseq.version;
        int at = vers.indexOf("version ");
        if (at >= 0) {
            vers = vers.substring(at + "version ".length()).trim();
        }
        Environ.gEnv.set("APP_VERSION", vers);
        this.outformat = Environ.gEnv.get("format", "biosequence/fasta");
        this.doall = Environ.gEnv.isTrue("all", this.doall);
        this.dochecksum = Environ.gEnv.isTrue("checksum", this.dochecksum);
        this.doreverse = Environ.gEnv.isTrue("reverse", this.doreverse);
        s_reportmemory = Environ.gEnv.isTrue("memory", s_reportmemory);
        this.dotime = Environ.gEnv.isTrue("time", this.dotime);
        this.doclassic = Environ.gEnv.isTrue("classic", this.doclassic);
        this.dolowercase = Environ.gEnv.isTrue("caselower", this.dolowercase);
        this.douppercase = Environ.gEnv.isTrue("CASEUPPPER", this.douppercase);
        this.degap = Environ.gEnv.isTrue("degap", this.degap);
        this.dolist = Environ.gEnv.isTrue("list", this.dolist);
        this.dopipe = Environ.gEnv.isTrue("pipe", this.dopipe);
        this.verbose = Environ.gEnv.isTrue("verbose", this.verbose);
        this.doPairedDocNSeq = Environ.gEnv.isTrue("pair-feature-seq", this.doPairedDocNSeq);
        this.doUnpairDocNSeq = Environ.gEnv.isTrue("unpair-feature-seq", this.doUnpairDocNSeq);
        this.doformhelp = Environ.gEnv.isTrue("formhelp", this.doformhelp);
        this.featlist = Environ.gEnv.get("features", this.featlist);
        this.nofeatlist = Environ.gEnv.get("nofeatures", this.nofeatlist);
        this.keepfeatures = Environ.gEnv.get("keepfeatures", this.keepfeatures);
        this.featsubrange = Environ.gEnv.get("subrange", this.featsubrange);
        this.extractrange = Environ.gEnv.get("extract", this.extractrange);
        this.pretty.seqwidth = Environ.gEnv.getInt("pretty.width", this.pretty.seqwidth);
        this.pretty.tab = Environ.gEnv.getInt("pretty.tab", this.pretty.tab);
        this.pretty.spacer = Environ.gEnv.getInt("pretty.colspace", this.pretty.spacer);
        this.pretty.baseonlynum = !Environ.gEnv.isTrue("pretty.gapcount", !this.pretty.baseonlynum);
        this.pretty.nameleft = Environ.gEnv.isTrue("pretty.nameleft", this.pretty.nameleft);
        this.pretty.nameright = Environ.gEnv.isTrue("pretty.nameright", this.pretty.nameright);
        this.pretty.nametop = Environ.gEnv.isTrue("pretty.nametop", this.pretty.nametop);
        this.pretty.namewidth = Environ.gEnv.getInt("pretty.namewidth", this.pretty.namewidth);
        this.pretty.numleft = Environ.gEnv.isTrue("pretty.numleft", this.pretty.numleft);
        this.pretty.numright = Environ.gEnv.isTrue("pretty.numright", this.pretty.numright);
        this.pretty.numtop = Environ.gEnv.isTrue("pretty.numtop", this.pretty.numtop);
        this.pretty.numbot = Environ.gEnv.isTrue("pretty.numbot", this.pretty.numbot);
        this.pretty.domatch = Environ.gEnv.isTrue("pretty.match", this.pretty.domatch);
        this.pretty.interline = Environ.gEnv.getInt("pretty.interline", this.pretty.interline);
    }

    public void setInputFiles(File[] inputfiles) {
        if (inputfiles != null) {
            int i = 0;
            while (i < inputfiles.length) {
                this.innames.addElement(inputfiles[i]);
                ++i;
            }
        }
    }

    public void setInputNames(String[] names) {
        this.innames.removeAllElements();
        if (names != null) {
            int i = 0;
            while (i < names.length) {
                this.innames.addElement(names[i].trim());
                ++i;
            }
        }
    }

    public void setInputObjects(FastVector list) {
        this.innames.removeAllElements();
        if (list != null) {
            int i = 0;
            while (i < list.size()) {
                this.innames.addElement(list.elementAt(i));
                ++i;
            }
        }
    }

    public void addInputObject(Object item) {
        if (item != null) {
            this.innames.addElement(item);
        }
    }

    public boolean haveInputData() {
        return !this.innames.isEmpty();
    }

    protected void message(String s) {
        BioseqReader.message(s);
    }

    protected String guessOutname(int outid) {
        String outname = null;
        int k = 0;
        while (outname == null && k < this.innames.size()) {
            Object el = this.innames.elementAt(k);
            if (el instanceof File) {
                outname = ((File)el).toString();
            } else if (el instanceof URL) {
                outname = ((URL)el).getFile();
            } else if (el instanceof String) {
                outname = (String)el;
                if (outname.startsWith(kInputStringKey)) {
                    outname = null;
                } else if (outname.length() > 50) {
                    // empty if block
                }
            }
            ++k;
        }
        if (outname == null) {
            outname = "run-output";
        }
        outname = this.docompare ? outname + ".diff" : (this.dolist ? outname + ".list" : outname + BioseqFormats.formatSuffix(outid));
        return outname;
    }

    protected void comparePair(String inname, Readseq rd, Object second, int forceInformat, Writer outs) throws IOException {
        Readseq rd2 = new Readseq();
        rd2.setInDirectory(this.indir);
        String in2name = rd2.setInputObjectChecked(second);
        if (this.verbose || this.dotime) {
            this.message("Comparing to " + in2name);
        }
        if (in2name == null) {
            return;
        }
        if (forceInformat > 0) {
            rd2.setInputFormat(forceInformat);
        }
        if (!rd2.isKnownFormat()) {
            this.message("Unknown biosequence format for input " + in2name);
            return;
        }
        if (forceInformat > 0) {
            rd2.getBioseqFormat().setVariant(this.informat);
        }
        if (!rd2.readInit()) {
            this.message("Error initializing readseq for input " + in2name);
            return;
        }
        CompareSeqWriter cmpwriter = new CompareSeqWriter();
        cmpwriter.setOutput(outs);
        cmpwriter.setFlags(this.compareval);
        cmpwriter.setSourceNames(in2name, inname);
        boolean more = true;
        more = true;
        int irec = 1;
        while (more) {
            SeqFileInfo rec = rd.readAt(irec);
            if (rec == null) {
                more = false;
            } else {
                cmpwriter.addLib(inname, new BioseqRecord(rec));
            }
            ++irec;
        }
        more = true;
        int irec2 = 1;
        while (more) {
            SeqFileInfo rec = rd2.readAt(irec2);
            if (rec == null) {
                more = false;
            } else {
                cmpwriter.addLib(in2name, new BioseqRecord(rec));
            }
            ++irec2;
        }
        cmpwriter.compareLibs(inname, in2name);
        cmpwriter.writeTrailer();
        cmpwriter.close();
    }

    public void run() {
        File dir;
        SeqFileInfo.gWriteMask = dowritemask;
        if (this.doclassic && this.verbose) {
            this.verboseClassic = true;
            this.verbose = false;
        } else {
            this.verboseClassic = false;
        }
        BioseqReader.verbose = this.verbose;
        boolean bl = this.dohtml = this.outname != null && this.outname.indexOf("html") >= 0;
        if (this.doformhelp) {
            try {
                PrintStream pr = this.outname == null ? System.out : new PrintStream(new FileOutputStream(this.outname));
                help h = new help(false, this.dohtml, pr);
                if (this.outformat == null || !this.hasoutformat) {
                    h.formatHelp();
                } else {
                    h.formatDoc(BioseqFormats.getFormatId(this.outformat));
                    h.formatDocEnd();
                }
                pr.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
            return;
        }
        if (!this.haveInputData() && !this.dopipe) {
            run.usage();
            return;
        }
        if (this.outformat == null) {
            this.outformat = Environ.gEnv.get("format", "biosequence/fasta");
        }
        int outid = BioseqFormats.getFormatId(this.outformat);
        if (this.outdirname != null && (dir = new File(this.outdirname)).isDirectory()) {
            this.outdir = dir;
        }
        if (this.indirname != null && (dir = new File(this.indirname)).isDirectory()) {
            this.indir = dir;
        }
        int forceInformat = 0;
        if (this.informat != null) {
            forceInformat = BioseqFormats.getFormatId(this.informat);
        }
        if (this.innames.isEmpty() && this.dopipe) {
            this.addInputObject(System.in);
        }
        if (!this.dopipe && this.outname == null && this.haveInputData()) {
            this.outname = this.guessOutname(outid);
        }
        this.featSubrange = null;
        this.extractRange = null;
        if (bExtractRangeOkay) {
            SeqRange sr;
            if (this.extractrange != null) {
                try {
                    sr = SeqRange.parse(this.extractrange);
                    if (sr != null && !sr.isEmpty()) {
                        this.extractRange = sr;
                    }
                    Debug.println("parse extractrange=" + this.extractrange + ", extractRange=" + this.extractRange);
                }
                catch (SeqRangeException sre) {
                    this.extractRange = null;
                }
            }
            if (this.featsubrange != null) {
                try {
                    sr = SeqRange.parse(this.featsubrange);
                    if (sr != null && !sr.isEmpty()) {
                        this.featSubrange = sr;
                    }
                    Debug.println("parse featsubrange=" + this.featsubrange + ", featSubrange=" + this.featSubrange);
                }
                catch (SeqRangeException sre) {
                    this.featSubrange = null;
                }
            }
        }
        if (this.verbose || this.dotime) {
            this.message(this.getClass().getName() + " -- starting ");
            this.message("Writing to " + (this.outname == null ? "Std. output" : this.outname));
        }
        try {
            Writer outs = null;
            BufferedWriter outs2 = null;
            BioseqWriterIface seqwriter = null;
            BioseqWriterIface seqwriter2 = null;
            boolean iDidHeader = false;
            Object pairdoc = null;
            SeqFileInfo pairseq = null;
            String outname2 = null;
            int outid2 = 0;
            boolean seqfirst = false;
            Readseq rd = new Readseq();
            rd.verboseClassic = this.verboseClassic;
            rd.noEmptyFiles = this.noEmptyFiles;
            if (this.outname == null) {
                outs = new OutputStreamWriter(System.out);
            } else {
                URL outurl = rd.checkUrl(this.outname);
                if (outurl != null) {
                    URLConnection uconn = outurl.openConnection();
                    outs = new OutputStreamWriter(uconn.getOutputStream());
                } else {
                    outs = this.outdir != null ? new BufferedWriter(new FileWriter(new File(this.outdir, this.outname))) : new BufferedWriter(new FileWriter(this.outname));
                }
            }
            if (!this.dolist && !this.docompare) {
                seqwriter = BioseqFormats.newWriter(outid);
                if (seqwriter == null) {
                    throw new ReadseqException("No BioseqWriter for this format: " + this.outformat);
                }
                this.setWriterOptions(seqwriter);
                seqwriter.setOutput(outs);
                seqwriter.writeHeader();
                iDidHeader = true;
            }
            FastVector vitems = this.getItems(this.itemlist);
            rd.setInDirectory(this.indir);
            rd.checkInList(this.innames, kInputStringKey);
            Enumeration en = this.innames.elements();
            while (en.hasMoreElements()) {
                BioseqFormat fmt;
                String inname = rd.setInputObjectChecked(en.nextElement());
                if (inname == null) continue;
                if (this.verbose || this.dotime) {
                    this.message("Reading from " + inname);
                }
                if (forceInformat > 0) {
                    rd.setInputFormat(forceInformat);
                }
                if (!rd.isKnownFormat()) {
                    this.message("Unknown biosequence format for input " + inname);
                    continue;
                }
                if (forceInformat > 0) {
                    fmt = rd.getBioseqFormat();
                    fmt.setVariant(this.informat);
                }
                if (!this.exfeatures.isEmpty() || this.featSubrange != null) {
                    rd.setFeatureExtraction(this.exfeatures, this.featSubrange);
                }
                if (!rd.readInit()) {
                    this.message("Error initializing readseq for input " + inname);
                    continue;
                }
                if (this.dolist) {
                    rd.list(outs);
                    continue;
                }
                if (this.docompare) {
                    this.comparePair(inname, rd, en.nextElement(), forceInformat, outs);
                    continue;
                }
                if (this.doPairedDocNSeq) {
                    fmt = rd.getBioseqFormat();
                    Debug.println("Pair: informat " + fmt.formatName());
                    if (fmt.hasdoc() && !fmt.hasseq()) {
                        SeqFileInfo si = rd.readAt(1);
                        pairdoc = si.seqdoc;
                        if (Debug.isOn) {
                            Debug.println("Pair: got doc " + inname + " nfeat=" + ((BioseqDoc)pairdoc).features().size());
                        }
                    } else if (fmt.hasseq()) {
                        pairseq = rd.readAt(1);
                        if (Debug.isOn) {
                            Debug.println("Pair: got seq " + inname + " len=" + pairseq.seqlen);
                        }
                    }
                    if (pairseq == null || pairdoc == null) continue;
                    pairseq.seqdoc = pairdoc;
                    if (pairdoc instanceof BioseqDoc && ((BioseqDoc)pairdoc).getID() != null) {
                        pairseq.setSeqID(((BioseqDoc)pairdoc).getID());
                    }
                    if (!iDidHeader) {
                        seqwriter.writeHeader();
                    }
                    rd.writeSeqTo(pairseq, seqwriter, null);
                    if (!iDidHeader) {
                        seqwriter.writeTrailer();
                    }
                    pairseq = null;
                    pairdoc = null;
                    continue;
                }
                if (this.doUnpairDocNSeq) {
                    boolean didwrite = false;
                    BioseqFormat infmt = rd.getBioseqFormat();
                    BioseqFormat outfmt = BioseqFormats.bioseqFormat(outid);
                    if (infmt.hasseq() && infmt.hasdoc() && (!outfmt.hasseq() || !outfmt.hasdoc()) && this.outname != null) {
                        if (seqwriter2 == null) {
                            if (outfmt.hasseq()) {
                                outid2 = BioseqFormats.formatFromName("FFF");
                                seqfirst = true;
                            } else {
                                outid2 = BioseqFormats.formatFromName("fasta");
                                seqfirst = false;
                            }
                            outname2 = this.outname + BioseqFormats.formatSuffix(outid2);
                            outs2 = this.outdir != null ? new BufferedWriter(new FileWriter(new File(this.outdir, outname2))) : new BufferedWriter(new FileWriter(outname2));
                            seqwriter2 = BioseqFormats.newWriter(outid2);
                            if (seqwriter2 != null) {
                                this.setWriterOptions(seqwriter2);
                                seqwriter2.setOutput(outs2);
                                seqwriter2.writeHeader();
                            }
                        }
                        didwrite = seqfirst ? rd.readToPair(seqwriter, seqwriter2, !iDidHeader) : rd.readToPair(seqwriter2, seqwriter, !iDidHeader);
                    }
                    if (didwrite) continue;
                    rd.readTo(seqwriter, !iDidHeader);
                    continue;
                }
                if (vitems != null) {
                    int i = 0;
                    while (i < vitems.size()) {
                        int iseq = (Integer)vitems.elementAt(i);
                        SeqFileInfo si = rd.readAt(iseq);
                        rd.writeSeqTo(si, seqwriter, null);
                        ++i;
                    }
                    continue;
                }
                rd.readTo(seqwriter, !iDidHeader);
            }
            try {
                if (seqwriter != null) {
                    if (iDidHeader) {
                        seqwriter.writeTrailer();
                    }
                    seqwriter.close();
                }
                if (seqwriter2 != null) {
                    if (iDidHeader) {
                        seqwriter2.writeTrailer();
                    }
                    seqwriter2.close();
                }
                if (outs != null) {
                    outs.close();
                }
                if (outs2 != null) {
                    outs.close();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            rd.close();
        }
        catch (ReadseqException e) {
            if (this.verbose) {
                e.printStackTrace();
            } else {
                System.err.println(e.getMessage());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.verbose || this.dotime) {
            this.message(this.getClass().getName() + " -- done ");
        }
    }

    protected FastVector getItems(String list) {
        if (list == null || list.length() == 0) {
            return null;
        }
        FastVector v = new FastVector();
        int len = list.length();
        boolean expand = false;
        int lastn = 1;
        int i = 0;
        while (i < len) {
            char c = list.charAt(i);
            if (c == '-') {
                expand = true;
            } else if (c == '.' && i < len - 1 && list.charAt(i + 1) == '.') {
                ++i;
                expand = true;
            } else if (c >= '0' && c <= '9') {
                int e = i;
                while (e < len && Character.isDigit(list.charAt(e))) {
                    ++e;
                }
                if (e > i) {
                    try {
                        Integer n = new Integer(list.substring(i, e));
                        if (expand) {
                            int k = lastn + 1;
                            int ke = n - 1;
                            while (k < ke) {
                                v.addElement(new Integer(k));
                                ++k;
                            }
                            expand = false;
                        }
                        v.addElement(n);
                        lastn = n;
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                i = e - 1;
            }
            ++i;
        }
        if (v.isEmpty()) {
            return null;
        }
        return v;
    }

    protected void setWriterOptions(BioseqWriterIface seqwriter) {
        String[] vals;
        OutBiobaseIntf outb = seqwriter.getOutputTranslation();
        if (this.degap) {
            outb = new ToDegappedBase(this.degapc, outb);
        }
        if (this.dolowercase) {
            outb = new ToLowercaseBase(outb);
        } else if (this.douppercase) {
            outb = new ToUppercaseBase(outb);
        }
        if (this.doaminotrans) {
            outb = new ToAminoBase(outb);
        }
        if (this.dotranslate && this.translates != null && this.translates.length() > 0) {
            StringBuffer intr = new StringBuffer();
            StringBuffer outtr = new StringBuffer();
            String ft = this.translates;
            if (ft.length() > 1) {
                int flen = ft.length();
                char inc = '\u0000';
                int j = 0;
                while (j < flen) {
                    char c = ft.charAt(j);
                    if (c > ' ' && c != ',' && c != ':') {
                        if (inc == '\u0000') {
                            inc = c;
                        } else {
                            intr.append(inc);
                            outtr.append(c);
                            inc = '\u0000';
                        }
                    }
                    ++j;
                }
            }
            outb = new ToTranslatedBase(intr.toString(), outtr.toString(), outb);
        }
        if (outb != null) {
            seqwriter.setOutputTranslation(outb);
        }
        this.exfeatures.clear();
        if (this.hasFeatlist()) {
            vals = Utils.splitString(this.featlist, ", ");
            int k = 0;
            while (k < vals.length) {
                this.exfeatures.put(vals[k], "true");
                ++k;
            }
        }
        if (this.hasNofeatlist()) {
            vals = Utils.splitString(this.nofeatlist, ", ");
            int k = 0;
            while (k < vals.length) {
                this.exfeatures.put(vals[k], "false");
                ++k;
            }
        }
        if (seqwriter instanceof BioseqWriter) {
            ((BioseqWriter)seqwriter).setChecksum(this.dochecksum);
            ((BioseqWriter)seqwriter).setReverseComplement(this.doreverse);
        }
        if (seqwriter instanceof PrettySeqWriter) {
            ((PrettySeqWriter)seqwriter).setOpts(this.pretty);
        } else if (seqwriter instanceof PlainSeqWriter) {
            ((PlainSeqWriter)seqwriter).setOpts(this.pretty);
        } else if (this.pretty.userchoice && seqwriter instanceof BioseqWriter) {
            ((BioseqWriter)seqwriter).setOpts(this.pretty);
        }
        if (this.pretty.interline == 0 && seqwriter instanceof InterleavedSeqWriter) {
            ((InterleavedSeqWriter)seqwriter).setinterleaved(false);
        }
    }

    final boolean hasFeatlist() {
        return this.featlist != null && this.featlist.length() > 0;
    }

    final boolean hasNofeatlist() {
        return this.nofeatlist != null && this.nofeatlist.length() > 0;
    }

    public void getargs(String[] sargs) {
        this.argv = new Args(sargs);
        this.getargs();
    }

    public void getargs() {
        if (this.doclassic) {
            this.argv.setArgPattern("acCdi:lo:prt:vf:", false);
        }
        this.pretty.prettyInit();
        while (this.argv.hasMoreElements()) {
            this.argv.nextArg();
            this.getOneArg();
        }
    }

    protected void handleUnknownArg() {
        this.message("Unknown argument: " + this.argv.argKey() + "=" + this.argv.argValue());
    }

    protected void getOneArg() {
        boolean boolval;
        String argstr = this.argv.arg();
        String key = this.argv.argKey();
        String val = this.argv.argValue();
        boolean hasval = this.argv.hasValue();
        boolean bl = boolval = this.argv.isBoolean() ? this.argv.booleanValue() : true;
        if (!key.startsWith("C")) {
            key = key.toLowerCase();
        }
        if ("help".equals(key) || "h".equals(key)) {
            run.usage();
        } else if (this.argv.argType() == 0) {
            this.addInputObject(argstr);
        } else if (key.startsWith("ch")) {
            this.dochecksum = boolval;
        } else if (key.startsWith("inform")) {
            this.informat = val;
        } else if (key.startsWith("inter")) {
            this.pretty.userset();
            if (this.argv.hasValue()) {
                this.pretty.interline = this.argv.intValue();
            }
        } else if (key.startsWith("in")) {
            if (hasval) {
                this.addInputObject(val);
            }
        } else if (key.startsWith("memory")) {
            s_reportmemory = boolval;
        } else if (key.startsWith("time")) {
            this.dotime = boolval;
        } else if (key.startsWith("formhelp")) {
            this.doformhelp = boolval;
        } else if (key.startsWith("debug")) {
            Debug.isOn = boolval;
        } else if (key.startsWith("classic")) {
            this.doclassic = boolval;
        } else if (key.startsWith("all")) {
            this.doall = boolval;
        } else if (key.startsWith("caselo")) {
            this.dolowercase = true;
        } else if (key.startsWith("CASEUP") || key.startsWith("caseup")) {
            this.douppercase = true;
        } else if (key.startsWith("degap")) {
            this.degap = true;
            if (hasval) {
                this.degapc = val.charAt(0);
            }
        } else if (key.startsWith("format")) {
            this.hasoutformat = true;
            if (hasval) {
                this.outformat = val;
            }
        } else if (key.startsWith("item")) {
            this.itemlist = val;
        } else if (key.startsWith("list")) {
            this.dolist = boolval;
        } else if (key.startsWith("compare")) {
            this.docompare = boolval;
            this.compareval = val;
        } else if (key.startsWith("noempty")) {
            this.noEmptyFiles = boolval;
        } else if (key.equals("pair-feature-seq")) {
            this.doPairedDocNSeq = boolval;
        } else if (key.startsWith("pair")) {
            this.doPairedDocNSeq = boolval;
        } else if (key.equals("unpair-feature-seq")) {
            this.doUnpairDocNSeq = boolval;
        } else if (key.startsWith("unpair")) {
            this.doUnpairDocNSeq = boolval;
        } else if (key.startsWith("indir")) {
            this.indirname = val;
        } else if (key.startsWith("outdir")) {
            this.outdirname = val;
        } else if (key.startsWith("out")) {
            this.outname = val;
        } else if (key.startsWith("pipe")) {
            this.dopipe = boolval;
        } else if (key.startsWith("rev")) {
            this.doreverse = boolval;
        } else if (key.startsWith("trans")) {
            this.setTranslation(val, true);
        } else if (key.startsWith("amin")) {
            this.doaminotrans = boolval;
        } else if (key.startsWith("verb")) {
            this.verbose = boolval;
        } else if (key.startsWith("feat") || key.startsWith("field")) {
            if (hasval) {
                this.featlist = this.appends(this.featlist, val);
            }
        } else if (key.startsWith("nofeat") || key.startsWith("nofield")) {
            if (hasval) {
                this.nofeatlist = this.appends(this.nofeatlist, val);
            }
        } else if (key.startsWith("keepfeature")) {
            if (hasval) {
                this.keepfeatures = this.appends(this.keepfeatures, val);
            }
        } else if (key.startsWith("subrange")) {
            if (hasval) {
                this.featsubrange = val;
            }
        } else if (key.startsWith("extract")) {
            if (hasval) {
                this.extractrange = val;
            }
        } else if (key.startsWith("wid")) {
            this.pretty.seqwidth = this.argv.intValue();
            this.pretty.userset();
        } else if (key.startsWith("tab")) {
            this.pretty.tab = this.argv.intValue();
            this.pretty.userset();
        } else if (key.startsWith("col")) {
            this.pretty.spacer = this.argv.intValue();
            this.pretty.userset();
        } else if (key.startsWith("gap")) {
            this.pretty.baseonlynum = false;
            this.pretty.userset();
        } else if (key.startsWith("nameleft")) {
            this.pretty.nameleft = true;
            this.pretty.userset();
            if (this.argv.hasValue()) {
                this.pretty.namewidth = this.argv.intValue();
            }
        } else if (key.startsWith("nameright")) {
            this.pretty.nameright = true;
            this.pretty.userset();
            if (this.argv.hasValue()) {
                this.pretty.namewidth = this.argv.intValue();
            }
        } else if (key.startsWith("nametop")) {
            this.pretty.nametop = true;
            this.pretty.userset();
        } else if (key.startsWith("numleft")) {
            this.pretty.numleft = true;
            this.pretty.userset();
            if (this.argv.hasValue()) {
                this.pretty.numwidth = this.argv.intValue();
            }
        } else if (key.startsWith("numright")) {
            this.pretty.numright = true;
            this.pretty.userset();
            if (this.argv.hasValue()) {
                this.pretty.numwidth = this.argv.intValue();
            }
        } else if (key.startsWith("numtop")) {
            this.pretty.numtop = true;
            this.pretty.userset();
        } else if (key.startsWith("numbot")) {
            this.pretty.numbot = true;
            this.pretty.userset();
        } else if (key.startsWith("match")) {
            this.pretty.domatch = true;
            this.pretty.userset();
            if (this.argv.hasValue()) {
                this.pretty.matchchar = val.charAt(0);
            }
        } else if (key.startsWith("inter")) {
            this.pretty.userset();
            if (this.argv.hasValue()) {
                this.pretty.interline = this.argv.intValue();
            }
        } else if (this.doclassic) {
            if (key.startsWith("a")) {
                this.doall = true;
            } else if (key.startsWith("c")) {
                this.dolowercase = true;
            } else if (key.startsWith("C")) {
                this.douppercase = true;
            } else if (key.startsWith("d")) {
                this.degap = true;
                if (this.argv.hasValue()) {
                    this.degapc = val.charAt(0);
                }
            } else if (key.startsWith("f")) {
                if (hasval) {
                    this.outformat = val;
                }
            } else if (key.startsWith("i")) {
                this.itemlist = val;
            } else if (key.startsWith("l")) {
                this.dolist = true;
            } else if (key.startsWith("o")) {
                this.outname = val;
            } else if (key.startsWith("p")) {
                this.dopipe = true;
            } else if (key.startsWith("r")) {
                this.doreverse = true;
            } else if (key.startsWith("t")) {
                this.setTranslation(val, true);
            } else if (key.startsWith("v")) {
                this.verbose = true;
            }
        } else {
            this.handleUnknownArg();
        }
    }

    final String appends(String val, String addval) {
        if (val == null) {
            return addval;
        }
        if (addval == null) {
            return val;
        }
        return val + " " + addval;
    }

    public void setTranslation(String val, boolean append) {
        if (val != null && val.length() > 0) {
            this.dotranslate = true;
            this.translates = append ? this.appends(this.translates, val) : val;
        } else if (!append) {
            this.dotranslate = false;
        }
    }

    public static void usage() {
        run.usage(System.out);
    }

    public static void usage(PrintStream out) {
        out.println();
        out.println("  " + Readseq.version);
        String helps = AppResources.global.getData(kReadseqcHelp);
        if (helps != null) {
            String lf = System.getProperty("line.separator");
            int hat = helps.indexOf("<HTML");
            if (hat >= 0) {
                int at = helps.indexOf(lf);
                at = at < 0 ? 0 : ++at;
                int e = helps.indexOf("</HTML", at);
                if (e > at) {
                    e = helps.lastIndexOf(lf, e);
                }
                if (e < 0) {
                    e = helps.length();
                }
                helps = helps.substring(at, e);
            }
            out.println(helps);
        } else {
            out.println("  Read & reformat biosequences, command-line interface");
            out.println("  Usage: jre -cp readseq.jar " + (class$iubio$readseq$run == null ? (class$iubio$readseq$run = run.class$("iubio.readseq.run")) : class$iubio$readseq$run).getName() + " [options] input-file");
            out.println();
            out.println("  Options: [help not available]");
            out.println();
        }
        out.println("  Known biosequence formats:");
        out.println(BioseqFormats.getInfo(0, "space-header"));
        int i = 1;
        while (i <= BioseqFormats.nFormats()) {
            out.println(BioseqFormats.getInfo(i, "space-command-line"));
            ++i;
        }
        out.println("   (Int'leaf = interleaved format; Features = documentation/features are parsed)");
        out.println();
    }

    private static void reportMemory(String lab, Runtime rt) {
        long total = rt.totalMemory();
        long free = rt.freeMemory();
        long using = total - free;
        System.err.print(lab);
        System.err.print('\t');
        System.err.println(free + "/" + total + ": use " + using + " bytes");
        System.err.flush();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

