/*
 * Decompiled with CFR 0.152.
 */
package iubio.readseq;

import flybase.AppResources;
import flybase.Environ;
import flybase.Utils;
import iubio.readseq.BioseqFormat;
import iubio.readseq.BioseqFormats;
import iubio.readseq.app;
import iubio.readseq.cgi;
import iubio.readseq.run;
import iubio.readseq.test;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;

public class help {
    public static String kReadseq2Help = "rez/Readseq2-help.html";
    public boolean dohtml;
    public PrintStream out;
    boolean didfmthead = false;

    public static void main(String[] args) {
        help help2 = new help(args);
    }

    public help() {
        this.help(null, System.out);
    }

    public help(String[] args) {
        this.help(args, System.out);
    }

    public help(PrintStream out) {
        this.help(null, out);
    }

    public help(String[] args, PrintStream out) {
        this.help(args, out);
    }

    public help(boolean noaction, boolean dohtml, PrintStream out) {
        this.dohtml = dohtml;
        this.out = out;
    }

    public void help(String[] args, PrintStream out) {
        if (out == null) {
            out = System.out;
        }
        this.out = out;
        boolean needhelp = false;
        boolean morehelp = false;
        boolean formathelp = false;
        if (args != null) {
            int i = 0;
            while (i < args.length) {
                String arg = args[i].toLowerCase();
                if (arg.startsWith("-")) {
                    arg = arg.substring(1);
                }
                if (arg.indexOf("html") >= 0) {
                    this.dohtml = true;
                } else if (arg.startsWith("h")) {
                    needhelp = true;
                } else if (arg.startsWith("m")) {
                    morehelp = true;
                } else if (arg.startsWith("f")) {
                    formathelp = true;
                }
                ++i;
            }
        }
        if (needhelp || !morehelp && !formathelp) {
            this.mainHelp();
        }
        if (morehelp) {
            this.extraHelp();
        }
        if (formathelp) {
            this.formatHelp();
        }
    }

    public void mainHelp() {
        this.out.println(" For basic help     : java -cp readseq.jar help ");
        this.out.println(" For more details   : java -cp readseq.jar help more ");
        this.out.println(" For format details : java -cp readseq.jar help formats ");
        String homeurl = Environ.gEnv.get("APP_SOURCE_URL");
        if (homeurl.length() > 0) {
            this.out.println("  Home of this package");
            if (this.dohtml) {
                this.out.println("    <a href=\"" + homeurl + "\">" + homeurl + "</a>");
            } else {
                this.out.println("    " + homeurl);
            }
        }
        this.out.println("Programs available in this package");
        this.rule();
        app.appusage(this.out);
        this.rule();
        cgi.cgiusage(this.out);
        this.rule();
        test.testusage(this.out);
        this.rule();
        run.usage(this.out);
        this.rule();
    }

    public void extraHelp() {
        String helps = AppResources.global.getData(kReadseq2Help);
        if (helps == null) {
            this.out.println("No extra help found in " + kReadseq2Help);
        } else if (this.dohtml) {
            this.out.println(helps);
        } else {
            this.out.println(Utils.htmlToText(helps));
        }
    }

    public void formatHelp() {
        if (this.dohtml) {
            this.out.println("<HTML><TITLE>Readseq: Formats</TITLE><BODY>");
            this.out.println("<B>Known biosequence formats:</B><BR>");
            this.out.println(BioseqFormats.getInfo(0, "html-header"));
            int i = 1;
            while (i <= BioseqFormats.nFormats()) {
                String s = BioseqFormats.getInfo(i, "html-command-line-toc");
                this.out.println(s);
                ++i;
            }
            this.out.println(BioseqFormats.getInfo(0, "html-footer"));
            this.rule();
            this.out.println("<P>");
            int i2 = 1;
            while (i2 <= BioseqFormats.nFormats()) {
                this.formatDoc(i2);
                ++i2;
            }
            this.out.println("&nbsp;&nbsp; (Int'leaf = interleaved format; Features = documentation/features are parsed)");
        } else {
            this.out.println("Known biosequence formats:");
            int i = 1;
            int n = BioseqFormats.nFormats();
            while (i <= n) {
                this.formatDoc(i);
                ++i;
            }
            this.out.println(BioseqFormats.getInfo(0, "space-footer"));
            this.out.println("   (Int'leaf = interleaved format; Features = documentation/features are parsed)");
        }
    }

    public void formatDocEnd() {
        this.out.println(BioseqFormats.getInfo(0, this.dohtml ? "html-footer" : "space-footer"));
    }

    public void formatDoc(int ifmt) {
        String s;
        if (!this.didfmthead) {
            s = BioseqFormats.getInfo(0, this.dohtml ? "html-header" : "space-header");
            if (this.dohtml) {
                s = "<A name=\"fmt" + ifmt + "\">&nbsp</a>" + s;
            }
            this.out.println(s);
        } else {
            s = BioseqFormats.getInfo(0, this.dohtml ? "html-header1" : "space-header1");
            this.out.println(s);
        }
        s = BioseqFormats.getInfo(ifmt, this.dohtml ? "html-command-line" : "space-command-line");
        this.out.println(s);
        if (this.dohtml) {
            this.out.println(BioseqFormats.getInfo(0, "html-footer"));
        } else {
            this.out.println();
        }
        BioseqFormat fmt = BioseqFormats.bioseqFormat(ifmt);
        InputStream ins = fmt.getDocument();
        if (ins == null) {
            this.out.println("No format details ");
        } else {
            try {
                String lf = System.getProperty("line.separator");
                StringBuffer sb = new StringBuffer();
                DataInputStream dis = new DataInputStream(ins);
                while ((s = dis.readLine()) != null) {
                    sb.append(s);
                    sb.append(lf);
                }
                s = sb.toString();
                int it = s.indexOf("<BODY>");
                if (it > 0) {
                    s = s.substring(it + "<BODY>".length());
                }
                if ((it = s.indexOf("</BODY>")) > 0) {
                    s = s.substring(0, it);
                }
                if (this.dohtml) {
                    this.out.println(s);
                } else {
                    this.out.println(Utils.htmlToText(s));
                }
                ins.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        this.rule();
    }

    public void rule() {
        if (this.dohtml) {
            this.out.print("<HR width=\"50%\" align=left>");
        } else {
            int i = 0;
            while (i < 30) {
                this.out.print('-');
                ++i;
            }
        }
        this.out.println();
    }
}

