/*
 * Decompiled with CFR 0.152.
 */
package iubio.readseq;

import flybase.Debug;
import flybase.OpenString;
import iubio.bioseq.SeqInfo;
import iubio.readseq.BioseqFormat;
import iubio.readseq.BioseqFormats;
import iubio.readseq.HTMLFilterReader;
import iubio.readseq.PlainSeqFormat;
import iubio.readseq.SeqFileInfo;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;

public class Testseq {
    public static int maxlines2check = 500;
    public static int kBufferSize = 4094;
    protected static int plainFormatID = BioseqFormats.formatFromContentType("biosequence/plain");
    protected boolean done;
    protected int splen;
    protected int nbytes;
    protected int nlines;
    protected int format;
    protected int skiplines;
    protected int maxbytes2check;
    protected SeqInfo seqkind;
    protected Reader fIns;
    protected Reader fNewIns;
    private static final boolean bTestHtmlFilter = true;
    private static final boolean bTestGzipFilter = false;
    private static final boolean bSuckAll = true;
    private OpenString sp;
    private BufferedReader dis;
    private char[] osval;
    private OpenString osbuf;
    private int oslinei;
    private int oslen;
    private int osnewlinesize = 1;
    private char osnewline;
    public static final int GZIP_MAGIC = 35615;

    public Testseq() {
        this.initTest();
    }

    public int getFormat() {
        return this.format;
    }

    public int getStartLine() {
        return this.skiplines;
    }

    public Reader getPossibleNewInputReader() {
        return this.fNewIns != null ? this.fNewIns : this.fIns;
    }

    public Reader getFilterReader() {
        return this.fNewIns;
    }

    protected void initTest() {
        this.format = BioseqFormats.kUnknown;
        this.done = false;
        this.skiplines = 0;
        this.splen = 0;
        this.nlines = 0;
        this.nbytes = 0;
        this.maxbytes2check = kBufferSize - 200;
        this.seqkind = SeqInfo.getSeqInfo(this.maxbytes2check, false, false);
    }

    protected final OpenString readLine() {
        return this.readOSLine();
    }

    protected OpenString readInsLine() {
        block3: {
            this.sp = null;
            this.splen = 0;
            try {
                String s = this.dis.readLine();
                if (s == null) {
                    this.done = true;
                    break block3;
                }
                this.sp = new OpenString(s);
                this.splen = this.sp.length();
                ++this.nlines;
                this.nbytes += this.splen;
            }
            catch (IOException ex) {
                this.done = true;
            }
        }
        return this.sp;
    }

    protected OpenString readOSLine() {
        if (this.oslinei < 0) {
            this.done = true;
            this.splen = 0;
            this.sp = null;
        } else {
            int e = this.osbuf.indexOf(this.osnewline, this.oslinei);
            if (e < this.oslinei) {
                this.sp = this.osbuf.substring(this.oslinei);
                this.oslinei = -1;
            } else {
                this.sp = this.osbuf.substring(this.oslinei, e);
                this.oslinei = e + this.osnewlinesize;
                this.nbytes += this.osnewlinesize;
            }
            this.splen = this.sp.length();
            ++this.nlines;
            this.nbytes += this.splen;
        }
        return this.sp;
    }

    protected void openStream(Reader ins) {
        if (this.osval == null) {
            this.osval = new char[kBufferSize];
        }
        try {
            this.oslen = ins.read(this.osval);
            this.osbuf = new OpenString(this.osval, 0, this.oslen);
            this.oslinei = 0;
        }
        catch (IOException e) {
            this.oslen = 0;
            this.oslinei = -1;
        }
        this.osnewlinesize = 1;
        int i = 0;
        while (i < this.oslen) {
            if (this.osval[i] == '\n') {
                this.osnewline = (char)10;
                if (this.osval[i + 1] != '\r') break;
                this.osnewlinesize = 2;
                break;
            }
            if (this.osval[i] == '\r') {
                this.osnewline = (char)13;
                if (this.osval[i + 1] != '\n') break;
                this.osnewlinesize = 2;
                break;
            }
            ++i;
        }
    }

    protected boolean checkMailHeader() {
        int hat = this.sp.indexOf("From ");
        if (hat != 0) {
            hat = this.sp.indexOf("Received");
        }
        if (hat == 0) {
            int k = 0;
            do {
                this.sp = this.readLine();
                k = 0;
                while (k < this.splen && this.sp.charAt(k) <= ' ') {
                    ++k;
                }
            } while (!this.done && k < this.splen);
            this.skiplines = this.nlines;
            return true;
        }
        return false;
    }

    protected boolean checkCompressedData() {
        return false;
    }

    protected boolean checkHtmlHeader() {
        boolean gotpre = false;
        int hat = this.sp.indexOf("<HTML");
        if (hat < 0) {
            hat = this.sp.indexOf("<html");
        }
        if (hat < 0) {
            hat = this.sp.indexOf("<BODY");
        }
        if (hat < 0) {
            hat = this.sp.indexOf("<body");
        }
        if (hat < 0) {
            hat = this.sp.indexOf("<PRE");
            if (hat < 0) {
                hat = this.sp.indexOf("<pre");
            }
            if (hat >= 0) {
                gotpre = true;
                this.sp = this.sp.substring(hat + 5);
                this.splen = this.sp.length();
            }
        }
        if (hat >= 0) {
            while (!gotpre && !this.done) {
                this.sp = this.readLine();
                if (this.done) continue;
                int at = this.sp.indexOf("<PRE>");
                if (at < 0) {
                    at = this.sp.indexOf("<pre>");
                }
                if (at < 0) continue;
                gotpre = true;
                this.sp = this.sp.substring(at + 5);
                this.splen = this.sp.length();
            }
            this.skiplines = this.nlines - 1;
            this.fNewIns = new HTMLFilterReader(this.fIns, this.nbytes - this.splen - 1);
            Debug.println("using HTMLFilterReader");
            this.skiplines = 0;
            this.nlines = 1;
            return true;
        }
        return false;
    }

    public int testFormat(Reader ins, SeqFileInfo si) {
        int maybeskip = 0;
        int bestform = -1;
        int bestpct = 0;
        int otherlines = 0;
        int aminolines = 0;
        int dnalines = 0;
        this.fIns = ins;
        if (ins == null) {
            si.err = -1;
            this.format = BioseqFormats.kNoformat;
            return this.format;
        }
        this.initTest();
        BioseqFormats.formatTestInit();
        this.openStream(ins);
        boolean headChecked = false;
        BioseqFormat psf = BioseqFormats.bioseqFormat(BioseqFormats.formatFromName("raw"));
        if (psf instanceof PlainSeqFormat) {
            ((PlainSeqFormat)psf).setSeqInfoTester(this.seqkind);
        }
        while (!this.done) {
            int iform;
            this.sp = this.readLine();
            if (this.nlines < 10 && !this.done && !headChecked) {
                if (this.checkHtmlHeader()) {
                    headChecked = true;
                } else if (this.checkMailHeader()) {
                    headChecked = true;
                }
            }
            boolean testLineFound = false;
            if (this.sp != null && this.splen > 0) {
                iform = 1;
                while (iform <= BioseqFormats.nFormats()) {
                    block25: {
                        try {
                            if (BioseqFormats.formatTestLine(iform, this.sp, this.nlines, this.skiplines)) {
                                testLineFound = true;
                            }
                        }
                        catch (Exception fmte) {
                            if (!Debug.isOn) break block25;
                            fmte.printStackTrace();
                        }
                    }
                    ++iform;
                }
                if (!testLineFound || this.nlines - this.skiplines > 10) {
                    this.seqkind.add(this.sp.getValue(), this.sp.getOffset(), this.splen);
                    int skind = this.seqkind.getKind();
                    switch (skind) {
                        case 1: 
                        case 2: {
                            if (this.splen <= 20) break;
                            ++dnalines;
                            break;
                        }
                        case 4: {
                            if (this.splen <= 20) break;
                            ++aminolines;
                            break;
                        }
                        case 0: {
                            ++otherlines;
                            break;
                        }
                    }
                }
            }
            iform = 1;
            bestform = -1;
            bestpct = 0;
            while (iform <= BioseqFormats.nFormats()) {
                block26: {
                    try {
                        int percent = BioseqFormats.formatTestLikelihood(iform);
                        if (percent > bestpct) {
                            bestform = iform;
                            bestpct = percent;
                        }
                    }
                    catch (Exception fmte) {
                        if (!Debug.isOn) break block26;
                        fmte.printStackTrace();
                    }
                }
                ++iform;
            }
            if (bestform >= 0 && bestpct >= 90) {
                this.format = BioseqFormats.formatFromIndex(bestform);
                this.done = true;
                continue;
            }
            if (!this.done && this.nbytes <= this.maxbytes2check) continue;
            this.format = bestform >= 0 && bestpct > 50 ? BioseqFormats.formatFromIndex(bestform) : (otherlines > 0 ? BioseqFormats.kUnknown : (dnalines > 0 ? plainFormatID : (aminolines > 0 ? plainFormatID : BioseqFormats.kUnknown)));
            this.done = true;
        }
        if (bestform >= 0) {
            maybeskip = BioseqFormats.recordStartLine(bestform) - 1;
        }
        if (this.skiplines == 0 && maybeskip > 0) {
            this.skiplines = maybeskip;
        }
        si.format = this.format;
        si.skiplines = this.skiplines;
        return this.format;
    }
}

