/*
 * Decompiled with CFR 0.152.
 */
package iubio.readseq;

import Acme.Fmt;
import iubio.bioseq.SeqRange;
import iubio.readseq.BioseqDoc;
import iubio.readseq.DocItem;
import iubio.readseq.EmblDoc;
import iubio.readseq.FeatureItem;

public class SwissDoc
extends EmblDoc {
    public SwissDoc() {
        this.swinit();
    }

    public SwissDoc(BioseqDoc source) {
        super(source);
        this.swinit();
    }

    public SwissDoc(String idname) {
        super(idname);
        this.swinit();
    }

    protected void swinit() {
        this.fFeatIndent = 14;
        this.isAmino = true;
    }

    public void addFeature(String field, String value, int level, boolean append) {
        if (this.lastlev == 1) {
            this.addDocField(70, "");
        }
        String start = "";
        String stop = "";
        int sp = value.indexOf(32);
        if (sp > 0) {
            start = value.substring(0, sp);
            if ((sp = (value = value.substring(sp + 1).trim()).indexOf(32)) > 0) {
                stop = value.substring(0, sp);
                value = value.substring(sp + 1).trim();
            } else {
                stop = value;
                value = "";
            }
            start = start + ".." + stop;
        }
        super.addFeature(field, start, level, false);
        this.addFeatureNote("note", value);
    }

    protected void addIdline(String field, String val) {
        int vlen = val.length();
        int at = this.addlinefield(val, vlen, 0, " ", field, 10, 1);
        if (at > 0) {
            at = this.addlinefield(val, vlen, at, "; ", "dataclass", 12, 1);
        }
        if (at > 0) {
            at = this.addlinefield(val, vlen, at, "; ", "mol", 113, 1);
        }
        if (at > 0) {
            at = this.addlinefield(val, vlen, at, " AA", "length", 112, 1);
        }
    }

    protected String getIdValue(DocItem di) {
        StringBuffer sb = new StringBuffer();
        this.putlinefield(sb, Fmt.fmt(di.getValue(), 15, 2), "Noname", "");
        this.putlinefield(sb, 8, this.getDocField(12), "STANDARD", "; ");
        this.putlinefield(sb, 8, this.getDocField(113), "      PRT", "; ");
        this.putlinefield(sb, 5, this.getDocField(112), "   0", " AA.");
        return sb.toString();
    }

    protected void addSeqstats(String field, String val) {
        int vlen = val.length();
        super.addDocField(field, "", 110, 1, false);
        int at = val.indexOf("AA;") + 4;
        if (at > 0) {
            at = this.addlinefield(val, vlen, at, " MW;", "mw", 121, 2);
        }
        if (at > 0) {
            at = this.addlinefield(val, vlen, at, " CRC", "crc", 114, 2);
        }
    }

    protected String getSequenceValue(DocItem di) {
        StringBuffer sb = new StringBuffer("SEQUENCE ");
        this.putlinefield(sb, 5, this.getDocField(112), "0", " AA; ");
        this.putlinefield(sb, 6, this.getDocField(121), "", "");
        this.putlinefield(sb, 9, this.getDocField(114), "", "");
        return sb.toString();
    }

    protected void putlinefield(StringBuffer sb, int wd, String sv, String defval, String tail) {
        sb.append(Fmt.fmt(sv == null ? defval : sv, wd, 0));
        sb.append(tail);
    }

    protected void writeDocItem(DocItem nv, boolean writeAll) {
        switch (nv.getKind()) {
            default: {
                super.writeDocItem(nv, writeAll);
                break;
            }
            case 70: {
                if (this.featWrit || !writeAll) break;
                this.writeDocVector(this.features(), writeAll);
                this.writeExtractionFeature();
                this.featWrit = true;
            }
        }
    }

    protected String getFieldLabel(int level, DocItem di) {
        Object name = null;
        this.indent = 0;
        this.subindent = 0;
        switch (level) {
            default: {
                return super.getFieldLabel(level, di);
            }
            case 5: 
        }
        return null;
    }

    protected String getFieldValue(DocItem di) {
        if (di instanceof FeatureItem) {
            SeqRange sr = ((FeatureItem)di).getLocation();
            String val = Fmt.fmt(sr.start() + 1, 6, 0) + " " + Fmt.fmt(sr.stop() + 1, 6, 0);
            String note = ((FeatureItem)di).getNoteValue("note");
            if ((note = this.getTrimFieldValue(note)) != null) {
                val = val + Fmt.fmt(" ", 7) + note;
            }
            return val;
        }
        if (di.getLevel() == 5) {
            return this.getTrimFieldValue(di);
        }
        return super.getFieldValue(di);
    }
}

