/*
 * Decompiled with CFR 0.152.
 */
package iubio.readseq;

import flybase.Debug;
import iubio.bioseq.Bioseq;
import iubio.readseq.BioseqReaderIface;
import iubio.readseq.BioseqWriterIface;
import iubio.readseq.GenbankDoc;
import iubio.readseq.MessageApp;
import iubio.readseq.NotScfException;
import iubio.readseq.RsInput;
import iubio.readseq.SeqFileInfo;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Hashtable;

class ScfTraceReader
implements BioseqReaderIface {
    public static boolean verbose;
    static final boolean useBioseqBytes = true;
    protected int formatId;
    protected int seqlen;
    protected int seqoffset;
    protected int nseq;
    protected int err;
    protected int choice;
    protected int atseq;
    protected String idword = SeqFileInfo.gBlankSeqid;
    protected String seqid = SeqFileInfo.gBlankSeqid;
    private byte[] bases;
    protected Object seqdoc;
    private boolean fEof = false;
    private Reader fIns;
    private InputStream fByteIns;
    private int oslinei;
    private int oslen;
    private final int kMaxbuf = 8192;
    public static MessageApp messageapp;
    private static final long SCF_MAGIC = 779314022L;
    public static final int NONE = 0;
    public static final int BASES = 1;
    public static final int LEFTVEC = 2;
    public static final int LEFTQUAL = 3;
    public static final int RIGHTQUAL = 4;
    public static final int RIGHTVEC = 5;
    public short[][] data;
    public byte[][] data1;
    public int magic_number;
    public int samples;
    public int samples_offset;
    public int numbases;
    public int bases_left_clip;
    public int bases_right_clip;
    public int bases_offset;
    public int comments_size;
    public int comments_offset;
    public int sample_size;
    public int code_set;
    public int private_size;
    public int private_offset;
    public short max;
    public short qualmax;
    int[] spare = new int[18];
    char[] version = new char[4];
    char[] private_data;
    public int[] peaks;
    public short[] prob_A;
    public short[] prob_C;
    public short[] prob_G;
    public short[] prob_T;
    public short[] quality;
    short[][] basespare;
    short p_sample;
    byte p_sample1;
    public Hashtable commentHash;
    int leftqual;
    int rightqual;
    int leftvec;
    int rightvec;
    int leftqualbase;
    int leftvecbase;
    int rightqualbase;
    int rightvecbase;
    int insertpos;

    public ScfTraceReader() {
    }

    public ScfTraceReader(Reader ins) {
        this.setInput(ins);
    }

    public static void message(String s) {
        if (messageapp != null) {
            messageapp.infomessage(s);
        } else {
            System.err.println(s);
        }
    }

    public int formatID() {
        return this.formatId;
    }

    public void setFormatID(int id) {
        this.formatId = id;
    }

    public void setInput(Reader ins) {
        this.fIns = ins;
        this.fEof = false;
        this.setReaderBuf(this.fIns);
    }

    public boolean endOfFile() {
        return this.fEof;
    }

    public void reset() {
        block2: {
            this.err = 0;
            this.atseq = 0;
            this.nseq = 0;
            this.seqlen = 0;
            this.fEof = false;
            if (this.fIns == null) break block2;
            try {
                this.fIns.reset();
                this.fEof = !this.fIns.ready();
                this.setReaderBuf(this.fIns);
            }
            catch (IOException ex) {
                Debug.println(this.getClass().getName() + ".reset() err=" + ex.getMessage());
            }
        }
    }

    void setReaderBuf(Reader ins) {
        this.oslinei = 0;
        this.oslen = 0;
        this.fByteIns = ins instanceof RsInput ? ((RsInput)ins).getByteStream() : null;
    }

    public void resetSeq() {
        this.seqlen = 0;
        this.idword = SeqFileInfo.gBlankSeqid;
        this.seqid = SeqFileInfo.gBlankSeqid;
    }

    public void setChoice(int seqchoice) {
        this.choice = seqchoice;
    }

    public int getNseq() {
        return this.nseq;
    }

    public void copyto(SeqFileInfo si) {
        if (si == null) {
            return;
        }
        if (si.err == 0) {
            si.err = this.err;
        }
        si.seqlen = this.seqlen;
        if (si.err == 0 && this.seqlen > 0) {
            si.atseq = this.atseq;
            if (this.atseq > si.nseq) {
                si.nseq = this.atseq;
            }
            si.seqid = this.seqid;
            si.seqdoc = this.seqdoc;
            si.checkSeqID();
            si.seq = new Bioseq(this.bases, 0, this.seqlen);
        }
    }

    public void skipPastHeader(int skiplines) {
    }

    public void doRead() throws IOException {
        this.nseq = 0;
        if (this.fIns == null) {
            throw new FileNotFoundException();
        }
        this.getOsBuf();
        this.seqlen = this.getData();
        ++this.nseq;
        if (this.seqdoc == null) {
            this.seqdoc = new GenbankDoc(this.seqid.toString());
        }
    }

    public void readTo(BioseqWriterIface writer, int skipHeaderLines) throws IOException {
        int skiplines = skipHeaderLines;
        boolean more = true;
        int atseqNum = 1;
        while (more) {
            this.skipPastHeader(skiplines);
            skiplines = 0;
            SeqFileInfo sfi = this.readOne(atseqNum);
            if (sfi == null) {
                more = false;
            } else {
                if (Debug.isOn || verbose) {
                    ScfTraceReader.message("read " + atseqNum + " id=" + sfi.seqid + " seqlen=" + sfi.seqlen);
                }
                if (writer.setSeq(sfi)) {
                    writer.writeSeqRecord();
                }
            }
            ++atseqNum;
        }
    }

    public SeqFileInfo readOne(int whichEntry) throws IOException {
        this.resetSeq();
        if (this.endOfFile()) {
            return null;
        }
        this.setChoice(whichEntry);
        this.doRead();
        SeqFileInfo sfi = new SeqFileInfo();
        this.copyto(sfi);
        sfi.nseq = this.getNseq();
        return sfi;
    }

    private void getOsBuf() throws IOException {
    }

    private final int readByte() throws IOException {
        if (this.fByteIns != null) {
            int b = this.fByteIns.read();
            if (b < 0) {
                this.fEof = true;
                throw new EOFException();
            }
            return b;
        }
        int b = this.fIns.read();
        if (b < 0) {
            this.fEof = true;
            throw new EOFException();
        }
        return (byte)b;
    }

    private final int readUint4() throws IOException {
        int ch1 = this.readByte();
        int ch2 = this.readByte();
        int ch3 = this.readByte();
        int ch4 = this.readByte();
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    private final int readUint2() throws IOException {
        int ch1 = this.readByte();
        int ch2 = this.readByte();
        return (ch1 << 8) + (ch2 << 0);
    }

    private final short readSint2s() throws IOException {
        int ch1 = this.readByte();
        int ch2 = this.readByte();
        return (short)((ch1 << 8) + (ch2 << 0));
    }

    private final short readUint1() throws IOException {
        return (short)this.readByte();
    }

    protected int getData() throws IOException {
        int bat;
        byte base;
        int j;
        Debug.println("ScfTraceReader.getData");
        this.magic_number = this.readUint4();
        if ((long)this.magic_number != 779314022L) {
            throw new NotScfException("Input is not in SCF format.");
        }
        this.samples = this.readUint4();
        Debug.println("samples=" + this.samples);
        this.samples_offset = this.readUint4();
        this.numbases = this.readUint4();
        Debug.println("numbases=" + this.numbases);
        this.bases_left_clip = this.readUint4();
        this.bases_right_clip = this.readUint4();
        this.bases_offset = this.readUint4();
        this.comments_size = this.readUint4();
        this.comments_offset = this.readUint4();
        int i = 0;
        while (i < 4) {
            this.version[i] = (char)this.readByte();
            ++i;
        }
        Debug.println("version=" + this.version[0]);
        this.sample_size = this.readUint4();
        Debug.println("sample_size=" + this.sample_size);
        this.code_set = this.readUint4();
        this.private_size = this.readUint4();
        this.private_offset = this.readUint4();
        i = 0;
        while (i < 18) {
            this.spare[i] = this.readUint4();
            ++i;
        }
        if (this.sample_size == 1 && this.version[0] == '3') {
            this.data1 = new byte[4][this.samples];
        }
        this.data = new short[4][this.samples];
        if (this.version[0] == '2' || this.version[0] == '1') {
            if (this.sample_size == 1) {
                i = 0;
                while (i < this.samples) {
                    j = 0;
                    while (j < 4) {
                        this.data[j][i] = this.readUint1();
                        ++j;
                    }
                    ++i;
                }
            } else if (this.sample_size == 2) {
                i = 0;
                while (i < this.samples) {
                    j = 0;
                    while (j < 4) {
                        this.data[j][i] = this.readSint2s();
                        ++j;
                    }
                    ++i;
                }
            }
        } else if (this.sample_size == 1) {
            j = 0;
            while (j < 4) {
                i = 0;
                while (i < this.samples) {
                    this.data1[j][i] = (byte)this.readByte();
                    ++i;
                }
                ++j;
            }
            j = 0;
            while (j < 4) {
                this.p_sample1 = 0;
                i = 0;
                while (i < this.samples) {
                    byte[] byArray = this.data1[j];
                    int n = i;
                    byArray[n] = (byte)(byArray[n] + this.p_sample1);
                    this.p_sample1 = this.data1[j][i];
                    ++i;
                }
                this.p_sample1 = 0;
                i = 0;
                while (i < this.samples) {
                    byte[] byArray = this.data1[j];
                    int n = i;
                    byArray[n] = (byte)(byArray[n] + this.p_sample1);
                    this.p_sample1 = this.data1[j][i];
                    this.data[j][i] = this.data1[j][i];
                    if (this.data[j][i] < 0) {
                        short[] sArray = this.data[j];
                        int n2 = i;
                        sArray[n2] = (short)(sArray[n2] + 256);
                    }
                    ++i;
                }
                ++j;
            }
        } else if (this.sample_size == 2) {
            j = 0;
            while (j < 4) {
                i = 0;
                while (i < this.samples) {
                    this.data[j][i] = this.readSint2s();
                    ++i;
                }
                ++j;
            }
            j = 0;
            while (j < 4) {
                this.p_sample = 0;
                i = 0;
                while (i < this.samples) {
                    this.data[j][i] = (short)(this.data[j][i] + this.p_sample);
                    this.p_sample = this.data[j][i];
                    ++i;
                }
                this.p_sample = 0;
                i = 0;
                while (i < this.samples) {
                    this.data[j][i] = (short)(this.data[j][i] + this.p_sample);
                    this.p_sample = this.data[j][i];
                    ++i;
                }
                ++j;
            }
        }
        this.seqlen = 0;
        this.bases = new byte[this.numbases];
        this.peaks = new int[this.numbases];
        this.prob_A = new short[this.numbases];
        this.prob_C = new short[this.numbases];
        this.prob_G = new short[this.numbases];
        this.prob_T = new short[this.numbases];
        this.basespare = new short[this.numbases][3];
        this.quality = new short[this.samples];
        if (this.version[0] == '1' || this.version[0] == '2') {
            i = 0;
            while (i < this.numbases) {
                this.peaks[i] = this.readUint4();
                this.prob_A[i] = this.readUint1();
                this.prob_C[i] = this.readUint1();
                this.prob_G[i] = this.readUint1();
                this.prob_T[i] = this.readUint1();
                base = (byte)this.readByte();
                bat = this.peaks[i];
                this.bases[this.seqlen++] = base;
                j = 0;
                while (j < 3) {
                    this.basespare[i][j] = this.readUint1();
                    ++j;
                }
                ++i;
            }
        } else {
            i = 0;
            while (i < this.numbases) {
                this.peaks[i] = this.readUint4();
                ++i;
            }
            i = 0;
            while (i < this.numbases) {
                this.prob_A[i] = this.readUint1();
                ++i;
            }
            i = 0;
            while (i < this.numbases) {
                this.prob_C[i] = this.readUint1();
                ++i;
            }
            i = 0;
            while (i < this.numbases) {
                this.prob_G[i] = this.readUint1();
                ++i;
            }
            i = 0;
            while (i < this.numbases) {
                this.prob_T[i] = this.readUint1();
                ++i;
            }
            i = 0;
            while (i < this.numbases) {
                base = (byte)this.readByte();
                bat = this.peaks[i];
                this.bases[this.seqlen++] = base;
                ++i;
            }
            j = 0;
            while (j < 3) {
                i = 0;
                while (i < this.numbases) {
                    this.basespare[i][j] = this.readUint1();
                    ++i;
                }
                ++j;
            }
        }
        i = 0;
        while (i < this.numbases) {
            base = this.bases[i];
            switch (base) {
                case 65: {
                    this.quality[this.peaks[i]] = this.prob_A[i];
                    break;
                }
                case 67: {
                    this.quality[this.peaks[i]] = this.prob_C[i];
                    break;
                }
                case 71: {
                    this.quality[this.peaks[i]] = this.prob_G[i];
                    break;
                }
                case 84: {
                    this.quality[this.peaks[i]] = this.prob_T[i];
                    break;
                }
                default: {
                    this.quality[this.peaks[i]] = 0;
                }
            }
            if (i != 0) {
                j = this.peaks[i - 1] + 1;
                while (j < this.peaks[i]) {
                    this.quality[j] = j < (this.peaks[i - 1] + this.peaks[i]) / 2 ? this.quality[this.peaks[i - 1]] : this.quality[this.peaks[i]];
                    ++j;
                }
            }
            ++i;
        }
        this.qualmax = (short)100;
        this.max = 0;
        j = 0;
        while (j < 4) {
            i = 0;
            while (i < this.samples) {
                if (this.data[j][i] > this.max) {
                    this.max = this.data[j][i];
                }
                ++i;
            }
            ++j;
        }
        char[] rawcomment = new char[this.comments_size];
        i = 0;
        while (i < this.comments_size) {
            rawcomment[i] = (char)this.readByte();
            ++i;
        }
        Debug.println("comments=" + new String(rawcomment));
        this.commentHash = this.parseComments(rawcomment);
        if (this.commentHash.contains("PHRED")) {
            this.qualmax = (short)50;
        }
        if (this.commentHash.containsKey("QMAX")) {
            this.qualmax = (short)Integer.parseInt((String)this.commentHash.get("QMAX"));
        }
        this.leftvecbase = this.bases_left_clip;
        this.rightqualbase = this.bases_right_clip;
        this.leftqualbase = 0;
        this.rightvecbase = this.numbases + 1;
        if (this.commentHash.containsKey("CLIP") && ((String)this.commentHash.get("CLIP")).equals("LRQV1.0")) {
            if (this.commentHash.containsKey("LQCE")) {
                this.leftqualbase = Integer.parseInt((String)this.commentHash.get("LQCE"));
            }
            if (this.commentHash.containsKey("RQCB")) {
                this.rightqualbase = Integer.parseInt((String)this.commentHash.get("RQCB"));
            }
            if (this.commentHash.containsKey("LVCE")) {
                this.leftvecbase = Integer.parseInt((String)this.commentHash.get("LVCE"));
            }
            if (this.commentHash.containsKey("RVCB")) {
                this.rightvecbase = Integer.parseInt((String)this.commentHash.get("RVCB"));
            }
        }
        this.leftqual = this.leftqualbase <= 0 ? 0 : (this.leftqualbase >= this.numbases ? this.samples + 1 : (this.peaks[this.leftqualbase] + this.peaks[this.leftqualbase - 1]) / 2);
        this.leftvec = this.leftvecbase <= 0 ? 0 : (this.leftvecbase >= this.numbases ? this.samples + 1 : (this.peaks[this.leftvecbase] + this.peaks[this.leftvecbase - 1]) / 2);
        this.rightqual = this.rightqualbase <= 0 ? 0 : (this.rightqualbase >= this.numbases ? this.samples + 1 : (this.peaks[this.rightqualbase - 1] + this.peaks[this.rightqualbase - 2]) / 2);
        this.rightvec = this.rightvecbase <= 0 ? 0 : (this.rightvecbase >= this.numbases ? this.samples + 1 : (this.peaks[this.rightvecbase - 1] + this.peaks[this.rightvecbase - 2]) / 2);
        if (this.private_size > 0) {
            this.private_data = new char[this.private_size];
            i = 0;
            while (i < this.private_size) {
                this.private_data[i] = (char)this.readByte();
                ++i;
            }
        }
        return this.seqlen;
    }

    private Hashtable parseComments(char[] raw) {
        Hashtable<String, String> comments = new Hashtable<String, String>(20, 1.0f);
        char[] temp = new char[raw.length];
        int i = 0;
        while (i < raw.length) {
            int j = i;
            while (i < raw.length && raw[i] != '=' && raw[i] != '\n') {
                temp[i - j] = raw[i++];
            }
            if (i >= raw.length || raw[i] == '\n') {
                ++i;
                continue;
            }
            ++i;
            int k = 0;
            while (Character.isSpace(temp[k])) {
                ++k;
            }
            String tag = new String(temp, k, 4);
            while (i < raw.length && Character.isSpace(raw[i])) {
                ++i;
            }
            j = i;
            while (i < raw.length && raw[i] != '\n') {
                temp[i - j] = raw[i++];
            }
            String value = new String(temp, 0, i - j);
            comments.put(tag, value);
            ++i;
        }
        return comments;
    }

    static {
        messageapp = null;
    }
}

