/*
 * Decompiled with CFR 0.152.
 */
package iubio.readseq;

import flybase.AppResources;
import flybase.Debug;
import flybase.Environ;
import flybase.FastVector;
import flybase.Native;
import flybase.OpenString;
import iubio.bioseq.Bioseq;
import iubio.bioseq.SeqInfo;
import iubio.bioseq.SeqRange;
import iubio.readseq.BasicBioseqDoc;
import iubio.readseq.BioseqFormat;
import iubio.readseq.BioseqFormats;
import iubio.readseq.BioseqReader;
import iubio.readseq.BioseqReaderIface;
import iubio.readseq.BioseqRecord;
import iubio.readseq.BioseqWriter;
import iubio.readseq.BioseqWriterIface;
import iubio.readseq.FeatureItem;
import iubio.readseq.FlatFeatReader;
import iubio.readseq.PlainSeqFormat;
import iubio.readseq.PlainSeqReader;
import iubio.readseq.ReadseqException;
import iubio.readseq.RsInput;
import iubio.readseq.RsInputBytes;
import iubio.readseq.RsInputChars;
import iubio.readseq.RsInputFile;
import iubio.readseq.RsInputOpenString;
import iubio.readseq.RsInputReader;
import iubio.readseq.RsInputStream;
import iubio.readseq.RsInputString;
import iubio.readseq.RsInputUrl;
import iubio.readseq.SeqFileInfo;
import iubio.readseq.Testseq;
import iubio.readseq.WriteseqOpts;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Readseq
implements Enumeration {
    public static String version = "Readseq version 2.1.19 (14-Mar-2004)";
    public static String kInputStringKey = "indata=";
    public boolean verbose;
    public boolean verboseClassic;
    public boolean noEmptyFiles;
    protected int forceFormatId;
    protected File indir;
    protected boolean didinit;
    protected Hashtable exfeatures;
    protected SeqRange featSubrange;
    protected SeqRange extractRange;
    protected boolean wantSelectedFeats;
    protected int extractOrigin;
    protected boolean fWriteMask = SeqFileInfo.gWriteMask;
    protected Testseq formatTestor;
    protected Vector seqfilevec = new Vector();
    protected int fAt;
    protected BioseqReaderIface reader;
    protected BioseqFormat former;
    protected Reader fIns;
    protected RsInput fRdIns;
    protected SeqFileInfo si = new SeqFileInfo();
    protected int format;
    protected int saveskip;
    protected int whichEntry = 1;
    protected String seqDefname;

    public Readseq() {
        this(BioseqFormats.kNoformat);
    }

    public Readseq(int format) {
        this.setFormat(format);
        this.verbose = Debug.isOn || BioseqReader.verbose;
    }

    public Reader getInput() {
        return this.fIns;
    }

    public void setInput(File f) throws IOException {
        this.close();
        this.fRdIns = new RsInputFile(f);
        this.fIns = this.fRdIns;
    }

    public void setInput(Reader in) throws IOException {
        this.close();
        this.fRdIns = new RsInputReader(in);
        this.fIns = this.fRdIns;
    }

    public void setInput(InputStream in) throws IOException {
        this.close();
        this.fRdIns = new RsInputStream(in);
        this.fIns = this.fRdIns;
    }

    public void setInput(URL url) throws IOException {
        this.close();
        this.fRdIns = new RsInputUrl(url);
        this.fIns = this.fRdIns;
    }

    public void setInput(String s) throws IOException {
        this.close();
        this.fRdIns = new RsInputString(s);
        this.fIns = this.fRdIns;
    }

    public void setInput(OpenString s) throws IOException {
        this.close();
        this.fRdIns = new RsInputOpenString(s);
        this.fIns = this.fRdIns;
    }

    public void setInput(byte[] b) throws IOException {
        this.close();
        this.fRdIns = new RsInputBytes(b);
        this.fIns = this.fRdIns;
    }

    public void setInput(char[] c) throws IOException {
        this.close();
        this.fRdIns = new RsInputChars(c);
        this.fIns = this.fRdIns;
    }

    public String setInputObject(Object inob) throws IOException {
        if (inob instanceof String) {
            inob = this.checkInString((String)inob);
        }
        return this.setInputObjectChecked(inob);
    }

    public String setInputObjectChecked(Object inob) throws IOException {
        if (inob instanceof File) {
            this.setInput((File)inob);
            return inob.toString();
        }
        if (inob instanceof URL) {
            this.setInput((URL)inob);
            return inob.toString();
        }
        if (inob instanceof InputStream) {
            this.setInput((InputStream)inob);
            return "InputStream";
        }
        if (inob instanceof Reader) {
            this.setInput((Reader)inob);
            return "Reader";
        }
        if (inob instanceof String) {
            this.setInput((String)inob);
            return "String";
        }
        if (inob instanceof OpenString) {
            this.setInput((OpenString)inob);
            return "OpenString";
        }
        if (inob instanceof char[]) {
            this.setInput((char[])inob);
            return "char[]";
        }
        if (inob instanceof byte[]) {
            this.setInput((byte[])inob);
            return "byte[]";
        }
        if (inob instanceof Enumeration) {
            this.readlist((Enumeration)inob);
            return null;
        }
        if (inob instanceof Integer) {
            return null;
        }
        if (inob != null) {
            this.message("Unreadable input object " + inob.getClass().getName());
            return null;
        }
        return null;
    }

    public static String tempFolder() {
        return Environ.gEnv.get("tempdir", Native.tempFolder());
    }

    public static String tempFilename() {
        return Native.tempFilename("readseq-", ".tmp");
    }

    public static File tempFile() {
        return new File(Readseq.tempFolder(), Readseq.tempFilename());
    }

    protected void message(String s) {
        BioseqReader.message(s);
    }

    public void close() throws IOException {
        if (this.fIns != null) {
            this.fIns.close();
        }
        if (this.fRdIns != null) {
            try {
                this.fRdIns.finalize();
            }
            catch (Throwable th) {
                // empty catch block
            }
        }
        this.fIns = null;
    }

    public void setFormatTestor(Testseq testor) {
        this.formatTestor = testor;
    }

    public final boolean isMydata() {
        return this.isKnownFormat();
    }

    public void setInputFormat(int formatID) {
        this.forceFormatId = formatID;
    }

    public boolean isKnownFormat() {
        this.si = new SeqFileInfo();
        int fmt = BioseqFormats.kUnknown;
        if (this.forceFormatId > 0) {
            this.si.format = fmt = this.forceFormatId;
            this.si.skiplines = 0;
            this.forceFormatId = 0;
        } else {
            if (this.formatTestor == null) {
                this.formatTestor = new Testseq();
            }
            fmt = this.formatTestor.testFormat(this.fIns, this.si);
            this.fIns = this.formatTestor.getPossibleNewInputReader();
        }
        if (this.verbose) {
            this.message("isKnownFormat format=" + fmt + ":" + BioseqFormats.formatName(fmt));
        }
        if (fmt <= BioseqFormats.kUnknown) {
            return false;
        }
        this.setFormat(fmt);
        return true;
    }

    public boolean canread() {
        if (this.reader != null) {
            return true;
        }
        if (this.format > 0) {
            return BioseqFormats.canread(this.format);
        }
        return false;
    }

    public final SeqFileInfo getInfo() {
        return this.si;
    }

    public final int getFormat() {
        return this.format;
    }

    public void setFormat(int format) {
        this.format = format;
        this.former = BioseqFormats.bioseqFormat(format);
        if (this.reader != null && this.reader.formatID() != format) {
            this.reader = null;
        }
    }

    public String getFormatName() {
        if (this.reader != null) {
            return BioseqFormats.formatName(this.reader.formatID());
        }
        if (this.format > 0) {
            return BioseqFormats.formatName(this.getFormat());
        }
        return "";
    }

    public BioseqReaderIface getReader() {
        return this.reader;
    }

    public BioseqFormat getBioseqFormat() {
        return this.former;
    }

    public boolean eof() {
        try {
            return this.si != null && this.si.err != 0 || this.fIns == null || !this.fIns.ready();
        }
        catch (IOException ex) {
            return true;
        }
    }

    public URL checkUrl(String s) {
        if (s.lastIndexOf(":/", 30) > 0) {
            try {
                URL u;
                if (s.startsWith("systemresource:/") && s.indexOf("/+/") < 0) {
                    u = AppResources.global.getUrl(s.substring("systemresource:/".length()));
                    Debug.println(" sysrez -> " + u);
                    if (u != null) {
                        return u;
                    }
                }
                u = new URL(s);
                Debug.println(" url -> " + u);
                return u;
            }
            catch (Exception ue) {
            }
        }
        return null;
    }

    public final Object checkInString(String ins) {
        return this.checkInString(ins, kInputStringKey);
    }

    public Object checkInString(String ins, String stringDataKey) {
        if (Debug.isOn) {
            Debug.print("checkInString  '" + ins.substring(0, Math.min(80, ins.length())));
        }
        if (ins.startsWith(stringDataKey)) {
            URL url = this.checkUrl(ins = ins.substring(stringDataKey.length()));
            if (url != null) {
                Debug.println("' is url.");
                return url;
            }
            Debug.println("' is data.");
            return ins;
        }
        URL url = this.checkUrl(ins);
        if (url != null) {
            Debug.println("' is url.");
            return url;
        }
        File file = this.indir != null ? new File(this.indir, ins) : new File(ins);
        if (file.exists() && file.isFile() && file.canRead()) {
            Debug.println("' is file.");
            return file;
        }
        Debug.println("' is unknown/unreadable object.");
        this.message("Unknown or unreadable data: " + ins);
        return new Integer(0);
    }

    public void checkInList(FastVector inlist, String stringDataKey) {
        if (inlist != null) {
            int i = 0;
            while (i < inlist.size()) {
                Object newel;
                Object el = inlist.elementAt(i);
                if (el instanceof String && (newel = this.checkInString((String)el, stringDataKey)) != null) {
                    inlist.setElementAt(newel, i);
                }
                ++i;
            }
        }
    }

    public void setInDirectory(File indir) {
        this.indir = indir;
    }

    public final void readlist(FastVector inlist) {
        this.readlist(inlist, kInputStringKey);
    }

    public final void readlist(Enumeration inlist) {
        this.readlist(inlist, kInputStringKey);
    }

    public void readlist(FastVector inlist, String stringDataKey) {
        this.readlist(inlist.elements(), stringDataKey);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void readlist(Enumeration inlist, String stringDataKey) {
        if (inlist == null) {
            return;
        }
        int forceInformat = this.forceFormatId;
        while (inlist.hasMoreElements()) {
            try {
                Object inob = inlist.nextElement();
                String inname = this.setInputObject(inob);
                if (inname == null) continue;
                if (this.verbose) {
                    this.message("Reading from " + inname);
                }
                if (forceInformat > 0) {
                    this.setInputFormat(forceInformat);
                }
                if (!this.isKnownFormat()) {
                    this.message("Unknown biosequence format for input " + inname);
                } else if (!this.readInit()) {
                    this.message("Error initializing drawseq for input " + inname);
                } else {
                    while (this.canReadMore()) {
                        this.readNext();
                    }
                }
                this.close();
            }
            catch (IOException e) {
                this.message("Readseq.list error: " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    public final SeqFileInfo nextSeq() {
        if (this.moreresults()) {
            return (SeqFileInfo)this.seqfilevec.elementAt(this.fAt++);
        }
        return null;
    }

    public SeqFileInfo[] allSeqs() {
        Object[] sfi = new SeqFileInfo[this.seqfilevec.size()];
        this.seqfilevec.copyInto(sfi);
        return sfi;
    }

    public final Object result() {
        if (this.moreresults()) {
            return this.seqfilevec.elementAt(this.fAt++);
        }
        return null;
    }

    public final boolean moreresults() {
        return this.fAt < this.seqfilevec.size();
    }

    public final int atresult() {
        return this.fAt;
    }

    public final int nresults() {
        return this.seqfilevec.size();
    }

    public final Vector allresults() {
        return this.seqfilevec;
    }

    public final void restartresults() {
        this.fAt = 0;
    }

    public final void removeresults() {
        this.fAt = 0;
        this.seqfilevec.removeAllElements();
    }

    public boolean hasMoreElements() {
        if (this.moreresults()) {
            return true;
        }
        return this.canReadMore();
    }

    public Object nextElement() {
        if (this.moreresults()) {
            return this.result();
        }
        try {
            if (this.readNext()) {
                return this.result();
            }
        }
        catch (IOException e) {}
        return null;
    }

    public void initIfNeeded(String defname) {
        if (!this.didinit) {
            this.readInit(defname);
        }
    }

    public final boolean readInit() {
        return this.readInit(SeqFileInfo.gBlankSeqid);
    }

    public boolean readInit(String defname) {
        if (this.reader == null) {
            this.reader = BioseqFormats.newReader(this.format);
        }
        if (this.reader == null) {
            return false;
        }
        if (this.former.interleaved()) {
            this.fRdIns.makeRewindable();
        }
        this.reader.setInput(this.fIns);
        this.reader.reset();
        if (this.reader instanceof PlainSeqReader) {
            ((PlainSeqReader)this.reader).setInputFile(this.fRdIns.getFile());
        }
        if (this.reader instanceof BioseqReader) {
            int clen = ((BioseqReader)this.reader).getReadChunkSize();
            long flen = this.fRdIns.guessLength();
            if (flen - (long)clen > 50000L) {
                clen = this.former instanceof PlainSeqFormat ? (int)Math.min(500000L, flen) : (int)Math.max((long)clen, Math.min(500000L, flen / 10L));
                ((BioseqReader)this.reader).setReadChunkSize(clen);
            }
        }
        if (this.wantSelectedFeats && this.reader instanceof FlatFeatReader) {
            ((FlatFeatReader)this.reader).setIncludeFeats(this.exfeatures, this.exfeatures);
        }
        if (defname == null) {
            defname = SeqFileInfo.gBlankSeqid;
        }
        this.seqDefname = SeqFileInfo.cleanSeqID(defname);
        this.saveskip = this.si.skiplines;
        this.whichEntry = 0;
        this.didinit = true;
        return true;
    }

    void verboseClassic(SeqFileInfo si) {
        StringBuffer sb = new StringBuffer();
        sb.append("Sequence ");
        sb.append(this.whichEntry);
        sb.append(", length= ");
        sb.append(si.seqlen);
        long checksum = 0L;
        try {
            BioseqRecord bs = new BioseqRecord(si);
            SeqInfo sst = bs.getseq().getSeqStats();
            checksum = sst.getChecksum();
        }
        catch (Exception ex) {
            // empty catch block
        }
        sb.append(", checksum= ");
        sb.append(Long.toHexString(checksum).toUpperCase());
        sb.append(", format= ");
        sb.append(this.former.formatID());
        sb.append(". ");
        sb.append(this.former.formatName());
        sb.append(", id= ");
        sb.append(si.seqid);
        this.message(sb.toString());
    }

    public int getInsReadlen() {
        if (this.reader instanceof BioseqReader) {
            return ((BioseqReader)this.reader).getInsReadlen();
        }
        return -1;
    }

    public boolean canReadMore() {
        if (this.reader == null) {
            return false;
        }
        if (this.former.interleaved()) {
            return this.whichEntry == 0 ? true : this.whichEntry < this.si.nseq;
        }
        if (!this.reader.endOfFile()) {
            return true;
        }
        return !this.eof();
    }

    public SeqFileInfo readAt(int atEntry) throws IOException {
        if (this.reader == null) {
            throw new ReadseqException("Null BioseqReader");
        }
        this.si = this.readSeq(this.si, atEntry);
        if (this.si != null) {
            if (!this.si.hasid()) {
                this.si.seqid = this.seqDefname;
            }
            this.extractOrigin = 0;
            if (this.extractRange != null && !this.extractRange.isEmpty()) {
                int start = this.extractRange.start() + this.extractRange.origin();
                int nbases = this.extractRange.nbases();
                if (this.si.length() >= nbases && this.si.offset() + this.si.length() > start) {
                    this.si.setoffset(start);
                    this.si.setlength(nbases);
                    this.extractOrigin = start;
                }
            }
        }
        return this.si;
    }

    public boolean readNext() throws IOException {
        this.si = this.readAt(++this.whichEntry);
        if (this.si != null && (this.si.hasseq() || this.si.hasdoc())) {
            this.seqfilevec.addElement(this.si);
        }
        return this.moreresults();
    }

    public void setFeatureExtraction(Hashtable featurelist, SeqRange featSubrange) {
        this.exfeatures = featurelist;
        this.featSubrange = featSubrange;
        this.wantSelectedFeats = this.exfeatures != null && !this.exfeatures.isEmpty();
    }

    public void setExtractRange(SeqRange exSubrange) {
        this.extractRange = exSubrange;
    }

    protected void writeSelectedFeatureRecords(SeqFileInfo si, BioseqWriterIface seqwriter, BioseqWriterIface docwriter) throws IOException {
        BioseqRecord bsrec = new BioseqRecord(si);
        BioseqRecord bsfeat = new BioseqRecord();
        String seqid = bsrec.getID();
        bsfeat.setSeqID(seqid);
        BasicBioseqDoc featdoc = new BasicBioseqDoc(seqid);
        SeqRange maxRange = new SeqRange(bsrec.offset(), bsrec.length());
        int maxStart = maxRange.start();
        int maxEnd = maxRange.max();
        if (Debug.isOn) {
            Debug.println("writeSelectedFeatureRecords for " + bsrec + ", maxRange=" + maxRange);
        }
        if (bsrec.hasdoc()) {
            featdoc.addDocField(bsrec.getdoc().findDocItem(30, 0));
            featdoc.addDocField(bsrec.getdoc().findDocItem(80, 0));
            featdoc.addDocField(bsrec.getdoc().findDocItem(20, 0));
        }
        FeatureItem[] fits = bsrec.findFeatures(this.exfeatures, this.extractRange);
        String fn = "";
        Enumeration en = this.exfeatures.keys();
        while (en.hasMoreElements()) {
            fn = fn + (String)en.nextElement() + ", ";
        }
        if (fits == null) {
            Debug.println("writeSelectedFeatureRecords: None found:" + fn);
            if (this.noEmptyFiles) {
                return;
            }
            featdoc.addComment("No such features found: " + fn);
            bsfeat.set(null, featdoc, null);
            if (docwriter == null) {
                docwriter = seqwriter;
            }
            if (docwriter != null && docwriter.setSeq(bsfeat)) {
                docwriter.writeSeqRecord();
            }
        } else {
            Debug.println("writeSelectedFeatureRecords: found " + fits.length + " of " + fn);
            featdoc.addComment("Extracted features: " + fn);
            if (this.featSubrange != null) {
                featdoc.addComment("Extracted feature subrange: " + this.featSubrange);
            }
            FeatureItem fit = null;
            int k = 0;
            int nex = 0;
            while (k < fits.length) {
                try {
                    fit = fits[k];
                    if (Debug.isOn) {
                        Debug.println(" feature [" + k + "]=" + fit);
                    }
                    SeqRange featsr = fit.getLocation();
                    if (this.featSubrange != null) {
                        featsr = featsr.subrange(this.featSubrange);
                    }
                    if (maxStart > featsr.start() || maxEnd < featsr.max()) {
                        int b = Math.max(maxStart, featsr.start());
                        int e = Math.min(maxEnd, featsr.max());
                        featsr = new SeqRange(b, e - b + 1);
                    }
                    Debug.print("featrange, extracted=" + featsr);
                    Bioseq bseq = bsrec.extractBases(featsr);
                    Debug.println("  bseq, extracted len=" + bseq.length());
                    int featorig = 0;
                    featorig = featsr.next() != null ? 1 : (featsr.isComplement() ? featsr.origin() + featsr.max() : featsr.origin() + featsr.start());
                    String featid = fit.getNoteValue("ID");
                    if (featid == null || featid.length() == 0) {
                        featid = fit.getNoteValue("name");
                    }
                    if (featid == null || featid.length() == 0) {
                        featid = fit.getNoteValue("symbol");
                    }
                    featid = featid == null || featid.length() == 0 ? BioseqRecord.getNextBlankID(seqid) : seqid + "_" + featid;
                    featdoc.replaceDocField(10, featid);
                    bsfeat.setSeqID(featid);
                    String featinfo = "selected_feature: " + fit.getNotesText();
                    featdoc.replaceDocField(20, featinfo);
                    featdoc.addFeature(fit);
                    featdoc.addFeature("extracted_range", featsr);
                    featdoc.addFeatureNote("/note", "Location extracted from source. Feature locations are for source, not for this extraction.");
                    bsfeat.set(bseq, featdoc, null);
                    bsfeat.offset = 0;
                    if (docwriter != null && docwriter.setSeq(bsfeat)) {
                        docwriter.writeSeqRecord();
                    }
                    if (seqwriter != null && seqwriter.setSeq(bsfeat)) {
                        if (seqwriter instanceof BioseqWriter) {
                            WriteseqOpts opts = ((BioseqWriter)seqwriter).getOpts();
                            opts.reversed = featsr.next() != null ? false : featsr.isComplement();
                            opts.origin = featorig;
                        }
                        seqwriter.writeSeqRecord();
                    }
                    featdoc.features().removeAllElements();
                }
                catch (Exception ex) {
                    if (Debug.isOn) {
                        Debug.println("Exception with feature [" + k + "]=" + fit);
                    }
                    if (nex++ > 2) {
                        ex.printStackTrace();
                        ReadseqException rex = new ReadseqException(ex.getMessage());
                        throw rex;
                    }
                    featdoc.features().removeAllElements();
                }
                ++k;
            }
        }
    }

    public void writeSeqTo(SeqFileInfo si, BioseqWriterIface seqwriter, BioseqWriterIface docwriter) throws IOException {
        if (this.extractOrigin > 0 && seqwriter instanceof BioseqWriter) {
            WriteseqOpts opts = ((BioseqWriter)seqwriter).getOpts();
            opts.origin = this.extractOrigin;
        }
        if (this.wantSelectedFeats && si.hasdoc()) {
            this.writeSelectedFeatureRecords(si, seqwriter, docwriter);
        } else {
            if (docwriter != null && docwriter.setSeq(si)) {
                docwriter.writeSeqRecord();
            }
            if (seqwriter != null && seqwriter.setSeq(si)) {
                seqwriter.writeSeqRecord();
            }
        }
    }

    public void setWriteMask(boolean turnon) {
        this.fWriteMask = turnon;
    }

    public boolean readTo(BioseqWriterIface writer) throws IOException {
        return this.readTo(writer, false);
    }

    public boolean readToOld(BioseqWriterIface writer, boolean writeWrapper) throws IOException {
        if (this.reader == null) {
            throw new ReadseqException("Null BioseqReader");
        }
        if (writeWrapper) {
            writer.writeHeader();
        }
        this.reader.readTo(writer, this.si.skiplines);
        if (writeWrapper) {
            writer.writeTrailer();
        }
        return true;
    }

    public boolean readTo(BioseqWriterIface seqwriter, boolean writeWrapper) throws IOException {
        if (writeWrapper) {
            seqwriter.writeHeader();
        }
        if (this.reader instanceof BioseqReader) {
            ((BioseqReader)this.reader).setSkipDocs(!this.wantSelectedFeats && !seqwriter.wantsDocument());
        }
        while (this.canReadMore() && (this.si = this.readAt(++this.whichEntry)) != null) {
            this.writeSeqTo(this.si, seqwriter, null);
        }
        if (writeWrapper) {
            seqwriter.writeTrailer();
        }
        return true;
    }

    public boolean readToPair(BioseqWriterIface seqwriter, BioseqWriterIface docwriter, boolean writeWrapper) throws IOException {
        if (writeWrapper) {
            docwriter.writeHeader();
            seqwriter.writeHeader();
        }
        if (this.reader instanceof BioseqReader) {
            ((BioseqReader)this.reader).setSkipDocs(false);
        }
        while (this.canReadMore() && (this.si = this.readAt(++this.whichEntry)) != null) {
            this.writeSeqTo(this.si, seqwriter, docwriter);
        }
        if (writeWrapper) {
            docwriter.writeTrailer();
            seqwriter.writeTrailer();
        }
        return true;
    }

    public void list(Writer out) {
        try {
            boolean more = true;
            while (more) {
                this.si = this.readSeq(this.si, -1);
                boolean bl = more = this.si != null && (this.si.hasseq() || this.si.hasdoc());
                if (!more) continue;
                out.write(((Bioseq)this.si.seq).toChars());
            }
        }
        catch (IOException ex) {
            Debug.println("list error");
            ex.printStackTrace();
        }
    }

    protected SeqFileInfo readSeq(SeqFileInfo sin, int atEntry) throws IOException {
        this.reader.skipPastHeader(sin.skiplines);
        sin.skiplines = 0;
        this.whichEntry = atEntry;
        SeqFileInfo sout = this.reader.readOne(this.whichEntry);
        if (this.verboseClassic && sout != null) {
            this.verboseClassic(sout);
        } else if (this.verbose && sout != null) {
            this.message("read " + atEntry + ", id=" + sout.seqid + " seqlen=" + sout.seqlen);
        }
        return sout;
    }
}

