/*
 * Decompiled with CFR 0.152.
 */
package iubio.readseq;

import Acme.Fmt;
import iubio.readseq.InterleavedSeqWriter;
import iubio.readseq.Readseq;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;

class PhylipSeqWriter
extends InterleavedSeqWriter {
    BufferedWriter tempOs;

    PhylipSeqWriter() {
    }

    public void writeHeader() throws IOException {
        super.writeHeader();
        if (!this.interleaved()) {
            this.tempFile = Readseq.tempFile();
            this.tempOs = new BufferedWriter(new FileWriter(this.tempFile));
            this.douts = this.tempOs;
        }
    }

    public void writeRecordStart() {
        super.writeRecordStart();
        this.opts.spacer = 10;
        this.opts.tab = 12;
        this.l1 = -1;
    }

    public void writeDoc() {
        super.writeDoc();
        this.writeString(Fmt.fmt(this.idword, 10, 34) + "  ");
    }

    protected void interleaf(int leaf) {
        this.writeln();
    }

    protected void interleaveHeader() {
        this.writeString(" " + this.nseq);
        this.writeString(" " + this.seqlen);
        if (this.interleaved()) {
            this.writeln();
        } else {
            this.writeln(" I ");
        }
    }

    public void writeTrailer() {
        if (!this.interleaved()) {
            try {
                this.douts.close();
            }
            catch (IOException ex) {
                // empty catch block
            }
            this.setOutput(this.outs);
            this.interleaveHeader();
            this.sequentialOutput();
        }
        super.writeTrailer();
    }

    /*
     * WARNING - void declaration
     */
    protected void sequentialOutput() {
        try {
            int nread;
            FileReader tempis = new FileReader(this.tempFile);
            char[] buf = new char[2048];
            while ((nread = tempis.read(buf)) >= 0) {
                void var3_4;
                this.douts.write(buf, 0, (int)var3_4);
            }
            ((Reader)tempis).close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.tempFile.delete();
        this.tempFile = null;
    }
}

