/*
 * Decompiled with CFR 0.152.
 */
package iubio.readseq;

import flybase.Debug;
import iubio.readseq.NumSppBases;
import iubio.readseq.PhylipSeqFormat;
import iubio.readseq.PhylipSeqReader;
import java.io.IOException;

class Phylip2SeqReader
extends PhylipSeqReader {
    public Phylip2SeqReader() {
        this.interleaved = false;
    }

    public boolean endOfSequence() {
        return this.endSequential();
    }

    protected void read() throws IOException {
        this.readSequential();
    }

    protected boolean endSequential() {
        this.ungetend = false;
        this.countseq(this.getreadchars(), this.getreadcharofs() + this.margin, this.nWaiting);
        boolean done = this.seqlencount >= this.sequenceLength();
        this.addend = !done;
        return done;
    }

    protected void readSequential() throws IOException {
        if (this.sequenceLength() == 0 || this.speciesCount() == 0) {
            NumSppBases nsppb = PhylipSeqFormat.readSpeciesLength(this.sWaiting);
            this.nospp = nsppb.nospp;
            this.baselen = nsppb.baselen;
            Debug.println("format: phylip-sequential, nspp=" + this.speciesCount() + ", nbase=" + this.sequenceLength());
            this.getline();
        }
        this.setNseq(this.speciesCount());
        while (!this.allDone) {
            this.seqlencount = 0;
            this.seqid = this.sWaiting.substring(0, 10).toString();
            this.sWaiting = this.sWaiting.substring(10);
            this.nWaiting = this.sWaiting.length();
            this.margin = 0;
            this.addfirst = true;
            this.readLoop();
            if (!this.endOfFile()) continue;
            this.allDone = true;
        }
    }
}

