/*
 * Decompiled with CFR 0.152.
 */
package iubio.readseq;

import flybase.Debug;
import iubio.readseq.BioseqDoc;
import iubio.readseq.BioseqWriter;
import iubio.readseq.WriteseqOpts;

class PearsonSeqWriter
extends BioseqWriter {
    static final int kSeqwidth = 60;
    int seqwidth = 60;

    PearsonSeqWriter() {
    }

    public void setOpts(WriteseqOpts newopts) {
        if (newopts != null) {
            this.opts.seqwidth = this.seqwidth = newopts.seqwidth;
        }
    }

    public void writeRecordStart() {
        super.writeRecordStart();
        this.opts.seqwidth = this.seqwidth;
    }

    public void writeRecordEnd() {
    }

    public void writeSeq() {
        int nout = 0;
        boolean newline = true;
        if (this.bioseq.isBytes() && this.testbaseKind != 1) {
            byte[] ba = this.bioseq.toBytes();
            int i = 0;
            while (i < this.seqlen) {
                this.writeByte((char)ba[this.offset + i]);
                newline = false;
                if (i % this.seqwidth == this.seqwidth - 1) {
                    this.writeln();
                    newline = true;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.seqlen) {
                char bc = this.bioseq.base(this.offset + i, this.fBasePart);
                if (this.testbaseKind == 1) {
                    bc = (char)this.testbase.outSeqChar(bc);
                }
                if (bc > '\u0000') {
                    this.writeByte(bc);
                    newline = false;
                    if ((++nout - 1) % this.seqwidth == this.seqwidth - 1) {
                        this.writeln();
                        newline = true;
                    }
                }
                ++i;
            }
        }
        if (!newline) {
            this.writeln();
        }
    }

    public void writeDoc() {
        this.writeString(">");
        this.writeString(this.seqid);
        if (this.seqdoc instanceof BioseqDoc) {
            Debug.println("fasta doc from " + this.seqdoc);
            String title = ((BioseqDoc)this.seqdoc).getTitle();
            if (title != null) {
                title = title.replace('\n', ';').replace('\r', ';');
                this.writeString(" ");
                this.writeString(title);
            }
        }
        this.writeString(" ");
        this.writeString(String.valueOf(this.seqlen));
        this.writeString(" bp ");
        this.writeln(this.checksumString());
    }
}

