/*
 * Decompiled with CFR 0.152.
 */
package iubio.readseq;

import flybase.OpenString;
import iubio.readseq.BioseqFormat;
import iubio.readseq.BioseqReaderIface;
import iubio.readseq.BioseqWriterIface;
import iubio.readseq.GenbankSeqReader;
import iubio.readseq.GenbankSeqWriter;

public class GenbankSeqFormat
extends BioseqFormat {
    public String formatName() {
        return "GenBank|gb";
    }

    public String formatSuffix() {
        return ".gb";
    }

    public String contentType() {
        return "biosequence/genbank";
    }

    public boolean canread() {
        return true;
    }

    public boolean canwrite() {
        return true;
    }

    public boolean hasdoc() {
        return true;
    }

    public BioseqReaderIface newReader() {
        return new GenbankSeqReader();
    }

    public BioseqWriterIface newWriter() {
        return new GenbankSeqWriter();
    }

    public boolean formatTestLine(OpenString line, int atline, int skiplines) {
        if (line.startsWith("LOCUS ")) {
            this.formatLikelihood = 80;
            if (this.recordStartline == 0) {
                this.recordStartline = atline;
            }
            return false;
        }
        if (line.startsWith("ORIGIN")) {
            this.formatLikelihood += 70;
            return false;
        }
        if (line.startsWith("//")) {
            this.formatLikelihood += 20;
            return false;
        }
        return false;
    }
}

