/*
 * Decompiled with CFR 0.152.
 */
package iubio.readseq;

import flybase.Debug;
import flybase.FastVector;
import iubio.bioseq.SeqRange;
import iubio.bioseq.SeqRangeException;
import iubio.readseq.DocItem;
import iubio.readseq.FeatureNote;
import java.util.StringTokenizer;

public class FeatureItem
extends DocItem {
    protected SeqRange location;
    protected FastVector notes;
    protected DocItem curnote;

    public FeatureItem(String name, SeqRange value) {
        super(name, value.toString(), 71, 4);
        this.location = value;
    }

    public FeatureItem(String name, SeqRange value, int level) {
        super(name, value.toString(), 71, level);
        this.location = value;
    }

    public FeatureItem(String name, String value, int level) {
        super(name, value, 71, level);
        this.setValue(value);
    }

    public FeatureItem() {
        super("", "", 71, 4);
    }

    public void set(String name, SeqRange value) {
        this.name = name;
        this.setValue(value.toString());
    }

    public Object clone() {
        FeatureItem fi = (FeatureItem)super.clone();
        if (this.notes != null) {
            fi.notes = (FastVector)this.notes.clone();
        }
        if (this.location != null) {
            fi.location = (SeqRange)this.location.clone();
        }
        fi.curnote = null;
        return fi;
    }

    public boolean equals(Object ob) {
        if (ob instanceof FeatureItem) {
            FeatureItem fi = (FeatureItem)ob;
            return this.getName().equals(fi.getName()) && this.location.equals(fi.getLocation());
        }
        return false;
    }

    public String getValue() {
        return this.getLocationString();
    }

    public void setValue(String newval) {
        super.setValue(newval);
        try {
            this.location = SeqRange.parse(this.value);
        }
        catch (SeqRangeException sre) {
            System.err.println(sre.getMessage());
        }
    }

    public void appendValue(String appendval) {
        super.appendValue("", appendval);
    }

    public SeqRange getLocation() {
        return this.location;
    }

    public String getLocationString() {
        return this.location.toString();
    }

    public void updateRange(int changeflags, int start, int length, byte[] changes) {
        this.location.updateRange(changeflags, start, length, changes);
    }

    public int compareTo(Object ob) {
        int c = 0;
        if (this.location != null) {
            c = this.location.compareTo(((FeatureItem)ob).location);
        }
        if (c == 0) {
            c = super.compareTo(ob);
        }
        return c;
    }

    public FastVector getNotes() {
        return this.notes;
    }

    public String getNotesText() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getName());
        sb.append(" loc=");
        sb.append(this.getLocationString());
        sb.append('\n');
        if (this.notes != null) {
            int i = 0;
            while (i < this.notes.size()) {
                DocItem di = (DocItem)this.notes.elementAt(i);
                sb.append(di.getName());
                sb.append('=');
                String v = di.getValue();
                if (v.indexOf(32) >= 0) {
                    String q = "'";
                    if (v.indexOf("'") >= 0) {
                        q = "\"";
                    }
                    v = q + v + q;
                }
                sb.append(v);
                sb.append('\n');
                ++i;
            }
        }
        return sb.toString();
    }

    public void setNotesText(String notetext, boolean append) {
        if (!append && this.notes != null) {
            this.notes.removeAllElements();
        }
        StringTokenizer st = new StringTokenizer(notetext, "\n\r");
        while (st.hasMoreTokens()) {
            String kv = st.nextToken();
            int eq = kv.indexOf(61);
            if (eq <= 0) continue;
            String key = kv.substring(0, eq).trim();
            String val = kv.substring(eq + 1).trim();
            if ("name".equals(key)) {
                this.name = val;
                continue;
            }
            if ("location".equals(key)) {
                this.setValue(val);
                continue;
            }
            if (!key.startsWith("/")) {
                key = "/" + key;
            }
            this.putNote(new FeatureNote(key, val));
        }
    }

    public void putNote(DocItem note) {
        if (this.notes == null) {
            this.notes = new FastVector();
        }
        this.notes.addElement(note);
        this.curnote = note;
    }

    public void appendNote(String value) {
        if (this.curnote != null && value != null) {
            if ("/translation".equals(this.curnote.getName())) {
                this.curnote.appendValue("", value.trim());
            } else {
                this.curnote.appendValue(DocItem.sAppendBreak, value);
            }
        }
    }

    public DocItem getNote(String name) {
        if (this.notes == null) {
            return null;
        }
        String n2 = name.startsWith("/") ? null : "/" + name;
        int i = 0;
        while (i < this.notes.size()) {
            DocItem nv = (DocItem)this.notes.elementAt(i);
            if (nv.sameName(name)) {
                return nv;
            }
            if (n2 != null && nv.sameName(n2)) {
                return nv;
            }
            ++i;
        }
        return null;
    }

    public String getNoteValue(String name) {
        DocItem di = this.getNote(name);
        if (di != null) {
            return di.getValue();
        }
        return null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (Debug.val() > 1) {
            sb.append(this.getClass().getName());
            sb.append(": ");
        }
        sb.append(this.name);
        sb.append("=");
        sb.append(this.value);
        if (this.notes != null) {
            int i = 0;
            while (i < this.notes.size()) {
                sb.append('\t');
                sb.append(this.notes.elementAt(i));
                ++i;
            }
        }
        return sb.toString();
    }
}

