/*
 * Decompiled with CFR 0.152.
 */
package iubio.readseq;

import Acme.Fmt;
import flybase.Debug;
import iubio.bioseq.SeqInfo;
import iubio.readseq.BioseqDoc;
import iubio.readseq.BioseqWriter;
import iubio.readseq.EmblDoc;
import iubio.readseq.SeqFileInfo;
import iubio.readseq.SwissDoc;

class EmblSeqWriter
extends BioseqWriter {
    static final int seqwidth = 60;
    static final int ktab = 5;
    static final int kspacer = 10;
    static final int knumwidth = 8;
    static final int knumflags = 0;
    protected int seqkind;

    EmblSeqWriter() {
    }

    public void writeRecordStart() {
        super.writeRecordStart();
        this.opts.tab = 5;
        this.opts.spacer = 10;
        this.opts.seqwidth = 60;
        this.opts.numright = true;
        this.opts.numwidth = 8;
        this.seqkind = this.bioseq.getSeqtype();
        if (this.seqkind == 4) {
            this.setChecksum(true);
        }
    }

    public void writeRecordEnd() {
        this.writeln("//");
    }

    public void writeSeq() {
        int ib;
        int j;
        int i;
        int nout = 0;
        int origin = this.opts.origin;
        boolean rev = this.opts.reversed;
        boolean newline = true;
        if (this.bioseq.isBytes() && this.testbaseKind != 1) {
            byte[] ba = this.bioseq.toBytes();
            i = 0;
            while (i < this.seqlen) {
                if (newline) {
                    j = 0;
                    while (j < 5) {
                        this.writeByte(32);
                        ++j;
                    }
                    newline = false;
                }
                this.writeByte(ba[this.offset + i]);
                if (i % 60 == 59) {
                    ib = rev ? origin - i : origin + i;
                    this.writeString("  " + Fmt.fmt(ib, 8, 0));
                    this.writeln();
                    newline = true;
                } else if (i % 10 == 9) {
                    this.writeByte(32);
                }
                ++i;
            }
        } else {
            i = 0;
            while (i < this.seqlen) {
                if (newline) {
                    j = 0;
                    while (j < 5) {
                        this.writeByte(32);
                        ++j;
                    }
                    newline = false;
                }
                char bc = this.bioseq.base(this.offset + i, this.fBasePart);
                if (this.testbaseKind == 1) {
                    bc = (char)this.testbase.outSeqChar(bc);
                }
                if (bc > '\u0000') {
                    this.writeByte(bc);
                    if (nout % 60 == 59) {
                        ib = rev ? origin - nout : origin + nout;
                        this.writeString("  " + Fmt.fmt(ib, 8, 0));
                        this.writeln();
                        newline = true;
                    } else if (nout % 10 == 9) {
                        this.writeByte(32);
                    }
                    ++nout;
                }
                ++i;
            }
        }
        if (!newline) {
            int tab = this.seqlen % 60;
            if (tab > 0) {
                tab = 60 - tab;
                tab += (tab - 1) / 10;
            }
            j = 0;
            while (j < tab) {
                this.writeByte(32);
                ++j;
            }
            ib = rev ? origin - this.seqlen - 1 : origin + this.seqlen - 1;
            this.writeString("  " + Fmt.fmt(ib, 8, 0));
            this.writeln();
        }
    }

    protected void writeID() {
        this.writeString("ID   ");
        if (this.seqkind == 4) {
            this.writeString(Fmt.fmt(this.idword, 15, 2));
            this.writeString(" STANDARD;      PRT; ");
            this.writeString(String.valueOf(this.seqlen));
            this.writeln(" AA.");
        } else {
            this.writeString(Fmt.fmt(this.idword, 11, 2));
            this.writeString(" standard; ");
            this.writeString(SeqInfo.getKindLabel(this.seqkind));
            if (Debug.isOn) {
                this.writeString("; debug");
            }
            this.writeString("; UNC; ");
            this.writeString(String.valueOf(this.seqlen));
            this.writeln(" BP.");
        }
    }

    protected final void writeTitle() {
        this.writeString("DE   ");
        this.writeln(this.seqid);
    }

    protected void writeSeqStats(String cks) {
        if (this.seqkind == 4) {
            this.writeString("SQ   SEQUENCE ");
            this.writeString(Fmt.fmt(this.seqlen, 5, 0));
            this.writeString(" AA;");
            this.writeString(Fmt.fmt(cks, 10, 0));
            this.writeString(" CRC32;");
            this.writeln();
        } else {
            if (cks.length() > 0) {
                this.writeString("CC   ");
                this.writeString(cks);
                this.writeln(" CRC32;");
            }
            this.writeString("SQ   Sequence ");
            this.writeString(String.valueOf(this.seqlen));
            this.writeln(" BP;");
        }
    }

    public void writeDoc() {
        String cks = this.checksumString();
        int at = cks.indexOf(" checksum");
        if (at > 0) {
            cks = cks.substring(0, at);
        }
        if (this.seqdoc instanceof BioseqDoc) {
            EmblDoc doc = this.seqkind == 4 ? new SwissDoc((BioseqDoc)this.seqdoc) : new EmblDoc((BioseqDoc)this.seqdoc);
            boolean doid = true;
            String docid = doc.getID();
            if (docid == null || !this.idword.startsWith(SeqFileInfo.gBlankSeqid) && !docid.equals(this.idword)) {
                this.writeID();
                doid = false;
            }
            if (!doid && doc.getTitle() == null) {
                this.writeTitle();
            }
            doc.replaceDocField(112, String.valueOf(this.seqlen));
            if (cks.length() > 0) {
                doc.replaceDocField(114, cks);
            }
            this.linesout += doc.writeTo(this.douts, doid);
            if (doc.getDocField(110) == null) {
                if (this.seqkind != 4 && doc.getDocField(114) != null) {
                    cks = "";
                }
                this.writeSeqStats(cks);
            }
        } else {
            this.writeID();
            this.writeTitle();
            this.writeSeqStats(cks);
        }
    }
}

