/*
 * Decompiled with CFR 0.152.
 */
package iubio.readseq;

import flybase.Debug;

public class DocItem
implements Cloneable {
    public static String sAppendBreak = "\n";
    public String name;
    public String value;
    public int kind;
    public int level;
    protected static StringBuffer apbuf = new StringBuffer();

    public DocItem() {
        this("", "", 0, 0);
    }

    public DocItem(DocItem p) {
        this(p.getName(), p.getValue(), p.getKind(), p.getLevel());
    }

    public DocItem(String name, String value, int kind, int level) {
        this.kind = kind;
        this.level = level;
        this.name = name;
        this.setValue(value);
    }

    public final int getLevel() {
        return this.level;
    }

    public final void setLevel(int level) {
        this.level = level;
    }

    public final String getName() {
        return this.name;
    }

    public final int getKind() {
        return this.kind;
    }

    public final boolean hasValue() {
        return this.value != null && this.value.length() > 0;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String other) {
        this.value = other == null ? "" : other;
    }

    public void appendValue(String appendval) {
        this.appendValue(sAppendBreak, appendval);
    }

    public void appendValue(String joinval, String appendval) {
        if (appendval != null) {
            apbuf.setLength(0);
            apbuf.append(this.value);
            apbuf.append(joinval);
            apbuf.append(appendval);
            this.setValue(apbuf.toString());
        }
    }

    public final boolean sameLevel(DocItem other) {
        return this.level == other.getLevel();
    }

    public final boolean sameName(String other) {
        return this.name.equals(other);
    }

    public final boolean sameName(DocItem other) {
        return this.name.equals(other.name);
    }

    public final boolean sameKind(int otherkind) {
        return this.kind == otherkind;
    }

    public final boolean sameKind(DocItem other) {
        return this.kind == other.kind;
    }

    public final boolean sameValue(String other) {
        return this.value.equals(other);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (Debug.val() > 1) {
            sb.append(this.getClass().getName());
            sb.append(": ");
        }
        sb.append(this.name);
        sb.append("=");
        sb.append(this.value);
        if (Debug.val() > 1) {
            sb.append(" [k=");
            sb.append(this.kind);
            sb.append(", l=");
            sb.append(this.level);
            sb.append("]");
        }
        return sb.toString();
    }

    public boolean equals(Object other) {
        if (other instanceof DocItem) {
            DocItem odoc = (DocItem)other;
            if (!this.sameKind(odoc.kind)) {
                return false;
            }
            if (!this.sameName(odoc.name)) {
                return false;
            }
            return this.sameValue(odoc.value);
        }
        return false;
    }

    public boolean sameNameOrKind(Object other) {
        if (other instanceof DocItem) {
            return this.sameKind((DocItem)other) && this.sameName((DocItem)other);
        }
        if (other instanceof Integer) {
            return this.sameKind((Integer)other);
        }
        if (other instanceof String) {
            return this.sameName((String)other);
        }
        return false;
    }

    public int compareTo(Object ob) {
        int c = 0;
        if (this.name != null) {
            c = this.name.compareTo(((DocItem)ob).name);
        }
        if (c == 0 && this.value != null) {
            c = this.value.compareTo(((DocItem)ob).value);
        }
        return c;
    }

    public Object clone() {
        try {
            DocItem c = (DocItem)super.clone();
            return c;
        }
        catch (CloneNotSupportedException ex) {
            throw new Error(ex.toString());
        }
    }
}

