/*
 * Decompiled with CFR 0.152.
 */
package iubio.readseq;

import flybase.FastHashtable;
import flybase.OpenString;
import iubio.bioseq.BaseKind;
import iubio.readseq.BioseqReader;
import java.io.IOException;

class BlastOutputReader
extends BioseqReader {
    protected char matchchar = '\u0000';
    protected final int kMinSeqline = 30;
    protected boolean firstSeqline;
    protected boolean atname;
    protected boolean domatch;
    protected boolean done;
    protected OpenString saveseq;
    protected String sid1;
    protected int atbase;
    protected int alignmentLine;
    protected int iline;
    protected int seqindent;
    protected int seqendindent;
    protected FastHashtable idhash = new FastHashtable();
    static final int kEndOfSequence = -1;
    static final int kSkipLine = 0;
    static final int kSequenceLine = 1;

    public BlastOutputReader() {
        this.margin = 0;
        this.addfirst = false;
        this.addend = false;
        this.ungetend = true;
    }

    protected void read() throws IOException {
        if (this.alignmentLine == 0) {
            this.alignmentLine = this.findAlignments();
        }
        if (this.alignmentLine < 0) {
            return;
        }
        this.readAlignments();
    }

    public void skipPastHeader(int skiplines) {
        block3: {
            super.skipPastHeader(skiplines);
            try {
                if (this.alignmentLine <= 0) break block3;
                int i = this.alignmentLine - 1;
                while (i > 0) {
                    this.getline();
                    --i;
                }
            }
            catch (IOException e) {}
        }
    }

    protected int findAlignments() throws IOException {
        int aline = 0;
        while (!this.endOfFile()) {
            this.getline();
            ++aline;
            int at = this.sWaiting.indexOf(32);
            if (at <= 0) continue;
            int len = this.nWaiting;
            boolean haveSeqChar = false;
            boolean maybeSeqLine = true;
            while (!haveSeqChar && maybeSeqLine) {
                if (++at >= len) {
                    maybeSeqLine = false;
                    continue;
                }
                char c = this.sWaiting.charAt(at);
                if (c <= ' ') continue;
                if (BaseKind.isAlphaseq(c)) {
                    haveSeqChar = true;
                    continue;
                }
                if (BaseKind.isIndel(c) || c >= '0' && c <= '9') continue;
                maybeSeqLine = false;
            }
            if (!haveSeqChar) continue;
            int e = at;
            while (e < len) {
                char c = this.sWaiting.charAt(e);
                if (c <= ' ') break;
                if (!BaseKind.isAlphaseq(c) && !BaseKind.isIndel(c)) {
                    maybeSeqLine = false;
                    break;
                }
                ++e;
            }
            if (!maybeSeqLine || e <= at + 30) continue;
            this.seqindent = at;
            this.seqendindent = e;
            return aline;
        }
        return -1;
    }

    public boolean endOfSequence() {
        return this.isSequenceLine() == -1;
    }

    protected int isSequenceLine() {
        if (this.nWaiting == 0) {
            return 0;
        }
        char c = this.sWaiting.charAt(0);
        if (Character.isLetterOrDigit(c)) {
            if (this.nWaiting > this.seqindent) {
                return 1;
            }
            return -1;
        }
        if (c == ' ') {
            int at = 0;
            while (at < this.nWaiting && this.sWaiting.charAt(at) <= ' ') {
                ++at;
            }
            if (at == this.nWaiting) {
                return 0;
            }
            if (at < this.seqindent) {
                return -1;
            }
            return 0;
        }
        return 0;
    }

    protected void readAlignments() throws IOException {
        this.atname = true;
        this.firstSeqline = true;
        this.domatch = true;
        boolean bl = this.addit = this.choice > 0;
        if (this.addit) {
            this.seqlen = 0;
        }
        this.iline = 0;
        this.seqlencount = 0;
        this.atbase = 0;
        this.seqoffset = 0;
        this.readIndata();
        do {
            this.getline();
            this.done = this.endOfFile();
            if (this.done && this.nWaiting == 0) break;
            switch (this.isSequenceLine()) {
                case 0: {
                    break;
                }
                case -1: {
                    this.done = true;
                    break;
                }
                case 1: {
                    this.readIndata();
                }
            }
        } while (!this.done);
        this.nseq = this.idhash.size();
        this.setNseq(this.nseq);
        this.allDone = true;
    }

    protected void fixmatchchar(int offset) {
        if (this.matchchar == '\u0000') {
            int dots = 0;
            int dashes = 0;
            int len = this.nWaiting - offset;
            int i = 0;
            while (i < len) {
                char c = this.getreadbuf(offset + i);
                if (c == '.') {
                    ++dots;
                } else if (c == '-') {
                    ++dashes;
                }
                ++i;
            }
            this.matchchar = dashes > dots ? (char)45 : (char)46;
        }
        int i = 0;
        while (i < this.saveseq.length()) {
            char c = this.getreadbuf(offset + i);
            if (c == ' ') {
                this.setreadbuf(offset + i, BaseKind.indelEdge);
            } else if (c == this.matchchar) {
                this.setreadbuf(offset + i, this.saveseq.charAt(i));
            }
            ++i;
        }
    }

    protected void readIndata() {
        OpenString si = this.sWaiting;
        if (this.nWaiting > 0) {
            int seqat;
            int endname = si.indexOf(32);
            if (endname <= 0) {
                return;
            }
            String sid = si.substring(0, endname).trim().toString();
            if (this.idhash.get(sid) == null) {
                ++this.nseq;
                this.idhash.put(sid, new SeqIndex(this.nseq, this.seqoffset));
                if (this.choice == -1) {
                    this.addinfo(sid);
                }
            }
            SeqIndex sind = (SeqIndex)this.idhash.get(sid);
            this.atseq = sind.atseq;
            if (this.atseq == this.choice) {
                this.seqid = sid;
            }
            if (this.atseq == 1) {
                this.sid1 = sid;
            }
            if ((seqat = this.seqindent) >= this.nWaiting) {
                return;
            }
            int endseq = this.seqendindent;
            if (endseq >= this.nWaiting) {
                endseq = this.nWaiting;
            }
            boolean badc = true;
            while (badc && endseq > seqat) {
                char c = si.charAt(endseq - 1);
                if (c > ' ' && (BaseKind.isAlphaseq(c) || BaseKind.isIndel(c))) {
                    badc = false;
                    continue;
                }
                --endseq;
            }
            if (sid.equals(this.seqid)) {
                if (this.domatch) {
                    if (sid.equals(this.sid1)) {
                        this.saveseq = si.substring(seqat, endseq);
                    } else {
                        this.fixmatchchar(seqat);
                    }
                }
                if (this.firstSeqline && this.atseq != 1 && this.seqoffset > 0) {
                    this.setSeqoffset(this.seqoffset);
                }
                this.addseq(this.getreadchars(), this.getreadcharofs() + seqat, endseq - seqat);
                if (this.atseq == 1) {
                    this.seqoffset = this.atbase;
                    this.atbase = this.seqlen;
                }
                this.firstSeqline = false;
            } else if (sid.equals(this.sid1)) {
                if (this.domatch) {
                    this.saveseq = si.substring(seqat, endseq);
                }
                this.seqoffset = this.atbase;
                int bases = this.countseqline(this.getreadchars(), this.getreadcharofs() + seqat, endseq - seqat);
                this.atbase += bases;
            }
            ++this.iline;
        }
    }

    class SeqIndex {
        int atseq;
        int atbase;

        SeqIndex(int nseq, int nbase) {
            this.atseq = nseq;
            this.atbase = nbase;
        }
    }
}

