/*
 * Decompiled with CFR 0.152.
 */
package iubio.readseq;

import Acme.Fmt;
import flybase.FastProperties;
import flybase.OpenString;
import iubio.readseq.BioseqFormat;
import iubio.readseq.BioseqReaderIface;
import iubio.readseq.BioseqWriterIface;

public class BioseqFormats {
    public static int kNoformat = -1;
    public static int kUnknown = 0;
    public static int kMaxFormat = 30;
    public static int kIG = 1;
    public static int kGenBank = 2;
    public static int kNBRF = 3;
    public static int kEMBL = 4;
    public static int kGCG = 5;
    public static int kStrider = 6;
    public static int kFitch = 7;
    public static int kPearson = 8;
    public static int kZuker = 9;
    public static int kOlsen = 10;
    public static int kPhylip2 = 11;
    public static int kPhylip4;
    public static int kPhylip;
    public static int kPlain;
    public static int kPIR;
    public static int kMSF;
    public static int kASN1;
    public static int kPAUP;
    public static int kPretty;
    public static String propname;
    static int nforms;
    static BioseqFormat[] formats;
    public static String tablestr;

    public static int nFormats() {
        return nforms;
    }

    public static int register(BioseqFormat formatinfo) {
        if (formats == null) {
            formats = new BioseqFormat[kMaxFormat];
            nforms = 0;
            BioseqFormats.formats[0] = new BioseqFormat();
        }
        if (formats.length + 1 <= nforms) {
            int maxforms = nforms * 2;
            BioseqFormat[] nf = new BioseqFormat[maxforms];
            System.arraycopy(formats, 0, nf, 0, nforms);
            formats = nf;
        }
        BioseqFormats.formats[++BioseqFormats.nforms] = formatinfo;
        formatinfo.setFormatID(nforms);
        return nforms;
    }

    public static int indexFromFormat(int format) {
        return format;
    }

    public static BioseqFormat bioseqFormat(int format) {
        if (format >= 0 && format <= nforms) {
            return formats[format];
        }
        return null;
    }

    public static void formatTestInit() {
        int i = 0;
        while (i <= nforms) {
            formats[i].formatTestInit();
            ++i;
        }
    }

    public static int recordStartLine(int format) {
        return formats[format].recordStartLine();
    }

    public static int formatTestLikelihood(int format) {
        return formats[format].formatTestLikelihood();
    }

    public static boolean formatTestLine(int format, OpenString line, int atline, int skiplines) {
        return formats[format].formatTestLine(line, atline, skiplines);
    }

    public static boolean formatTestLine(int format, String line, int atline, int skiplines) {
        return formats[format].formatTestLine(new OpenString(line), atline, skiplines);
    }

    public static String formatName(int format) {
        try {
            return formats[format].formatName();
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String formatNameFromIndex(int format) {
        if (format >= 0 && format <= nforms) {
            boolean nowrite;
            String fn = formats[format].formatName();
            boolean noread = !formats[format].canread();
            boolean bl = nowrite = !formats[format].canwrite();
            if (noread && nowrite) {
                fn = fn + " [no read/write]";
            } else if (noread) {
                fn = fn + " [write only]";
            } else if (nowrite) {
                fn = fn + " [read only]";
            }
            return fn;
        }
        return "";
    }

    static final String spc(boolean spaced, String val, int wid, int flag) {
        if (spaced) {
            val = Fmt.fmt(val, wid, flag);
            return val;
        }
        return val;
    }

    static final String isyes(boolean b) {
        if (b) {
            return "yes ";
        }
        return "-- ";
    }

    public static String getInfo(int format, String style) {
        String delim = "\t";
        boolean w = false;
        boolean dohtml = false;
        boolean dospace = false;
        boolean dotoc = false;
        boolean dohref = false;
        boolean doshort = false;
        boolean doread = true;
        boolean dowrite = true;
        if (style.indexOf("tab") >= 0) {
            delim = "\t";
        } else if (style.indexOf("space") >= 0) {
            dospace = true;
            delim = "  ";
        } else if (style.indexOf("html") >= 0) {
            dohtml = true;
            delim = "</TD><TD>";
        } else if (style.indexOf("short") >= 0) {
            doshort = true;
            dospace = true;
            delim = "  ";
        }
        if (style.indexOf("noread") >= 0) {
            doread = false;
        }
        if (style.indexOf("nowrite") >= 0) {
            dowrite = false;
        }
        if (style.indexOf("toc") >= 0) {
            dotoc = true;
        }
        if (style.indexOf("href") >= 0) {
            dohref = true;
        }
        StringBuffer sb = new StringBuffer();
        if (style.indexOf("header") >= 0) {
            if (dohtml) {
                if (style.indexOf("header1") < 0) {
                    sb.append(tablestr);
                }
                sb.append("<TR bgcolor=\"#99CCFF\"><TH align=left>");
                delim = "</TH><TH align=left>";
            }
            sb.append(BioseqFormats.spc(dospace, "ID", 3, 0));
            sb.append(delim);
            sb.append(BioseqFormats.spc(dospace, "Name", 14, 2));
            sb.append(delim);
            if (doread) {
                sb.append(BioseqFormats.spc(dospace, "Read", 5, 0));
                sb.append(delim);
            }
            if (dowrite) {
                sb.append(BioseqFormats.spc(dospace, "Write", 5, 0));
                sb.append(delim);
            }
            if (!doshort) {
                sb.append(BioseqFormats.spc(dospace, "Int'leaf", 8, 0));
                sb.append(delim);
            }
            sb.append(BioseqFormats.spc(dospace, "Features", 8, 0));
            sb.append(delim);
            sb.append(BioseqFormats.spc(dospace, "Sequence", 8, 0));
            sb.append(delim);
            if (!doshort) {
                sb.append(BioseqFormats.spc(dospace, "Suffix", 6, 2));
                sb.append(delim);
                sb.append(BioseqFormats.spc(false, "Content-type", 19, 2));
            }
            if (dohtml) {
                sb.append("</TH></TR>");
            }
        } else if (style.indexOf("footer") >= 0) {
            if (dohtml) {
                sb.append("</TABLE>");
            }
        } else {
            BioseqFormat fmt = BioseqFormats.bioseqFormat(format);
            if (fmt != null && (dowrite || !doread || fmt.canread()) && (doread || !dowrite || fmt.canwrite())) {
                String sid = String.valueOf(fmt.formatID());
                if (dohtml) {
                    sb.append("<TR><TD>");
                    if (dotoc) {
                        sb.append("<A href=\"#fmt" + sid + "\">");
                    } else if (dohref) {
                        sb.append("<A name=\"fmt" + sid + "\">");
                    }
                }
                sb.append(BioseqFormats.spc(dospace, sid, 3, 0));
                if (dotoc || dohref) {
                    sb.append("</A>");
                }
                sb.append(delim);
                sb.append(BioseqFormats.spc(dospace, fmt.formatName(), 14, 2));
                sb.append(delim);
                if (doread) {
                    sb.append(BioseqFormats.spc(dospace, BioseqFormats.isyes(fmt.canread()), 5, 0));
                    sb.append(delim);
                }
                if (dowrite) {
                    sb.append(BioseqFormats.spc(dospace, BioseqFormats.isyes(fmt.canwrite()), 5, 0));
                    sb.append(delim);
                }
                if (!doshort) {
                    sb.append(BioseqFormats.spc(dospace, BioseqFormats.isyes(fmt.interleaved()), 8, 0));
                    sb.append(delim);
                }
                sb.append(BioseqFormats.spc(dospace, BioseqFormats.isyes(fmt.hasdoc()), 8, 0));
                sb.append(delim);
                sb.append(BioseqFormats.spc(dospace, BioseqFormats.isyes(fmt.hasseq()), 8, 0));
                sb.append(delim);
                if (!doshort) {
                    sb.append(BioseqFormats.spc(dospace, fmt.formatSuffix(), 6, 2));
                    sb.append(delim);
                    sb.append(BioseqFormats.spc(false, fmt.contentType(), 19, 2));
                }
                if (dohtml) {
                    sb.append("</TD></TR>");
                }
            }
        }
        return sb.toString();
    }

    public static String formatSuffixFromIndex(int index) {
        return BioseqFormats.formatSuffix(index);
    }

    public static String formatSuffix(int format) {
        if (format >= 0 && format <= nforms) {
            return formats[format].formatSuffix();
        }
        return "";
    }

    public static String contentTypeFromIndex(int index) {
        return BioseqFormats.contentType(index);
    }

    public static String contentType(int format) {
        if (format >= 0 && format <= nforms) {
            return formats[format].contentType();
        }
        return "biosequence/*";
    }

    public static int formatFromIndex(int format) {
        if (format >= 0 && format <= nforms) {
            return formats[format].formatID();
        }
        return kUnknown;
    }

    public static int getFormatId(String format) {
        int fid = kUnknown;
        if (format == null || format.length() < 1) {
            return fid;
        }
        int at = format.indexOf(124);
        if (at > 0) {
            format = format.substring(0, at);
        }
        if (Character.isDigit((format = format.trim()).charAt(0))) {
            try {
                fid = Integer.parseInt(format);
            }
            catch (Exception e) {
                fid = kUnknown;
            }
        }
        if (fid == kUnknown) {
            fid = BioseqFormats.formatFromContentType(format);
        }
        if (fid == kUnknown) {
            fid = BioseqFormats.formatFromName(format);
        }
        return fid;
    }

    public static int formatFromName(String name) {
        if (name != null && name.length() > 1) {
            int i = 1;
            while (i <= nforms) {
                int at;
                String form2 = null;
                String form1 = new String(formats[i].formatName());
                do {
                    if ((at = form1.indexOf(124)) > 0) {
                        form2 = form1.substring(at + 1).trim();
                        form1 = form1.substring(0, at).trim();
                    }
                    if (name.equalsIgnoreCase(form1)) {
                        return formats[i].formatID();
                    }
                    form1 = form2;
                } while (at > 0);
                ++i;
            }
        }
        int i = 0;
        while (i <= nforms) {
            String sufx = formats[i].formatSuffix();
            if (sufx.startsWith(".")) {
                sufx = sufx.substring(1);
            }
            if (name.equalsIgnoreCase(sufx)) {
                return formats[i].formatID();
            }
            ++i;
        }
        return kUnknown;
    }

    public static int formatFromContentType(String content) {
        if (content != null && content.length() > 1) {
            int i = 1;
            while (i <= nforms) {
                String ct = formats[i].contentType();
                if (content.equalsIgnoreCase(ct)) {
                    return formats[i].formatID();
                }
                ++i;
            }
        }
        return kUnknown;
    }

    public static boolean canread(int format) {
        try {
            return formats[format].canread();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean canwrite(int format) {
        try {
            return formats[format].canwrite();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static final BioseqWriterIface newWriter(int format) {
        return BioseqFormats.newWriter(format, 2);
    }

    public static BioseqWriterIface newWriter(int format, int nseqs) {
        try {
            if (!formats[format].canwrite()) {
                return null;
            }
            BioseqWriterIface wtr = formats[format].newWriter();
            wtr.setFormatID(format);
            return wtr;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static BioseqReaderIface newReader(int format) {
        try {
            if (!formats[format].canread()) {
                return null;
            }
            BioseqReaderIface rdr = formats[format].newReader();
            rdr.setFormatID(format);
            return rdr;
        }
        catch (Exception e) {
            return null;
        }
    }

    protected static void loadClasses(String propname) {
        String pname = System.getProperty(propname, propname);
        String listname = System.getProperty("formats", "formats");
        FastProperties props = new FastProperties();
        props.loadProperties(pname);
        String cs = props.getProperty(listname);
        if (cs == null) {
            return;
        }
        int at0 = 0;
        while (at0 >= 0) {
            String c;
            int at = cs.indexOf(44, at0);
            if (at > at0) {
                c = cs.substring(at0, at);
                at0 = at + 1;
            } else {
                c = cs.substring(at0);
                at0 = -1;
            }
            c = c.trim();
            if (c.length() <= 0) continue;
            try {
                Class<?> rc = Class.forName(c);
                BioseqFormats.register((BioseqFormat)rc.newInstance());
            }
            catch (Exception e) {
                System.err.println("Error loading class: '" + c + "'");
            }
        }
    }

    static {
        kPhylip = kPhylip4 = 12;
        kPlain = 13;
        kPIR = 14;
        kMSF = 15;
        kASN1 = 16;
        kPAUP = 17;
        kPretty = 18;
        propname = "BioseqFormats";
        BioseqFormats.loadClasses(propname);
        tablestr = "<TABLE bgcolor=\"white\" border=0 CELLSPACING=0 CELLPADDING=4>";
    }
}

