/*
 * Decompiled with CFR 0.152.
 */
package iubio.bioseq;

import iubio.bioseq.SeqRangeException;

public class SeqRange
implements Cloneable {
    public static final int kDelete = 1;
    public static final int kInsert = 2;
    public static final int kReorder = 4;
    public static final int kChange = 8;
    public static final int kNoValue = Integer.MIN_VALUE;
    public static final int kZero = 1;
    public static final int kStartless = 1;
    public static final int kStartmore = 2;
    public static final int kEndless = 4;
    public static final int kEndmore = 8;
    public static final int kBetween = 16;
    public static final int kStartMatchend = 32;
    public static final int kEndMatchend = 64;
    public static final String[] sOperators = new String[]{"join", "complement", "order", "group", "one-of", "", ""};
    public static final byte opJoin = 0;
    public static final byte opComplement = 1;
    public static final byte opOrder = 2;
    public static final byte opGroup = 3;
    public static final byte opOneof = 4;
    public static final byte opMax = 5;
    public static final byte opNull = 6;
    public static boolean joinspace = false;
    protected int start;
    protected int nbases;
    protected int myZero = 1;
    protected byte uncertain;
    protected byte operation = (byte)6;
    protected byte coperation = (byte)6;
    protected SeqRange next;
    protected String refid;

    public SeqRange() {
    }

    public SeqRange(int start, int nbases) {
        this.set(start, nbases);
    }

    public SeqRange(int start, int nbases, int uncertain) {
        this(start, nbases, uncertain, null, 6, null);
    }

    public SeqRange(int start, int nbases, int uncertain, String refid) {
        this(start, nbases, uncertain, refid, 6, null);
    }

    public SeqRange(int start, int nbases, int uncertain, String refid, String soperation, SeqRange next) {
        this(start, nbases, uncertain, refid, 6, next);
        if (soperation != null) {
            if ("jo".equals(soperation)) {
                this.operation = 0;
            } else if ("co".equals(soperation)) {
                this.operation = 1;
            } else {
                int op = 0;
                while (op < 5) {
                    if (sOperators[op].equals(soperation)) {
                        this.operation = (byte)op;
                        break;
                    }
                    op = (byte)(op + 1);
                }
            }
        }
    }

    public SeqRange(String range) throws SeqRangeException {
        this.parse1(range);
    }

    protected SeqRange(int start, int nbases, int uncertain, String refid, byte oper, SeqRange next) {
        this.start = start;
        this.nbases = nbases;
        this.uncertain = (byte)uncertain;
        this.refid = refid;
        this.next = next;
        this.operation = oper;
    }

    protected SeqRange(int start, int nbases, int uncertain, String refid, byte oper, SeqRange next, int zero) {
        this.start = start;
        this.nbases = nbases;
        this.uncertain = (byte)uncertain;
        this.refid = refid;
        this.next = next;
        this.operation = oper;
        this.myZero = zero;
    }

    public final void set(int start, int nbases) {
        this.start = start;
        this.nbases = nbases;
    }

    public final int start() {
        return this.start;
    }

    public final int nbases() {
        return this.nbases;
    }

    public final int stop() {
        return this.start + this.nbases - 1;
    }

    public final int uncertain() {
        return this.uncertain;
    }

    public final SeqRange next() {
        return this.next;
    }

    public final String operation() {
        return this.operation >= 5 ? "" : sOperators[this.operation];
    }

    public final int oper2() {
        return this.coperation < 5 ? this.coperation : this.operation;
    }

    public final int opint() {
        return this.oper2();
    }

    public final int oper2(boolean isfirst) {
        return isfirst ? this.coperation : this.operation;
    }

    public final String refId() {
        return this.refid;
    }

    public final boolean hasId() {
        return this.refid != null;
    }

    public final String remoteSeq() {
        return this.refid;
    }

    public final boolean isRemote() {
        return this.refid != null;
    }

    public boolean isPartRemote(String defid) {
        SeqRange nr = this;
        if (defid == null) {
            defid = nr.refid;
        }
        while ((nr.refid == null || nr.refid.equals(defid)) && nr.next != null) {
            nr = nr.next;
        }
        return nr.refid != null && !nr.refid.equals(defid);
    }

    public final boolean isEmpty() {
        return this.start == 0 && this.nbases == 0 && this.next == null;
    }

    public final boolean isComplex() {
        return this.next != null || this.operation > 0 && this.operation < 6;
    }

    public final boolean isComplement() {
        return this.operation == 1;
    }

    public final int origin() {
        return this.myZero;
    }

    public final boolean stopIsEnd() {
        return (this.uncertain & 0x40) != 0;
    }

    public final boolean startIsEnd() {
        return (this.uncertain & 0x20) != 0;
    }

    public final void setStart(int start) {
        this.start = start;
    }

    public final void setNbases(int nbases) {
        this.nbases = nbases;
    }

    public int setDisplayOrigin(int zerobase) {
        int savez = this.myZero;
        this.myZero = zerobase;
        SeqRange nx = this.next;
        while (nx != null) {
            nx.myZero = zerobase;
            nx = nx.next();
        }
        return savez;
    }

    public int min() {
        int min = this.start();
        SeqRange nx = this.next;
        while (nx != null) {
            min = Math.min(min, nx.start());
            nx = nx.next();
        }
        return min;
    }

    public int max() {
        int max = this.stop();
        SeqRange nx = this.next;
        while (nx != null) {
            max = Math.max(max, nx.stop());
            nx = nx.next();
        }
        return max;
    }

    public void copy(SeqRange sr) {
        this.start = sr.start;
        this.nbases = sr.nbases;
        this.uncertain = sr.uncertain;
        this.operation = sr.operation;
        this.coperation = sr.coperation;
        this.refid = sr.refid;
        this.next = sr.next;
    }

    public void add(SeqRange sr) {
        if (sr != null && sr.nbases > 0) {
            if (this.nbases == 0) {
                this.copy(sr);
            } else {
                SeqRange nr = this;
                while (nr.next != null) {
                    nr = nr.next;
                }
                if (sr.start < nr.stop()) {
                    if (sr.stop() < nr.stop()) {
                        return;
                    }
                    sr.nbases += sr.start - nr.stop();
                    sr.start = nr.stop();
                }
                nr.next = sr;
                if (this.operation == 6) {
                    this.operation = 0;
                }
            }
        }
    }

    public Object clone() {
        try {
            SeqRange sr = (SeqRange)super.clone();
            if (this.next != null) {
                sr.next = (SeqRange)this.next.clone();
            }
            return sr;
        }
        catch (CloneNotSupportedException ex) {
            throw new Error(ex.toString());
        }
    }

    public SeqRange inorder() {
        boolean inorder = true;
        SeqRange lx = this;
        int np = 1;
        SeqRange nx = this.next;
        while (nx != null) {
            ++np;
            if (nx.start < lx.start) {
                inorder = false;
            }
            lx = nx;
            nx = nx.next();
        }
        if (inorder) {
            return this;
        }
        SeqRange[] v = new SeqRange[np];
        byte saveop = this.operation;
        this.operation = this.coperation;
        int i = 0;
        SeqRange nx2 = this;
        while (nx2 != null) {
            v[i++] = nx2;
            nx2 = nx2.next();
        }
        this.sortr(v, 0, np - 1);
        SeqRange newr = null;
        lx = null;
        i = 0;
        while (i < np) {
            SeqRange nx3 = new SeqRange();
            nx3.copy(v[i]);
            nx3.next = null;
            if (lx == null) {
                newr = nx3;
                newr.coperation = newr.operation;
                newr.operation = saveop;
            } else {
                lx.next = nx3;
            }
            lx = nx3;
            ++i;
        }
        this.operation = saveop;
        return newr;
    }

    private final void swapr(SeqRange[] v, int a, int b) {
        SeqRange an = v[a];
        v[a] = v[b];
        v[b] = an;
    }

    private final int comparer(SeqRange[] v, int a, int b) {
        return v[a].start - v[b].start;
    }

    private void sortr(SeqRange[] v, int min, int max) {
        if (min < max) {
            int lo = min;
            int hi = max;
            while (true) {
                if (lo < hi && this.comparer(v, lo, max) <= 0) {
                    ++lo;
                    continue;
                }
                while (hi > lo && this.comparer(v, hi, max) >= 0) {
                    --hi;
                }
                if (lo < hi) {
                    this.swapr(v, lo, hi);
                }
                if (lo >= hi) break;
            }
            this.swapr(v, lo, max);
            if (lo - min < max - lo) {
                this.sortr(v, min, lo - 1);
                this.sortr(v, lo + 1, max);
            } else {
                this.sortr(v, lo + 1, max);
                this.sortr(v, min, lo - 1);
            }
        }
    }

    public final boolean updateRange(int changeflags, int astart, int length) {
        return this.updateRange(changeflags, astart, length, null);
    }

    public boolean updateRange(int changeflags, int astart, int length, byte[] basechanges) {
        if (astart > this.stop()) {
            return false;
        }
        int oldstart = this.start;
        int oldlen = this.nbases;
        int istop = this.stop();
        if (basechanges != null) {
            int i = 0;
            while (i < basechanges.length) {
                int at = i + astart;
                if (at <= istop) {
                    switch (basechanges[i]) {
                        case 1: {
                            if (at < this.start) {
                                --this.start;
                                break;
                            }
                            if (at > istop) break;
                            --this.nbases;
                            break;
                        }
                        case 2: {
                            if (at < this.start) {
                                ++this.start;
                                break;
                            }
                            if (at > istop) break;
                            ++this.nbases;
                        }
                    }
                    ++i;
                    continue;
                }
                break;
            }
        } else if ((changeflags & 2) != 0) {
            if (astart < this.start) {
                this.start += length;
            } else if (astart <= istop) {
                this.nbases += length;
            }
        } else if ((changeflags & 1) != 0) {
            if (astart < this.start) {
                this.start -= length;
            } else if (astart <= istop) {
                this.nbases -= length;
            }
        }
        if (this.start < 0) {
            this.start = 0;
        }
        if (this.nbases < 0) {
            this.nbases = 0;
        }
        boolean changedme = oldstart != this.start || oldlen != this.nbases;
        boolean changednext = false;
        if (this.next != null) {
            changednext = this.next.updateRange(changeflags, astart, length, basechanges);
        }
        return changedme || changednext;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.operation < 5) {
            sb.append(sOperators[this.operation]);
            sb.append('(');
        }
        this.toBufFirst(sb);
        if (this.operation < 5) {
            sb.append(')');
        }
        return sb.toString();
    }

    public boolean equals(Object ob) {
        if (ob instanceof SeqRange) {
            SeqRange sr = (SeqRange)ob;
            if (this.start == sr.start && this.nbases == sr.nbases) {
                return this.next == null || this.next.equals(sr.next);
            }
        }
        return false;
    }

    public boolean contains(SeqRange sr) {
        if (sr == null) {
            return false;
        }
        return this.start <= sr.start() && this.max() >= sr.max();
    }

    public boolean intersects(SeqRange sr) {
        if (sr == null) {
            return false;
        }
        if (this.start <= sr.stop() && this.stop() >= sr.start) {
            return true;
        }
        if (this.next != null && this.next.intersects(sr)) {
            return true;
        }
        return sr.next != null && this.intersects(sr.next);
    }

    public boolean intersectsMax(SeqRange sr) {
        if (sr == null) {
            return false;
        }
        return this.start <= sr.max() && this.max() >= sr.start;
    }

    public SeqRange intersection0(SeqRange sr) {
        if (sr == null) {
            return null;
        }
        if (this.start <= sr.max() && this.max() >= sr.start) {
            int b = Math.max(this.start, sr.start());
            int e = Math.min(this.max(), sr.max());
            return this.newRange(b, e - b + 1);
        }
        return null;
    }

    public SeqRange intersection(SeqRange sr) {
        if (sr == null) {
            return this;
        }
        if (sr.start() <= this.start && sr.max() >= this.max()) {
            return this;
        }
        if (this.start <= sr.start() && this.max() >= sr.max()) {
            return sr;
        }
        return this.intersection0(sr);
    }

    public int compareTo(SeqRange sr) {
        int srmax;
        boolean srun;
        if (sr == null) {
            return -1;
        }
        if (this.start < sr.start()) {
            return -1;
        }
        if (this.start > sr.start()) {
            return 1;
        }
        boolean myun = (this.uncertain & 1) != 0;
        boolean bl = srun = (sr.uncertain & 1) != 0;
        if (myun && !srun) {
            return -1;
        }
        if (!myun && srun) {
            return 1;
        }
        int mx = this.max();
        if (mx < (srmax = sr.max())) {
            return -1;
        }
        if (mx > srmax) {
            return 1;
        }
        myun = (this.uncertain & 2) != 0;
        boolean bl2 = srun = (sr.uncertain & 2) != 0;
        if (myun && !srun) {
            return 1;
        }
        if (!myun && srun) {
            return -1;
        }
        return 0;
    }

    public SeqRange invert(int maxlen) {
        SeqRange invsr = this.newRange();
        int at = 0;
        SeqRange sr = this;
        while (sr != null && at < maxlen) {
            if (sr.start > at) {
                invsr.add(this.newRange(at, sr.start - at));
            }
            at = sr.stop() + 1;
            sr = sr.next;
        }
        if (at < maxlen) {
            invsr.add(this.newRange(at, maxlen - at));
        }
        return invsr;
    }

    public SeqRange joinRange(SeqRange sr) {
        SeqRange unionsr = null;
        unionsr = this.newRange();
        this.addRange(unionsr, sr);
        if (unionsr.next != null && unionsr.operation == 6) {
            unionsr.operation = 0;
        }
        return unionsr;
    }

    protected void addRange(SeqRange unionsr, SeqRange sr) {
        if (sr == null) {
            unionsr.add(new SeqRange(this.start, this.nbases, this.uncertain, this.refid));
            if (this.next != null) {
                this.next.addRange(unionsr, sr);
            }
        } else if (this.start == 0 && this.nbases == 0) {
            unionsr.add(new SeqRange(sr.start, sr.nbases, sr.uncertain, sr.refid));
            this.addRange(unionsr, sr.next);
        } else if (this.start <= sr.stop() && this.stop() >= sr.start) {
            int min = Math.min(this.start, sr.start);
            int max = Math.max(this.stop(), sr.stop());
            unionsr.add(new SeqRange(min, max - min + 1, this.uncertain | sr.uncertain));
            if (this.next != null) {
                this.next.addRange(unionsr, sr.next);
            } else if (sr.next != null) {
                sr.next.addRange(unionsr, null);
            }
        } else if (sr.start < this.start) {
            unionsr.add(new SeqRange(sr.start, sr.nbases, sr.uncertain, sr.refid));
            this.addRange(unionsr, sr.next);
        } else {
            unionsr.add(new SeqRange(this.start, this.nbases, this.uncertain, this.refid));
            sr.addRange(unionsr, this.next);
        }
    }

    public SeqRange subrange(SeqRange subr) {
        if (subr == null || subr.isEmpty()) {
            return this;
        }
        SeqRange unionsr = this.newRange();
        SeqRange thisr = this;
        if (this.isComplement()) {
            thisr = this.reverse();
        }
        SeqRange sr = subr;
        while (sr != null) {
            int rstop = sr.stopIsEnd() ? thisr.max() + sr.stop() : thisr.start() + sr.stop();
            int rstart = sr.startIsEnd() ? thisr.max() + sr.start() : thisr.start() + sr.start();
            if (rstop <= thisr.start()) {
                unionsr.add(this.newRange(rstart, rstop - rstart + 1));
            } else if (rstart >= thisr.max()) {
                unionsr.add(this.newRange(rstart, rstop - rstart + 1));
            } else {
                thisr.subRange(unionsr, sr, rstart, rstop);
            }
            sr = sr.next;
        }
        if (this.isComplement()) {
            unionsr = unionsr.reverse();
            unionsr.operation = this.operation;
        } else if (unionsr.next != null && unionsr.operation == 6) {
            unionsr.operation = 0;
        }
        return unionsr;
    }

    protected void subRange(SeqRange unionsr, SeqRange sr, int srstart, int srstop) {
        if (sr != null) {
            if (this.start == 0 && this.nbases == 0) {
                if (this.next != null) {
                    this.next.subRange(unionsr, sr, srstart, srstop);
                }
            } else {
                if (srstop < this.start) {
                    if (unionsr.isEmpty()) {
                        unionsr.add(this.newRange(srstart, srstop - srstart + 1));
                    }
                    return;
                }
                if (srstart > this.stop()) {
                    if (this.next != null) {
                        this.next.subRange(unionsr, sr, srstart, srstop);
                    }
                    if (unionsr.isEmpty()) {
                        unionsr.add(this.newRange(srstart, srstop - srstart + 1));
                    }
                    return;
                }
                int b = this.start;
                int e = this.stop();
                b = srstart < this.start ? (unionsr.isEmpty() ? srstart : this.start) : Math.max(srstart, this.start());
                e = srstop > this.stop() ? (this.next == null ? srstop : this.stop()) : Math.min(srstop, this.stop());
                SeqRange addr = this.newRange(b, e - b + 1);
                unionsr.add(addr);
                if (this.next != null) {
                    this.next.subRange(unionsr, sr, srstart, srstop);
                }
            }
        }
    }

    public SeqRange reverse() {
        SeqRange revr = this.newRange();
        byte saveop = this.operation;
        this.operation = this.coperation;
        this.reverseRange(revr);
        revr.coperation = (byte)(revr.operation > 0 && revr.operation < 5 ? (int)revr.operation : 6);
        revr.operation = saveop;
        this.operation = saveop;
        return revr;
    }

    protected void reverseRange(SeqRange revr) {
        if (this.next != null) {
            this.next.reverseRange(revr);
        }
        SeqRange rev1 = this.newRangeCopy(-this.start - this.nbases, this.nbases);
        revr.add(rev1);
    }

    public SeqRange reverseComplement(int revbase) {
        SeqRange revr = this.newRange();
        byte saveop = this.operation;
        this.operation = this.coperation;
        this.reverseRange(revr, revbase);
        revr.coperation = (byte)(revr.operation > 0 && revr.operation < 5 ? (int)revr.operation : 6);
        revr.operation = saveop == 1 ? (byte)0 : 1;
        this.operation = saveop;
        return revr;
    }

    protected void reverseRange(SeqRange revr, int revbase) {
        if (this.next != null) {
            this.next.reverseRange(revr, revbase);
        }
        SeqRange rev1 = this.newRangeCopy(revbase - this.start - this.nbases, this.nbases);
        revr.add(rev1);
    }

    protected void toBufPart(StringBuffer sb) {
        int oper = this.oper2();
        if (oper > 0 && oper < 5) {
            sb.append(sOperators[oper]);
            sb.append('(');
        }
        this.toBufNoop(sb);
        if (oper < 5) {
            sb.append(')');
        }
        this.toBufNext(sb);
    }

    protected void toBufFirst(StringBuffer sb) {
        byte oper = this.coperation;
        if (oper < 5) {
            sb.append(sOperators[oper]);
            sb.append('(');
        }
        this.toBufNoop(sb);
        if (oper < 5) {
            sb.append(')');
        }
        this.toBufNext(sb);
    }

    protected void toBufNext(StringBuffer sb) {
        if (this.next != null) {
            sb.append(',');
            if (joinspace) {
                sb.append(' ');
            }
            this.next.toBufPart(sb);
        }
    }

    protected void toBufNoop(StringBuffer sb) {
        boolean do2;
        if (this.refid != null) {
            sb.append(this.refid);
            sb.append(':');
        }
        if ((this.uncertain & 1) != 0) {
            sb.append('<');
        } else if ((this.uncertain & 2) != 0) {
            sb.append('>');
        }
        if ((this.uncertain & 0x20) != 0) {
            sb.append("end");
        }
        sb.append(this.start + this.myZero);
        boolean bl = do2 = (this.uncertain & 0x5C) != 0;
        if (do2 || this.nbases > 1) {
            if ((this.uncertain & 0x10) != 0) {
                sb.append('^');
            } else {
                sb.append("..");
            }
            if ((this.uncertain & 4) != 0) {
                sb.append('<');
            } else if ((this.uncertain & 8) != 0) {
                sb.append('>');
            }
            if ((this.uncertain & 0x40) != 0) {
                sb.append("end");
            }
            sb.append(this.stop() + this.myZero);
        }
    }

    protected final int getMyMark(String s) {
        int at = s.indexOf(58);
        if (at > 0) {
            this.refid = s.substring(0, at);
            s = s.substring(at + 1);
        }
        return this.getMyMark(s, 1, 2, 32);
    }

    protected final int getMyEndMark(String s) {
        return this.getMyMark(s, 4, 8, 64);
    }

    protected int getMyMark(String s, int lessflag, int moreflag, int endflag) {
        boolean minus = false;
        int val = Integer.MIN_VALUE;
        int b = -1;
        int e = -1;
        int slen = s.length();
        int i = 0;
        while (i < slen) {
            char c = s.charAt(i);
            if (c > ' ') {
                if (c >= '0' && c <= '9') {
                    e = i;
                    if (b == -1) {
                        b = i;
                    }
                } else {
                    if (b >= 0) break;
                    switch (c) {
                        case '<': {
                            this.uncertain = (byte)(this.uncertain | lessflag);
                            break;
                        }
                        case '>': {
                            this.uncertain = (byte)(this.uncertain | moreflag);
                            break;
                        }
                        case '^': {
                            this.uncertain = (byte)(this.uncertain | 0x10);
                            break;
                        }
                        case '-': {
                            minus = true;
                            break;
                        }
                        case '+': {
                            minus = false;
                            break;
                        }
                        case 'e': {
                            if (i + 1 < slen && s.charAt(i + 1) == 'n') {
                                ++i;
                            }
                            if (i + 1 < slen && s.charAt(i + 1) == 'd') {
                                ++i;
                            }
                            this.uncertain = (byte)(this.uncertain | endflag);
                            val = 0;
                        }
                    }
                }
            }
            ++i;
        }
        if (b < 0) {
            return val;
        }
        try {
            val = Integer.parseInt(s.substring(b, e + 1));
        }
        catch (Exception ex) {
            return Integer.MIN_VALUE;
        }
        if (minus) {
            val = -val;
        }
        return val -= this.myZero;
    }

    protected boolean getMyRange(String s) {
        int start;
        int i = s.indexOf(40);
        if (i >= 0) {
            int oper = 6;
            int op = 0;
            while (op < 5) {
                if (s.startsWith(sOperators[op])) {
                    oper = op;
                    break;
                }
                op = (byte)(op + 1);
            }
            if (this.operation < 5) {
                this.coperation = (byte)oper;
            } else {
                this.operation = (byte)oper;
            }
            int e = s.indexOf(41, i);
            if (e < 0) {
                e = s.length();
            }
            s = s.substring(i + 1, e);
        }
        int sepwid = 2;
        int e = s.indexOf("..");
        if (e < 0 && (e = s.indexOf(94)) > 0) {
            this.uncertain = (byte)(this.uncertain | 0x10);
            sepwid = 1;
        }
        if (e >= 0) {
            start = this.getMyMark(s.substring(0, e));
            int stop = this.getMyEndMark(s.substring(e + sepwid));
            if (start == Integer.MIN_VALUE) {
                if (stop == Integer.MIN_VALUE) {
                    return false;
                }
                this.set(stop, 1);
            } else if (stop == Integer.MIN_VALUE) {
                this.set(start, 1);
            } else {
                this.set(start, stop - start + 1);
            }
        } else {
            start = this.getMyMark(s);
            if (start == Integer.MIN_VALUE) {
                return false;
            }
            this.set(start, 1);
        }
        return true;
    }

    protected boolean getNextJoin(String s) {
        if (s.length() == 0) {
            return false;
        }
        int c = s.indexOf(44);
        if (c < 0) {
            return this.getMyRange(s);
        }
        if (!this.getMyRange(s.substring(0, c))) {
            return this.getNextJoin(s.substring(c + 1));
        }
        SeqRange newnext = this.newRange();
        boolean ok = newnext.getNextJoin(s.substring(c + 1));
        if (ok) {
            this.next = newnext;
        }
        return ok;
    }

    public SeqRange newRange() {
        SeqRange sr = new SeqRange();
        sr.myZero = this.myZero;
        return sr;
    }

    public SeqRange newRange(int start, int nbases) {
        SeqRange sr = new SeqRange(start, nbases);
        sr.myZero = this.myZero;
        return sr;
    }

    public SeqRange newRangeCopy(int start, int nbases) {
        SeqRange sr = new SeqRange(start, nbases, this.uncertain, null, this.operation, null, this.myZero);
        return sr;
    }

    public void parse1(String s) throws SeqRangeException {
        boolean ok = true;
        try {
            this.operation = (byte)6;
            s = s.trim();
            if (s.length() == 0) {
                return;
            }
            int co = s.indexOf(58);
            int pa = s.indexOf(40);
            if (co >= 0 && co < pa) {
                this.refid = s.substring(0, co);
                s = s.substring(co + 1);
            }
            if (s.startsWith("jo(")) {
                this.operation = 0;
            } else if (s.startsWith("co(")) {
                this.operation = 1;
            } else {
                int op = 0;
                while (op < 5) {
                    if (s.startsWith(sOperators[op])) {
                        this.operation = (byte)op;
                        break;
                    }
                    op = (byte)(op + 1);
                }
            }
            if (pa >= 0 || this.operation != 6) {
                int e = 0;
                int i = s.indexOf(40);
                if (i >= 0) {
                    e = s.lastIndexOf(41);
                }
                if (e < 0) {
                    e = s.length();
                }
                if (i >= 0) {
                    s = s.substring(i + 1, e);
                } else if (this.operation != 6) {
                    s = s.substring(sOperators[this.operation].length());
                }
            }
            ok = this.getNextJoin(s);
        }
        catch (Exception e) {
            throw new SeqRangeException("SeqRange error parsing '" + s + "': " + e.getMessage());
        }
        if (!ok) {
            throw new SeqRangeException("SeqRange error parsing '" + s + "'");
        }
    }

    public static SeqRange parse(String s) throws SeqRangeException {
        if (s == null) {
            return null;
        }
        SeqRange sr = new SeqRange();
        sr.parse1(s);
        return sr;
    }
}

