/*
 * Decompiled with CFR 0.152.
 */
package iubio.bioseq;

import iubio.bioseq.SeqKind;

public class SeqInfo {
    public static final short kOtherSeq = 0;
    public static final short kDNA = 1;
    public static final short kRNA = 2;
    public static final short kNucleic = 3;
    public static final short kAmino = 4;
    public static final short kIndelSeq = 5;
    protected short seqtype;
    protected int basecount;
    protected long checksum;

    public int getKind() {
        return this.seqtype;
    }

    public int getBaseCount() {
        return this.basecount;
    }

    public long getChecksum() {
        return this.checksum;
    }

    public void setKind(int seqtype) {
        this.seqtype = (short)seqtype;
    }

    public void setBaseCount(int basecount) {
        this.basecount = basecount;
    }

    public void setChecksum(long checksum) {
        this.checksum = checksum;
    }

    public boolean equals(SeqInfo si) {
        return si.seqtype == this.seqtype && si.basecount == this.basecount && si.checksum == this.checksum;
    }

    public int[] getACGTcounts() {
        return null;
    }

    public void init(int maxlen) {
    }

    public void add(byte[] ba, int offset, int len) {
    }

    public void add(char[] ca, int offset, int len) {
    }

    public void add(String s, int offset, int len) {
    }

    public void add(int c) {
    }

    public static SeqInfo getSeqInfo(int maxlen, boolean shorttest, boolean wantcrc) {
        SeqKind sk = new SeqKind(maxlen, shorttest, wantcrc);
        return sk;
    }

    public String getKindLabel() {
        return SeqInfo.getKindLabel(this.seqtype);
    }

    public static String getKindLabel(int kind) {
        switch (kind) {
            case 4: {
                return "PROTEIN";
            }
            case 3: {
                return "NUCLEOTIDE";
            }
            case 2: {
                return "RNA";
            }
        }
        return "DNA";
    }
}

