/*
 * Decompiled with CFR 0.152.
 */
package flybase;

import flybase.Debug;
import flybase.FastVector;
import flybase.OpenString;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public final class Utils {
    static Hashtable htmlcodes;
    static Hashtable isocodes;
    static final String spaces;
    protected static final int pipesize = 2048;
    private static final int Crypt1 = 52895;
    private static final int Crypt2 = 22419;
    private static final int Cryptkey = 23647;

    public static final String[] splitString(String val) {
        return Utils.splitString(val, "\n\r\t", -1);
    }

    public static final String[] splitString(String val, String delims) {
        return Utils.splitString(val, delims, -1);
    }

    public static String[] splitString(String val, String delims, int maxparts) {
        String[] ss;
        boolean getrem;
        if (val == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(val, delims);
        int n = st.countTokens();
        if (maxparts > 0 && n > maxparts) {
            n = maxparts - 1;
            getrem = true;
            ss = new String[maxparts];
        } else {
            getrem = false;
            ss = new String[n];
        }
        int i = 0;
        while (i < n) {
            ss[i] = st.nextToken();
            ++i;
        }
        if (getrem) {
            val = st.nextToken("\u0000");
            if (val.length() > 0 && delims.indexOf(val.charAt(0)) >= 0) {
                val = val.substring(1);
            }
            ss[n] = val;
        }
        return ss;
    }

    private static final int skipDelimiters(OpenString ost, String delims, int at, int len) {
        while (at < len && delims.indexOf(ost.charAt(at)) >= 0) {
            ++at;
        }
        return at;
    }

    public static final OpenString[] splitString(OpenString val) {
        return Utils.splitString(val, "\n\r\t", -1);
    }

    public static final OpenString[] splitString(OpenString val, String delims) {
        return Utils.splitString(val, delims, -1);
    }

    public static OpenString[] splitString(OpenString val, String delims, int maxparts) {
        if (val == null) {
            return null;
        }
        FastVector v = new FastVector();
        int len = val.length();
        int at = 0;
        int np = 0;
        while (at < len) {
            if (maxparts > 0 && np >= maxparts) {
                OpenString endval = val.substring(at);
                if (endval.length() > 0 && delims.indexOf(endval.charAt(0)) >= 0) {
                    endval = endval.substring(1);
                }
                v.addElement(endval);
                at = len;
                break;
            }
            if ((at = Utils.skipDelimiters(val, delims, at, len)) >= len) continue;
            int at0 = at;
            while (at < len && delims.indexOf(val.charAt(at)) < 0) {
                ++at;
            }
            v.addElement(val.substring(at0, at));
            ++np;
        }
        Object[] ss = new OpenString[v.size()];
        v.copyInto(ss);
        return ss;
    }

    public static String joinStrings(String[] vals, String delim) {
        if (vals == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        int i = 0;
        while (i < vals.length) {
            if (vals[i] != null) {
                if (!first) {
                    sb.append(delim);
                }
                first = false;
                sb.append(vals[i]);
            }
            ++i;
        }
        return sb.toString();
    }

    public static String joinStrings(OpenString[] vals, String delim) {
        if (vals == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        int i = 0;
        while (i < vals.length) {
            if (vals[i] != null) {
                if (!first) {
                    sb.append(delim);
                }
                first = false;
                sb.append(vals[i].toString());
            }
            ++i;
        }
        return sb.toString();
    }

    public static String removeChars(String s, String remove) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (remove.indexOf(c) < 0) {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }

    public static int countChars(String s, String charset) {
        int nc = 0;
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (charset.indexOf(c) >= 0) {
                ++nc;
            }
            ++i;
        }
        return nc;
    }

    public static int countChar(String s, char c) {
        int nc = 0;
        int i = 0;
        while (i < s.length()) {
            if (c == s.charAt(i)) {
                ++nc;
            }
            ++i;
        }
        return nc;
    }

    public static int stringHashCode(String s) {
        int h = 0;
        int len = s.length();
        int i = 0;
        while (i < len) {
            h = 31 * h + s.charAt(i);
            ++i;
        }
        return h;
    }

    public static String quote(String s) {
        if (s.indexOf(32) >= 0) {
            char dqc = '\"';
            char sqc = '\'';
            int len = s.length();
            if (s.charAt(0) == dqc && s.charAt(len - 1) == dqc) {
                return s;
            }
            if (s.charAt(0) == sqc && s.charAt(len - 1) == sqc) {
                return s;
            }
            String qs = s.indexOf(dqc) >= 0 ? "'" : "\"";
            return qs + s + qs;
        }
        return s;
    }

    public static final String stuffLink(String href, String linkid) {
        return Utils.stuffLink(href, linkid, false);
    }

    public static String stuffLink(String href, String linkid, boolean noencode) {
        if (!noencode) {
            linkid = URLEncoder.encode(Utils.quote(linkid));
        }
        StringBuffer sb = new StringBuffer();
        int at = href.indexOf("%s");
        if (at >= 0) {
            sb.append(href.substring(0, at));
            int at2 = href.indexOf("%s", at += 2);
            if (at2 > 0) {
                sb.append(href.substring(at, at2));
                sb.append(linkid);
                int close = href.indexOf(">", at2 += 2);
                if (close > 0) {
                    sb.append(href.substring(at2, close + 1));
                } else {
                    at = href.indexOf("%s", at2);
                    if (at > 0) {
                        sb.append(href.substring(at2, at));
                        sb.append(href.substring(at + 2));
                    } else {
                        sb.append(href.substring(at2));
                    }
                }
            } else {
                sb.append(linkid);
                sb.append(href.substring(at));
            }
        } else {
            sb.append(href);
            sb.append(linkid);
        }
        return sb.toString();
    }

    public static boolean isUrl(String s) {
        try {
            URL u = new URL(s);
            return u != null;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    public static String stripHtmlCodes(String s) {
        int b;
        int a = s.indexOf(60);
        if (a >= 0 && (b = s.indexOf(62, a)) > a) {
            StringBuffer sb = new StringBuffer(s.substring(0, a));
            int a0 = b + 1;
            int len = s.length();
            a = a0 >= len ? -1 : s.indexOf(60, a0);
            while (a > 0) {
                b = s.indexOf(62, a);
                if (b > a) {
                    sb.append(s.substring(a0, a));
                    a0 = b + 1;
                    a = a0 >= len ? -1 : s.indexOf(60, a0);
                    continue;
                }
                a = -1;
            }
            if (a0 < len) {
                sb.append(s.substring(a0));
            }
            return sb.toString();
        }
        return s;
    }

    static void initHtmlCodes() {
        htmlcodes = new Hashtable();
        htmlcodes.put("<p>", "\n");
        htmlcodes.put("<br>", "\n");
        htmlcodes.put("<hr>", "\n---------------------------\n");
        htmlcodes.put("<sup>", "[");
        htmlcodes.put("</sup>", "]");
        htmlcodes.put("<sub>", "[[");
        htmlcodes.put("</sub>", "]]");
        isocodes = new Hashtable();
        isocodes.put("&lt;", "<");
        isocodes.put("&gt;", ">");
        isocodes.put("&amp;", "&");
        isocodes.put("&quot;", "\"");
        isocodes.put("&reg;", "TM");
        isocodes.put("&copy;", "(C)");
        isocodes.put("&nbsp;", " ");
    }

    public static String convertHtmlCode(String s) {
        if (htmlcodes == null) {
            Utils.initHtmlCodes();
        }
        return (String)htmlcodes.get(s.toLowerCase());
    }

    public static String convertIsoCode(String s) {
        String cs;
        if (isocodes == null) {
            Utils.initHtmlCodes();
        }
        if ((cs = (String)isocodes.get(s.toLowerCase())) != null) {
            return cs;
        }
        if (s.length() > 4 && s.charAt(1) == '#') {
            try {
                int c = Integer.parseInt(s.substring(2, 5));
                cs = new Character((char)c).toString();
                return cs;
            }
            catch (Exception e) {
            }
        }
        return s;
    }

    public static String isoCodesToText(String s) {
        int b;
        int a = s.indexOf(38);
        if (a >= 0 && (b = s.indexOf(59, a)) > a && b < a + 8) {
            int len;
            int a0;
            StringBuffer sb = new StringBuffer(s.substring(0, a));
            String hcode = Utils.convertIsoCode(s.substring(a, b + 1));
            if (hcode != null) {
                sb.append(hcode);
            }
            a = (a0 = b + 1) >= (len = s.length()) ? -1 : s.indexOf(38, a0);
            while (a > 0) {
                b = s.indexOf(59, a);
                if (b > a && b < a + 8) {
                    sb.append(s.substring(a0, a));
                    hcode = Utils.convertIsoCode(s.substring(a, b + 1));
                    if (hcode != null) {
                        sb.append(hcode);
                    }
                    a = (a0 = b + 1) >= len ? -1 : s.indexOf(38, a0);
                    continue;
                }
                a = -1;
            }
            if (a0 < len) {
                sb.append(s.substring(a0));
            }
            return sb.toString();
        }
        return s;
    }

    public static String htmlToText(String s) {
        int b;
        int a = s.indexOf(60);
        if (a >= 0 && (b = s.indexOf(62, a)) > a) {
            int len;
            int a0;
            StringBuffer sb = new StringBuffer(s.substring(0, a));
            String hcode = Utils.convertHtmlCode(s.substring(a, b + 1));
            if (hcode != null) {
                sb.append(hcode);
            }
            a = (a0 = b + 1) >= (len = s.length()) ? -1 : s.indexOf(60, a0);
            while (a > 0) {
                b = s.indexOf(62, a);
                if (b > a) {
                    sb.append(s.substring(a0, a));
                    hcode = Utils.convertHtmlCode(s.substring(a, b + 1));
                    if (hcode != null) {
                        sb.append(hcode);
                    }
                    a = (a0 = b + 1) >= len ? -1 : s.indexOf(60, a0);
                    continue;
                }
                a = -1;
            }
            if (a0 < len) {
                sb.append(s.substring(a0));
            }
            s = sb.toString();
        }
        return Utils.isoCodesToText(s);
    }

    public static String titleToSentenceCase(String s) {
        if (s.length() > 1 && Character.isUpperCase(s.charAt(0)) && Character.isLowerCase(s.charAt(1))) {
            return s.toLowerCase();
        }
        return s;
    }

    public static OpenString titleToSentenceCase(OpenString s) {
        if (s.length() > 1 && Character.isUpperCase(s.charAt(0)) && Character.isLowerCase(s.charAt(1))) {
            return new OpenString(s.toLowerCase());
        }
        return s;
    }

    public static OpenString trimSentenceEnd(OpenString s, int cut) {
        int lat;
        int at = s.indexOf(". ");
        if (at < 0 && (lat = s.length() - 1) >= 0 && s.charAt(lat) == '.') {
            at = lat;
        }
        if (cut < 0 || at > 0 && at < cut) {
            cut = at;
        }
        if (cut >= 0) {
            s = s.substring(0, cut).trim();
        }
        return s;
    }

    public static String trimSentenceEnd(String s, int cut) {
        int lat;
        if (cut < 0) {
            cut = s.indexOf(". ");
        }
        if (cut < 0 && (lat = s.lastIndexOf(".")) == s.length() - 1) {
            cut = lat;
        }
        if (cut >= 0) {
            s = s.substring(0, cut).trim();
        }
        return s;
    }

    public static String fileSizeLabel(long size, boolean brief) {
        String lb;
        String s;
        if (size >= 1024000000L) {
            s = Long.toString(size / 102400000L);
            lb = brief ? "Gb" : " Gigabytes";
        } else if (size >= 1024000L) {
            s = Long.toString(size / 102400L);
            lb = brief ? "Mb" : " Megabytes";
        } else if (size >= 1024L) {
            s = Long.toString(size / 100L);
            lb = brief ? "kb" : " kilobytes";
        } else {
            return Long.toString(size) + (brief ? "b" : " bytes");
        }
        int l = s.length() - 1;
        if (l > 0) {
            String d = s.substring(l);
            s = s.substring(0, l);
            if (l < 2 && !d.equals("0")) {
                s = s + "." + d;
            }
        }
        return s + lb;
    }

    public static String formatString(String s, int width) {
        int len = s.length();
        if (width > len) {
            s = spaces.substring(0, width - len) + s;
        } else if (-width > len) {
            s = s + spaces.substring(0, -width - len);
        }
        return s;
    }

    public static final String formatNum(int num, int width) {
        return Utils.formatString(String.valueOf(num), width);
    }

    public static final String formatDouble(double num, int width, int precision) {
        return Utils.formatReal(String.valueOf(num), width, precision);
    }

    public static final String formatFloat(float num, int width, int precision) {
        return Utils.formatReal(String.valueOf(num), width, precision);
    }

    public static String formatReal(String s, int width, int precision) {
        int dec = s.indexOf(46);
        if (dec > 0) {
            int len = s.length();
            while (len > dec && s.charAt(len - 1) == '0') {
                --len;
            }
            if (len - 1 == dec || precision == 0) {
                len = dec;
            } else if (precision > 0 && (dec += precision + 1) < len) {
                len = dec;
            }
            s = s.substring(0, len);
        }
        return Utils.formatString(s, width);
    }

    public static int hexValue(String val) {
        int i = (val = val.trim()).indexOf("0x");
        if (i < 0) {
            i = val.indexOf("0X");
        }
        if (i >= 0) {
            i += 2;
        }
        if (i > 0) {
            val = val.substring(i);
        }
        try {
            return Integer.parseInt(val, 16);
        }
        catch (NumberFormatException ex) {
            return 0;
        }
    }

    public static long hexLongValue(String val) {
        int i = (val = val.trim()).indexOf("0x");
        if (i < 0) {
            i = val.indexOf("0X");
        }
        if (i >= 0) {
            i += 2;
        }
        if (i > 0) {
            val = val.substring(i);
        }
        return Long.parseLong(val, 16);
    }

    public static BitSet bitset(String s) {
        BitSet bs = new BitSet();
        String[] ss = Utils.splitString(s, " ,\t\n");
        int i = 0;
        while (i < ss.length) {
            try {
                bs.set(Integer.parseInt(ss[i]));
            }
            catch (Exception e) {
                // empty catch block
            }
            ++i;
        }
        return bs;
    }

    public static boolean findString(String[] list, String target, boolean partmatch) {
        if (list == null || target == null) {
            return false;
        }
        int i = 0;
        while (i < list.length) {
            if (partmatch ? target.indexOf(list[i]) >= 0 : target.equals(list[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String decode(String str) {
        if (str == null) {
            return null;
        }
        char[] res = new char[str.length()];
        int didx = 0;
        int sidx = 0;
        while (sidx < str.length()) {
            char ch = str.charAt(sidx);
            if (ch == '+') {
                res[didx++] = 32;
            } else if (ch == '%') {
                try {
                    res[didx++] = (char)Integer.parseInt(str.substring(sidx + 1, sidx + 3), 16);
                    sidx += 2;
                }
                catch (NumberFormatException e) {
                    Debug.println("urlDecode:" + str.substring(sidx, sidx + 3) + " is an invalid code");
                }
            } else {
                res[didx++] = ch;
            }
            ++sidx;
        }
        return String.valueOf(res, 0, didx);
    }

    public static void pipeStream(InputStream ins, OutputStream ous) {
        block3: {
            if (ous == null || ins == null) break block3;
            try {
                int len;
                byte[] pipe = new byte[2048];
                do {
                    if ((len = ins.read(pipe)) <= 0) continue;
                    ous.write(pipe, 0, len);
                } while (len >= 0);
                ous.flush();
                ins.close();
            }
            catch (IOException ex) {}
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void pipeTextStream(InputStream ins, OutputStream ous) {
        block3: {
            if (ous == null || ins == null) break block3;
            try {
                String s;
                BufferedReader rdr = new BufferedReader(new InputStreamReader(ins));
                BufferedWriter wtr = new BufferedWriter(new OutputStreamWriter(ous));
                while ((s = rdr.readLine()) != null) {
                    void var4_5;
                    wtr.write((String)var4_5);
                    wtr.newLine();
                }
                wtr.flush();
                ins.close();
                ous.flush();
            }
            catch (IOException ex) {}
        }
    }

    public static void writeObject(OutputStream os, Object ob, boolean dogzip) {
        block4: {
            try {
                if (dogzip) {
                    GZIPOutputStream gzos = new GZIPOutputStream(os);
                    os = gzos;
                }
                ObjectOutputStream out = new ObjectOutputStream(os);
                out.writeObject(ob);
                out.flush();
                if (dogzip) {
                    out.close();
                }
            }
            catch (Exception ex) {
                System.err.println(ex);
                if (!Debug.isOn) break block4;
                ex.printStackTrace();
            }
        }
    }

    public static Object readObject(InputStream in, boolean dogzip) {
        Object ob;
        block3: {
            ob = null;
            try {
                GZIPInputStream gzis = null;
                if (dogzip) {
                    gzis = new GZIPInputStream(in);
                    in = gzis;
                }
                ObjectInputStream oin = new ObjectInputStream(in);
                ob = oin.readObject();
            }
            catch (Exception ex) {
                System.err.println(ex);
                if (!Debug.isOn) break block3;
                ex.printStackTrace();
            }
        }
        return ob;
    }

    public static final String encrypt(String s) {
        return Utils.encrypt(s, 23647L);
    }

    public static final String decrypt(String s) {
        return Utils.decrypt(s, 23647L);
    }

    public static String encrypt(String s, long key) {
        if (s == null || s.length() < 1) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(s.length());
        int i = 0;
        while (i < s.length()) {
            char decr = s.charAt(i);
            char encr = (char)(((long)decr ^ key) & 0xFFL);
            key = ((long)encr + key) * 52895L + 22419L;
            out.write(37);
            out.write(Character.forDigit(encr >> 4, 16));
            out.write(Character.forDigit(encr & 0xF, 16));
            ++i;
        }
        return out.toString();
    }

    public static String decrypt(String s, long key) {
        if (s == null || s.length() < 1) {
            return null;
        }
        char[] buf = new char[s.length()];
        int buflen = 0;
        int i = 0;
        while (i < s.length()) {
            char ch = s.charAt(i);
            if (ch == '%') {
                try {
                    buf[buflen++] = (char)Integer.parseInt(s.substring(i + 1, i + 3), 16);
                    i += 2;
                }
                catch (NumberFormatException e) {
                    throw new InternalError("decrypt: invalid code");
                }
            } else {
                buf[buflen++] = ch;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < buflen) {
            char encr = buf[i2];
            char decr = (char)(((long)encr ^ key) & 0xFFL);
            key = ((long)encr + key) * 52895L + 22419L;
            buf[i2] = decr;
            ++i2;
        }
        return String.valueOf(buf, 0, buflen);
    }

    static {
        spaces = new String("                                            ");
    }
}

