/*
 * Decompiled with CFR 0.152.
 */
package flybase;

import flybase.ComparableVector;
import flybase.FastVector;
import java.util.Vector;

public abstract class SortVector {
    protected Vector v;
    protected FastVector fv;
    protected ComparableVector cv;

    public SortVector(Vector v, ComparableVector cv) {
        this.v = v;
        this.cv = cv;
    }

    public SortVector(FastVector v, ComparableVector cv) {
        this.fv = v;
        this.cv = cv;
    }

    public abstract void sort();

    public void setVector(Vector v, ComparableVector cv) {
        this.v = v;
        this.cv = cv;
    }

    public void setVector(FastVector v, ComparableVector cv) {
        this.fv = v;
        this.cv = cv;
    }

    protected final int size() {
        return this.fv != null ? this.fv.size() : this.v.size();
    }

    protected final int compare(int a, int b) {
        if (a < 0 || a >= this.size()) {
            return -1;
        }
        if (b < 0 || b >= this.size()) {
            return 1;
        }
        return this.cv.compareAt(a, b);
    }

    protected void swap(int a, int b) {
        if (a < 0 || a >= this.size() || b < 0 || b >= this.size()) {
            return;
        }
        if (this.fv != null) {
            Object aob = this.fv.elementAt(a);
            Object bob = this.fv.elementAt(b);
            this.fv.setElementAt(bob, a);
            this.fv.setElementAt(aob, b);
        } else {
            Object aob = this.v.elementAt(a);
            Object bob = this.v.elementAt(b);
            this.v.setElementAt(bob, a);
            this.v.setElementAt(aob, b);
        }
    }
}

