/*
 * Decompiled with CFR 0.152.
 */
package flybase;

import flybase.ComparableVector;
import flybase.Comparator;
import flybase.FastVector;
import flybase.SortVector;
import java.util.Vector;

public class QSortVector
extends SortVector {
    protected Comparator cmp;

    public QSortVector(Vector v, ComparableVector cv) {
        super(v, cv);
    }

    public QSortVector(FastVector v, ComparableVector cv) {
        super(v, cv);
    }

    public QSortVector(FastVector v, ComparableVector cv, Comparator cmp) {
        super(v, cv);
        this.cmp = cmp;
    }

    public void sort() {
        if (this.cmp != null) {
            this.quickrc(0, this.size() - 1);
        } else {
            this.quickr(0, this.size() - 1);
        }
    }

    protected void quickrc(int min, int max) {
        if (min < max) {
            int lo = min;
            int hi = max;
            while (true) {
                if (lo < hi && this.cmp.compare(lo, max) <= 0) {
                    ++lo;
                    continue;
                }
                while (hi > lo && this.cmp.compare(hi, max) >= 0) {
                    --hi;
                }
                if (lo < hi) {
                    this.swap(lo, hi);
                }
                if (lo >= hi) break;
            }
            this.swap(lo, max);
            if (lo - min < max - lo) {
                this.quickrc(min, lo - 1);
                this.quickrc(lo + 1, max);
            } else {
                this.quickrc(lo + 1, max);
                this.quickrc(min, lo - 1);
            }
        }
    }

    protected void quickr(int min, int max) {
        if (min < max) {
            int lo = min;
            int hi = max;
            while (true) {
                if (lo < hi && this.compare(lo, max) <= 0) {
                    ++lo;
                    continue;
                }
                while (hi > lo && this.compare(hi, max) >= 0) {
                    --hi;
                }
                if (lo < hi) {
                    this.swap(lo, hi);
                }
                if (lo >= hi) break;
            }
            this.swap(lo, max);
            if (lo - min < max - lo) {
                this.quickr(min, lo - 1);
                this.quickr(lo + 1, max);
            } else {
                this.quickr(lo + 1, max);
                this.quickr(min, lo - 1);
            }
        }
    }
}

