/*
 * Decompiled with CFR 0.152.
 */
package flybase;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Vector;

public class AppResources {
    public static AppResources global;
    public static String defaultRezpath;
    String lineSeparator = System.getProperty("line.separator");

    public static void main(String[] args) {
        Vector<String> data = new Vector<String>();
        String out = null;
        boolean append = false;
        String rezpath = defaultRezpath;
        if (args.length == 0) {
            args = new String[]{"help"};
        }
        int i = 0;
        while (i < args.length) {
            String arg = args[i];
            int eq = arg.indexOf(61);
            if (eq > 0) {
                String key = arg.substring(0, eq).toLowerCase();
                String val = arg.substring(eq + 1);
                if (key.startsWith("out")) {
                    out = val;
                } else if (key.startsWith("path")) {
                    rezpath = val;
                } else if (key.startsWith("append")) {
                    append = !val.equals("false");
                } else if (key.startsWith("data")) {
                    data.addElement(val);
                }
            } else if (arg.equals("help") || arg.startsWith("-h") || arg.startsWith("--h")) {
                System.out.println("Usage: java -cp app.jar flybase.AppResources [option=val] rezfile");
                System.out.println("options:");
                System.out.println("out=filename - output file");
                System.out.println("append=true - append to output");
                System.out.println("data=filename - resource file");
                System.out.println("path=/jar/path/ - resource path in jar, default=" + rezpath);
                System.exit(0);
            } else {
                data.addElement(arg);
            }
            ++i;
        }
        try {
            AppResources ar = new AppResources();
            OutputStreamWriter wtr = out == null ? new OutputStreamWriter(System.out) : new FileWriter(out, append);
            int i2 = 0;
            while (i2 < data.size()) {
                String datas = ar.getData(rezpath, (String)data.elementAt(i2));
                if (datas != null) {
                    wtr.write(datas);
                }
                ++i2;
            }
            ((Writer)wtr).close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final InputStream getStream(String rezpath, String filename) {
        return this.getStream(this.rezPath(rezpath, filename));
    }

    public InputStream getStream(String rezpath) {
        try {
            return ClassLoader.getSystemResourceAsStream(rezpath);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public final String getData(String rezpath, String filename) {
        return this.getData(this.rezPath(rezpath, filename));
    }

    /*
     * WARNING - void declaration
     */
    public String getData(String rezpath) {
        try {
            String s;
            InputStream ins = this.getStream(rezpath);
            if (ins == null) {
                return null;
            }
            BufferedReader rdr = new BufferedReader(new InputStreamReader(ins));
            StringWriter wtr = new StringWriter();
            while ((s = rdr.readLine()) != null) {
                void var5_6;
                wtr.write((String)var5_6);
                wtr.write(this.lineSeparator);
            }
            ins.close();
            wtr.close();
            return wtr.toString();
        }
        catch (Exception e) {
            System.err.println("Error loading " + rezpath + ": " + e.getMessage());
            return null;
        }
    }

    public final byte[] getBytes(String rezpath, String filename) {
        return this.getBytes(this.rezPath(rezpath, filename));
    }

    /*
     * WARNING - void declaration
     */
    public byte[] getBytes(String rezpath) {
        try {
            int b;
            InputStream ins = this.getStream(rezpath);
            if (ins == null) {
                return null;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while ((b = ins.read()) >= 0) {
                void var4_5;
                baos.write((byte)var4_5);
            }
            return baos.toByteArray();
        }
        catch (Exception e) {
            return null;
        }
    }

    public String findPath(String cname) {
        if (!this.hasResource(cname)) {
            int at = cname.lastIndexOf(47);
            if (at > 0 && this.hasResource(cname = cname.substring(at + 1))) {
                return cname;
            }
            cname = defaultRezpath + cname;
            if (!this.hasResource(cname)) {
                return null;
            }
        }
        return cname;
    }

    public final boolean hasResource(String rezpath, String filename) {
        return this.getUrl(rezpath, filename) != null;
    }

    public final boolean hasResource(String rezpath) {
        return this.getUrl(rezpath) != null;
    }

    public final URL getUrl(String rezpath, String filename) {
        return this.getUrl(this.rezPath(rezpath, filename));
    }

    public URL getUrl(String rezpath) {
        try {
            return ClassLoader.getSystemResource(rezpath);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public String rezPath(String path, String filename) {
        if (path == null || path.length() == 0) {
            return filename;
        }
        if (filename == null) {
            return path;
        }
        if ((path = path.replace('.', '/')).charAt(path.length() - 1) != '/') {
            path = path + "/";
        }
        return path + filename;
    }

    static {
        defaultRezpath = "rez/";
        global = new AppResources();
    }
}

