/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.internal;

import com.ibm.xml.framework.ChunkyCharArray;
import com.ibm.xml.framework.ParserState;
import com.ibm.xml.framework.ScanContentState;
import com.ibm.xml.framework.StringPool;
import com.ibm.xml.framework.StringProducer;
import com.ibm.xml.framework.XMLDocumentHandler;
import com.ibm.xml.framework.XMLErrorHandler;
import com.ibm.xml.framework.XMLReader;
import com.ibm.xml.framework.XMLScanner;
import java.io.InputStream;

final class UTF8Reader
extends XMLReader {
    protected static final int CHUNK_SHIFT = 14;
    protected static final int CHUNK_SIZE = 16384;
    protected static final int CHUNK_MASK = 16383;
    protected char[] fCharacters = new char[256];
    protected int fCharDataLength = 0;
    protected XMLScanner fScanner = null;
    protected StringPool fStringPool = null;
    protected XMLDocumentHandler fDocumentHandler = null;
    protected boolean fSendCharDataAsCharArray = false;
    protected XMLErrorHandler fErrorHandler = null;
    protected InputStream fInputStream = null;
    protected UTF8DataChunk fCurrentChunk = null;
    protected int fCurrentIndex = 0;
    protected byte[] fMostRecentData = null;
    protected int fMostRecentByte = 0;
    protected int fLength = 0;
    protected boolean fCheckOverflow = false;
    protected byte[] fOverflow = null;
    protected int fOverflowOffset = 0;
    protected int fOverflowEnd = 0;
    protected boolean fSkipLinefeed = false;
    protected int fPartialMultiByteIn = 0;
    protected byte[] fPartialMultiByteChar = new byte[4];
    protected boolean fPartialMultiByteResult = false;
    protected int fFastCopyCount = 0;
    protected int fOutputOffset = 0;
    protected int fPartialMultiByteOut = 0;

    UTF8Reader(ParserState parserState, String publicId, String systemId, InputStream dataStream) throws Exception {
        super(parserState, publicId, systemId);
        this.fInputStream = dataStream;
        this.fScanner = parserState.getScanner();
        this.fStringPool = parserState.cacheStringPool();
        this.fDocumentHandler = parserState.getDocumentHandler();
        this.fSendCharDataAsCharArray = this.fDocumentHandler != null && this.fDocumentHandler.sendCharDataAsCharArray();
        this.fErrorHandler = parserState.getErrorHandler();
        this.fCurrentChunk = new UTF8DataChunk(this.fStringPool, null);
        this.fillCurrentChunk();
    }

    public int addString(int offset, int length) {
        if (length == 0) {
            return 0;
        }
        return this.fCurrentChunk.addString(offset, length);
    }

    public int addSymbol(int offset, int length) {
        if (length == 0) {
            return 0;
        }
        return this.fCurrentChunk.addSymbol(offset, length, 0);
    }

    protected int addSymbol(int offset, int length, int hashcode) {
        return this.fCurrentChunk.addSymbol(offset, length, hashcode);
    }

    public void append(ChunkyCharArray charArray, int offset, int length) {
        this.fCurrentChunk.append(charArray, offset, length);
    }

    protected int slowLoadNextByte() throws Exception {
        if (this.fCurrentChunk.nextChunk() != null) {
            this.fCurrentChunk = this.fCurrentChunk.nextChunk();
            this.fCurrentIndex = 0;
            this.fMostRecentData = this.fCurrentChunk.toByteArray();
            this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
            return this.fMostRecentByte;
        }
        this.fCurrentChunk = new UTF8DataChunk(this.fStringPool, this.fCurrentChunk);
        return this.fillCurrentChunk();
    }

    protected int loadNextByte() throws Exception {
        ++this.fCurrentOffset;
        if (++this.fCurrentIndex == 16384) {
            return this.slowLoadNextByte();
        }
        this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
        return this.fMostRecentByte;
    }

    protected void checkEOF(int offset) {
        if (offset > this.fLength) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    protected void skipOneCharStartingWithByte(int b0) throws Exception {
        if ((0x80 & b0) == 0) {
            if (b0 == 0) {
                int offset = this.fCurrentOffset + 1;
                if (offset > this.fLength) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                ++this.fCharacterCounter;
                return;
            }
            if (b0 == 10) {
                ++this.fLinefeedCounter;
                this.fCharacterCounter = 1;
                return;
            }
            ++this.fCharacterCounter;
            return;
        }
        ++this.fCharacterCounter;
        this.loadNextByte();
        if ((0xE0 & b0) == 192) {
            return;
        }
        this.loadNextByte();
        if ((0xF0 & b0) == 224) {
            return;
        }
        this.loadNextByte();
    }

    public int skipOneChar() throws Exception {
        int b0 = this.fMostRecentByte;
        this.skipOneCharStartingWithByte(b0);
        this.loadNextByte();
        return this.fCurrentOffset;
    }

    public int skipAsciiChar() throws Exception {
        ++this.fCharacterCounter;
        this.loadNextByte();
        return this.fCurrentOffset;
    }

    public int skipToChar(char ch) throws Exception {
        int b0 = this.fMostRecentByte;
        while (b0 != ch) {
            this.skipOneCharStartingWithByte(b0);
            b0 = this.loadNextByte();
        }
        return this.fCurrentOffset;
    }

    public int skipPastChar(char ch) throws Exception {
        int b0 = this.fMostRecentByte;
        while (true) {
            if (b0 == ch) {
                ++this.fCharacterCounter;
                this.loadNextByte();
                return this.fCurrentOffset;
            }
            this.skipOneCharStartingWithByte(b0);
            b0 = this.loadNextByte();
        }
    }

    public boolean skippedValidChar() throws Exception {
        int b0 = this.fMostRecentByte;
        if ((0x80 & b0) == 0) {
            int offset;
            if (b0 >= 32 || b0 == 9) {
                ++this.fCharacterCounter;
                this.loadNextByte();
                return true;
            }
            if (b0 == 10) {
                ++this.fLinefeedCounter;
                this.fCharacterCounter = 1;
                this.loadNextByte();
                return true;
            }
            if (b0 == 0 && (offset = this.fCurrentOffset + 1) > this.fLength) {
                throw new ArrayIndexOutOfBoundsException();
            }
            return false;
        }
        UTF8DataChunk saveChunk = this.fCurrentChunk;
        int saveIndex = this.fCurrentIndex;
        int saveOffset = this.fCurrentOffset;
        int b1 = this.loadNextByte();
        if ((0xE0 & b0) == 192) {
            ++this.fCharacterCounter;
            this.loadNextByte();
            return true;
        }
        int b2 = this.loadNextByte();
        if ((0xF0 & b0) == 224) {
            if (!(b0 == 237 && b1 >= 160 || b0 == 239 && b1 == 191 && b2 >= 190)) {
                ++this.fCharacterCounter;
                this.loadNextByte();
                return true;
            }
            this.fCurrentChunk = saveChunk;
            this.fCurrentIndex = saveIndex;
            this.fCurrentOffset = saveOffset;
            this.fMostRecentData = saveChunk.toByteArray();
            this.fMostRecentByte = b0;
            return false;
        }
        this.loadNextByte();
        if (b0 <= 244 && (b0 != 244 || b1 < 144)) {
            ++this.fCharacterCounter;
            this.loadNextByte();
            return true;
        }
        this.fCurrentChunk = saveChunk;
        this.fCurrentIndex = saveIndex;
        this.fCurrentOffset = saveOffset;
        this.fMostRecentData = saveChunk.toByteArray();
        this.fMostRecentByte = b0;
        return false;
    }

    public boolean lookingAtValidChar() throws Exception {
        int b0 = this.fMostRecentByte;
        if ((0x80 & b0) == 0) {
            int offset;
            if (b0 >= 32 || b0 == 9 || b0 == 10) {
                return true;
            }
            if (b0 == 0 && (offset = this.fCurrentOffset + 1) > this.fLength) {
                throw new ArrayIndexOutOfBoundsException();
            }
            return false;
        }
        UTF8DataChunk saveChunk = this.fCurrentChunk;
        int saveIndex = this.fCurrentIndex;
        int saveOffset = this.fCurrentOffset;
        int b1 = this.loadNextByte();
        if ((0xE0 & b0) == 192) {
            this.fCurrentChunk = saveChunk;
            this.fCurrentIndex = saveIndex;
            this.fCurrentOffset = saveOffset;
            this.fMostRecentData = saveChunk.toByteArray();
            this.fMostRecentByte = b0;
            return true;
        }
        int b2 = this.loadNextByte();
        if ((0xF0 & b0) == 224) {
            this.fCurrentChunk = saveChunk;
            this.fCurrentIndex = saveIndex;
            this.fCurrentOffset = saveOffset;
            this.fMostRecentData = saveChunk.toByteArray();
            this.fMostRecentByte = b0;
            return (b0 == 237 && b1 >= 160 || b0 == 239 && b1 == 191 && b2 >= 190) ^ true;
        }
        this.loadNextByte();
        this.fCurrentChunk = saveChunk;
        this.fCurrentIndex = saveIndex;
        this.fCurrentOffset = saveOffset;
        this.fMostRecentData = saveChunk.toByteArray();
        this.fMostRecentByte = b0;
        return (b0 > 244 || b0 == 244 && b1 >= 144) ^ true;
    }

    public int skipInvalidChar(int errorCode) throws Exception {
        int ch;
        int b0 = this.fMostRecentByte;
        ++this.fCharacterCounter;
        if ((b0 & 0x80) == 0) {
            ch = b0;
        } else {
            int b1 = this.loadNextByte();
            if ((0xE0 & b0) == 192) {
                ch = ((0x1F & b0) << 6) + (0x3F & b1);
            } else {
                int b2 = this.loadNextByte();
                if ((0xF0 & b0) == 224) {
                    ch = ((0xF & b0) << 12) + ((0x3F & b1) << 6) + (0x3F & b2);
                } else {
                    int b3 = this.loadNextByte();
                    ch = ((0xF & b0) << 18) + ((0x3F & b1) << 12) + ((0x3F & b2) << 6) + (0x3F & b3);
                }
            }
        }
        switch (errorCode) {
            case 63: 
            case 85: {
                String arg = Integer.toHexString(ch);
                this.fErrorHandler.error1(errorCode, this.fStringPool.addString(arg));
                break;
            }
            case 80: 
            case 82: 
            case 110: {
                String arg = new Character((char)ch).toString();
                this.fErrorHandler.error1(errorCode, this.fStringPool.addString(arg));
                break;
            }
            case 43: {
                String arg1 = new Character((char)ch).toString();
                String arg2 = Integer.toHexString(ch);
                this.fErrorHandler.error2(errorCode, this.fStringPool.addString(arg1), this.fStringPool.addString(arg2));
            }
        }
        this.loadNextByte();
        return this.fCurrentOffset;
    }

    public boolean skippedChar(char ch) throws Exception {
        int b0 = this.fMostRecentByte;
        if (b0 != ch) {
            return false;
        }
        ++this.fCharacterCounter;
        ++this.fCurrentOffset;
        if (++this.fCurrentIndex == 16384) {
            this.slowLoadNextByte();
        } else {
            this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
        }
        return true;
    }

    public boolean lookingAtChar(char ch) {
        int b0 = this.fMostRecentByte;
        return b0 == ch;
    }

    public boolean skippedSpace() throws Exception {
        int ch = this.fMostRecentByte;
        if (ch > 32) {
            return false;
        }
        if (ch == 32 || ch == 9) {
            ++this.fCharacterCounter;
        } else if (ch == 10) {
            ++this.fLinefeedCounter;
            this.fCharacterCounter = 1;
        } else {
            return false;
        }
        ++this.fCurrentOffset;
        if (++this.fCurrentIndex == 16384) {
            this.slowLoadNextByte();
        } else {
            this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
        }
        return true;
    }

    public boolean lookingAtSpace() {
        int ch = this.fMostRecentByte;
        return ch == 32 || ch == 9 || ch == 10;
    }

    public int skipPastSpaces() throws Exception {
        int ch = this.fMostRecentByte;
        while (true) {
            if (ch == 32 || ch == 9) {
                ++this.fCharacterCounter;
            } else if (ch == 10) {
                ++this.fLinefeedCounter;
                this.fCharacterCounter = 1;
            } else {
                return this.fCurrentOffset;
            }
            ch = this.loadNextByte();
        }
    }

    public int skipDecimalDigit() throws Exception {
        int ch = this.fMostRecentByte;
        if (ch < 48 || ch > 57) {
            return -1;
        }
        ++this.fCharacterCounter;
        this.loadNextByte();
        return ch - 48;
    }

    public int skipHexDigit() throws Exception {
        int ch = this.fMostRecentByte;
        if (ch > 102 || XMLReader.fgAsciiXDigitChar[ch] == 0) {
            return -1;
        }
        ++this.fCharacterCounter;
        this.loadNextByte();
        return ch - (ch < 65 ? 48 : (ch < 97 ? 65 : 97) - 10);
    }

    public boolean skippedAlpha() throws Exception {
        int ch = this.fMostRecentByte;
        if (ch > 122 || XMLReader.fgAsciiAlphaChar[ch] == 0) {
            return false;
        }
        ++this.fCharacterCounter;
        this.loadNextByte();
        return true;
    }

    protected final boolean skippedAsciiCharWithFlag(byte flag) throws Exception {
        int ch = this.fMostRecentByte;
        if ((ch & 0x80) != 0 || (XMLReader.fgCharFlags[ch] & flag) == 0) {
            return false;
        }
        ++this.fCharacterCounter;
        this.loadNextByte();
        return true;
    }

    public final boolean skippedVersionNum() throws Exception {
        return this.skippedAsciiCharWithFlag((byte)1);
    }

    public final boolean skippedEncName() throws Exception {
        return this.skippedAsciiCharWithFlag((byte)2);
    }

    public final boolean skippedPubidChar() throws Exception {
        int ch = this.fMostRecentByte;
        if ((ch & 0x80) != 0) {
            return false;
        }
        if ((XMLReader.fgCharFlags[ch] & 4) != 0) {
            ++this.fCharacterCounter;
            this.loadNextByte();
            return true;
        }
        if (ch == 10) {
            ++this.fLinefeedCounter;
            this.fCharacterCounter = 1;
            this.loadNextByte();
            return true;
        }
        return false;
    }

    public boolean skippedString(char[] s) throws Exception {
        int length = s.length;
        byte[] data = this.fMostRecentData;
        int index = this.fCurrentIndex;
        if (index + length <= 16384) {
            int i = 0;
            while (i < length) {
                if (data[index++] != s[i]) {
                    return false;
                }
                ++i;
            }
            this.fCharacterCounter += length;
            this.fCurrentOffset += length;
            this.fCurrentIndex = index;
            if (index == 16384) {
                this.slowLoadNextByte();
            } else {
                this.fMostRecentByte = data[index] & 0xFF;
            }
            return true;
        }
        UTF8DataChunk dataChunk = this.fCurrentChunk;
        int offset = this.fCurrentOffset;
        int savedIndex = index;
        int i = 0;
        while (index < 16384) {
            if (data[index++] == s[i++]) continue;
            return false;
        }
        this.slowLoadNextByte();
        data = this.fMostRecentData;
        index = 0;
        while (i < length) {
            if (data[index++] == s[i++]) continue;
            this.fCurrentChunk = dataChunk;
            this.fCurrentIndex = savedIndex;
            this.fCurrentOffset = offset;
            this.fMostRecentData = dataChunk.toByteArray();
            this.fMostRecentByte = this.fMostRecentData[savedIndex] & 0xFF;
            return false;
        }
        this.fCharacterCounter += length;
        this.fCurrentOffset += length;
        this.fCurrentIndex = index;
        if (index == 16384) {
            this.slowLoadNextByte();
        } else {
            this.fMostRecentByte = data[index] & 0xFF;
        }
        return true;
    }

    public int scanName(char fastcheck, int expectedName) throws Exception {
        int hashcode;
        int b0;
        int offset;
        block21: {
            int saveIndex;
            int saveOffset;
            UTF8DataChunk saveChunk;
            block22: {
                int ch;
                offset = this.fCurrentOffset++;
                byte[] data = this.fMostRecentData;
                b0 = this.fMostRecentByte;
                if ((b0 & 0x80) == 0) {
                    if (XMLReader.fgAsciiInitialNameChar[b0] == 0) {
                        return -1;
                    }
                    ch = b0;
                } else {
                    UTF8DataChunk saveChunk2 = this.fCurrentChunk;
                    int saveIndex2 = this.fCurrentIndex++;
                    if (this.fCurrentIndex == 16384) {
                        this.fCurrentChunk = new UTF8DataChunk(this.fStringPool, this.fCurrentChunk);
                        this.fillCurrentChunk();
                        data = this.fMostRecentData;
                    }
                    int b1 = data[this.fCurrentIndex] & 0xFF;
                    if ((0xE0 & b0) == 192) {
                        ch = ((0x1F & b0) << 6) + (0x3F & b1);
                        if ((XMLReader.fgCharFlags[ch] & 0x10) == 0) {
                            this.fCurrentChunk = saveChunk2;
                            this.fCurrentIndex = saveIndex2;
                            this.fCurrentOffset = offset;
                            this.fMostRecentData = saveChunk2.toByteArray();
                            this.fMostRecentByte = b0;
                            return -1;
                        }
                    } else {
                        ++this.fCurrentOffset;
                        if (++this.fCurrentIndex == 16384) {
                            this.fCurrentChunk = new UTF8DataChunk(this.fStringPool, this.fCurrentChunk);
                            this.fillCurrentChunk();
                            data = this.fMostRecentData;
                        }
                        int b2 = data[this.fCurrentIndex] & 0xFF;
                        if ((0xF0 & b0) == 224) {
                            if (b0 == 237 && b1 >= 160 || b0 == 239 && b1 == 191 && b2 >= 190) {
                                this.fCurrentChunk = saveChunk2;
                                this.fCurrentIndex = saveIndex2;
                                this.fCurrentOffset = offset;
                                this.fMostRecentData = saveChunk2.toByteArray();
                                this.fMostRecentByte = b0;
                                return -1;
                            }
                            ch = ((0xF & b0) << 12) + ((0x3F & b1) << 6) + (0x3F & b2);
                            if ((XMLReader.fgCharFlags[ch] & 0x10) == 0) {
                                this.fCurrentChunk = saveChunk2;
                                this.fCurrentIndex = saveIndex2;
                                this.fCurrentOffset = offset;
                                this.fMostRecentData = saveChunk2.toByteArray();
                                this.fMostRecentByte = b0;
                                return -1;
                            }
                        } else {
                            this.fCurrentChunk = saveChunk2;
                            this.fCurrentIndex = saveIndex2;
                            this.fCurrentOffset = offset;
                            this.fMostRecentData = saveChunk2.toByteArray();
                            this.fMostRecentByte = b0;
                            return -1;
                        }
                    }
                }
                hashcode = 0;
                int position = 0;
                while (true) {
                    int hashcode2 = hashcode;
                    ++position;
                    int top = hashcode2 >> 24;
                    hashcode2 += hashcode2 * 37 + top + ch;
                    hashcode = hashcode2;
                    ++this.fCharacterCounter;
                    ++this.fCurrentOffset;
                    if (++this.fCurrentIndex == 16384) {
                        this.fCurrentChunk = new UTF8DataChunk(this.fStringPool, this.fCurrentChunk);
                        this.fillCurrentChunk();
                        data = this.fMostRecentData;
                    }
                    if (fastcheck == (b0 = data[this.fCurrentIndex] & 0xFF)) break block21;
                    if ((b0 & 0x80) == 0) {
                        if (XMLReader.fgAsciiNameChar[b0] != 0) {
                            ch = b0;
                            continue;
                        }
                        break block21;
                    }
                    saveChunk = this.fCurrentChunk;
                    saveOffset = this.fCurrentOffset++;
                    saveIndex = this.fCurrentIndex++;
                    if (this.fCurrentIndex == 16384) {
                        this.fCurrentChunk = new UTF8DataChunk(this.fStringPool, this.fCurrentChunk);
                        this.fillCurrentChunk();
                        data = this.fMostRecentData;
                    }
                    int b1 = data[this.fCurrentIndex] & 0xFF;
                    if ((0xE0 & b0) == 192) {
                        ch = ((0x1F & b0) << 6) + (0x3F & b1);
                        if ((XMLReader.fgCharFlags[ch] & 0x20) != 0) continue;
                        this.fCurrentChunk = saveChunk;
                        this.fCurrentIndex = saveIndex;
                        this.fCurrentOffset = saveOffset;
                        this.fMostRecentData = saveChunk.toByteArray();
                        break block21;
                    }
                    ++this.fCurrentOffset;
                    if (++this.fCurrentIndex == 16384) {
                        this.fCurrentChunk = new UTF8DataChunk(this.fStringPool, this.fCurrentChunk);
                        this.fillCurrentChunk();
                        data = this.fMostRecentData;
                    }
                    int b2 = data[this.fCurrentIndex] & 0xFF;
                    if ((0xF0 & b0) != 224) break block22;
                    if (b0 == 237 && b1 >= 160 || b0 == 239 && b1 == 191 && b2 >= 190) {
                        this.fCurrentChunk = saveChunk;
                        this.fCurrentIndex = saveIndex;
                        this.fCurrentOffset = saveOffset;
                        this.fMostRecentData = saveChunk.toByteArray();
                        break block21;
                    }
                    ch = ((0xF & b0) << 12) + ((0x3F & b1) << 6) + (0x3F & b2);
                    if ((XMLReader.fgCharFlags[ch] & 0x20) == 0) break;
                }
                this.fCurrentChunk = saveChunk;
                this.fCurrentIndex = saveIndex;
                this.fCurrentOffset = saveOffset;
                this.fMostRecentData = saveChunk.toByteArray();
                break block21;
            }
            this.fCurrentChunk = saveChunk;
            this.fCurrentIndex = saveIndex;
            this.fCurrentOffset = saveOffset;
            this.fMostRecentData = saveChunk.toByteArray();
        }
        this.fMostRecentByte = b0;
        int hashcode3 = hashcode;
        hashcode = (hashcode3 &= Integer.MAX_VALUE) == 0 ? 1 : hashcode3;
        int length = this.fCurrentOffset - offset;
        int nameIndex = this.fCurrentChunk.addSymbol(offset, length, hashcode);
        if (expectedName == -1 || expectedName == nameIndex) {
            return nameIndex;
        }
        return -1;
    }

    protected boolean skippedMultiByteCharWithFlag(int b0, int flag) throws Exception {
        UTF8DataChunk saveChunk = this.fCurrentChunk;
        int saveOffset = this.fCurrentOffset;
        int saveIndex = this.fCurrentIndex;
        int b1 = this.loadNextByte();
        if ((0xE0 & b0) == 192) {
            if ((XMLReader.fgCharFlags[((0x1F & b0) << 6) + (0x3F & b1)] & flag) == 0) {
                this.fCurrentChunk = saveChunk;
                this.fCurrentIndex = saveIndex;
                this.fCurrentOffset = saveOffset;
                this.fMostRecentData = saveChunk.toByteArray();
                this.fMostRecentByte = b0;
                return false;
            }
            return true;
        }
        int b2 = this.loadNextByte();
        if ((0xF0 & b0) == 224) {
            if (b0 == 237 && b1 >= 160 || b0 == 239 && b1 == 191 && b2 >= 190) {
                this.fCurrentChunk = saveChunk;
                this.fCurrentIndex = saveIndex;
                this.fCurrentOffset = saveOffset;
                this.fMostRecentData = saveChunk.toByteArray();
                this.fMostRecentByte = b0;
                return false;
            }
            if ((XMLReader.fgCharFlags[((0xF & b0) << 12) + ((0x3F & b1) << 6) + (0x3F & b2)] & flag) == 0) {
                this.fCurrentChunk = saveChunk;
                this.fCurrentIndex = saveIndex;
                this.fCurrentOffset = saveOffset;
                this.fMostRecentData = saveChunk.toByteArray();
                this.fMostRecentByte = b0;
                return false;
            }
            return true;
        }
        this.fCurrentChunk = saveChunk;
        this.fCurrentIndex = saveIndex;
        this.fCurrentOffset = saveOffset;
        this.fMostRecentData = saveChunk.toByteArray();
        this.fMostRecentByte = b0;
        return false;
    }

    public int skipPastName(char fastcheck) throws Exception {
        int b0 = this.fMostRecentByte;
        if ((b0 & 0x80) == 0 ? XMLReader.fgAsciiInitialNameChar[b0] == 0 : !this.skippedMultiByteCharWithFlag(b0, 16)) {
            return this.fCurrentOffset;
        }
        do {
            ++this.fCharacterCounter;
            b0 = this.loadNextByte();
            if (fastcheck != b0) continue;
            return this.fCurrentOffset;
        } while (!((b0 & 0x80) == 0 ? XMLReader.fgAsciiNameChar[b0] == 0 : !this.skippedMultiByteCharWithFlag(b0, 32)));
        return this.fCurrentOffset;
    }

    public int skipPastNmtoken(char fastcheck) throws Exception {
        int b0 = this.fMostRecentByte;
        while (fastcheck != b0) {
            if ((b0 & 0x80) == 0 ? XMLReader.fgAsciiNameChar[b0] == 0 : !this.skippedMultiByteCharWithFlag(b0, 32)) {
                return this.fCurrentOffset;
            }
            ++this.fCharacterCounter;
            b0 = this.loadNextByte();
        }
        return this.fCurrentOffset;
    }

    /*
     * Unable to fully structure code
     */
    public int scanContent(ScanContentState scanState) throws Exception {
        block95: {
            this.fCurrentChunk.clearPreviousChunk();
            this.fCharDataLength = 0;
            charDataOffset = this.fCurrentOffset++;
            ch = this.fMostRecentByte;
            if ((ch & 128) != 0) break block95;
            switch (XMLReader.fgAsciiWSCharData[ch]) {
                case 0: {
                    ++this.fCharacterCounter;
                    if (++this.fCurrentIndex == 16384) {
                        this.slowLoadNextByte();
                    } else {
                        this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 255;
                    }
                    if (this.fSendCharDataAsCharArray) {
                        this.appendCharData(ch);
                    }
                    ** GOTO lbl196
                }
                case 1: {
                    ++this.fCharacterCounter;
                    ++this.fCurrentOffset;
                    if (++this.fCurrentIndex == 16384) {
                        this.slowLoadNextByte();
                    } else {
                        this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 255;
                    }
                    if (!scanState.inCDSect) {
                        return 1;
                    }
                    if (this.fSendCharDataAsCharArray) {
                        this.appendCharData(60);
                    }
                    ** GOTO lbl196
                }
                case 2: {
                    ++this.fCharacterCounter;
                    ++this.fCurrentOffset;
                    if (++this.fCurrentIndex == 16384) {
                        this.slowLoadNextByte();
                    } else {
                        this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 255;
                    }
                    if (!scanState.inCDSect) {
                        return 2;
                    }
                    if (this.fSendCharDataAsCharArray) {
                        this.appendCharData(38);
                    }
                    ** GOTO lbl196
                }
                case 3: {
                    ++this.fCharacterCounter;
                    ch = this.loadNextByte();
                    if (ch == 93) ** GOTO lbl50
                    if (this.fSendCharDataAsCharArray) {
                        this.appendCharData(93);
                    }
                    ** GOTO lbl196
lbl50:
                    // 1 sources

                    if (this.fCurrentIndex + 1 != 16384) ** GOTO lbl63
                    saveChunk = this.fCurrentChunk;
                    saveIndex = this.fCurrentIndex;
                    saveOffset = this.fCurrentOffset;
                    if (this.loadNextByte() == 62) ** GOTO lbl69
                    this.fCurrentChunk = saveChunk;
                    this.fCurrentIndex = saveIndex;
                    this.fCurrentOffset = saveOffset;
                    this.fMostRecentData = saveChunk.toByteArray();
                    this.fMostRecentByte = 93;
                    if (this.fSendCharDataAsCharArray) {
                        this.appendCharData(93);
                    }
                    ** GOTO lbl196
lbl63:
                    // 1 sources

                    if (this.fMostRecentData[this.fCurrentIndex + 1] == 62) ** GOTO lbl67
                    if (this.fSendCharDataAsCharArray) {
                        this.appendCharData(93);
                    }
                    ** GOTO lbl196
lbl67:
                    // 1 sources

                    ++this.fCurrentIndex;
                    ++this.fCurrentOffset;
lbl69:
                    // 2 sources

                    this.loadNextByte();
                    this.fCharacterCounter += 2;
                    if (scanState.inCDSect) {
                        scanState.inCDSect = false;
                        return this.scanContent(scanState);
                    }
                    return 3;
                }
                case 4: {
                    return 4;
                }
                case 5: {
                    do {
                        if (this.fSendCharDataAsCharArray) {
                            this.appendCharData(ch);
                        }
                        if (ch == 10) {
                            ++this.fLinefeedCounter;
                            this.fCharacterCounter = 1;
                        } else {
                            ++this.fCharacterCounter;
                        }
                        ++this.fCurrentOffset;
                    } while ((ch = ++this.fCurrentIndex == 16384 ? this.slowLoadNextByte() : (this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 255)) == 32 || ch == 9 || ch == 10);
                    if ((ch & 128) != 0) ** GOTO lbl181
                    switch (XMLReader.fgAsciiCharData[ch]) {
                        case 0: {
                            ++this.fCharacterCounter;
                            ++this.fCurrentOffset;
                            if (++this.fCurrentIndex == 16384) {
                                this.slowLoadNextByte();
                            } else {
                                this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 255;
                            }
                            if (this.fSendCharDataAsCharArray) {
                                this.appendCharData(ch);
                            }
                            ** GOTO lbl196
                        }
                        case 1: {
                            if (!scanState.inCDSect) {
                                if (this.fDocumentHandler != null) {
                                    this.callWSCharDataHandler(charDataOffset, this.fCurrentOffset, false);
                                }
                                ++this.fCharacterCounter;
                                this.loadNextByte();
                                return 25;
                            }
                            ++this.fCharacterCounter;
                            ++this.fCurrentOffset;
                            if (++this.fCurrentIndex == 16384) {
                                this.slowLoadNextByte();
                            } else {
                                this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 255;
                            }
                            if (this.fSendCharDataAsCharArray) {
                                this.appendCharData(ch);
                            }
                            ** GOTO lbl196
                        }
                        case 2: {
                            if (!scanState.inCDSect) {
                                if (this.fDocumentHandler != null) {
                                    this.callWSCharDataHandler(charDataOffset, this.fCurrentOffset, false);
                                }
                                ++this.fCharacterCounter;
                                this.loadNextByte();
                                return 26;
                            }
                            ++this.fCharacterCounter;
                            ++this.fCurrentOffset;
                            if (++this.fCurrentIndex == 16384) {
                                this.slowLoadNextByte();
                            } else {
                                this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 255;
                            }
                            if (this.fSendCharDataAsCharArray) {
                                this.appendCharData(ch);
                            }
                            ** GOTO lbl196
                        }
                        case 3: {
                            endOffset = this.fCurrentOffset++;
                            ch = this.loadNextByte();
                            if (ch == 93) ** GOTO lbl146
                            ++this.fCharacterCounter;
                            if (this.fSendCharDataAsCharArray) {
                                this.appendCharData(93);
                            }
                            ** GOTO lbl196
lbl146:
                            // 1 sources

                            if (this.fCurrentIndex + 1 != 16384) ** GOTO lbl160
                            saveChunk = this.fCurrentChunk;
                            saveIndex = this.fCurrentIndex;
                            saveOffset = this.fCurrentOffset;
                            if (this.loadNextByte() == 62) ** GOTO lbl166
                            this.fCurrentChunk = saveChunk;
                            this.fCurrentIndex = saveIndex;
                            this.fCurrentOffset = saveOffset;
                            this.fMostRecentData = saveChunk.toByteArray();
                            this.fMostRecentByte = 93;
                            ++this.fCharacterCounter;
                            if (this.fSendCharDataAsCharArray) {
                                this.appendCharData(93);
                            }
                            ** GOTO lbl196
lbl160:
                            // 1 sources

                            if (this.fMostRecentData[this.fCurrentIndex + 1] == 62) ** GOTO lbl165
                            ++this.fCharacterCounter;
                            if (this.fSendCharDataAsCharArray) {
                                this.appendCharData(93);
                            }
                            ** GOTO lbl196
lbl165:
                            // 1 sources

                            ++this.fCurrentIndex;
lbl166:
                            // 2 sources

                            this.loadNextByte();
                            if (this.fDocumentHandler != null) {
                                this.callWSCharDataHandler(charDataOffset, endOffset, scanState.inCDSect);
                            }
                            this.fCharacterCounter += 3;
                            if (scanState.inCDSect) {
                                scanState.inCDSect = false;
                                return this.scanContent(scanState);
                            }
                            return 27;
                        }
                        case 4: {
                            if (this.fDocumentHandler != null) {
                                this.callWSCharDataHandler(charDataOffset, this.fCurrentOffset, scanState.inCDSect);
                            }
                            return 28;
                        }
                        default: {
                            ** if (!this.fSendCharDataAsCharArray) goto lbl-1000
                        }
                    }
lbl181:
                    // 1 sources

                    if (this.fSendCharDataAsCharArray) {
                        if (!this.copyMultiByteCharData(ch)) {
                            this.callWSCharDataHandler(charDataOffset, this.fCurrentOffset, scanState.inCDSect);
                            return 28;
                        }
                    } else if (!this.skipMultiByteCharData(ch)) {
                        if (this.fDocumentHandler != null) {
                            this.callWSCharDataHandler(charDataOffset, this.fCurrentOffset, scanState.inCDSect);
                        }
                        return 28;
                    }
                    ** GOTO lbl196
                }
                default: {
                    ** if (!this.fSendCharDataAsCharArray) goto lbl-1000
                }
            }
        }
        if (!this.skipMultiByteCharData(ch)) {
            return 4;
        }
lbl196:
        // 16 sources

        if (this.fSendCharDataAsCharArray) lbl-1000:
        // 3 sources

        {
            ch = this.copyAsciiCharData();
        } else lbl-1000:
        // 3 sources

        {
            ch = this.skipAsciiCharData();
        }
        block23: while (true) {
            if ((ch & 128) == 0) {
                switch (XMLReader.fgAsciiCharData[ch]) {
                    default: {
                        continue block23;
                    }
                    case 0: {
                        ++this.fCharacterCounter;
                        if (this.fSendCharDataAsCharArray) {
                            this.appendCharData(ch);
                        }
                        ch = this.loadNextByte();
                        continue block23;
                    }
                    case 1: {
                        if (!scanState.inCDSect) {
                            if (this.fDocumentHandler != null) {
                                this.callCharDataHandler(charDataOffset, this.fCurrentOffset, false);
                            }
                            ++this.fCharacterCounter;
                            ++this.fCurrentOffset;
                            if (++this.fCurrentIndex == 16384) {
                                this.slowLoadNextByte();
                            } else {
                                this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 255;
                            }
                            return 9;
                        }
                        ++this.fCharacterCounter;
                        if (this.fSendCharDataAsCharArray) {
                            this.appendCharData(ch);
                        }
                        ch = this.loadNextByte();
                        continue block23;
                    }
                    case 2: {
                        if (!scanState.inCDSect) {
                            if (this.fDocumentHandler != null) {
                                this.callCharDataHandler(charDataOffset, this.fCurrentOffset, false);
                            }
                            ++this.fCharacterCounter;
                            ++this.fCurrentOffset;
                            if (++this.fCurrentIndex == 16384) {
                                this.slowLoadNextByte();
                            } else {
                                this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 255;
                            }
                            return 10;
                        }
                        ++this.fCharacterCounter;
                        if (this.fSendCharDataAsCharArray) {
                            this.appendCharData(ch);
                        }
                        ch = this.loadNextByte();
                        continue block23;
                    }
                    case 3: {
                        endOffset = this.fCurrentOffset++;
                        ch = this.loadNextByte();
                        if (ch != 93) {
                            ++this.fCharacterCounter;
                            if (!this.fSendCharDataAsCharArray) continue block23;
                            this.appendCharData(93);
                            continue block23;
                        }
                        if (this.fCurrentIndex + 1 == 16384) {
                            saveChunk = this.fCurrentChunk;
                            saveIndex = this.fCurrentIndex;
                            saveOffset = this.fCurrentOffset;
                            if (this.loadNextByte() != 62) {
                                this.fCurrentChunk = saveChunk;
                                this.fCurrentIndex = saveIndex;
                                this.fCurrentOffset = saveOffset;
                                this.fMostRecentData = saveChunk.toByteArray();
                                this.fMostRecentByte = 93;
                                ++this.fCharacterCounter;
                                if (!this.fSendCharDataAsCharArray) continue block23;
                                this.appendCharData(93);
                                continue block23;
                            }
                        } else {
                            if (this.fMostRecentData[this.fCurrentIndex + 1] != 62) {
                                ++this.fCharacterCounter;
                                if (!this.fSendCharDataAsCharArray) continue block23;
                                this.appendCharData(93);
                                continue block23;
                            }
                            ++this.fCurrentIndex;
                        }
                        this.loadNextByte();
                        if (this.fDocumentHandler != null) {
                            this.callCharDataHandler(charDataOffset, endOffset, scanState.inCDSect);
                        }
                        this.fCharacterCounter += 3;
                        if (scanState.inCDSect) {
                            scanState.inCDSect = false;
                            return this.scanContent(scanState);
                        }
                        return 11;
                    }
                    case 4: 
                }
                if (ch == 10) {
                    ++this.fLinefeedCounter;
                    this.fCharacterCounter = 1;
                    ch = this.loadNextByte();
                    continue;
                }
                if (this.fDocumentHandler != null) {
                    this.callCharDataHandler(charDataOffset, this.fCurrentOffset, scanState.inCDSect);
                }
                return 12;
            }
            if (this.fSendCharDataAsCharArray) {
                if (!this.copyMultiByteCharData(ch)) {
                    this.callCharDataHandler(charDataOffset, this.fCurrentOffset, scanState.inCDSect);
                    return 12;
                }
            } else if (!this.skipMultiByteCharData(ch)) {
                if (this.fDocumentHandler != null) {
                    this.callCharDataHandler(charDataOffset, this.fCurrentOffset, scanState.inCDSect);
                }
                return 12;
            }
            ch = this.fMostRecentByte;
        }
    }

    protected boolean copyMultiByteCharData(int b0) throws Exception {
        UTF8DataChunk saveChunk = this.fCurrentChunk;
        int saveOffset = this.fCurrentOffset;
        int saveIndex = this.fCurrentIndex;
        int b1 = this.loadNextByte();
        if ((0xE0 & b0) == 192) {
            int ch = ((0x1F & b0) << 6) + (0x3F & b1);
            this.appendCharData(ch);
            return true;
        }
        int b2 = this.loadNextByte();
        if ((0xF0 & b0) == 224) {
            if (b0 == 237 && b1 >= 160 || b0 == 239 && b1 == 191 && b2 >= 190) {
                this.fCurrentChunk = saveChunk;
                this.fCurrentIndex = saveIndex;
                this.fCurrentOffset = saveOffset;
                this.fMostRecentData = saveChunk.toByteArray();
                this.fMostRecentByte = b0;
                return false;
            }
            int ch = ((0xF & b0) << 12) + ((0x3F & b1) << 6) + (0x3F & b2);
            this.appendCharData(ch);
            return true;
        }
        int b3 = this.loadNextByte();
        if (b0 > 244 || b0 == 244 && b1 >= 144) {
            this.fCurrentChunk = saveChunk;
            this.fCurrentIndex = saveIndex;
            this.fCurrentOffset = saveOffset;
            this.fMostRecentData = saveChunk.toByteArray();
            this.fMostRecentByte = b0;
            return false;
        }
        int ch = ((0xF & b0) << 18) + ((0x3F & b1) << 12) + ((0x3F & b2) << 6) + (0x3F & b3);
        if (ch < 65536) {
            this.appendCharData(ch);
        } else {
            this.appendCharData((ch - 65536 >> 10) + 55296);
            this.appendCharData((ch - 65536 & 0x3FF) + 56320);
        }
        return true;
    }

    protected boolean skipMultiByteCharData(int b0) throws Exception {
        UTF8DataChunk saveChunk = this.fCurrentChunk;
        int saveOffset = this.fCurrentOffset;
        int saveIndex = this.fCurrentIndex;
        int b1 = this.loadNextByte();
        if ((0xE0 & b0) == 192) {
            return true;
        }
        int b2 = this.loadNextByte();
        if ((0xF0 & b0) == 224) {
            if (b0 == 237 && b1 >= 160 || b0 == 239 && b1 == 191 && b2 >= 190) {
                this.fCurrentChunk = saveChunk;
                this.fCurrentIndex = saveIndex;
                this.fCurrentOffset = saveOffset;
                this.fMostRecentData = saveChunk.toByteArray();
                this.fMostRecentByte = b0;
                return false;
            }
            return true;
        }
        this.loadNextByte();
        if (b0 > 244 || b0 == 244 && b1 >= 144) {
            this.fCurrentChunk = saveChunk;
            this.fCurrentIndex = saveIndex;
            this.fCurrentOffset = saveOffset;
            this.fMostRecentData = saveChunk.toByteArray();
            this.fMostRecentByte = b0;
            return false;
        }
        return true;
    }

    protected int copyAsciiCharData() throws Exception {
        int coffset = this.fCharDataLength;
        int index = this.fCurrentIndex;
        int offset = this.fCurrentOffset - index;
        while (true) {
            byte[] data = this.fMostRecentData;
            while (index < 16384) {
                int endOffset = 16384;
                int outputCapacity = this.fCharacters.length - 2 - coffset;
                int inputAvailable = 16384 - index;
                if (outputCapacity < inputAvailable) {
                    if (outputCapacity < 64) {
                        char[] newchars = new char[this.fCharacters.length * 2];
                        System.arraycopy(this.fCharacters, 0, newchars, 0, this.fCharacters.length);
                        this.fCharacters = newchars;
                        outputCapacity = this.fCharacters.length - 2 - coffset;
                        if (outputCapacity < inputAvailable) {
                            endOffset = index + outputCapacity;
                        }
                    } else {
                        endOffset = index + outputCapacity;
                    }
                }
                while (index < endOffset) {
                    int ch = data[index] & 0xFF;
                    if ((ch & 0x80) != 0) {
                        this.fCurrentOffset = offset + index;
                        this.fCurrentIndex = index;
                        this.fMostRecentByte = ch;
                        this.fCharDataLength = coffset;
                        return ch;
                    }
                    if (XMLReader.fgAsciiCharData[ch] != 0) {
                        if (ch != 10) {
                            this.fCurrentOffset = offset + index;
                            this.fCurrentIndex = index;
                            this.fMostRecentByte = ch;
                            this.fCharDataLength = coffset;
                            return ch;
                        }
                        ++this.fLinefeedCounter;
                        this.fCharacterCounter = 1;
                    } else {
                        ++this.fCharacterCounter;
                    }
                    this.fCharacters[coffset++] = (char)ch;
                    ++index;
                }
            }
            offset += index;
            this.fCurrentChunk = new UTF8DataChunk(this.fStringPool, this.fCurrentChunk);
            this.fillCurrentChunk();
            index = 0;
        }
    }

    protected int skipAsciiCharData() throws Exception {
        int index = this.fCurrentIndex;
        int offset = this.fCurrentOffset - index;
        while (true) {
            byte[] data = this.fMostRecentData;
            while (index < 16384) {
                int ch = data[index] & 0xFF;
                if ((ch & 0x80) != 0) {
                    this.fCurrentOffset = offset + index;
                    this.fCurrentIndex = index;
                    this.fMostRecentByte = ch;
                    return ch;
                }
                if (XMLReader.fgAsciiCharData[ch] != 0) {
                    if (ch != 10) {
                        this.fCurrentOffset = offset + index;
                        this.fCurrentIndex = index;
                        this.fMostRecentByte = ch;
                        return ch;
                    }
                    ++this.fLinefeedCounter;
                    this.fCharacterCounter = 1;
                } else {
                    ++this.fCharacterCounter;
                }
                ++index;
            }
            offset += index;
            this.fCurrentChunk = new UTF8DataChunk(this.fStringPool, this.fCurrentChunk);
            this.fillCurrentChunk();
            index = 0;
        }
    }

    protected void appendCharData(int ch) {
        if (this.fCharacters.length == this.fCharDataLength) {
            char[] newchars = new char[this.fCharacters.length * 2];
            System.arraycopy(this.fCharacters, 0, newchars, 0, this.fCharacters.length);
            this.fCharacters = newchars;
        }
        this.fCharacters[this.fCharDataLength++] = (char)ch;
    }

    public void callCharDataHandler(int offset, int endOffset, boolean inCDSect) throws Exception {
        if (!this.fSendCharDataAsCharArray) {
            int length = endOffset - offset;
            int stringIndex = length == 0 ? 0 : this.fCurrentChunk.addString(offset, length);
            this.fDocumentHandler.characters(stringIndex, inCDSect);
            return;
        }
        this.fDocumentHandler.characters(this.fCharacters, 0, this.fCharDataLength, inCDSect);
    }

    public void callWSCharDataHandler(int offset, int endOffset, boolean inCDSect) throws Exception {
        int contentSpecType = this.fParserState.getScanner().getCurrentContentSpecType();
        if (contentSpecType != 4) {
            this.callCharDataHandler(offset, endOffset, inCDSect);
            return;
        }
        if (!this.fSendCharDataAsCharArray) {
            int length = endOffset - offset;
            int stringIndex = length == 0 ? 0 : this.fCurrentChunk.addString(offset, length);
            this.fDocumentHandler.ignorableWhitespace(stringIndex, inCDSect);
            return;
        }
        this.fDocumentHandler.ignorableWhitespace(this.fCharacters, 0, this.fCharDataLength, inCDSect);
    }

    /*
     * Unable to fully structure code
     */
    protected int fillCurrentChunk() throws Exception {
        this.fOutputOffset = 0;
        if (this.fCheckOverflow) {
            if (this.fOverflowEnd < 16384) {
                if (this.fOverflowEnd > 0) {
                    this.fMostRecentData = new byte[1 + this.fOverflowEnd - this.fOverflowOffset];
                    this.copyNormalize(this.fOverflow, this.fOverflowOffset, this.fMostRecentData, this.fOutputOffset);
                } else {
                    this.fMostRecentData = new byte[1];
                }
                this.fMostRecentData[this.fOutputOffset] = 0;
                this.fOverflow = null;
                this.fLength += this.fOutputOffset;
                this.fCurrentIndex = 0;
                this.fCurrentChunk.setByteArray(this.fMostRecentData);
                this.fMostRecentByte = this.fMostRecentData[0];
                return this.fMostRecentByte;
            }
            this.fMostRecentData = new byte[16384];
            this.copyNormalize(this.fOverflow, this.fOverflowOffset, this.fMostRecentData, this.fOutputOffset);
            this.fCheckOverflow = false;
        } else {
            if (this.fOverflow == null) {
                this.fOverflow = new byte[16384];
            }
            this.fMostRecentData = null;
        }
        do lbl-1000:
        // 3 sources

        {
            block12: {
                this.fOverflowOffset = 0;
                this.fOverflowEnd = 0;
                capacity = 16384;
                result = 0;
                do {
                    if ((result = this.fInputStream.read(this.fOverflow, this.fOverflowEnd, capacity)) == -1) {
                        this.fInputStream.close();
                        this.fInputStream = null;
                        if (this.fMostRecentData == null) {
                            this.fMostRecentData = new byte[1 + this.fOverflowEnd];
                            this.copyNormalize(this.fOverflow, this.fOverflowOffset, this.fMostRecentData, this.fOutputOffset);
                            this.fOverflow = null;
                            this.fMostRecentData[this.fOutputOffset] = 0;
                            break;
                        }
                        alldone = this.copyNormalize(this.fOverflow, this.fOverflowOffset, this.fMostRecentData, this.fOutputOffset);
                        if (alldone) {
                            if (this.fOverflowEnd == 16384) {
                                this.fCheckOverflow = true;
                                this.fOverflowOffset = 0;
                                this.fOverflowEnd = 0;
                                break;
                            }
                            this.fOverflow = null;
                            this.fMostRecentData[this.fOutputOffset] = 0;
                            break;
                        }
                        this.fCheckOverflow = true;
                        break;
                    }
                    if (result <= 0) continue;
                    this.fOverflowEnd += result;
                    capacity -= result;
                } while (capacity > 0);
                if (result == -1) break;
                if (this.fMostRecentData == null) break block12;
                alldone = this.copyNormalize(this.fOverflow, this.fOverflowOffset, this.fMostRecentData, this.fOutputOffset);
                if (this.fOutputOffset != 16384) ** GOTO lbl-1000
                if (alldone) break;
                this.fCheckOverflow = true;
                break;
            }
            this.fMostRecentData = new byte[16384];
            this.copyNormalize(this.fOverflow, this.fOverflowOffset, this.fMostRecentData, this.fOutputOffset);
        } while (this.fOutputOffset != 16384);
        this.fLength += this.fOutputOffset;
        this.fCurrentIndex = 0;
        this.fCurrentChunk.setByteArray(this.fMostRecentData);
        this.fMostRecentByte = this.fMostRecentData[0];
        return this.fMostRecentByte;
    }

    protected boolean copyNormalize(byte[] in, int inOffset, byte[] out, int outOffset) throws Exception {
        int inEnd = this.fOverflowEnd;
        int outEnd = out.length;
        if (inOffset == inEnd) {
            return true;
        }
        byte b = in[inOffset];
        if (this.fSkipLinefeed) {
            this.fSkipLinefeed = false;
            if (b == 10) {
                if (++inOffset == inEnd) {
                    return this.exitNormalize(inOffset, outOffset, true);
                }
                b = in[inOffset];
            }
        } else if (this.fPartialMultiByteIn > 0) {
            if (!this.handlePartialMultiByteChar(b, in, inOffset, inEnd, out, outOffset, outEnd)) {
                return this.fPartialMultiByteResult;
            }
            inOffset = this.fOverflowOffset;
            outOffset = this.fOutputOffset;
            b = in[inOffset];
        }
        while (outOffset < outEnd) {
            int inCount = inEnd - inOffset;
            int outCount = outEnd - outOffset;
            if (inCount > outCount) {
                inCount = outCount;
            }
            ++inOffset;
            while (true) {
                if (b == 13 || (b & 0x80) != 0) {
                    if (b == 13) {
                        out[outOffset++] = 10;
                        if (inOffset == inEnd) {
                            this.fSkipLinefeed = true;
                            return this.exitNormalize(inOffset, outOffset, true);
                        }
                        b = in[inOffset];
                        if (b == 10) {
                            if (++inOffset == inEnd) {
                                return this.exitNormalize(inOffset, outOffset, true);
                            }
                            b = in[inOffset];
                        }
                        if (outOffset == outEnd) {
                            return this.exitNormalize(inOffset, outOffset, false);
                        }
                    } else {
                        if (!this.handleMultiByteChar(b, in, inOffset, inEnd, out, outOffset, outEnd)) {
                            return this.fPartialMultiByteResult;
                        }
                        inOffset = this.fOverflowOffset;
                        outOffset = this.fOutputOffset;
                        b = in[inOffset];
                    }
                    if ((inCount = inEnd - inOffset) > (outCount = outEnd - outOffset)) {
                        inCount = outCount;
                    }
                    ++inOffset;
                    continue;
                }
                do {
                    out[outOffset++] = b;
                } while (--inCount != 0 && (b = in[inOffset++]) != 13 && (b & 0x80) == 0);
                if (inCount == 0) break;
            }
            if (inOffset == inEnd) break;
        }
        return this.exitNormalize(inOffset, outOffset, inOffset == inEnd);
    }

    protected boolean exitNormalize(int inOffset, int outOffset, boolean result) {
        this.fOverflowOffset = inOffset;
        this.fOutputOffset = outOffset;
        return result;
    }

    protected void savePartialMultiByte(int inCount, int outCount, byte bz, byte by, byte bx, byte bw) {
        this.fPartialMultiByteIn = inCount--;
        this.fPartialMultiByteOut = outCount;
        this.fPartialMultiByteChar[inCount] = bz;
        this.fPartialMultiByteChar[--inCount] = by;
        this.fPartialMultiByteChar[--inCount] = bx;
        this.fPartialMultiByteChar[--inCount] = bw;
    }

    protected void savePartialMultiByte(int inCount, int outCount, byte bz, byte by, byte bx) {
        this.fPartialMultiByteIn = inCount--;
        this.fPartialMultiByteOut = outCount;
        this.fPartialMultiByteChar[inCount] = bz;
        this.fPartialMultiByteChar[--inCount] = by;
        this.fPartialMultiByteChar[--inCount] = bx;
    }

    protected void savePartialMultiByte(int inCount, int outCount, byte bz, byte by) {
        this.fPartialMultiByteIn = inCount--;
        this.fPartialMultiByteOut = outCount;
        this.fPartialMultiByteChar[inCount] = bz;
        this.fPartialMultiByteChar[--inCount] = by;
    }

    protected void savePartialMultiByte(int inCount, int outCount, byte bz) {
        this.fPartialMultiByteIn = inCount--;
        this.fPartialMultiByteOut = outCount;
        this.fPartialMultiByteChar[inCount] = bz;
    }

    protected boolean handleMultiByteChar(byte b, byte[] in, int inOffset, int inEnd, byte[] out, int outOffset, int outEnd) throws Exception {
        byte b1;
        if (inOffset == inEnd) {
            int inCount = 1;
            this.fPartialMultiByteIn = inCount--;
            this.fPartialMultiByteOut = 0;
            this.fPartialMultiByteChar[inCount] = b;
            this.fOverflowOffset = inOffset;
            this.fOutputOffset = outOffset;
            this.fPartialMultiByteResult = true;
            return false;
        }
        if (((b1 = in[inOffset++]) & 0xC0) != 128) {
            this.fErrorHandler.error2(57, this.fStringPool.addString(Integer.toHexString(b)), this.fStringPool.addString(Integer.toHexString(b1)));
        }
        if ((b & 0xE0) == 192) {
            out[outOffset++] = b;
            if (outOffset == outEnd) {
                this.savePartialMultiByte(2, 1, b1, b);
                boolean result = inOffset == inEnd;
                this.fOverflowOffset = inOffset;
                this.fOutputOffset = outOffset;
                this.fPartialMultiByteResult = result;
                return false;
            }
            out[outOffset++] = b1;
            if (inOffset == inEnd || outOffset == outEnd) {
                boolean result = inOffset == inEnd;
                this.fOverflowOffset = inOffset;
                this.fOutputOffset = outOffset;
                this.fPartialMultiByteResult = result;
                return false;
            }
        } else {
            byte b2;
            if (inOffset == inEnd) {
                this.savePartialMultiByte(2, 0, b1, b);
                this.fOverflowOffset = inOffset;
                this.fOutputOffset = outOffset;
                this.fPartialMultiByteResult = true;
                return false;
            }
            if (((b2 = in[inOffset++]) & 0xC0) != 128) {
                this.fErrorHandler.error3(58, this.fStringPool.addString(Integer.toHexString(b)), this.fStringPool.addString(Integer.toHexString(b1)), this.fStringPool.addString(Integer.toHexString(b2)));
            }
            if ((b & 0xF0) == 224) {
                out[outOffset++] = b;
                if (outOffset == outEnd) {
                    this.savePartialMultiByte(3, 1, b2, b1, b);
                    boolean result = inOffset == inEnd;
                    this.fOverflowOffset = inOffset;
                    this.fOutputOffset = outOffset;
                    this.fPartialMultiByteResult = result;
                    return false;
                }
                out[outOffset++] = b1;
                if (outOffset == outEnd) {
                    this.savePartialMultiByte(3, 2, b2, b1, b);
                    boolean result = inOffset == inEnd;
                    this.fOverflowOffset = inOffset;
                    this.fOutputOffset = outOffset;
                    this.fPartialMultiByteResult = result;
                    return false;
                }
                out[outOffset++] = b2;
                if (inOffset == inEnd || outOffset == outEnd) {
                    boolean result = inOffset == inEnd;
                    this.fOverflowOffset = inOffset;
                    this.fOutputOffset = outOffset;
                    this.fPartialMultiByteResult = result;
                    return false;
                }
            } else {
                byte b3;
                if ((b & 0xF8) != 240) {
                    this.fErrorHandler.error1(56, this.fStringPool.addString(Integer.toHexString(b)));
                }
                if (inOffset == inEnd) {
                    this.savePartialMultiByte(3, 0, b2, b1, b);
                    this.fOverflowOffset = inOffset;
                    this.fOutputOffset = outOffset;
                    this.fPartialMultiByteResult = true;
                    return false;
                }
                if (((b3 = in[inOffset++]) & 0xC0) != 128) {
                    this.fErrorHandler.error4(59, this.fStringPool.addString(Integer.toHexString(b)), this.fStringPool.addString(Integer.toHexString(b1)), this.fStringPool.addString(Integer.toHexString(b2)), this.fStringPool.addString(Integer.toHexString(b3)));
                }
                out[outOffset++] = b;
                if (outOffset == outEnd) {
                    this.savePartialMultiByte(4, 1, b3, b2, b1, b);
                    boolean result = inOffset == inEnd;
                    this.fOverflowOffset = inOffset;
                    this.fOutputOffset = outOffset;
                    this.fPartialMultiByteResult = result;
                    return false;
                }
                out[outOffset++] = b1;
                if (outOffset == outEnd) {
                    this.savePartialMultiByte(4, 2, b3, b2, b1, b);
                    boolean result = inOffset == inEnd;
                    this.fOverflowOffset = inOffset;
                    this.fOutputOffset = outOffset;
                    this.fPartialMultiByteResult = result;
                    return false;
                }
                out[outOffset++] = b2;
                if (outOffset == outEnd) {
                    this.savePartialMultiByte(4, 3, b3, b2, b1, b);
                    boolean result = inOffset == inEnd;
                    this.fOverflowOffset = inOffset;
                    this.fOutputOffset = outOffset;
                    this.fPartialMultiByteResult = result;
                    return false;
                }
                out[outOffset++] = b3;
                if (inOffset == inEnd || outOffset == outEnd) {
                    boolean result = inOffset == inEnd;
                    this.fOverflowOffset = inOffset;
                    this.fOutputOffset = outOffset;
                    this.fPartialMultiByteResult = result;
                    return false;
                }
            }
        }
        this.fOverflowOffset = inOffset;
        this.fOutputOffset = outOffset;
        return true;
    }

    protected boolean handlePartialMultiByteChar(byte b, byte[] in, int inOffset, int inEnd, byte[] out, int outOffset, int outEnd) throws Exception {
        if (outOffset == outEnd) {
            boolean result = inOffset == inEnd;
            this.fOverflowOffset = inOffset;
            this.fOutputOffset = outOffset;
            this.fPartialMultiByteResult = result;
            return false;
        }
        int byteIn = this.fPartialMultiByteIn;
        int byteOut = this.fPartialMultiByteOut;
        this.fPartialMultiByteIn = 0;
        this.fPartialMultiByteOut = 0;
        byte b1 = 0;
        byte b2 = 0;
        byte b3 = 0;
        byte b4 = 0;
        switch (byteIn) {
            case 1: {
                b1 = b;
                break;
            }
            case 2: {
                b2 = b;
                break;
            }
            case 3: {
                b3 = b;
                break;
            }
            case 4: {
                b4 = b;
            }
        }
        int i = byteIn;
        switch (byteIn) {
            case 4: {
                b3 = this.fPartialMultiByteChar[--i];
            }
            case 3: {
                b2 = this.fPartialMultiByteChar[--i];
            }
            case 2: {
                b1 = this.fPartialMultiByteChar[--i];
            }
            case 1: {
                b = this.fPartialMultiByteChar[--i];
            }
        }
        switch (byteIn) {
            case 1: {
                if ((b1 & 0xC0) != 128) {
                    this.fErrorHandler.error2(57, this.fStringPool.addString(Integer.toHexString(b)), this.fStringPool.addString(Integer.toHexString(b1)));
                }
            }
            case 2: {
                if ((b & 0xE0) == 192) {
                    switch (byteOut) {
                        case 0: {
                            out[outOffset++] = b;
                            if (outOffset == outEnd) {
                                int inCount = 2;
                                this.fPartialMultiByteIn = inCount--;
                                this.fPartialMultiByteOut = 1;
                                this.fPartialMultiByteChar[inCount] = b1;
                                this.fOverflowOffset = inOffset;
                                this.fOutputOffset = outOffset;
                                this.fPartialMultiByteResult = false;
                                return false;
                            }
                        }
                        case 1: {
                            out[outOffset++] = b1;
                            if (outOffset != outEnd) break;
                            this.fOverflowOffset = inOffset;
                            this.fOutputOffset = outOffset;
                            this.fPartialMultiByteResult = false;
                            return false;
                        }
                    }
                    if (byteIn >= 2 || ++inOffset != inEnd) break;
                    this.fOverflowOffset = inOffset;
                    this.fOutputOffset = outOffset;
                    this.fPartialMultiByteResult = true;
                    return false;
                }
                if (byteIn < 2) {
                    if (++inOffset == inEnd) {
                        int inCount = 2;
                        this.fPartialMultiByteIn = inCount--;
                        this.fPartialMultiByteOut = 0;
                        this.fPartialMultiByteChar[inCount] = b1;
                        this.fOverflowOffset = inOffset;
                        this.fOutputOffset = outOffset;
                        this.fPartialMultiByteResult = true;
                        return false;
                    }
                    b2 = in[inOffset];
                }
                if ((b2 & 0xC0) != 128) {
                    this.fErrorHandler.error3(58, this.fStringPool.addString(Integer.toHexString(b)), this.fStringPool.addString(Integer.toHexString(b1)), this.fStringPool.addString(Integer.toHexString(b2)));
                }
            }
            case 3: {
                if ((b & 0xF0) == 224) {
                    switch (byteOut) {
                        case 0: {
                            out[outOffset++] = b;
                            if (outOffset == outEnd) {
                                this.savePartialMultiByte(3, 1, b2, b1);
                                this.fOverflowOffset = inOffset;
                                this.fOutputOffset = outOffset;
                                this.fPartialMultiByteResult = false;
                                return false;
                            }
                        }
                        case 1: {
                            out[outOffset++] = b1;
                            if (outOffset == outEnd) {
                                this.savePartialMultiByte(3, 2, b2, b1);
                                this.fOverflowOffset = inOffset;
                                this.fOutputOffset = outOffset;
                                this.fPartialMultiByteResult = false;
                                return false;
                            }
                        }
                        case 2: {
                            out[outOffset++] = b2;
                            if (outOffset != outEnd) break;
                            this.fOverflowOffset = inOffset;
                            this.fOutputOffset = outOffset;
                            this.fPartialMultiByteResult = false;
                            return false;
                        }
                    }
                    if (byteIn >= 3 || ++inOffset != inEnd) break;
                    this.fOverflowOffset = inOffset;
                    this.fOutputOffset = outOffset;
                    this.fPartialMultiByteResult = true;
                    return false;
                }
                if (byteIn < 3) {
                    if ((b & 0xF8) != 240) {
                        this.fErrorHandler.error1(56, this.fStringPool.addString(Integer.toHexString(b)));
                    }
                    if (++inOffset == inEnd) {
                        this.savePartialMultiByte(3, 0, b2, b1);
                        this.fOverflowOffset = inOffset;
                        this.fOutputOffset = outOffset;
                        this.fPartialMultiByteResult = true;
                        return false;
                    }
                    b3 = in[inOffset];
                }
                if ((b3 & 0xC0) != 128) {
                    this.fErrorHandler.error4(59, this.fStringPool.addString(Integer.toHexString(b)), this.fStringPool.addString(Integer.toHexString(b1)), this.fStringPool.addString(Integer.toHexString(b2)), this.fStringPool.addString(Integer.toHexString(b3)));
                }
            }
            case 4: {
                switch (byteOut) {
                    case 0: {
                        out[outOffset++] = b;
                        if (outOffset == outEnd) {
                            this.savePartialMultiByte(4, 1, b3, b2, b1);
                            this.fOverflowOffset = inOffset;
                            this.fOutputOffset = outOffset;
                            this.fPartialMultiByteResult = false;
                            return false;
                        }
                    }
                    case 1: {
                        out[outOffset++] = b1;
                        if (outOffset == outEnd) {
                            this.savePartialMultiByte(4, 2, b3, b2, b1);
                            this.fOverflowOffset = inOffset;
                            this.fOutputOffset = outOffset;
                            this.fPartialMultiByteResult = false;
                            return false;
                        }
                    }
                    case 2: {
                        out[outOffset++] = b2;
                        if (outOffset == outEnd) {
                            this.savePartialMultiByte(4, 3, b3, b2, b1);
                            this.fOverflowOffset = inOffset;
                            this.fOutputOffset = outOffset;
                            this.fPartialMultiByteResult = false;
                            return false;
                        }
                    }
                    case 3: {
                        out[outOffset++] = b3;
                        if (outOffset != outEnd) break;
                        this.fOverflowOffset = inOffset;
                        this.fOutputOffset = outOffset;
                        this.fPartialMultiByteResult = false;
                        return false;
                    }
                }
                if (byteIn >= 4 || ++inOffset != inEnd) break;
                this.fOverflowOffset = inOffset;
                this.fOutputOffset = outOffset;
                this.fPartialMultiByteResult = true;
                return false;
            }
        }
        this.fOverflowOffset = inOffset;
        this.fOutputOffset = outOffset;
        return true;
    }

    protected class UTF8DataChunk
    implements StringProducer {
        protected StringPool fStringPool = null;
        protected int fChunk;
        protected byte[] fData = null;
        protected UTF8DataChunk fPreviousChunk = null;
        protected UTF8DataChunk fNextChunk = null;

        protected UTF8DataChunk(StringPool stringPool, UTF8DataChunk prev) throws Exception {
            this.fStringPool = stringPool;
            this.fChunk = prev == null ? 0 : prev.fChunk + 1;
            this.fPreviousChunk = prev;
            if (prev != null) {
                prev.fNextChunk = this;
            }
        }

        protected UTF8DataChunk(UTF8DataChunk proto) {
            this.fStringPool = proto.fStringPool;
            this.fChunk = proto.fChunk;
            this.fData = proto.fData;
            this.fPreviousChunk = null;
            this.fNextChunk = null;
        }

        public UTF8DataChunk chunkFor(int offset) {
            int firstChunk = offset >> 14;
            UTF8DataChunk dataChunk = this;
            while (firstChunk != dataChunk.fChunk) {
                dataChunk = dataChunk.fPreviousChunk;
            }
            return dataChunk;
        }

        public byte[] toByteArray() {
            return this.fData;
        }

        public void setByteArray(byte[] data) {
            this.fData = data;
        }

        public UTF8DataChunk nextChunk() {
            return this.fNextChunk;
        }

        public void clearPreviousChunk() {
            if (this.fPreviousChunk != null) {
                this.fPreviousChunk.fNextChunk = null;
                this.fPreviousChunk = null;
            }
        }

        public String toString(int offset, int length) {
            StringBuffer sb = new StringBuffer(length);
            UTF8DataChunk dataChunk = this;
            int endOffset = offset + length;
            int index = offset & 0x3FFF;
            byte[] data = this.fData;
            while (offset < endOffset) {
                int ch;
                int b0 = data[index++] & 0xFF;
                ++offset;
                if (index == 16384) {
                    dataChunk = dataChunk.fNextChunk;
                    data = dataChunk.fData;
                    index = 0;
                }
                if ((b0 & 0x80) == 0) {
                    sb.append((char)b0);
                    continue;
                }
                int b1 = data[index++] & 0xFF;
                ++offset;
                if (index == 16384) {
                    dataChunk = dataChunk.fNextChunk;
                    data = dataChunk.fData;
                    index = 0;
                }
                if ((0xE0 & b0) == 192) {
                    int ch2 = ((0x1F & b0) << 6) + (0x3F & b1);
                    sb.append((char)ch2);
                    continue;
                }
                int b2 = data[index++] & 0xFF;
                ++offset;
                if (index == 16384) {
                    dataChunk = dataChunk.fNextChunk;
                    data = dataChunk.fData;
                    index = 0;
                }
                if ((0xF0 & b0) == 224) {
                    int ch3 = ((0xF & b0) << 12) + ((0x3F & b1) << 6) + (0x3F & b2);
                    sb.append((char)ch3);
                    continue;
                }
                int b3 = data[index++] & 0xFF;
                ++offset;
                if (index == 16384) {
                    dataChunk = dataChunk.fNextChunk;
                    data = dataChunk.fData;
                    index = 0;
                }
                if ((ch = ((0xF & b0) << 18) + ((0x3F & b1) << 12) + ((0x3F & b2) << 6) + (0x3F & b3)) < 65536) {
                    sb.append((char)ch);
                    continue;
                }
                sb.append((char)((ch - 65536 >> 10) + 55296));
                sb.append((char)((ch - 65536 & 0x3FF) + 56320));
            }
            return sb.toString();
        }

        public boolean equalsString(int offset, int length, String str, int strLength) {
            UTF8DataChunk dataChunk = this;
            int endOffset = offset + length;
            int index = offset & 0x3FFF;
            byte[] data = this.fData;
            int i = 0;
            while (offset < endOffset) {
                int ch;
                if (i == strLength) {
                    return false;
                }
                int b0 = data[index++] & 0xFF;
                ++offset;
                if (index == 16384) {
                    dataChunk = dataChunk.fNextChunk;
                    data = dataChunk.fData;
                    index = 0;
                }
                if ((b0 & 0x80) == 0) {
                    if (b0 == str.charAt(i++)) continue;
                    return false;
                }
                int b1 = data[index++] & 0xFF;
                ++offset;
                if (index == 16384) {
                    dataChunk = dataChunk.fNextChunk;
                    data = dataChunk.fData;
                    index = 0;
                }
                if ((0xE0 & b0) == 192) {
                    int ch2 = ((0x1F & b0) << 6) + (0x3F & b1);
                    if (ch2 == str.charAt(i++)) continue;
                    return false;
                }
                int b2 = data[index++] & 0xFF;
                ++offset;
                if (index == 16384) {
                    dataChunk = dataChunk.fNextChunk;
                    data = dataChunk.fData;
                    index = 0;
                }
                if ((0xF0 & b0) == 224) {
                    int ch3 = ((0xF & b0) << 12) + ((0x3F & b1) << 6) + (0x3F & b2);
                    if (ch3 == str.charAt(i++)) continue;
                    return false;
                }
                int b3 = data[index++] & 0xFF;
                ++offset;
                if (index == 16384) {
                    dataChunk = dataChunk.fNextChunk;
                    data = dataChunk.fData;
                    index = 0;
                }
                if ((ch = ((0xF & b0) << 18) + ((0x3F & b1) << 12) + ((0x3F & b2) << 6) + (0x3F & b3)) < 65536) {
                    if (ch == str.charAt(i++)) continue;
                    return false;
                }
                if ((ch - 65536 >> 10) + 55296 != str.charAt(i++)) {
                    return false;
                }
                if (i == strLength) {
                    return false;
                }
                if ((ch - 65536 & 0x3FF) + 56320 == str.charAt(i++)) continue;
                return false;
            }
            return i == strLength;
        }

        protected UTF8DataChunk createClump(int lastChunk) {
            UTF8DataChunk result = new UTF8DataChunk(this);
            UTF8DataChunk nextChunk = this.fNextChunk;
            UTF8DataChunk aChunk = result;
            do {
                UTF8DataChunk next;
                aChunk.fNextChunk = next = new UTF8DataChunk(nextChunk);
                nextChunk = nextChunk.fNextChunk;
                aChunk = next;
            } while (aChunk.fChunk != lastChunk);
            return result;
        }

        public int addString(int offset, int length) {
            int chunk = offset >> 14;
            if (chunk != this.fChunk) {
                if (this.fPreviousChunk != null) {
                    return this.fPreviousChunk.addString(offset, length);
                }
                try {
                    UTF8Reader.this.fErrorHandler.error(168);
                }
                catch (Exception exception) {}
                return -1;
            }
            int lastChunk = offset + length - 1 >> 14;
            if (chunk == lastChunk) {
                return this.fStringPool.addString(this, offset & 0x3FFF, length);
            }
            return this.fStringPool.addString(this.createClump(lastChunk), offset & 0x3FFF, length);
        }

        public int addSymbol(int offset, int length, int hashcode) {
            int chunk = offset >> 14;
            if (chunk != this.fChunk) {
                if (this.fPreviousChunk != null) {
                    return this.fPreviousChunk.addSymbol(offset, length, hashcode);
                }
                try {
                    UTF8Reader.this.fErrorHandler.error(168);
                }
                catch (Exception exception) {}
                return -1;
            }
            int lastChunk = offset + length - 1 >> 14;
            if (chunk == lastChunk) {
                if (hashcode == 0) {
                    hashcode = this.getHashcode(offset, length);
                }
                return this.fStringPool.addSymbol(this, offset & 0x3FFF, length, hashcode);
            }
            if (hashcode == 0) {
                hashcode = this.getHashcode(offset, length);
            }
            return this.fStringPool.addSymbol(this.createClump(lastChunk), offset & 0x3FFF, length, hashcode);
        }

        public void append(ChunkyCharArray charArray, int offset, int length) {
            UTF8DataChunk dataChunk = this.chunkFor(offset);
            int endOffset = offset + length;
            int index = offset & 0x3FFF;
            byte[] data = this.fData;
            while (offset < endOffset) {
                int ch;
                int b0 = data[index++] & 0xFF;
                ++offset;
                if (index == 16384) {
                    dataChunk = dataChunk.fNextChunk;
                    data = dataChunk.fData;
                    index = 0;
                }
                if ((b0 & 0x80) == 0) {
                    charArray.append((char)b0);
                    continue;
                }
                int b1 = data[index++] & 0xFF;
                ++offset;
                if (index == 16384) {
                    dataChunk = dataChunk.fNextChunk;
                    data = dataChunk.fData;
                    index = 0;
                }
                if ((0xE0 & b0) == 192) {
                    int ch2 = ((0x1F & b0) << 6) + (0x3F & b1);
                    charArray.append((char)ch2);
                    continue;
                }
                int b2 = data[index++] & 0xFF;
                ++offset;
                if (index == 16384) {
                    dataChunk = dataChunk.fNextChunk;
                    data = dataChunk.fData;
                    index = 0;
                }
                if ((0xF0 & b0) == 224) {
                    int ch3 = ((0xF & b0) << 12) + ((0x3F & b1) << 6) + (0x3F & b2);
                    charArray.append((char)ch3);
                    continue;
                }
                int b3 = data[index++] & 0xFF;
                ++offset;
                if (index == 16384) {
                    dataChunk = dataChunk.fNextChunk;
                    data = dataChunk.fData;
                    index = 0;
                }
                if ((ch = ((0xF & b0) << 18) + ((0x3F & b1) << 12) + ((0x3F & b2) << 6) + (0x3F & b3)) < 65536) {
                    charArray.append((char)ch);
                    continue;
                }
                charArray.append((char)((ch - 65536 >> 10) + 55296));
                charArray.append((char)((ch - 65536 & 0x3FF) + 56320));
            }
        }

        protected int getHashcode(int offset, int length) {
            UTF8DataChunk dataChunk = this.chunkFor(offset);
            int endOffset = offset + length;
            int hashcode = 0;
            int position = 0;
            int index = offset & 0x3FFF;
            byte[] data = dataChunk.fData;
            while (offset < endOffset) {
                int hashcode2;
                int ch;
                int b0 = data[index++] & 0xFF;
                ++offset;
                if (index == 16384) {
                    dataChunk = dataChunk.fNextChunk;
                    data = dataChunk.fData;
                    index = 0;
                }
                if ((b0 & 0x80) == 0) {
                    int hashcode3 = hashcode;
                    ++position;
                    int top = hashcode3 >> 24;
                    hashcode3 += hashcode3 * 37 + top + b0;
                    hashcode = hashcode3;
                    continue;
                }
                int b1 = data[index++] & 0xFF;
                ++offset;
                if (index == 16384) {
                    dataChunk = dataChunk.fNextChunk;
                    data = dataChunk.fData;
                    index = 0;
                }
                if ((0xE0 & b0) == 192) {
                    int ch2 = ((0x1F & b0) << 6) + (0x3F & b1);
                    int hashcode4 = hashcode;
                    ++position;
                    int top = hashcode4 >> 24;
                    hashcode4 += hashcode4 * 37 + top + ch2;
                    hashcode = hashcode4;
                    continue;
                }
                int b2 = data[index++] & 0xFF;
                ++offset;
                if (index == 16384) {
                    dataChunk = dataChunk.fNextChunk;
                    data = dataChunk.fData;
                    index = 0;
                }
                if ((0xF0 & b0) == 224) {
                    int ch3 = ((0xF & b0) << 12) + ((0x3F & b1) << 6) + (0x3F & b2);
                    int hashcode5 = hashcode;
                    ++position;
                    int top = hashcode5 >> 24;
                    hashcode5 += hashcode5 * 37 + top + ch3;
                    hashcode = hashcode5;
                    continue;
                }
                int b3 = data[index++] & 0xFF;
                ++offset;
                if (index == 16384) {
                    dataChunk = dataChunk.fNextChunk;
                    data = dataChunk.fData;
                    index = 0;
                }
                if ((ch = ((0xF & b0) << 18) + ((0x3F & b1) << 12) + ((0x3F & b2) << 6) + (0x3F & b3)) < 65536) {
                    hashcode2 = hashcode;
                    ++position;
                    int top = hashcode2 >> 24;
                    hashcode2 += hashcode2 * 37 + top + ch;
                    hashcode = hashcode2;
                    continue;
                }
                hashcode2 = hashcode;
                ++position;
                int ch4 = (ch - 65536 >> 10) + 55296;
                int top = hashcode2 >> 24;
                hashcode2 += hashcode2 * 37 + top + ch4;
                hashcode2 = hashcode = hashcode2;
                ++position;
                ch4 = (ch - 65536 & 0x3FF) + 56320;
                top = hashcode2 >> 24;
                hashcode2 += hashcode2 * 37 + top + ch4;
                hashcode = hashcode2;
            }
            int hashcode6 = hashcode;
            if ((hashcode6 &= Integer.MAX_VALUE) == 0) {
                return 1;
            }
            return hashcode6;
        }
    }
}

