/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.internal;

import com.ibm.xml.framework.ChunkyByteArray;
import com.ibm.xml.framework.ChunkyCharArray;
import com.ibm.xml.framework.ParserState;
import com.ibm.xml.framework.ScanContentState;
import com.ibm.xml.framework.StringPool;
import com.ibm.xml.framework.StringProducer;
import com.ibm.xml.framework.XMLDocumentHandler;
import com.ibm.xml.framework.XMLErrorHandler;
import com.ibm.xml.framework.XMLReader;
import java.io.IOException;

final class UCSReader
extends XMLReader
implements StringProducer {
    private static final boolean DEBUG_UTF16_BIG = false;
    static final int E_UCS4B = 0;
    static final int E_UCS4L = 1;
    static final int E_UCS2B = 2;
    static final int E_UCS2L = 3;
    static final int E_UCS2B_NOBOM = 4;
    static final int E_UCS2L_NOBOM = 5;
    private ChunkyByteArray fData = null;
    private int fEncoding = -1;
    private StringPool fStringPool = null;
    private XMLDocumentHandler fDocumentHandler = null;
    private XMLErrorHandler fErrorHandler = null;
    private int fBytesPerChar = -1;
    private boolean fBigEndian = true;
    private ChunkyCharArray fStringCharArray = null;
    private static char[] fCharacters = new char[256];
    private int fCharDataLength = 0;

    UCSReader(ParserState parserState, String publicId, String systemId, ChunkyByteArray data, int encoding) throws IOException {
        super(parserState, publicId, systemId);
        this.fCurrentOffset = encoding == 2 || encoding == 3 ? 2 : 0;
        this.fData = data;
        this.fEncoding = encoding;
        this.fStringPool = parserState.cacheStringPool();
        this.fDocumentHandler = parserState.getDocumentHandler();
        this.fErrorHandler = parserState.getErrorHandler();
        this.fBytesPerChar = this.fEncoding == 0 || this.fEncoding == 1 ? 4 : 2;
        this.fBigEndian = this.fEncoding == 0 || this.fEncoding == 2 || this.fEncoding == 4;
    }

    private int getChar(int offset) {
        int b0;
        if ((b0 = this.fData.byteAt(offset++) & 0xFF) == 255 && this.fData.atEOF(offset)) {
            return -1;
        }
        int b1 = this.fData.byteAt(offset++) & 0xFF;
        if (this.fBytesPerChar == 4) {
            int b2 = this.fData.byteAt(offset++) & 0xFF;
            int b3 = this.fData.byteAt(offset++) & 0xFF;
            if (this.fBigEndian) {
                return (b0 << 24) + (b1 << 16) + (b2 << 8) + b3;
            }
            return (b3 << 24) + (b2 << 16) + (b1 << 8) + b0;
        }
        if (this.fBigEndian) {
            return (b0 << 8) + b1;
        }
        return (b1 << 8) + b0;
    }

    public int addString(int offset, int length) {
        if (length == 0) {
            return 0;
        }
        return this.fStringPool.addString(this, offset, length);
    }

    public int addSymbol(int offset, int length) {
        if (length == 0) {
            return 0;
        }
        return this.fStringPool.addSymbol(this, offset, length, this.getHashcode(offset, length));
    }

    public void append(ChunkyCharArray charArray, int offset, int length) {
        int endOffset = offset + length;
        while (offset < endOffset) {
            int ch = this.getChar(offset);
            charArray.append((char)ch);
            offset += this.fBytesPerChar;
        }
    }

    public String toString(int offset, int length) {
        if (this.fStringCharArray == null) {
            this.fStringCharArray = new ChunkyCharArray(this.fStringPool);
        }
        int newOffset = this.fStringCharArray.length();
        ChunkyCharArray charArray = this.fStringCharArray;
        int offset2 = offset;
        int endOffset = offset2 + length;
        while (offset2 < endOffset) {
            int ch = this.getChar(offset2);
            charArray.append((char)ch);
            offset2 += this.fBytesPerChar;
        }
        int newLength = this.fStringCharArray.length() - newOffset;
        int stringIndex = this.fStringCharArray.addString(newOffset, newLength);
        return this.fStringPool.toString(stringIndex);
    }

    private int getHashcode(int offset, int length) {
        int endOffset = offset + length;
        int hashcode = 0;
        int position = 0;
        while (offset < endOffset) {
            int ch = this.getChar(offset);
            int hashcode2 = hashcode;
            ++position;
            int top = hashcode2 >> 24;
            hashcode2 += hashcode2 * 37 + top + ch;
            hashcode = hashcode2;
            offset += this.fBytesPerChar;
        }
        int hashcode3 = hashcode;
        if ((hashcode3 &= Integer.MAX_VALUE) == 0) {
            return 1;
        }
        return hashcode3;
    }

    public boolean equalsString(int offset, int length, String str, int strLength) {
        int endOffset = offset + length;
        int slen = strLength;
        int i = 0;
        while (offset < endOffset) {
            if (slen-- == 0) {
                return false;
            }
            int ch = this.getChar(offset);
            if (ch != str.charAt(i++)) {
                return false;
            }
            offset += this.fBytesPerChar;
        }
        return slen == 0;
    }

    private void appendCharData(int ch) {
        if (fCharacters.length == this.fCharDataLength) {
            char[] newchars = new char[fCharacters.length * 2];
            System.arraycopy(fCharacters, 0, newchars, 0, fCharacters.length);
            fCharacters = newchars;
        }
        UCSReader.fCharacters[this.fCharDataLength++] = (char)ch;
    }

    public void callWSCharDataHandler(int offset, int length, boolean inCDSect) throws Exception {
        int endOffset = offset + length;
        while (offset < endOffset) {
            int ch = this.getChar(offset);
            this.appendCharData(ch);
            offset += this.fBytesPerChar;
        }
        if (this.fDocumentHandler.sendCharDataAsCharArray()) {
            this.fDocumentHandler.ignorableWhitespace(fCharacters, 0, this.fCharDataLength, inCDSect);
        } else {
            int stringIndex = this.fStringPool.addString(new String(fCharacters, 0, this.fCharDataLength));
            this.fDocumentHandler.ignorableWhitespace(stringIndex, inCDSect);
        }
        this.fCharDataLength = 0;
    }

    public void callCharDataHandler(int offset, int length, boolean inCDSect) throws Exception {
        int endOffset = offset + length;
        while (offset < endOffset) {
            int ch = this.getChar(offset);
            this.appendCharData(ch);
            offset += this.fBytesPerChar;
        }
        if (this.fDocumentHandler.sendCharDataAsCharArray()) {
            this.fDocumentHandler.characters(fCharacters, 0, this.fCharDataLength, inCDSect);
        } else {
            int stringIndex = this.fStringPool.addString(new String(fCharacters, 0, this.fCharDataLength));
            this.fDocumentHandler.characters(stringIndex, inCDSect);
        }
        this.fCharDataLength = 0;
    }

    public int skipOneChar() throws IOException {
        this.fCurrentOffset += this.fBytesPerChar;
        return this.fCurrentOffset;
    }

    public int skipAsciiChar() throws IOException {
        this.fCurrentOffset += this.fBytesPerChar;
        return this.fCurrentOffset;
    }

    public int skipToChar(char ch) throws IOException {
        int ch2;
        while ((ch2 = this.getChar(this.fCurrentOffset)) != ch) {
            this.fCurrentOffset += this.fBytesPerChar;
        }
        return this.fCurrentOffset;
    }

    public int skipPastChar(char ch) throws IOException {
        int ch2;
        do {
            ch2 = this.getChar(this.fCurrentOffset);
            this.fCurrentOffset += this.fBytesPerChar;
        } while (ch2 != ch);
        return this.fCurrentOffset;
    }

    public boolean skippedValidChar() throws IOException {
        int ch = this.getChar(this.fCurrentOffset);
        this.fCurrentOffset += this.fBytesPerChar;
        if (ch < 32) {
            if (ch == 9) {
                ++this.fCharacterCounter;
                return true;
            }
            if (ch == 10) {
                ++this.fLinefeedCounter;
                this.fCharacterCounter = 1;
                return true;
            }
            if (ch == 13) {
                ++this.fCarriageReturnCounter;
                this.fCharacterCounter = 1;
                return true;
            }
            --this.fCurrentOffset;
            if (ch == -1) {
                this.fData.checkEOF(this.fCurrentOffset + 1);
            }
            return false;
        }
        ++this.fCharacterCounter;
        if (ch <= 55295) {
            return true;
        }
        if (ch <= 57343) {
            ++this.fCurrentOffset;
            return true;
        }
        if (ch <= 65533) {
            return true;
        }
        --this.fCharacterCounter;
        this.fCurrentOffset -= this.fBytesPerChar;
        return false;
    }

    public boolean lookingAtValidChar() throws IOException {
        int ch = this.getChar(this.fCurrentOffset);
        if (ch < 32) {
            if (ch == -1) {
                this.fData.checkEOF(this.fCurrentOffset + 1);
            }
            return ch == 9 || ch == 10 || ch == 13;
        }
        return ch <= 55295 || ch >= 57344 && (ch <= 65533 || ch >= 65536 && ch <= 0x10FFFF);
    }

    public int skipInvalidChar(int errorCode) throws Exception {
        int ch = this.getChar(this.fCurrentOffset);
        this.fCurrentOffset += this.fBytesPerChar;
        switch (errorCode) {
            case 63: 
            case 85: {
                String arg = Integer.toHexString(ch);
                this.fErrorHandler.error1(errorCode, this.fStringPool.addString(arg));
                break;
            }
            case 80: 
            case 82: 
            case 110: {
                String arg = new Character((char)ch).toString();
                this.fErrorHandler.error1(errorCode, this.fStringPool.addString(arg));
                break;
            }
            case 43: {
                String arg1 = new Character((char)ch).toString();
                String arg2 = Integer.toHexString(ch);
                this.fErrorHandler.error2(errorCode, this.fStringPool.addString(arg1), this.fStringPool.addString(arg2));
            }
        }
        return this.fCurrentOffset;
    }

    public boolean skippedChar(char ch) throws IOException {
        int ch2 = this.getChar(this.fCurrentOffset);
        if (ch2 == ch) {
            this.fCurrentOffset += this.fBytesPerChar;
            return true;
        }
        return false;
    }

    public boolean lookingAtChar(char ch) throws IOException {
        return ch == this.getChar(this.fCurrentOffset);
    }

    public boolean skippedSpace() throws IOException {
        int ch = this.getChar(this.fCurrentOffset);
        if (ch == 32 || ch == 9 || ch == 10 || ch == 13) {
            this.fCurrentOffset += this.fBytesPerChar;
            return true;
        }
        return false;
    }

    public boolean lookingAtSpace() throws IOException {
        int ch = this.getChar(this.fCurrentOffset);
        return ch == 32 || ch == 9 || ch == 10 || ch == 13;
    }

    public int skipPastSpaces() throws IOException {
        int ch;
        while ((ch = this.getChar(this.fCurrentOffset)) == 32 || ch == 9 || ch == 10 || ch == 13) {
            this.fCurrentOffset += this.fBytesPerChar;
        }
        return this.fCurrentOffset;
    }

    public int skipDecimalDigit() throws IOException {
        int ch = this.getChar(this.fCurrentOffset);
        if (ch < 48 || ch > 57) {
            return -1;
        }
        this.fCurrentOffset += this.fBytesPerChar;
        ++this.fCharacterCounter;
        return ch - 48;
    }

    public int skipHexDigit() throws IOException {
        int ch = this.getChar(this.fCurrentOffset);
        if (ch > 102 || XMLReader.fgAsciiXDigitChar[ch] == 0) {
            return -1;
        }
        this.fCurrentOffset += this.fBytesPerChar;
        ++this.fCharacterCounter;
        return ch - (ch < 65 ? 48 : (ch < 97 ? 65 : 97) - 10);
    }

    public boolean skippedAlpha() throws IOException {
        int ch = this.getChar(this.fCurrentOffset);
        if (ch <= 122 && XMLReader.fgAsciiAlphaChar[ch] == 1) {
            this.fCurrentOffset += this.fBytesPerChar;
            ++this.fCharacterCounter;
            return true;
        }
        return false;
    }

    private boolean skippedCharWithFlag(byte flag) {
        int ch = this.getChar(this.fCurrentOffset);
        if (ch < 128 && (XMLReader.fgCharFlags[ch] & flag) != 0) {
            this.fCurrentOffset += this.fBytesPerChar;
            ++this.fCharacterCounter;
            return true;
        }
        return false;
    }

    public final boolean skippedVersionNum() {
        return this.skippedCharWithFlag((byte)1);
    }

    public final boolean skippedEncName() {
        return this.skippedCharWithFlag((byte)2);
    }

    public final boolean skippedPubidChar() {
        int ch = this.getChar(this.fCurrentOffset);
        if (ch < 128) {
            if ((XMLReader.fgCharFlags[ch] & 4) != 0) {
                this.fCurrentOffset += this.fBytesPerChar;
                ++this.fCharacterCounter;
                return true;
            }
            if (ch == 10) {
                this.fCurrentOffset += this.fBytesPerChar;
                ++this.fLinefeedCounter;
                this.fCharacterCounter = 1;
                return true;
            }
            if (ch == 13) {
                this.fCurrentOffset += this.fBytesPerChar;
                ++this.fCarriageReturnCounter;
                this.fCharacterCounter = 1;
                return true;
            }
        }
        return false;
    }

    public boolean skippedString(char[] s) throws IOException {
        int offset = this.fCurrentOffset;
        int i = 0;
        while (i < s.length) {
            if (this.getChar(offset) != s[i]) {
                return false;
            }
            offset += this.fBytesPerChar;
            ++i;
        }
        this.fCurrentOffset = offset;
        this.fCharacterCounter += s.length;
        return true;
    }

    public int scanName(char fastcheck, int expectedName) throws IOException {
        int nameIndex;
        int nameOffset = this.fCurrentOffset;
        int nameLength = this.skipPastName(fastcheck) - nameOffset;
        if (nameLength == 0) {
            return -1;
        }
        int n = nameIndex = nameLength == 0 ? 0 : this.fStringPool.addSymbol(this, nameOffset, nameLength, this.getHashcode(nameOffset, nameLength));
        if (expectedName == -1 || expectedName == nameIndex) {
            return nameIndex;
        }
        return -1;
    }

    public int skipPastName(char fastcheck) throws IOException {
        int ch = this.getChar(this.fCurrentOffset);
        if ((XMLReader.fgCharFlags[ch] & 0x10) == 0) {
            return this.fCurrentOffset;
        }
        do {
            this.fCurrentOffset += this.fBytesPerChar;
            ++this.fCharacterCounter;
            ch = this.getChar(this.fCurrentOffset);
            if (fastcheck != ch) continue;
            return this.fCurrentOffset;
        } while ((XMLReader.fgCharFlags[ch] & 0x20) != 0);
        return this.fCurrentOffset;
    }

    public int skipPastNmtoken(char fastcheck) throws IOException {
        int ch = this.getChar(this.fCurrentOffset);
        while (fastcheck != ch) {
            if ((XMLReader.fgCharFlags[ch] & 0x20) == 0) {
                return this.fCurrentOffset;
            }
            this.fCurrentOffset += this.fBytesPerChar;
            ++this.fCharacterCounter;
            ch = this.getChar(this.fCurrentOffset);
        }
        return this.fCurrentOffset;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int scanContent(ScanContentState scanState) throws Exception {
        byte prop;
        int ch;
        int offset;
        block52: {
            block56: {
                block54: {
                    block55: {
                        offset = this.fCurrentOffset;
                        ch = this.getChar(this.fCurrentOffset);
                        this.fCurrentOffset += this.fBytesPerChar;
                        if (ch >= 128) break block54;
                        if (ch == -1) {
                            this.fCurrentOffset -= this.fBytesPerChar;
                            return 4;
                        }
                        prop = XMLReader.fgCharFlags[ch];
                        if ((prop & 8) != 0 || ch == 10 || ch == 13) break block55;
                        if (ch == 60) {
                            ++this.fCharacterCounter;
                            return 1;
                        }
                        if (ch == 38) {
                            ++this.fCharacterCounter;
                            return 2;
                        }
                        if (ch != 93) {
                            this.fCurrentOffset -= this.fBytesPerChar;
                            return 4;
                        }
                        if (this.getChar(this.fCurrentOffset) == 93 && this.getChar(this.fCurrentOffset + this.fBytesPerChar) == 62) {
                            this.fCharacterCounter += 3;
                            this.fCurrentOffset += 2 * this.fBytesPerChar;
                            return 3;
                        }
                        break block52;
                    }
                    if (ch != 32 && ch != 9 && ch != 10 && ch != 13) break block52;
                    break block56;
                }
                if (ch >= 55296 && ch <= 57343) {
                    this.fCurrentOffset += this.fBytesPerChar;
                    break block52;
                } else if (ch == 65534 || ch == 65535) {
                    this.fCurrentOffset -= this.fBytesPerChar;
                    return 4;
                }
                break block52;
            }
            do {
                if (ch == 10) {
                    ++this.fLinefeedCounter;
                    this.fCharacterCounter = 1;
                } else if (ch == 13) {
                    ++this.fCarriageReturnCounter;
                    this.fCharacterCounter = 1;
                } else {
                    ++this.fCharacterCounter;
                }
                ch = this.getChar(this.fCurrentOffset);
                this.fCurrentOffset += this.fBytesPerChar;
            } while (ch == 32 || ch == 9 || ch == 10 || ch == 13);
            if (ch < 128) {
                if (ch == -1) {
                    this.fCurrentOffset -= this.fBytesPerChar;
                    if (this.fDocumentHandler != null) {
                        this.callWSCharDataHandler(offset, this.fCurrentOffset - offset, scanState.inCDSect);
                    }
                    return 28;
                }
                prop = XMLReader.fgCharFlags[ch];
                if ((prop & 8) == 0) {
                    if (ch == 60) {
                        ++this.fCharacterCounter;
                        if (this.fDocumentHandler != null) {
                            this.callWSCharDataHandler(offset, this.fCurrentOffset - this.fBytesPerChar - offset, scanState.inCDSect);
                        }
                        return 25;
                    }
                    if (ch == 38) {
                        ++this.fCharacterCounter;
                        if (this.fDocumentHandler != null) {
                            this.callWSCharDataHandler(offset, this.fCurrentOffset - this.fBytesPerChar - offset, scanState.inCDSect);
                        }
                        return 26;
                    }
                    if (ch == 93) {
                        if (this.getChar(this.fCurrentOffset) == 93 && this.getChar(this.fCurrentOffset + this.fBytesPerChar) == 62) {
                            if (this.fDocumentHandler != null) {
                                this.callWSCharDataHandler(offset, this.fCurrentOffset - this.fBytesPerChar - offset, scanState.inCDSect);
                            }
                            this.fCharacterCounter += 3;
                            this.fCurrentOffset += 2 * this.fBytesPerChar;
                            return 27;
                        }
                    } else {
                        this.fCurrentOffset -= this.fBytesPerChar;
                        if (this.fDocumentHandler != null) {
                            this.callWSCharDataHandler(offset, this.fCurrentOffset - offset, scanState.inCDSect);
                        }
                        return 28;
                    }
                }
            } else if (ch >= 55296 && ch <= 57343) {
                this.fCurrentOffset += this.fBytesPerChar;
            } else if (ch == 65534 || ch == 65535) {
                this.fCurrentOffset -= this.fBytesPerChar;
                if (this.fDocumentHandler != null) {
                    this.callWSCharDataHandler(offset, this.fCurrentOffset - offset, scanState.inCDSect);
                }
                return 28;
            }
        }
        ++this.fCharacterCounter;
        while (true) {
            ch = this.getChar(this.fCurrentOffset);
            this.fCurrentOffset += this.fBytesPerChar;
            if (ch >= 128 || ch < 0) break;
            prop = XMLReader.fgCharFlags[ch];
            if ((prop & 8) == 0) {
                if (ch == 10) {
                    ++this.fLinefeedCounter;
                    this.fCharacterCounter = 1;
                    continue;
                }
                if (ch != 13) break;
                ++this.fCarriageReturnCounter;
                this.fCharacterCounter = 1;
                continue;
            }
            ++this.fCharacterCounter;
        }
        while (true) {
            block53: {
                block57: {
                    block58: {
                        block59: {
                            if (ch >= 128) break block57;
                            if (ch == -1) {
                                this.fCurrentOffset -= this.fBytesPerChar;
                                if (this.fDocumentHandler != null) {
                                    this.callCharDataHandler(offset, this.fCurrentOffset - offset, scanState.inCDSect);
                                }
                                return 12;
                            }
                            prop = XMLReader.fgCharFlags[ch];
                            if ((prop & 8) != 0) break block58;
                            if (ch == 60) {
                                ++this.fCharacterCounter;
                                if (this.fDocumentHandler != null) {
                                    this.callCharDataHandler(offset, this.fCurrentOffset - this.fBytesPerChar - offset, scanState.inCDSect);
                                }
                                return 9;
                            }
                            if (ch == 38) {
                                ++this.fCharacterCounter;
                                if (this.fDocumentHandler != null) {
                                    this.callCharDataHandler(offset, this.fCurrentOffset - this.fBytesPerChar - offset, scanState.inCDSect);
                                }
                                return 10;
                            }
                            if (ch != 10) break block59;
                            ++this.fLinefeedCounter;
                            this.fCharacterCounter = 1;
                            break block53;
                        }
                        if (ch == 13) {
                            ++this.fCarriageReturnCounter;
                            this.fCharacterCounter = 1;
                            break block53;
                        } else if (ch == 93) {
                            if (this.getChar(this.fCurrentOffset) == 93 && this.getChar(this.fCurrentOffset + this.fBytesPerChar) == 62) {
                                if (this.fDocumentHandler != null) {
                                    this.callCharDataHandler(offset, this.fCurrentOffset - this.fBytesPerChar - offset, scanState.inCDSect);
                                }
                                this.fCharacterCounter += 3;
                                this.fCurrentOffset += 2 * this.fBytesPerChar;
                                return 11;
                            }
                            ++this.fCharacterCounter;
                            break block53;
                        } else {
                            this.fCurrentOffset -= this.fBytesPerChar;
                            if (this.fDocumentHandler != null) {
                                this.callCharDataHandler(offset, this.fCurrentOffset - offset, scanState.inCDSect);
                            }
                            return 12;
                        }
                    }
                    ++this.fCharacterCounter;
                    break block53;
                }
                if (ch >= 55296 && ch <= 57343) {
                    ++this.fCharacterCounter;
                    this.fCurrentOffset += this.fBytesPerChar;
                } else if (ch == 65534 || ch == 65535) {
                    this.fCurrentOffset -= this.fBytesPerChar;
                    if (this.fDocumentHandler != null) {
                        this.callCharDataHandler(offset, this.fCurrentOffset - offset, scanState.inCDSect);
                    }
                    return 12;
                }
                ++this.fCharacterCounter;
            }
            ch = this.getChar(this.fCurrentOffset);
            this.fCurrentOffset += this.fBytesPerChar;
        }
    }
}

