/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.internal;

import com.ibm.xml.framework.ContentModel;
import com.ibm.xml.framework.ContentSpecNode;
import com.ibm.xml.framework.ElementDeclPool;
import com.ibm.xml.framework.InsertableElementsInfo;
import com.ibm.xml.internal.CMException;

class MixedContentModel
implements ContentModel {
    private int fCount = 0;
    private int[] fChildren;

    public MixedContentModel(ElementDeclPool declPool, int elementIndex) throws CMException {
        int listSize = 64;
        int[] tmpList = new int[listSize];
        ContentSpecNode nodeTmp = new ContentSpecNode();
        while (true) {
            try {
                this.fCount = this.buildContentList(declPool.getContentSpec(elementIndex), tmpList, 0, nodeTmp, declPool);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                tmpList = new int[listSize *= 2];
                this.fCount = 0;
                continue;
            }
            break;
        }
        this.fChildren = new int[this.fCount];
        int index = 0;
        while (index < this.fCount) {
            this.fChildren[index] = tmpList[index];
            ++index;
        }
    }

    public int validateContent(int childCount, int[] children) throws Exception {
        int outIndex = 0;
        while (outIndex < childCount) {
            int curChild = children[outIndex];
            if (curChild != -1) {
                int inIndex = 0;
                while (inIndex < this.fCount) {
                    if (curChild == this.fChildren[inIndex]) break;
                    ++inIndex;
                }
                if (inIndex == this.fCount) {
                    return outIndex;
                }
            }
            ++outIndex;
        }
        return -1;
    }

    public int whatCanGoHere(boolean fullyValid, InsertableElementsInfo info) throws Exception {
        int index = info.insertAt;
        while (index < info.childCount) {
            info.curChildren[index] = info.curChildren[index + 1];
            ++index;
        }
        --info.childCount;
        int failedIndex = this.validateContent(info.childCount, info.curChildren);
        if (failedIndex != -1 && failedIndex < info.insertAt) {
            return failedIndex;
        }
        info.canHoldPCData = true;
        info.isValidEOC = true;
        info.resultsCount = this.fCount;
        if (info.results == null || info.results.length < info.resultsCount) {
            info.results = new boolean[info.resultsCount];
        }
        if (info.possibleChildren == null || info.possibleChildren.length < info.resultsCount) {
            info.possibleChildren = new int[info.resultsCount];
        }
        boolean bStatus = true;
        if (fullyValid && failedIndex < info.childCount) {
            bStatus = false;
        }
        int index2 = 0;
        while (index2 < this.fCount) {
            info.possibleChildren[index2] = this.fChildren[index2];
            info.results[index2] = bStatus;
            ++index2;
        }
        return -1;
    }

    private final int buildContentList(int startNode, int[] list, int count, ContentSpecNode specNode, ElementDeclPool declPool) throws CMException {
        declPool.getContentSpecNode(startNode, specNode);
        if (specNode.type == 0) {
            list[count++] = specNode.value;
            return count;
        }
        int leftNode = specNode.value;
        int rightNode = specNode.otherValue;
        if (specNode.type == 4 || specNode.type == 5) {
            count = this.buildContentList(leftNode, list, count, specNode, declPool);
            count = this.buildContentList(rightNode, list, count, specNode, declPool);
        } else if (specNode.type == 1 || specNode.type == 2 || specNode.type == 3) {
            count = this.buildContentList(leftNode, list, count, specNode, declPool);
        } else {
            throw new CMException(152);
        }
        return count;
    }
}

