/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.internal;

import com.ibm.xml.framework.AttDef;
import com.ibm.xml.framework.Attr;
import com.ibm.xml.framework.AttrPool;
import com.ibm.xml.framework.ContentModel;
import com.ibm.xml.framework.ContentSpecNode;
import com.ibm.xml.framework.ElementDecl;
import com.ibm.xml.framework.ElementDeclPool;
import com.ibm.xml.framework.ParserState;
import com.ibm.xml.framework.StringPool;
import com.ibm.xml.framework.XMLErrorHandler;
import com.ibm.xml.framework.XMLValidationHandler;
import java.util.Enumeration;
import java.util.Hashtable;

public final class DefaultElementDeclPool
implements ElementDeclPool {
    private static final int CHUNK_SHIFT = 5;
    private static final int CHUNK_SIZE = 32;
    private static final int CHUNK_MASK = 31;
    private static final int INITIAL_CHUNK_COUNT = 32;
    private ParserState fParserState = null;
    private StringPool fStringPool = null;
    private AttrPool fAttrPool = null;
    private XMLErrorHandler fErrorHandler = null;
    private XMLValidationHandler fValidationHandler;
    private int fRootElement = -1;
    private Attr fAttr = new Attr();
    private int fElementCount = 0;
    private int[][] fElementName = new int[32][];
    private byte[][] fContentSpecType = new byte[32][];
    private int[][] fContentSpec = new int[32][];
    private ContentModel[][] fContentModel = new ContentModel[32][];
    private int[][] fAttlistHead = new int[32][];
    private int[][] fAttlistTail = new int[32][];
    private int fNodeCount = 0;
    private byte[][] fNodeType = new byte[32][];
    private int[][] fNodeValue = new int[32][];
    private int fAttDefCount = 0;
    private int[][] fAttName = new int[32][];
    private byte[][] fAttType = new byte[32][];
    private int[][] fEnumeration = new int[32][];
    private byte[][] fAttDefaultType = new byte[32][];
    private int[][] fAttValue = new int[32][];
    private int[][] fNextAttDef = new int[32][];
    private static final int INITIAL_BUCKET_SIZE = 4;
    private static final int HASHTABLE_SIZE = 128;
    private int[][] fElementNameHashtable = new int[128][];
    private int fXMLSpace = -1;
    private int fDefault = -1;
    private int fPreserve = -1;
    private Hashtable fIdDefs = null;
    private Hashtable fIdRefs = null;
    private Object fNullValue = null;
    private int[] localpartcache = new int[8];
    private int[] nsnamecache = new int[8];

    public DefaultElementDeclPool(ParserState parserState) {
        this.fParserState = parserState;
        this.fStringPool = parserState.cacheStringPool();
        this.fAttrPool = parserState.cacheAttrPool();
        this.fErrorHandler = parserState.getErrorHandler();
        this.fValidationHandler = parserState.getValidationHandler();
    }

    public void reset(ParserState parserState) {
        this.fParserState = parserState;
        this.fStringPool = parserState.cacheStringPool();
        this.fAttrPool = parserState.cacheAttrPool();
        this.fErrorHandler = parserState.getErrorHandler();
        this.fValidationHandler = parserState.getValidationHandler();
        int chunk = 0;
        int index = 0;
        int i = 0;
        while (i < this.fElementCount) {
            this.fContentModel[chunk][index] = null;
            if (++index == 32) {
                ++chunk;
                index = 0;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < 128) {
            this.fElementNameHashtable[i2] = null;
            ++i2;
        }
        this.fRootElement = -1;
        this.fElementCount = 0;
        this.fNodeCount = 0;
        this.fAttDefCount = 0;
        this.fXMLSpace = -1;
        this.fDefault = -1;
        this.fPreserve = -1;
        if (this.fIdDefs != null) {
            this.fIdDefs.clear();
        }
        if (this.fIdRefs != null) {
            this.fIdRefs.clear();
        }
    }

    public ElementDeclPool resetOrCopy(ParserState parserState) {
        return new DefaultElementDeclPool(parserState);
    }

    public void setRootElement(int elementIndex) {
        this.fRootElement = elementIndex;
    }

    public int getRootElement() {
        return this.fRootElement;
    }

    private boolean ensureElementCapacity(int chunk) {
        try {
            return this.fElementName[chunk][0] == 0;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            byte[][] newByteArray = new byte[chunk * 2][];
            System.arraycopy(this.fContentSpecType, 0, newByteArray, 0, chunk);
            this.fContentSpecType = newByteArray;
            int[][] newIntArray = new int[chunk * 2][];
            System.arraycopy(this.fElementName, 0, newIntArray, 0, chunk);
            this.fElementName = newIntArray;
            newIntArray = new int[chunk * 2][];
            System.arraycopy(this.fContentSpec, 0, newIntArray, 0, chunk);
            this.fContentSpec = newIntArray;
            ContentModel[][] newContentModel = new ContentModel[chunk * 2][];
            System.arraycopy(this.fContentModel, 0, newContentModel, 0, chunk);
            this.fContentModel = newContentModel;
            newIntArray = new int[chunk * 2][];
            System.arraycopy(this.fAttlistHead, 0, newIntArray, 0, chunk);
            this.fAttlistHead = newIntArray;
            newIntArray = new int[chunk * 2][];
            System.arraycopy(this.fAttlistTail, 0, newIntArray, 0, chunk);
            this.fAttlistTail = newIntArray;
        }
        catch (NullPointerException nullPointerException) {}
        this.fElementName[chunk] = new int[32];
        this.fContentSpecType[chunk] = new byte[32];
        this.fContentSpec[chunk] = new int[32];
        this.fContentModel[chunk] = new ContentModel[32];
        this.fAttlistHead[chunk] = new int[32];
        this.fAttlistTail[chunk] = new int[32];
        return true;
    }

    public int getElement(int elementNameIndex) {
        int hc = elementNameIndex % 128;
        int[] bucket = this.fElementNameHashtable[hc];
        if (bucket != null) {
            int j = 1;
            int i = 0;
            while (i < bucket[0]) {
                if (bucket[j] == elementNameIndex) {
                    return bucket[j + 1];
                }
                j += 2;
                ++i;
            }
        }
        return -1;
    }

    public int addElement(int elementNameIndex) {
        int hc = elementNameIndex % 128;
        int[] bucket = this.fElementNameHashtable[hc];
        if (bucket != null) {
            int j = 1;
            int i = 0;
            while (i < bucket[0]) {
                if (bucket[j] == elementNameIndex) {
                    return bucket[j + 1];
                }
                j += 2;
                ++i;
            }
        }
        int chunk = this.fElementCount >> 5;
        int index = this.fElementCount & 0x1F;
        this.ensureElementCapacity(chunk);
        this.fElementName[chunk][index] = elementNameIndex;
        this.fContentSpecType[chunk][index] = 0;
        this.fContentSpec[chunk][index] = -1;
        this.fContentModel[chunk][index] = null;
        this.fAttlistHead[chunk][index] = -1;
        this.fAttlistTail[chunk][index] = -1;
        if (bucket == null) {
            bucket = new int[9];
            bucket[0] = 1;
            bucket[1] = elementNameIndex;
            bucket[2] = this.fElementCount;
            this.fElementNameHashtable[hc] = bucket;
        } else {
            int count = bucket[0];
            int offset = 1 + count * 2;
            if (offset == bucket.length) {
                int newSize = count + 4;
                int[] newBucket = new int[1 + newSize * 2];
                System.arraycopy(bucket, 0, newBucket, 0, offset);
                bucket = newBucket;
                this.fElementNameHashtable[hc] = bucket;
            }
            bucket[offset++] = elementNameIndex;
            bucket[offset++] = this.fElementCount;
            bucket[0] = ++count;
        }
        return this.fElementCount++;
    }

    public int addElementDecl(ElementDecl decl) {
        int elementNameIndex = decl.elementName;
        int hc = elementNameIndex % 128;
        int[] bucket = this.fElementNameHashtable[hc];
        if (bucket != null) {
            int j = 1;
            int i = 0;
            while (i < bucket[0]) {
                if (bucket[j] == elementNameIndex) {
                    int elementIndex = bucket[j + 1];
                    int chunk = elementIndex >> 5;
                    int index = elementIndex & 0x1F;
                    if (this.fContentSpecType[chunk][index] != 0) {
                        return -1;
                    }
                    this.fContentSpecType[chunk][index] = (byte)decl.contentSpecType;
                    this.fContentSpec[chunk][index] = decl.contentSpec;
                    this.fContentModel[chunk][index] = null;
                    return elementIndex;
                }
                j += 2;
                ++i;
            }
        }
        int chunk = this.fElementCount >> 5;
        int index = this.fElementCount & 0x1F;
        this.ensureElementCapacity(chunk);
        this.fElementName[chunk][index] = decl.elementName;
        this.fContentSpecType[chunk][index] = (byte)decl.contentSpecType;
        this.fContentSpec[chunk][index] = decl.contentSpec;
        this.fContentModel[chunk][index] = null;
        this.fAttlistHead[chunk][index] = -1;
        this.fAttlistTail[chunk][index] = -1;
        if (bucket == null) {
            bucket = new int[9];
            bucket[0] = 1;
            bucket[1] = elementNameIndex;
            bucket[2] = this.fElementCount;
            this.fElementNameHashtable[hc] = bucket;
        } else {
            int count = bucket[0];
            int offset = 1 + count * 2;
            if (offset == bucket.length) {
                int newSize = count + 4;
                int[] newBucket = new int[1 + newSize * 2];
                System.arraycopy(bucket, 0, newBucket, 0, offset);
                bucket = newBucket;
                this.fElementNameHashtable[hc] = bucket;
            }
            bucket[offset++] = elementNameIndex;
            bucket[offset++] = this.fElementCount;
            bucket[0] = ++count;
        }
        return this.fElementCount++;
    }

    public int getElementName(int elementIndex) {
        if (elementIndex < 0 || elementIndex >= this.fElementCount) {
            return -1;
        }
        int chunk = elementIndex >> 5;
        int index = elementIndex & 0x1F;
        return this.fElementName[chunk][index];
    }

    public int getContentSpecType(int elementIndex) {
        if (elementIndex < 0 || elementIndex >= this.fElementCount) {
            return -1;
        }
        int chunk = elementIndex >> 5;
        int index = elementIndex & 0x1F;
        return this.fContentSpecType[chunk][index];
    }

    public int getContentSpec(int elementIndex) {
        if (elementIndex < 0 || elementIndex >= this.fElementCount) {
            return -1;
        }
        int chunk = elementIndex >> 5;
        int index = elementIndex & 0x1F;
        return this.fContentSpec[chunk][index];
    }

    public String getContentSpecAsString(int elementIndex) {
        if (elementIndex < 0 || elementIndex >= this.fElementCount) {
            return null;
        }
        int chunk = elementIndex >> 5;
        int index = elementIndex & 0x1F;
        switch (this.fContentSpecType[chunk][index]) {
            case 1: {
                return "EMPTY";
            }
            case 2: {
                return "ANY";
            }
            case 3: 
            case 4: {
                return this.getContentSpecNodeAsString(this.fContentSpec[chunk][index]);
            }
        }
        return null;
    }

    public ContentModel getContentModel(int elementIndex) {
        if (elementIndex < 0 || elementIndex >= this.fElementCount) {
            return null;
        }
        int chunk = elementIndex >> 5;
        int index = elementIndex & 0x1F;
        return this.fContentModel[chunk][index];
    }

    public void setContentModel(int elementIndex, ContentModel cm) {
        if (elementIndex < 0 || elementIndex >= this.fElementCount) {
            return;
        }
        int chunk = elementIndex >> 5;
        int index = elementIndex & 0x1F;
        this.fContentModel[chunk][index] = cm;
    }

    private boolean ensureNodeCapacity(int chunk) {
        try {
            return this.fNodeType[chunk][0] == 0;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            byte[][] newByteArray = new byte[chunk * 2][];
            System.arraycopy(this.fNodeType, 0, newByteArray, 0, chunk);
            this.fNodeType = newByteArray;
            int[][] newIntArray = new int[chunk * 2][];
            System.arraycopy(this.fNodeValue, 0, newIntArray, 0, chunk);
            this.fNodeValue = newIntArray;
        }
        catch (NullPointerException nullPointerException) {}
        this.fNodeType[chunk] = new byte[32];
        this.fNodeValue[chunk] = new int[32];
        return true;
    }

    public int addContentSpecNode(ContentSpecNode csn) {
        int chunk = this.fNodeCount >> 5;
        int index = this.fNodeCount & 0x1F;
        this.ensureNodeCapacity(chunk);
        switch (csn.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.fNodeType[chunk][index] = (byte)csn.type;
                this.fNodeValue[chunk][index] = csn.value;
                return this.fNodeCount++;
            }
            case 4: 
            case 5: {
                this.fNodeType[chunk][index] = (byte)csn.type;
                this.fNodeValue[chunk][index] = csn.value;
                int nodeIndex = this.fNodeCount++;
                if (++index == 32) {
                    this.ensureNodeCapacity(++chunk);
                    index = 0;
                }
                this.fNodeType[chunk][index] = (byte)(csn.type | 0x40);
                this.fNodeValue[chunk][index] = csn.otherValue;
                ++this.fNodeCount;
                return nodeIndex;
            }
        }
        return -1;
    }

    public void getContentSpecNode(int contentSpecIndex, ContentSpecNode csn) {
        int chunk = contentSpecIndex >> 5;
        int index = contentSpecIndex & 0x1F;
        csn.type = this.fNodeType[chunk][index];
        csn.value = this.fNodeValue[chunk][index];
        if (csn.type == 4 || csn.type == 5) {
            if (++index == 32) {
                ++chunk;
                index = 0;
            }
            csn.otherValue = this.fNodeValue[chunk][index];
            return;
        }
        csn.otherValue = -1;
    }

    private void appendContentSpecNode(int contentSpecIndex, StringBuffer sb, boolean noParen) {
        int chunk = contentSpecIndex >> 5;
        int index = contentSpecIndex & 0x1F;
        byte type = this.fNodeType[chunk][index];
        int value = this.fNodeValue[chunk][index];
        switch (type) {
            case 0: {
                sb.append(value == -1 ? "#PCDATA" : this.fStringPool.toString(value));
                return;
            }
            case 1: {
                this.appendContentSpecNode(value, sb, false);
                sb.append('?');
                return;
            }
            case 2: {
                this.appendContentSpecNode(value, sb, false);
                sb.append('*');
                return;
            }
            case 3: {
                this.appendContentSpecNode(value, sb, false);
                sb.append('+');
                return;
            }
            case 4: 
            case 5: {
                int leftIndex;
                int leftChunk;
                byte leftType;
                if (!noParen) {
                    sb.append('(');
                }
                this.appendContentSpecNode(value, sb, (leftType = this.fNodeType[leftChunk = value >> 5][leftIndex = value & 0x1F]) == type);
                sb.append(type == 4 ? (char)'|' : ',');
                if (++index == 32) {
                    ++chunk;
                    index = 0;
                }
                this.appendContentSpecNode(this.fNodeValue[chunk][index], sb, false);
                if (!noParen) {
                    sb.append(')');
                }
                return;
            }
        }
    }

    public String getContentSpecNodeAsString(int contentSpecIndex) {
        int chunk = contentSpecIndex >> 5;
        int index = contentSpecIndex & 0x1F;
        byte type = this.fNodeType[chunk][index];
        int value = this.fNodeValue[chunk][index];
        StringBuffer sb = new StringBuffer();
        switch (type) {
            case 0: {
                sb.append("(" + (value == -1 ? "#PCDATA" : this.fStringPool.toString(value)) + ")");
                break;
            }
            case 1: {
                chunk = value >> 5;
                index = value & 0x1F;
                if (this.fNodeType[chunk][index] == 0) {
                    value = this.fNodeValue[chunk][index];
                    sb.append("(" + (value == -1 ? "#PCDATA" : this.fStringPool.toString(value)) + ")?");
                    break;
                }
                this.appendContentSpecNode(contentSpecIndex, sb, false);
                break;
            }
            case 2: {
                chunk = value >> 5;
                index = value & 0x1F;
                if (this.fNodeType[chunk][index] == 0) {
                    value = this.fNodeValue[chunk][index];
                    sb.append("(" + (value == -1 ? "#PCDATA" : this.fStringPool.toString(value)) + ")*");
                    break;
                }
                this.appendContentSpecNode(contentSpecIndex, sb, false);
                break;
            }
            case 3: {
                chunk = value >> 5;
                index = value & 0x1F;
                if (this.fNodeType[chunk][index] == 0) {
                    value = this.fNodeValue[chunk][index];
                    sb.append("(" + (value == -1 ? "#PCDATA" : this.fStringPool.toString(value)) + ")+");
                    break;
                }
                this.appendContentSpecNode(contentSpecIndex, sb, false);
                break;
            }
            case 4: 
            case 5: {
                this.appendContentSpecNode(contentSpecIndex, sb, false);
                break;
            }
            default: {
                return null;
            }
        }
        return sb.toString();
    }

    private boolean ensureAttrCapacity(int chunk) {
        try {
            return this.fAttName[chunk][0] == 0;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            byte[][] newByteArray = new byte[chunk * 2][];
            System.arraycopy(this.fAttType, 0, newByteArray, 0, chunk);
            this.fAttType = newByteArray;
            newByteArray = new byte[chunk * 2][];
            System.arraycopy(this.fAttDefaultType, 0, newByteArray, 0, chunk);
            this.fAttDefaultType = newByteArray;
            int[][] newIntArray = new int[chunk * 2][];
            System.arraycopy(this.fAttName, 0, newIntArray, 0, chunk);
            this.fAttName = newIntArray;
            newIntArray = new int[chunk * 2][];
            System.arraycopy(this.fEnumeration, 0, newIntArray, 0, chunk);
            this.fEnumeration = newIntArray;
            newIntArray = new int[chunk * 2][];
            System.arraycopy(this.fAttValue, 0, newIntArray, 0, chunk);
            this.fAttValue = newIntArray;
            newIntArray = new int[chunk * 2][];
            System.arraycopy(this.fNextAttDef, 0, newIntArray, 0, chunk);
            this.fNextAttDef = newIntArray;
        }
        catch (NullPointerException nullPointerException) {}
        this.fAttType[chunk] = new byte[32];
        this.fAttDefaultType[chunk] = new byte[32];
        this.fAttName[chunk] = new int[32];
        this.fEnumeration[chunk] = new int[32];
        this.fAttValue[chunk] = new int[32];
        this.fNextAttDef[chunk] = new int[32];
        return true;
    }

    public int addAttDef(int elementIndex, AttDef attDef) throws Exception {
        int index;
        int elemChunk = elementIndex >> 5;
        int elemIndex = elementIndex & 0x1F;
        int attlistIndex = this.fAttlistHead[elemChunk][elemIndex];
        while (attlistIndex != -1) {
            int attrChunk = attlistIndex >> 5;
            int attrIndex = attlistIndex & 0x1F;
            if (this.fAttName[attrChunk][attrIndex] == attDef.attName) {
                if (this.fParserState.getWarningOnDuplicateAttDef()) {
                    this.fErrorHandler.error1(15, attDef.attName);
                }
                return -1;
            }
            if (attDef.attType == 1 && this.fAttType[attrChunk][attrIndex] == 1) {
                this.fErrorHandler.error1(13, attDef.attName);
                return -1;
            }
            attlistIndex = this.fNextAttDef[attrChunk][attrIndex];
        }
        if (this.fXMLSpace == -1) {
            this.fXMLSpace = this.fStringPool.addSymbol("xml:space".intern());
            this.fDefault = this.fStringPool.addSymbol("default".intern());
            this.fPreserve = this.fStringPool.addSymbol("preserve".intern());
        }
        if (attDef.attName == this.fXMLSpace) {
            boolean ok = false;
            if (attDef.attType == 9 && (index = attDef.enumeration) != -1) {
                boolean bl = ok = this.fStringPool.stringListLength(index) == 2 && this.fStringPool.stringInList(index, this.fDefault) && this.fStringPool.stringInList(index, this.fPreserve);
            }
            if (!ok) {
                this.fErrorHandler.error(14);
            }
        }
        int chunk = this.fAttDefCount >> 5;
        index = this.fAttDefCount & 0x1F;
        this.ensureAttrCapacity(chunk);
        this.fAttName[chunk][index] = attDef.attName;
        this.fAttType[chunk][index] = (byte)attDef.attType;
        this.fEnumeration[chunk][index] = attDef.enumeration;
        this.fAttDefaultType[chunk][index] = (byte)attDef.attDefaultType;
        this.fAttValue[chunk][index] = attDef.attValue;
        int nextIndex = -1;
        if (attDef.attValue != -1) {
            nextIndex = this.fAttlistHead[elemChunk][elemIndex];
            this.fAttlistHead[elemChunk][elemIndex] = this.fAttDefCount;
            if (nextIndex == -1) {
                this.fAttlistTail[elemChunk][elemIndex] = this.fAttDefCount;
            }
        } else {
            nextIndex = this.fAttlistTail[elemChunk][elemIndex];
            this.fAttlistTail[elemChunk][elemIndex] = this.fAttDefCount;
            if (nextIndex == -1) {
                this.fAttlistHead[elemChunk][elemIndex] = this.fAttDefCount;
            } else {
                this.fNextAttDef[nextIndex >> 5][nextIndex & 0x1F] = this.fAttDefCount;
                nextIndex = -1;
            }
        }
        this.fNextAttDef[chunk][index] = nextIndex;
        return this.fAttDefCount++;
    }

    public int getAttDef(int elementNameIndex, int attrNameIndex) {
        int chunk = 0;
        int index = 0;
        int elementIndex = 0;
        while (elementIndex < this.fElementCount) {
            if (this.fElementName[chunk][index] == elementNameIndex) {
                int attDefIndex = this.fAttlistHead[chunk][index];
                while (true) {
                    if (attDefIndex == -1) {
                        return -1;
                    }
                    chunk = attDefIndex >> 5;
                    index = attDefIndex & 0x1F;
                    if (this.fAttName[chunk][index] == attrNameIndex) {
                        return attDefIndex;
                    }
                    attDefIndex = this.fNextAttDef[chunk][index];
                }
            }
            if (++index == 32) {
                ++chunk;
                index = 0;
            }
            ++elementIndex;
        }
        return -1;
    }

    public int getAttName(int attDefIndex) {
        int chunk = attDefIndex >> 5;
        int index = attDefIndex & 0x1F;
        return this.fAttName[chunk][index];
    }

    public int getAttValue(int attDefIndex) {
        int chunk = attDefIndex >> 5;
        int index = attDefIndex & 0x1F;
        return this.fAttValue[chunk][index];
    }

    public int getAttType(int attDefIndex) {
        int chunk = attDefIndex >> 5;
        int index = attDefIndex & 0x1F;
        return this.fAttType[chunk][index];
    }

    public int getAttDefaultType(int attDefIndex) {
        int chunk = attDefIndex >> 5;
        int index = attDefIndex & 0x1F;
        return this.fAttDefaultType[chunk][index];
    }

    public int getEnumeration(int attDefIndex) {
        int chunk = attDefIndex >> 5;
        int index = attDefIndex & 0x1F;
        return this.fEnumeration[chunk][index];
    }

    public int addDefaultAttributes(int elementIndex, AttrPool attrPool, int firstAttrIndex, int lastAttrIndex) throws Exception {
        int elemChunk = elementIndex >> 5;
        int elemIndex = elementIndex & 0x1F;
        int attlistIndex = this.fAttlistHead[elemChunk][elemIndex];
        int firstCheck = firstAttrIndex;
        int lastCheck = lastAttrIndex;
        while (attlistIndex != -1) {
            int attrChunk = attlistIndex >> 5;
            int attrIndex = attlistIndex & 0x1F;
            byte attDefType = this.fAttDefaultType[attrChunk][attrIndex];
            if (attDefType != 3) {
                int attName = this.fAttName[attrChunk][attrIndex];
                boolean specified = false;
                if (firstCheck != -1) {
                    int i = firstCheck;
                    while (i <= lastCheck) {
                        attrPool.getAttrName(i);
                        if (attrPool.getAttrName(i) == attName) {
                            if (attDefType == 4 && attrPool.getAttValue(i) != this.fAttValue[attrChunk][attrIndex]) {
                                this.fErrorHandler.error3(134, attName, this.fAttValue[attrChunk][attrIndex], attrPool.getAttValue(i));
                            }
                            specified = true;
                            break;
                        }
                        ++i;
                    }
                }
                if (!specified) {
                    if (attDefType == 2) {
                        this.fErrorHandler.error1(133, attName);
                    } else {
                        this.fAttr.attName = attName;
                        this.fAttr.attType = this.fAttType[attrChunk][attrIndex];
                        this.fAttr.attValue = this.fAttValue[attrChunk][attrIndex];
                        this.fAttr.specified = false;
                        lastAttrIndex = attrPool.addAttr(this.fAttr, -1);
                        if (firstAttrIndex == -1) {
                            firstAttrIndex = lastAttrIndex;
                        }
                    }
                }
            }
            attlistIndex = this.fNextAttDef[attrChunk][attrIndex];
        }
        if (lastAttrIndex != -1) {
            attrPool.setIsLastAttr(lastAttrIndex);
        }
        return firstAttrIndex;
    }

    public boolean addId(int idIndex, int elementNameIndex) {
        Integer key = new Integer(idIndex);
        if (this.fIdDefs == null) {
            this.fIdDefs = new Hashtable();
        } else if (this.fIdDefs.containsKey(key)) {
            return false;
        }
        if (this.fNullValue == null) {
            this.fNullValue = new Object();
        }
        this.fIdDefs.put(key, this.fNullValue);
        return true;
    }

    public void addIdRef(int idIndex, int elementNameIndex) {
        Integer key = new Integer(idIndex);
        if (this.fIdDefs != null && this.fIdDefs.containsKey(key)) {
            return;
        }
        if (this.fIdRefs == null) {
            this.fIdRefs = new Hashtable();
        } else if (this.fIdRefs.containsKey(key)) {
            return;
        }
        if (this.fNullValue == null) {
            this.fNullValue = new Object();
        }
        this.fIdRefs.put(key, this.fNullValue);
    }

    public void checkIdRefs() throws Exception {
        if (this.fIdRefs == null) {
            return;
        }
        Enumeration en = this.fIdRefs.keys();
        while (en.hasMoreElements()) {
            Integer key = (Integer)en.nextElement();
            if (this.fIdDefs != null && this.fIdDefs.containsKey(key)) continue;
            this.fErrorHandler.error1(84, key);
        }
    }

    public void checkNamespace(int elementIndex, int firstAttrIndex) throws Exception {
        int elementName;
        String enString;
        int errorCode;
        if (firstAttrIndex != -1) {
            int attValue;
            String avString;
            int attrIndex = firstAttrIndex;
            int attrName = this.fAttrPool.getAttrName(attrIndex);
            String anString = this.fStringPool.toString(attrName);
            int errorCode2 = this.checkQName(elementIndex, anString);
            if (errorCode2 != -1) {
                this.fErrorHandler.error1(errorCode2, attrName);
            }
            if ((avString = this.fStringPool.toString(attValue = this.fAttrPool.getAttValue(attrIndex))).length() == 0 && anString.startsWith("xmlns:")) {
                this.fErrorHandler.error1(142, attrName);
            }
            if (this.localpartcache.length == 0) {
                int[] newcache = new int[]{};
                System.arraycopy(this.localpartcache, 0, newcache, 0, 0);
                this.localpartcache = newcache;
                newcache = new int[]{};
                System.arraycopy(this.nsnamecache, 0, newcache, 0, 0);
                this.nsnamecache = newcache;
            }
            this.localpartcache[0] = this.getNSLocalName(anString, attrName);
            this.nsnamecache[0] = this.getNSName(elementIndex, anString);
            if (this.nsnamecache[0] != -1) {
                int j = 0;
                while (j < 0) {
                    int ns;
                    if (this.localpartcache[j] == this.localpartcache[0] && (ns = this.nsnamecache[j]) != -1 && ns == this.nsnamecache[0]) {
                        this.fErrorHandler.error4(144, attrName, this.nsnamecache[0], this.localpartcache[0], this.fAttrPool.getAttrName(firstAttrIndex + j));
                    }
                    ++j;
                }
            }
        }
        if ((errorCode = this.checkQName(elementIndex, enString = this.fStringPool.toString(elementName = this.getElementName(elementIndex)))) != -1) {
            this.fErrorHandler.error1(errorCode, elementName);
        }
    }

    public void checkDeclaredElements() throws Exception {
        if (this.fParserState.getValidationHandler() != null) {
            int i = 0;
            while (i < this.fElementCount) {
                int type = this.getContentSpecType(i);
                if (type == 3 || type == 4) {
                    int chunk = i >> 5;
                    int index = i & 0x1F;
                    int contentSpecIndex = this.fContentSpec[chunk][index];
                    this.checkDeclaredElements(i, contentSpecIndex);
                }
                ++i;
            }
        }
    }

    private void checkDeclaredElements(int elementIndex, int contentSpecIndex) throws Exception {
        int chunk = contentSpecIndex >> 5;
        int index = contentSpecIndex & 0x1F;
        byte type = this.fNodeType[chunk][index];
        int value = this.fNodeValue[chunk][index];
        switch (type) {
            case 0: {
                if (value == -1 || this.getElement(value) != -1) break;
                int elemChunk = elementIndex >> 5;
                int elemIndex = elementIndex & 0x1F;
                int elementNameIndex = this.fElementName[elemChunk][elemIndex];
                this.fErrorHandler.error2(165, elementNameIndex, value);
                return;
            }
            case 1: 
            case 2: 
            case 3: {
                this.checkDeclaredElements(elementIndex, value);
                return;
            }
            case 4: 
            case 5: {
                this.checkDeclaredElements(elementIndex, value);
                if (++index == 32) {
                    ++chunk;
                    index = 0;
                }
                this.checkDeclaredElements(elementIndex, this.fNodeValue[chunk][index]);
                return;
            }
        }
    }

    private int checkQName(int elementIndex, String qname) {
        int index = qname.indexOf(58);
        if (index < 0) {
            return -1;
        }
        if (this.getNamespaceForPrefix(elementIndex, qname.substring(0, index)) == -1) {
            return 136;
        }
        if (qname.indexOf(58, index + 1) >= 0) {
            return 135;
        }
        return -1;
    }

    private int getNSLocalName(String qname, int qnameIndex) {
        int index = qname.indexOf(58);
        if (index < 0) {
            return qnameIndex;
        }
        return this.fStringPool.addSymbol(qname.substring(index + 1));
    }

    private int getNSName(int elementIndex, String qname) {
        int index = qname.indexOf(58);
        String prefix = index < 0 ? "" : qname.substring(0, index);
        return this.getNamespaceForPrefix(elementIndex, prefix);
    }

    private int getNamespaceForPrefix(int elementIndex, String prefix) {
        return -1;
    }
}

