/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.internal;

import com.ibm.xml.framework.ChunkyCharArray;
import com.ibm.xml.framework.ParserState;
import com.ibm.xml.framework.ScanContentState;
import com.ibm.xml.framework.StringPool;
import com.ibm.xml.framework.StringProducer;
import com.ibm.xml.framework.XMLDocumentHandler;
import com.ibm.xml.framework.XMLErrorHandler;
import com.ibm.xml.framework.XMLReader;
import com.ibm.xml.framework.XMLScanner;
import com.ibm.xml.internal.StringHasher;
import java.io.Reader;

final class CharReader
extends XMLReader {
    protected static final int CHUNK_SHIFT = 14;
    protected static final int CHUNK_SIZE = 16384;
    protected static final int CHUNK_MASK = 16383;
    protected XMLScanner fScanner = null;
    protected XMLDocumentHandler fDocumentHandler = null;
    protected XMLErrorHandler fErrorHandler = null;
    protected StringPool fStringPool = null;
    protected Reader fReader = null;
    protected CharDataChunk fCurrentChunk = null;
    protected int fCurrentIndex = 0;
    protected char[] fMostRecentData = null;
    protected int fMostRecentChar = 0;
    protected int fLength = 0;
    protected boolean fCheckOverflow = false;
    protected char[] fOverflow = null;
    protected int fOverflowOffset = 0;
    protected int fOverflowEnd = 0;
    protected int fOutputOffset = 0;
    protected boolean fSkipLinefeed = false;

    CharReader(ParserState parserState, String publicId, String systemId, Reader reader) throws Exception {
        super(parserState, publicId, systemId);
        this.fReader = reader;
        this.fScanner = parserState.getScanner();
        this.fStringPool = parserState.cacheStringPool();
        this.fDocumentHandler = parserState.getDocumentHandler();
        this.fErrorHandler = parserState.getErrorHandler();
        this.fCurrentChunk = new CharDataChunk(this.fStringPool, null);
        this.fillCurrentChunk();
    }

    public int addString(int offset, int length) {
        if (length == 0) {
            return 0;
        }
        return this.fCurrentChunk.addString(offset, length);
    }

    public int addSymbol(int offset, int length) {
        if (length == 0) {
            return 0;
        }
        return this.fCurrentChunk.addSymbol(offset, length, 0);
    }

    protected int addSymbol(int offset, int length, int hashcode) {
        if (length == 0) {
            return 0;
        }
        return this.fCurrentChunk.addSymbol(offset, length, hashcode);
    }

    public void append(ChunkyCharArray charArray, int offset, int length) {
        this.fCurrentChunk.append(charArray, offset, length);
    }

    protected int slowLoadNextChar() throws Exception {
        if (this.fCurrentChunk.nextChunk() != null) {
            this.fCurrentChunk = this.fCurrentChunk.nextChunk();
            this.fCurrentIndex = 0;
            this.fMostRecentData = this.fCurrentChunk.toCharArray();
            this.fMostRecentChar = this.fMostRecentData[this.fCurrentIndex] & 0xFFFF;
            return this.fMostRecentChar;
        }
        this.fCurrentChunk = new CharDataChunk(this.fStringPool, this.fCurrentChunk);
        return this.fillCurrentChunk();
    }

    protected int loadNextChar() throws Exception {
        ++this.fCurrentOffset;
        if (++this.fCurrentIndex == 16384) {
            return this.slowLoadNextChar();
        }
        this.fMostRecentChar = this.fMostRecentData[this.fCurrentIndex] & 0xFFFF;
        return this.fMostRecentChar;
    }

    protected void checkEOF(int offset) {
        if (offset > this.fLength) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    public int skipOneChar() throws Exception {
        int ch = this.fMostRecentChar;
        if (ch == 0) {
            int offset = this.fCurrentOffset + 1;
            if (offset > this.fLength) {
                throw new ArrayIndexOutOfBoundsException();
            }
            ++this.fCharacterCounter;
        } else if (ch == 10) {
            ++this.fLinefeedCounter;
            this.fCharacterCounter = 1;
        } else if (ch >= 55296 && ch < 56320) {
            ++this.fCharacterCounter;
            ch = this.loadNextChar();
            if (ch < 56320 || ch >= 57344) {
                return this.fCurrentOffset;
            }
        } else {
            ++this.fCharacterCounter;
        }
        this.loadNextChar();
        return this.fCurrentOffset;
    }

    public int skipAsciiChar() throws Exception {
        ++this.fCharacterCounter;
        this.loadNextChar();
        return this.fCurrentOffset;
    }

    public int skipToChar(char chr) throws Exception {
        int ch = this.fMostRecentChar;
        while (ch != chr) {
            if (ch == 0) {
                int offset = this.fCurrentOffset + 1;
                if (offset > this.fLength) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                ++this.fCharacterCounter;
            } else if (ch == 10) {
                ++this.fLinefeedCounter;
                this.fCharacterCounter = 1;
            } else if (ch >= 55296 && ch < 56320) {
                ++this.fCharacterCounter;
                ch = this.loadNextChar();
                if (ch < 56320 || ch >= 57344) {
                    continue;
                }
            } else {
                ++this.fCharacterCounter;
            }
            ch = this.loadNextChar();
        }
        return this.fCurrentOffset;
    }

    public int skipPastChar(char chr) throws Exception {
        int ch = this.fMostRecentChar;
        while (true) {
            if (ch == chr) {
                ++this.fCharacterCounter;
                this.loadNextChar();
                return this.fCurrentOffset;
            }
            if (ch == 0) {
                int offset = this.fCurrentOffset + 1;
                if (offset > this.fLength) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                ++this.fCharacterCounter;
            } else if (ch == 10) {
                ++this.fLinefeedCounter;
                this.fCharacterCounter = 1;
            } else if (ch >= 55296 && ch < 56320) {
                ++this.fCharacterCounter;
                ch = this.loadNextChar();
                if (ch < 56320 || ch >= 57344) {
                    continue;
                }
            } else {
                ++this.fCharacterCounter;
            }
            ch = this.loadNextChar();
        }
    }

    public boolean skippedValidChar() throws Exception {
        int ch = this.fMostRecentChar;
        if (ch < 55296) {
            int offset;
            if (ch >= 32 || ch == 9) {
                ++this.fCharacterCounter;
                this.loadNextChar();
                return true;
            }
            if (ch == 10) {
                ++this.fLinefeedCounter;
                this.fCharacterCounter = 1;
                this.loadNextChar();
                return true;
            }
            if (ch == 0 && (offset = this.fCurrentOffset + 1) > this.fLength) {
                throw new ArrayIndexOutOfBoundsException();
            }
            return false;
        }
        if (ch > 65533) {
            return false;
        }
        if (ch < 56320 ? (ch = this.loadNextChar()) < 56320 || ch >= 57344 : ch < 57344) {
            return false;
        }
        ++this.fCharacterCounter;
        this.loadNextChar();
        return true;
    }

    public boolean lookingAtValidChar() throws Exception {
        int ch = this.fMostRecentChar;
        if (ch < 32) {
            int offset;
            if (ch == 0 && (offset = this.fCurrentOffset + 1) > this.fLength) {
                throw new ArrayIndexOutOfBoundsException();
            }
            return ch == 9 || ch == 10;
        }
        return ch <= 65533;
    }

    public int skipInvalidChar(int errorCode) throws Exception {
        int ch = this.fMostRecentChar;
        if (ch == 10) {
            ++this.fLinefeedCounter;
            this.fCharacterCounter = 1;
            this.loadNextChar();
        } else {
            ++this.fCharacterCounter;
            if (ch >= 55296 && ch < 56320) {
                int ch2 = this.loadNextChar();
                if (ch2 >= 56320 && ch2 < 57344) {
                    ch = (ch - 55296 << 10) + (ch2 - 56320) + 65536;
                    this.loadNextChar();
                }
            } else {
                this.loadNextChar();
            }
        }
        switch (errorCode) {
            case 63: 
            case 85: {
                String arg = Integer.toHexString(ch);
                this.fErrorHandler.error1(errorCode, this.fStringPool.addString(arg));
                break;
            }
            case 80: 
            case 82: 
            case 110: {
                String arg = ch < 65536 ? new Character((char)ch).toString() : Integer.toHexString(ch);
                this.fErrorHandler.error1(errorCode, this.fStringPool.addString(arg));
                break;
            }
            case 43: {
                String arg1 = ch < 65536 ? new Character((char)ch).toString() : Integer.toHexString(ch);
                String arg2 = Integer.toHexString(ch);
                this.fErrorHandler.error2(errorCode, this.fStringPool.addString(arg1), this.fStringPool.addString(arg2));
            }
        }
        return this.fCurrentOffset;
    }

    public boolean skippedChar(char chr) throws Exception {
        int ch = this.fMostRecentChar;
        if (ch != chr) {
            return false;
        }
        ++this.fCharacterCounter;
        ++this.fCurrentOffset;
        if (++this.fCurrentIndex == 16384) {
            this.slowLoadNextChar();
        } else {
            this.fMostRecentChar = this.fMostRecentData[this.fCurrentIndex] & 0xFFFF;
        }
        return true;
    }

    public boolean lookingAtChar(char chr) throws Exception {
        int ch = this.fMostRecentChar;
        return ch == chr;
    }

    public boolean skippedSpace() throws Exception {
        int ch = this.fMostRecentChar;
        if (ch > 32) {
            return false;
        }
        if (ch == 32 || ch == 9) {
            ++this.fCharacterCounter;
        } else if (ch == 10) {
            ++this.fLinefeedCounter;
            this.fCharacterCounter = 1;
        } else {
            return false;
        }
        ++this.fCurrentOffset;
        if (++this.fCurrentIndex == 16384) {
            this.slowLoadNextChar();
        } else {
            this.fMostRecentChar = this.fMostRecentData[this.fCurrentIndex] & 0xFFFF;
        }
        return true;
    }

    public boolean lookingAtSpace() {
        int ch = this.fMostRecentChar;
        return ch == 32 || ch == 9 || ch == 10;
    }

    public int skipPastSpaces() throws Exception {
        int ch = this.fMostRecentChar;
        while (true) {
            if (ch == 32 || ch == 9) {
                ++this.fCharacterCounter;
            } else if (ch == 10) {
                ++this.fLinefeedCounter;
                this.fCharacterCounter = 1;
            } else {
                return this.fCurrentOffset;
            }
            ch = this.loadNextChar();
        }
    }

    public int skipDecimalDigit() throws Exception {
        int ch = this.fMostRecentChar;
        if (ch < 48 || ch > 57) {
            return -1;
        }
        ++this.fCharacterCounter;
        this.loadNextChar();
        return ch - 48;
    }

    public int skipHexDigit() throws Exception {
        int ch = this.fMostRecentChar;
        if (ch > 102 || XMLReader.fgAsciiXDigitChar[ch] == 0) {
            return -1;
        }
        ++this.fCharacterCounter;
        this.loadNextChar();
        return ch - (ch < 65 ? 48 : (ch < 97 ? 65 : 97) - 10);
    }

    public boolean skippedAlpha() throws Exception {
        int ch = this.fMostRecentChar;
        if (ch > 122 || XMLReader.fgAsciiAlphaChar[ch] == 0) {
            return false;
        }
        ++this.fCharacterCounter;
        this.loadNextChar();
        return true;
    }

    protected boolean skippedAsciiCharWithFlag(byte flag) throws Exception {
        int ch = this.fMostRecentChar;
        if (ch >= 128 || (XMLReader.fgCharFlags[ch] & flag) == 0) {
            return false;
        }
        ++this.fCharacterCounter;
        this.loadNextChar();
        return true;
    }

    public boolean skippedVersionNum() throws Exception {
        return this.skippedAsciiCharWithFlag((byte)1);
    }

    public boolean skippedEncName() throws Exception {
        return this.skippedAsciiCharWithFlag((byte)2);
    }

    public boolean skippedPubidChar() throws Exception {
        int ch = this.fMostRecentChar;
        if (ch >= 128) {
            return false;
        }
        if ((XMLReader.fgCharFlags[ch] & 4) != 0) {
            ++this.fCharacterCounter;
            this.loadNextChar();
            return true;
        }
        if (ch == 10) {
            ++this.fLinefeedCounter;
            this.fCharacterCounter = 1;
            this.loadNextChar();
            return true;
        }
        return false;
    }

    public boolean skippedString(char[] s) throws Exception {
        int length = s.length;
        char[] data = this.fMostRecentData;
        int index = this.fCurrentIndex;
        if (index + length <= 16384) {
            int i = 0;
            while (i < length) {
                if (data[index++] != s[i]) {
                    return false;
                }
                ++i;
            }
            this.fCharacterCounter += length;
            this.fCurrentOffset += length;
            this.fCurrentIndex = index;
            if (index == 16384) {
                this.slowLoadNextChar();
            } else {
                this.fMostRecentChar = data[index] & 0xFFFF;
            }
            return true;
        }
        CharDataChunk dataChunk = this.fCurrentChunk;
        int offset = this.fCurrentOffset;
        int savedIndex = index;
        int i = 0;
        while (index < 16384) {
            if (data[index++] == s[i++]) continue;
            return false;
        }
        this.slowLoadNextChar();
        data = this.fMostRecentData;
        index = 0;
        while (i < length) {
            if (data[index++] == s[i++]) continue;
            this.fCurrentChunk = dataChunk;
            this.fCurrentIndex = savedIndex;
            this.fCurrentOffset = offset;
            this.fMostRecentData = dataChunk.toCharArray();
            this.fMostRecentChar = this.fMostRecentData[savedIndex] & 0xFFFF;
            return false;
        }
        this.fCharacterCounter += length;
        this.fCurrentOffset += length;
        this.fCurrentIndex = index;
        if (index == 16384) {
            this.slowLoadNextChar();
        } else {
            this.fMostRecentChar = data[index] & 0xFFFF;
        }
        return true;
    }

    public int scanName(char fastcheck, int expectedName) throws Exception {
        int nameIndex;
        int ch = this.fMostRecentChar;
        if (ch < 128 ? XMLReader.fgAsciiInitialNameChar[ch] == 0 : (XMLReader.fgCharFlags[ch] & 0x10) == 0) {
            return -1;
        }
        int offset = this.fCurrentOffset;
        int index = this.fCurrentIndex;
        char[] data = this.fMostRecentData;
        if (++index == 16384) {
            this.fCurrentChunk = new CharDataChunk(this.fStringPool, this.fCurrentChunk);
            this.fillCurrentChunk();
            index = 0;
            data = this.fMostRecentData;
        }
        ++this.fCharacterCounter;
        ++this.fCurrentOffset;
        int hashcode = 0;
        int position = 0;
        while (true) {
            hashcode = StringHasher.hashChar(hashcode, position++, ch);
            ch = data[index] & 0xFFFF;
            if (fastcheck == ch || (ch >= 128 ? (XMLReader.fgCharFlags[ch] & 0x20) == 0 : XMLReader.fgAsciiNameChar[ch] == 0)) break;
            if (++index == 16384) {
                this.fCurrentChunk = new CharDataChunk(this.fStringPool, this.fCurrentChunk);
                this.fillCurrentChunk();
                index = 0;
                data = this.fMostRecentData;
            }
            ++this.fCharacterCounter;
            ++this.fCurrentOffset;
        }
        this.fCurrentIndex = index;
        this.fMostRecentChar = ch;
        hashcode = StringHasher.finishHash(hashcode);
        int length = this.fCurrentOffset - offset;
        int n = nameIndex = length == 0 ? 0 : this.fCurrentChunk.addSymbol(offset, length, hashcode);
        if (expectedName == -1 || expectedName == nameIndex) {
            return nameIndex;
        }
        return -1;
    }

    public int skipPastName(char fastcheck) throws Exception {
        int ch = this.fMostRecentChar;
        if (ch < 128 ? XMLReader.fgAsciiInitialNameChar[ch] == 0 : (XMLReader.fgCharFlags[ch] & 0x10) == 0) {
            return this.fCurrentOffset;
        }
        do {
            ++this.fCharacterCounter;
            ch = this.loadNextChar();
            if (fastcheck != ch) continue;
            return this.fCurrentOffset;
        } while (!(ch < 128 ? XMLReader.fgAsciiNameChar[ch] == 0 : (XMLReader.fgCharFlags[ch] & 0x20) == 0));
        return this.fCurrentOffset;
    }

    public int skipPastNmtoken(char fastcheck) throws Exception {
        int ch = this.fMostRecentChar;
        while (fastcheck != ch) {
            if (ch < 128 ? XMLReader.fgAsciiNameChar[ch] == 0 : (XMLReader.fgCharFlags[ch] & 0x20) == 0) {
                return this.fCurrentOffset;
            }
            ++this.fCharacterCounter;
            ch = this.loadNextChar();
        }
        return this.fCurrentOffset;
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    public int scanContent(ScanContentState scanState) throws Exception {
        block60: {
            this.fCurrentChunk.clearPreviousChunk();
            charDataOffset = this.fCurrentOffset++;
            ch = this.fMostRecentChar;
            if (ch >= 128) ** GOTO lbl63
            switch (XMLReader.fgAsciiWSCharData[ch]) {
                case 0: {
                    ++this.fCharacterCounter;
                    if (++this.fCurrentIndex == 16384) {
                        this.slowLoadNextChar();
                        ** break;
                    }
                    this.fMostRecentChar = this.fMostRecentData[this.fCurrentIndex] & 65535;
                    ** break;
                }
                case 1: {
                    ++this.fCharacterCounter;
                    ++this.fCurrentOffset;
                    if (++this.fCurrentIndex == 16384) {
                        this.slowLoadNextChar();
                    } else {
                        this.fMostRecentChar = this.fMostRecentData[this.fCurrentIndex] & 65535;
                    }
                    if (scanState.inCDSect) ** break;
                    return 1;
                }
                case 2: {
                    ++this.fCharacterCounter;
                    ++this.fCurrentOffset;
                    if (++this.fCurrentIndex == 16384) {
                        this.slowLoadNextChar();
                    } else {
                        this.fMostRecentChar = this.fMostRecentData[this.fCurrentIndex] & 65535;
                    }
                    if (scanState.inCDSect) ** break;
                    return 2;
                }
                case 3: {
                    ++this.fCharacterCounter;
                    ch = this.loadNextChar();
                    if (ch != 93) ** break;
                    if (this.fCurrentIndex + 1 == 16384) {
                        dataChunk = this.fCurrentChunk;
                        index = this.fCurrentIndex;
                        offset = this.fCurrentOffset;
                        if (this.loadNextChar() != 62) {
                            this.fCurrentChunk = dataChunk;
                            this.fCurrentIndex = index;
                            this.fCurrentOffset = offset;
                            this.fMostRecentData = dataChunk.toCharArray();
                            this.fMostRecentChar = 93;
                            ** break;
                        }
                    } else {
                        if (this.fMostRecentData[this.fCurrentIndex + 1] != '>') ** break;
                        ++this.fCurrentIndex;
                        ++this.fCurrentOffset;
                    }
                    this.loadNextChar();
                    this.fCharacterCounter += 2;
                    if (scanState.inCDSect == false) return 3;
                    scanState.inCDSect = false;
                    return this.scanContent(scanState);
                }
                case 4: {
                    return 4;
                }
                case 5: {
                    break;
                }
lbl63:
                // 1 sources

                if (this.skipMultiByteCharData(ch)) ** break;
                return 4;
                default: {
                    break block60;
                }
            }
            do {
                if (ch == 10) {
                    ++this.fLinefeedCounter;
                    this.fCharacterCounter = 1;
                } else {
                    ++this.fCharacterCounter;
                }
                ++this.fCurrentOffset;
            } while ((ch = ++this.fCurrentIndex == 16384 ? this.slowLoadNextChar() : (this.fMostRecentChar = this.fMostRecentData[this.fCurrentIndex] & 65535)) == 32 || ch == 9 || ch == 10);
            if (ch >= 128) ** GOTO lbl149
            switch (XMLReader.fgAsciiCharData[ch]) {
                case 0: {
                    ++this.fCharacterCounter;
                    ++this.fCurrentOffset;
                    if (++this.fCurrentIndex == 16384) {
                        this.slowLoadNextChar();
                        break;
                    }
                    this.fMostRecentChar = this.fMostRecentData[this.fCurrentIndex] & 65535;
                    break;
                }
                case 1: {
                    if (!scanState.inCDSect) {
                        if (this.fDocumentHandler != null) {
                            this.callWSCharDataHandler(charDataOffset, this.fCurrentOffset, false);
                        }
                        ++this.fCharacterCounter;
                        this.loadNextChar();
                        return 25;
                    }
                    ++this.fCharacterCounter;
                    ++this.fCurrentOffset;
                    if (++this.fCurrentIndex == 16384) {
                        this.slowLoadNextChar();
                        break;
                    }
                    this.fMostRecentChar = this.fMostRecentData[this.fCurrentIndex] & 65535;
                    break;
                }
                case 2: {
                    if (!scanState.inCDSect) {
                        if (this.fDocumentHandler != null) {
                            this.callWSCharDataHandler(charDataOffset, this.fCurrentOffset, false);
                        }
                        ++this.fCharacterCounter;
                        this.loadNextChar();
                        return 26;
                    }
                    ++this.fCharacterCounter;
                    this.loadNextChar();
                    break;
                }
                case 3: {
                    endOffset = this.fCurrentOffset++;
                    ch = this.loadNextChar();
                    if (ch != 93) {
                        ++this.fCharacterCounter;
                        break;
                    }
                    if (this.fCurrentIndex + 1 == 16384) {
                        dataChunk = this.fCurrentChunk;
                        index = this.fCurrentIndex;
                        offset = this.fCurrentOffset;
                        if (this.loadNextChar() != 62) {
                            this.fCurrentChunk = dataChunk;
                            this.fCurrentIndex = index;
                            this.fCurrentOffset = offset;
                            this.fMostRecentData = dataChunk.toCharArray();
                            this.fMostRecentChar = 93;
                            ++this.fCharacterCounter;
                            break;
                        }
                    } else {
                        if (this.fMostRecentData[this.fCurrentIndex + 1] != '>') {
                            ++this.fCharacterCounter;
                            break;
                        }
                        ++this.fCurrentIndex;
                    }
                    this.loadNextChar();
                    if (this.fDocumentHandler != null) {
                        this.callWSCharDataHandler(charDataOffset, endOffset, scanState.inCDSect);
                    }
                    this.fCharacterCounter += 3;
                    if (scanState.inCDSect == false) return 27;
                    scanState.inCDSect = false;
                    return this.scanContent(scanState);
                }
                case 4: {
                    if (this.fDocumentHandler == null) return 28;
                    this.callWSCharDataHandler(charDataOffset, this.fCurrentOffset, scanState.inCDSect);
                    return 28;
                }
lbl149:
                // 1 sources

                if (this.skipMultiByteCharData(ch)) break;
                if (this.fDocumentHandler == null) return 28;
                this.callWSCharDataHandler(charDataOffset, this.fCurrentOffset, scanState.inCDSect);
                return 28;
            }
        }
        ch = this.skipAsciiCharData();
        while (true) {
            if (ch < 128) {
                switch (XMLReader.fgAsciiCharData[ch]) {
                    case 0: {
                        ++this.fCharacterCounter;
                        ch = this.loadNextChar();
                        break;
                    }
                    case 1: {
                        if (!scanState.inCDSect) {
                            if (this.fDocumentHandler != null) {
                                this.callCharDataHandler(charDataOffset, this.fCurrentOffset, false);
                            }
                            ++this.fCharacterCounter;
                            ++this.fCurrentOffset;
                            if (++this.fCurrentIndex == 16384) {
                                this.slowLoadNextChar();
                                return 9;
                            }
                            this.fMostRecentChar = this.fMostRecentData[this.fCurrentIndex] & 65535;
                            return 9;
                        }
                        ++this.fCharacterCounter;
                        ch = this.loadNextChar();
                        break;
                    }
                    case 2: {
                        if (!scanState.inCDSect) {
                            if (this.fDocumentHandler != null) {
                                this.callCharDataHandler(charDataOffset, this.fCurrentOffset, false);
                            }
                            ++this.fCharacterCounter;
                            this.loadNextChar();
                            return 10;
                        }
                        ++this.fCharacterCounter;
                        ch = this.loadNextChar();
                        break;
                    }
                    case 3: {
                        endOffset = this.fCurrentOffset++;
                        ch = this.loadNextChar();
                        if (ch != 93) {
                            ++this.fCharacterCounter;
                            break;
                        }
                        if (this.fCurrentIndex + 1 == 16384) {
                            dataChunk = this.fCurrentChunk;
                            index = this.fCurrentIndex;
                            offset = this.fCurrentOffset;
                            if (this.loadNextChar() != 62) {
                                this.fCurrentChunk = dataChunk;
                                this.fCurrentIndex = index;
                                this.fCurrentOffset = offset;
                                this.fMostRecentData = dataChunk.toCharArray();
                                this.fMostRecentChar = 93;
                                ++this.fCharacterCounter;
                                break;
                            }
                        } else {
                            if (this.fMostRecentData[this.fCurrentIndex + 1] != '>') {
                                ++this.fCharacterCounter;
                                break;
                            }
                            ++this.fCurrentIndex;
                        }
                        this.loadNextChar();
                        if (this.fDocumentHandler != null) {
                            this.callCharDataHandler(charDataOffset, endOffset, scanState.inCDSect);
                        }
                        this.fCharacterCounter += 3;
                        if (scanState.inCDSect == false) return 11;
                        scanState.inCDSect = false;
                        return this.scanContent(scanState);
                    }
                    case 4: {
                        if (ch != 10) {
                            if (this.fDocumentHandler == null) return 12;
                            this.callCharDataHandler(charDataOffset, this.fCurrentOffset, scanState.inCDSect);
                            return 12;
                        }
                        ++this.fLinefeedCounter;
                        this.fCharacterCounter = 1;
                        ch = this.loadNextChar();
                        break;
                    }
                }
                continue;
            }
            if (!this.skipMultiByteCharData(ch)) {
                if (this.fDocumentHandler == null) return 12;
                this.callCharDataHandler(charDataOffset, this.fCurrentOffset, scanState.inCDSect);
                return 12;
            }
            ch = this.fMostRecentChar;
        }
    }

    protected boolean skipMultiByteCharData(int ch) throws Exception {
        if (ch > 65533) {
            return false;
        }
        if (ch >= 901120 && ch < 57344) {
            return false;
        }
        if (ch >= 884736 && ch < 56320 && ((ch = this.loadNextChar()) < 901120 || ch >= 57344)) {
            return false;
        }
        this.loadNextChar();
        return true;
    }

    protected int skipAsciiCharData() throws Exception {
        int index = this.fCurrentIndex;
        int offset = this.fCurrentOffset - index;
        while (true) {
            char[] data = this.fMostRecentData;
            while (index < 16384) {
                int ch = data[index] & 0xFFFF;
                if (ch >= 128) {
                    this.fCurrentOffset = offset + index;
                    this.fCurrentIndex = index;
                    this.fMostRecentChar = ch;
                    return ch;
                }
                if (XMLReader.fgAsciiCharData[ch] != 0) {
                    if (ch != 10) {
                        this.fCurrentOffset = offset + index;
                        this.fCurrentIndex = index;
                        this.fMostRecentChar = ch;
                        return ch;
                    }
                    ++this.fLinefeedCounter;
                    this.fCharacterCounter = 1;
                } else {
                    ++this.fCharacterCounter;
                }
                ++index;
            }
            offset += index;
            this.fCurrentChunk = new CharDataChunk(this.fStringPool, this.fCurrentChunk);
            this.fillCurrentChunk();
            index = 0;
        }
    }

    public void callCharDataHandler(int offset, int endOffset, boolean inCDSect) throws Exception {
        int length = endOffset - offset;
        if (!this.fDocumentHandler.sendCharDataAsCharArray()) {
            int stringIndex = length == 0 ? 0 : this.fCurrentChunk.addString(offset, length);
            this.fDocumentHandler.characters(stringIndex, inCDSect);
            return;
        }
        CharDataChunk dataChunk = this.fCurrentChunk.chunkFor(offset);
        int index = offset & 0x3FFF;
        if (index + length <= 16384) {
            if (length != 0) {
                this.fDocumentHandler.characters(dataChunk.toCharArray(), index, length, inCDSect);
            }
            return;
        }
        int count = length;
        int nbytes = 16384 - index;
        this.fDocumentHandler.characters(dataChunk.toCharArray(), index, nbytes, inCDSect);
        count -= nbytes;
        do {
            if ((dataChunk = dataChunk.nextChunk()) == null) {
                this.fErrorHandler.error(167);
            }
            nbytes = count <= 16384 ? count : 16384;
            this.fDocumentHandler.characters(dataChunk.toCharArray(), 0, nbytes, inCDSect);
        } while ((count -= nbytes) > 0);
    }

    public void callWSCharDataHandler(int offset, int endOffset, boolean inCDSect) throws Exception {
        int contentSpecType = this.fScanner.getCurrentContentSpecType();
        if (contentSpecType != 4) {
            this.callCharDataHandler(offset, endOffset, inCDSect);
            return;
        }
        int length = endOffset - offset;
        if (!this.fDocumentHandler.sendCharDataAsCharArray()) {
            int stringIndex = length == 0 ? 0 : this.fCurrentChunk.addString(offset, length);
            this.fDocumentHandler.ignorableWhitespace(stringIndex, inCDSect);
            return;
        }
        CharDataChunk dataChunk = this.fCurrentChunk.chunkFor(offset);
        int index = offset & 0x3FFF;
        if (index + length <= 16384) {
            if (length != 0) {
                this.fDocumentHandler.ignorableWhitespace(dataChunk.toCharArray(), index, length, inCDSect);
            }
            return;
        }
        int count = length;
        int nbytes = 16384 - index;
        this.fDocumentHandler.ignorableWhitespace(dataChunk.toCharArray(), index, nbytes, inCDSect);
        count -= nbytes;
        do {
            dataChunk = dataChunk.nextChunk();
            nbytes = count <= 16384 ? count : 16384;
            this.fDocumentHandler.ignorableWhitespace(dataChunk.toCharArray(), 0, nbytes, inCDSect);
        } while ((count -= nbytes) > 0);
    }

    /*
     * Unable to fully structure code
     */
    protected int fillCurrentChunk() throws Exception {
        this.fOutputOffset = 0;
        if (this.fCheckOverflow) {
            if (this.fOverflowEnd < 16384) {
                if (this.fOverflowEnd > 0) {
                    this.fMostRecentData = new char[1 + this.fOverflowEnd - this.fOverflowOffset];
                    this.copyNormalize(this.fOverflow, this.fOverflowOffset, this.fMostRecentData, this.fOutputOffset);
                } else {
                    this.fMostRecentData = new char[1];
                }
                this.fMostRecentData[this.fOutputOffset] = '\u0000';
                this.fOverflow = null;
                this.fLength += this.fOutputOffset;
                this.fCurrentIndex = 0;
                this.fCurrentChunk.setCharArray(this.fMostRecentData);
                this.fMostRecentChar = this.fMostRecentData[0];
                return this.fMostRecentChar;
            }
            this.fMostRecentData = new char[16384];
            this.copyNormalize(this.fOverflow, this.fOverflowOffset, this.fMostRecentData, this.fOutputOffset);
            this.fCheckOverflow = false;
        } else {
            if (this.fOverflow == null) {
                this.fOverflow = new char[16384];
            }
            this.fMostRecentData = null;
        }
        do lbl-1000:
        // 3 sources

        {
            block12: {
                this.fOverflowOffset = 0;
                this.fOverflowEnd = 0;
                capacity = 16384;
                result = 0;
                do {
                    if ((result = this.fReader.read(this.fOverflow, this.fOverflowEnd, capacity)) == -1) {
                        this.fReader.close();
                        this.fReader = null;
                        if (this.fMostRecentData == null) {
                            this.fMostRecentData = new char[1 + this.fOverflowEnd];
                            this.copyNormalize(this.fOverflow, this.fOverflowOffset, this.fMostRecentData, this.fOutputOffset);
                            this.fOverflow = null;
                            this.fMostRecentData[this.fOutputOffset] = '\u0000';
                            break;
                        }
                        alldone = this.copyNormalize(this.fOverflow, this.fOverflowOffset, this.fMostRecentData, this.fOutputOffset);
                        if (alldone) {
                            if (this.fOverflowEnd == 16384) {
                                this.fCheckOverflow = true;
                                this.fOverflowOffset = 0;
                                this.fOverflowEnd = 0;
                                break;
                            }
                            this.fOverflow = null;
                            this.fMostRecentData[this.fOutputOffset] = '\u0000';
                            break;
                        }
                        this.fCheckOverflow = true;
                        break;
                    }
                    if (result <= 0) continue;
                    this.fOverflowEnd += result;
                    capacity -= result;
                } while (capacity > 0);
                if (result == -1) break;
                if (this.fMostRecentData == null) break block12;
                alldone = this.copyNormalize(this.fOverflow, this.fOverflowOffset, this.fMostRecentData, this.fOutputOffset);
                if (this.fOutputOffset != 16384) ** GOTO lbl-1000
                if (alldone) break;
                this.fCheckOverflow = true;
                break;
            }
            this.fMostRecentData = new char[16384];
            this.copyNormalize(this.fOverflow, this.fOverflowOffset, this.fMostRecentData, this.fOutputOffset);
        } while (this.fOutputOffset != 16384);
        this.fLength += this.fOutputOffset;
        this.fCurrentIndex = 0;
        this.fCurrentChunk.setCharArray(this.fMostRecentData);
        this.fMostRecentChar = this.fMostRecentData[0];
        return this.fMostRecentChar;
    }

    protected boolean copyNormalize(char[] in, int inOffset, char[] out, int outOffset) throws Exception {
        int inEnd = this.fOverflowEnd;
        int outEnd = out.length;
        if (inOffset == inEnd) {
            return true;
        }
        char b = in[inOffset];
        if (this.fSkipLinefeed) {
            this.fSkipLinefeed = false;
            if (b == '\n') {
                if (++inOffset == inEnd) {
                    return this.exitNormalize(inOffset, outOffset, true);
                }
                b = in[inOffset];
            }
        }
        while (outOffset < outEnd) {
            int inCount = inEnd - inOffset;
            int outCount = outEnd - outOffset;
            if (inCount > outCount) {
                inCount = outCount;
            }
            ++inOffset;
            while (true) {
                if (b == '\r') {
                    out[outOffset++] = 10;
                    if (inOffset == inEnd) {
                        this.fSkipLinefeed = true;
                        return this.exitNormalize(inOffset, outOffset, true);
                    }
                    b = in[inOffset];
                    if (b == '\n') {
                        if (++inOffset == inEnd) {
                            return this.exitNormalize(inOffset, outOffset, true);
                        }
                        b = in[inOffset];
                    }
                    if (outOffset == outEnd) {
                        return this.exitNormalize(inOffset, outOffset, false);
                    }
                    inCount = inEnd - inOffset;
                    outCount = outEnd - outOffset;
                    if (inCount > outCount) {
                        inCount = outCount;
                    }
                    ++inOffset;
                    continue;
                }
                do {
                    out[outOffset++] = b;
                } while (--inCount != 0 && (b = in[inOffset++]) != '\r');
                if (inCount == 0) break;
            }
            if (inOffset == inEnd) break;
        }
        return this.exitNormalize(inOffset, outOffset, inOffset == inEnd);
    }

    protected boolean exitNormalize(int inOffset, int outOffset, boolean result) {
        this.fOverflowOffset = inOffset;
        this.fOutputOffset = outOffset;
        return result;
    }

    protected final class CharDataChunk
    implements StringProducer {
        protected StringPool fInnerStringPool = null;
        protected int fChunk;
        protected char[] fData = null;
        protected CharDataChunk fPreviousChunk = null;
        protected CharDataChunk fNextChunk = null;

        public CharDataChunk(StringPool stringPool, CharDataChunk prev) throws Exception {
            this.fInnerStringPool = stringPool;
            this.fChunk = prev == null ? 0 : prev.fChunk + 1;
            this.fPreviousChunk = prev;
            if (prev != null) {
                prev.fNextChunk = this;
            }
        }

        protected CharDataChunk(CharDataChunk proto) {
            this.fInnerStringPool = proto.fInnerStringPool;
            this.fChunk = proto.fChunk;
            this.fData = proto.fData;
            this.fPreviousChunk = null;
            this.fNextChunk = null;
        }

        public CharDataChunk chunkFor(int offset) {
            int firstChunk = offset >> 14;
            CharDataChunk dataChunk = this;
            while (firstChunk != dataChunk.fChunk) {
                dataChunk = dataChunk.fPreviousChunk;
            }
            return dataChunk;
        }

        public char[] toCharArray() {
            return this.fData;
        }

        public void setCharArray(char[] data) {
            this.fData = data;
        }

        public CharDataChunk nextChunk() {
            return this.fNextChunk;
        }

        public void clearPreviousChunk() {
            if (this.fPreviousChunk != null) {
                this.fPreviousChunk.fNextChunk = null;
                this.fPreviousChunk = null;
            }
        }

        public String toString(int offset, int length) {
            if (offset + length <= 16384) {
                return new String(this.fData, offset, length);
            }
            StringBuffer sb = new StringBuffer(length);
            int nbytes = 16384 - offset;
            sb.append(this.fData, offset, nbytes);
            length -= nbytes;
            CharDataChunk aChunk = this.fNextChunk;
            do {
                nbytes = length <= 16384 ? length : 16384;
                sb.append(aChunk.fData, 0, nbytes);
                aChunk = aChunk.fNextChunk;
            } while ((length -= nbytes) > 0);
            String retval = sb.toString();
            sb = null;
            return retval;
        }

        public boolean equalsString(int offset, int length, String str, int strLength) {
            if (length != strLength) {
                return false;
            }
            if (offset + length <= 16384) {
                int i = 0;
                while (i < length) {
                    if (this.fData[offset++] != str.charAt(i)) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            int nbytes = 16384 - offset;
            int index = 0;
            while (index < nbytes) {
                if (this.fData[offset++] == str.charAt(index++)) continue;
                return false;
            }
            length -= nbytes;
            CharDataChunk aChunk = this.fNextChunk;
            do {
                offset = 0;
                nbytes = length <= 16384 ? length : 16384;
                length -= nbytes;
                while (nbytes-- > 0) {
                    if (aChunk.fData[offset++] == str.charAt(index++)) continue;
                    return false;
                }
                aChunk = aChunk.fNextChunk;
            } while (length > 0);
            return true;
        }

        protected CharDataChunk createClump(int lastChunk) {
            CharDataChunk result = new CharDataChunk(this);
            CharDataChunk nextChunk = this.fNextChunk;
            CharDataChunk aChunk = result;
            do {
                CharDataChunk next;
                aChunk.fNextChunk = next = new CharDataChunk(nextChunk);
                nextChunk = nextChunk.fNextChunk;
                aChunk = next;
            } while (aChunk.fChunk != lastChunk);
            return result;
        }

        public int addString(int offset, int length) {
            int chunk = offset >> 14;
            if (chunk != this.fChunk) {
                if (this.fPreviousChunk != null) {
                    return this.fPreviousChunk.addString(offset, length);
                }
                try {
                    CharReader.this.fErrorHandler.error(168);
                }
                catch (Exception exception) {}
                return -1;
            }
            int lastChunk = offset + length - 1 >> 14;
            if (chunk == lastChunk) {
                return this.fInnerStringPool.addString(this, offset & 0x3FFF, length);
            }
            return this.fInnerStringPool.addString(this.createClump(lastChunk), offset & 0x3FFF, length);
        }

        public int addSymbol(int offset, int length, int hashcode) {
            int chunk = offset >> 14;
            if (chunk != this.fChunk) {
                if (this.fPreviousChunk != null) {
                    return this.fPreviousChunk.addSymbol(offset, length, hashcode);
                }
                try {
                    CharReader.this.fErrorHandler.error(168);
                }
                catch (Exception exception) {}
                return -1;
            }
            int lastChunk = offset + length - 1 >> 14;
            int index = offset & 0x3FFF;
            if (chunk == lastChunk) {
                if (hashcode == 0) {
                    int i = 0;
                    while (i < length) {
                        hashcode = StringHasher.hashChar(hashcode, i, this.fData[index++] & 0xFFFF);
                        ++i;
                    }
                    hashcode = StringHasher.finishHash(hashcode);
                }
                return this.fInnerStringPool.addSymbol(this, offset & 0x3FFF, length, hashcode);
            }
            if (hashcode == 0) {
                int position = 0;
                int hlength = length;
                int nbytes = 16384 - index;
                while (index < 16384) {
                    hashcode = StringHasher.hashChar(hashcode, position++, this.fData[index++] & 0xFFFF);
                }
                hlength -= nbytes;
                CharDataChunk aChunk = this.fNextChunk;
                do {
                    index = 0;
                    nbytes = hlength <= 16384 ? hlength : 16384;
                    while (index < nbytes) {
                        hashcode = StringHasher.hashChar(hashcode, position++, aChunk.fData[index++] & 0xFFFF);
                    }
                    aChunk = aChunk.fNextChunk;
                } while ((hlength -= nbytes) > 0);
                hashcode = StringHasher.finishHash(hashcode);
            }
            return this.fInnerStringPool.addSymbol(this.createClump(lastChunk), offset & 0x3FFF, length, hashcode);
        }

        public void append(ChunkyCharArray charArray, int offset, int length) {
            int firstChunk = offset >> 14;
            CharDataChunk dataChunk = this;
            while (firstChunk != dataChunk.fChunk) {
                dataChunk = dataChunk.fPreviousChunk;
            }
            CharDataChunk dataChunk2 = dataChunk;
            int index = offset & 0x3FFF;
            int nbytes = index + length <= 16384 ? length : 16384 - index;
            while (true) {
                charArray.append(dataChunk2.fData, index, nbytes);
                if ((length -= nbytes) == 0) break;
                dataChunk2 = dataChunk2.fNextChunk;
                index = 0;
                nbytes = length <= 16384 ? length : 16384;
            }
        }
    }
}

