/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.framework;

import com.ibm.xml.framework.Catalog;
import com.ibm.xml.framework.ParserState;
import com.ibm.xml.framework.XMLDocumentHandler;
import com.ibm.xml.framework.XMLDocumentTypeHandler;
import com.ibm.xml.framework.XMLEntityHandler;
import com.ibm.xml.framework.XMLErrorHandler;
import com.ibm.xml.framework.XMLScanner;
import com.ibm.xml.framework.XMLValidationHandler;
import com.ibm.xml.internal.DefaultEntityHandler;
import com.ibm.xml.internal.DefaultScanner;
import com.ibm.xml.internal.DefaultValidationHandler;
import com.ibm.xml.internal.ErrorCode;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import org.xml.sax.DTDHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class XMLParser
implements Parser,
XMLDocumentTypeHandler,
XMLDocumentHandler,
XMLErrorHandler {
    private ParserState fParserState = new ParserState(this);
    protected XMLScanner fScanner = new DefaultScanner(this.fParserState);
    private XMLEntityHandler fEntityHandler = new DefaultEntityHandler(this.fParserState);
    private ErrorHandler fSAXErrorHandler = null;
    protected Locale fLocale = null;
    protected ResourceBundle fResourceBundle = null;
    private boolean fAllowJavaEncodingName = false;
    private boolean fWarningOnDuplicateAttDef = false;
    private boolean fCheckNamespace = false;
    private boolean fContinueAfterFatalError = false;
    protected boolean fParseInProgress = false;
    protected boolean fNeedReset = false;
    private XMLDocumentHandler fDocHandler = null;
    private XMLDocumentTypeHandler fDocTypeHandler = null;
    private XMLValidationHandler fValidationHandler = null;

    protected XMLParser() {
    }

    public void reset() {
        this.fParserState.reset();
        this.fScanner.reset(this.fParserState);
        this.fEntityHandler.reset(this.fParserState);
        this.fNeedReset = false;
    }

    protected void resetOrCopy() {
        ParserState parserState = this.fParserState;
        this.fParserState = new ParserState(parserState);
        this.fScanner.reset(this.fParserState);
        this.fEntityHandler.reset(this.fParserState);
        this.fNeedReset = false;
    }

    protected void checkHandlers() throws Exception {
    }

    public ParserState getParserState() {
        return this.fParserState;
    }

    public XMLScanner getScanner() {
        return this.fScanner;
    }

    protected Locator getLocator() {
        return this.fScanner.getLocator();
    }

    public void setAllowJavaEncodingName(boolean flag) {
        this.fAllowJavaEncodingName = flag;
    }

    public boolean getAllowJavaEncodingName() {
        return this.fAllowJavaEncodingName;
    }

    public void setWarningOnDuplicateAttDef(boolean flag) {
        this.fWarningOnDuplicateAttDef = flag;
    }

    public boolean getWarningOnDuplicateAttDef() {
        return this.fWarningOnDuplicateAttDef;
    }

    public void setCheckNamespace(boolean flag) {
        this.fCheckNamespace = flag;
    }

    public boolean getCheckNamespace() {
        return this.fCheckNamespace;
    }

    public void setContinueAfterFatalError(boolean flag) {
        this.fContinueAfterFatalError = flag;
    }

    public boolean getContinueAfterFatalError() {
        return this.fContinueAfterFatalError;
    }

    protected void setDocumentHandler(XMLDocumentHandler handler) {
        this.fDocHandler = handler;
    }

    public XMLDocumentHandler getDocumentHandler() {
        return this.fDocHandler;
    }

    protected void setDocumentTypeHandler(XMLDocumentTypeHandler handler) {
        this.fDocTypeHandler = handler;
    }

    public XMLDocumentTypeHandler getDocumentTypeHandler() {
        return this.fDocTypeHandler;
    }

    protected void setEntityHandler(XMLEntityHandler handler) {
        this.fEntityHandler = handler;
    }

    public XMLEntityHandler getEntityHandler() {
        return this.fEntityHandler;
    }

    public XMLErrorHandler getErrorHandler() {
        return this;
    }

    protected void setValidationHandler(XMLValidationHandler handler) {
        this.fValidationHandler = handler;
    }

    public XMLValidationHandler getValidationHandler() {
        return this.fValidationHandler;
    }

    protected void useDefaultValidationHandler() {
        this.fValidationHandler = new DefaultValidationHandler(this.fParserState);
    }

    public void loadCatalog(InputSource source) throws Exception {
        XMLEntityHandler handler = this.getEntityHandler();
        if (handler != null) {
            EntityResolver resolver = handler.getEntityResolver();
            if (resolver != null) {
                if (resolver instanceof Catalog) {
                    ((Catalog)resolver).loadCatalog(source);
                    return;
                }
                throw new Exception("EntityResolver is not a Catalog");
            }
            throw new Exception("Catalog not installed");
        }
        throw new Exception("XMLEntityHandler not installed");
    }

    public final void setLocale(Locale locale) throws SAXException {
        if (this.fParseInProgress) {
            throw new SAXException("setLocale may not be called while parsing");
        }
        if (this.fLocale != locale) {
            this.fLocale = locale;
            this.fResourceBundle = null;
        }
    }

    public void setEntityResolver(EntityResolver resolver) {
        if (this.fEntityHandler != null) {
            this.fEntityHandler.setEntityResolver(resolver);
        }
    }

    public void setDTDHandler(DTDHandler handler) {
    }

    public void setDocumentHandler(DocumentHandler handler) {
    }

    public void setErrorHandler(ErrorHandler handler) {
        this.fSAXErrorHandler = handler;
    }

    public final void parse(InputSource source) throws SAXException, IOException {
        if (this.fParseInProgress) {
            throw new SAXException("parse may not be called while parsing");
        }
        if (this.fNeedReset) {
            this.resetOrCopy();
        }
        try {
            this.checkHandlers();
            this.fParseInProgress = true;
            this.fNeedReset = true;
            this.fScanner.scanDocument(source);
            this.fParseInProgress = false;
            return;
        }
        catch (SAXException ex) {
            this.fParseInProgress = false;
            throw ex;
        }
        catch (IOException ex) {
            this.fParseInProgress = false;
            throw ex;
        }
        catch (Exception ex) {
            this.fParseInProgress = false;
            throw new SAXException(ex);
        }
    }

    public final void parse(String systemId) throws SAXException, IOException {
        InputSource source = new InputSource(systemId);
        this.parse(source);
        try {
            Reader reader = source.getCharacterStream();
            if (reader != null) {
                reader.close();
                return;
            }
            InputStream is = source.getByteStream();
            if (is != null) {
                is.close();
                return;
            }
        }
        catch (IOException iOException) {}
    }

    public boolean sendCharDataAsCharArray() {
        return false;
    }

    protected boolean errorHandlingEnabled() {
        return this.fSAXErrorHandler != null;
    }

    protected void handleError(String errorKey, String errorMsg) throws Exception {
        SAXParseException spe = new SAXParseException(errorMsg, this.getLocator());
        if (this.fSAXErrorHandler == null) {
            if (this.isFatal(errorKey)) {
                throw spe;
            }
            return;
        }
        if (this.isWarning(errorKey)) {
            this.fSAXErrorHandler.warning(spe);
            return;
        }
        if (this.isFatal(errorKey)) {
            this.fSAXErrorHandler.fatalError(spe);
            return;
        }
        this.fSAXErrorHandler.error(spe);
    }

    protected final String getErrorMsgString(String errorKey, Object[] errorArgs) {
        if (this.fResourceBundle == null) {
            this.fResourceBundle = this.fLocale == null ? ResourceBundle.getBundle("com.ibm.xml.internal.msg.Message") : ResourceBundle.getBundle("com.ibm.xml.internal.msg.Message", this.fLocale);
        }
        String retval = this.fResourceBundle.getString(errorKey);
        if (errorArgs != null) {
            retval = MessageFormat.format(retval, errorArgs);
        }
        return retval;
    }

    protected final boolean isWarning(String errorKey) {
        boolean warning = errorKey.startsWith("W_");
        return warning;
    }

    protected final boolean isFatal(String errorKey) {
        boolean fatal = errorKey.startsWith("E_");
        return fatal;
    }

    public final void error(int errorCode) throws Exception {
        if (!this.errorHandlingEnabled()) {
            return;
        }
        String errorKey = ErrorCode.getErrorKey(errorCode);
        String errorMsg = this.getErrorMsgString(errorKey, null);
        this.handleError(errorKey, errorMsg);
    }

    public final void error1(int errorCode, int stringIndex1) throws Exception {
        boolean fatal;
        String errorKey = ErrorCode.getErrorKey(errorCode);
        if (!this.errorHandlingEnabled() && !(fatal = errorKey.startsWith("E_"))) {
            this.fParserState.getStringPool().releaseString(stringIndex1);
            return;
        }
        Object[] errorArgs = new String[]{this.fParserState.getStringPool().orphanString(stringIndex1)};
        String errorMsg = this.getErrorMsgString(errorKey, errorArgs);
        this.handleError(errorKey, errorMsg);
    }

    public final void error2(int errorCode, int stringIndex1, int stringIndex2) throws Exception {
        boolean fatal;
        String errorKey = ErrorCode.getErrorKey(errorCode);
        if (!this.errorHandlingEnabled() && !(fatal = errorKey.startsWith("E_"))) {
            this.fParserState.getStringPool().releaseString(stringIndex1);
            this.fParserState.getStringPool().releaseString(stringIndex2);
            return;
        }
        Object[] errorArgs = new String[]{this.fParserState.getStringPool().orphanString(stringIndex1), this.fParserState.getStringPool().orphanString(stringIndex2)};
        String errorMsg = this.getErrorMsgString(errorKey, errorArgs);
        this.handleError(errorKey, errorMsg);
    }

    public final void error3(int errorCode, int stringIndex1, int stringIndex2, int stringIndex3) throws Exception {
        boolean fatal;
        String errorKey = ErrorCode.getErrorKey(errorCode);
        if (!this.errorHandlingEnabled() && !(fatal = errorKey.startsWith("E_"))) {
            this.fParserState.getStringPool().releaseString(stringIndex1);
            this.fParserState.getStringPool().releaseString(stringIndex2);
            this.fParserState.getStringPool().releaseString(stringIndex3);
            return;
        }
        Object[] errorArgs = new String[]{this.fParserState.getStringPool().orphanString(stringIndex1), this.fParserState.getStringPool().orphanString(stringIndex2), this.fParserState.getStringPool().orphanString(stringIndex3)};
        String errorMsg = this.getErrorMsgString(errorKey, errorArgs);
        this.handleError(errorKey, errorMsg);
    }

    public final void error4(int errorCode, int stringIndex1, int stringIndex2, int stringIndex3, int stringIndex4) throws Exception {
        boolean fatal;
        String errorKey = ErrorCode.getErrorKey(errorCode);
        if (!(this.errorHandlingEnabled() || !this.getContinueAfterFatalError() && (fatal = errorKey.startsWith("E_")))) {
            this.fParserState.getStringPool().releaseString(stringIndex1);
            this.fParserState.getStringPool().releaseString(stringIndex2);
            this.fParserState.getStringPool().releaseString(stringIndex3);
            this.fParserState.getStringPool().releaseString(stringIndex4);
            return;
        }
        Object[] errorArgs = new String[]{this.fParserState.getStringPool().orphanString(stringIndex1), this.fParserState.getStringPool().orphanString(stringIndex2), this.fParserState.getStringPool().orphanString(stringIndex3), this.fParserState.getStringPool().orphanString(stringIndex4)};
        String errorMsg = this.getErrorMsgString(errorKey, errorArgs);
        this.handleError(errorKey, errorMsg);
    }

    public abstract void externalEntityDecl(int var1) throws Exception;

    public abstract void unparsedEntityDecl(int var1) throws Exception;

    public abstract void startExternalSubset(int var1, int var2) throws Exception;

    public abstract void doctypeDecl(int var1) throws Exception;

    public abstract void endExternalSubset() throws Exception;

    public abstract void internalEntityDecl(int var1) throws Exception;

    public abstract void attlistDecl(int var1, int var2) throws Exception;

    public abstract void notationDecl(int var1) throws Exception;

    public abstract void startDocument(int var1, int var2, int var3) throws Exception;

    public abstract void ignorableWhitespace(char[] var1, int var2, int var3, boolean var4) throws Exception;

    public abstract void ignorableWhitespace(int var1, boolean var2) throws Exception;

    public abstract void elementDecl(int var1) throws Exception;

    public abstract void processingInstruction(int var1, int var2) throws Exception;

    public abstract void endElement(int var1) throws Exception;

    public abstract void startInternalSubset() throws Exception;

    public abstract void endInternalSubset() throws Exception;

    public abstract void endDocument() throws Exception;

    public abstract void comment(int var1) throws Exception;

    public abstract void characters(char[] var1, int var2, int var3, boolean var4) throws Exception;

    public abstract void characters(int var1, boolean var2) throws Exception;

    public abstract void startEntityReference(int var1) throws Exception;

    public abstract void endEntityReference(int var1) throws Exception;

    public abstract void startElement(int var1, int var2) throws Exception;
}

