/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.framework;

import com.ibm.xml.framework.StringPool;
import com.ibm.xml.framework.StringProducer;
import com.ibm.xml.internal.StringHasher;

public final class ChunkyCharArray {
    protected static final int INITIAL_CHUNK_SHIFT = 7;
    protected static final int INITIAL_CHUNK_SIZE = 128;
    protected static final int CHUNK_SHIFT = 14;
    protected static final int CHUNK_SIZE = 16384;
    protected static final int CHUNK_MASK = 16383;
    protected CharArrayChunk fCurrentChunk = null;
    protected int fLength = 0;

    public ChunkyCharArray(StringPool stringPool) {
        this.fCurrentChunk = new CharArrayChunk(stringPool, null);
    }

    public int length() {
        return this.fLength;
    }

    public void setLength(int length) {
        CharArrayChunk charArrayChunk = this.fCurrentChunk;
        charArrayChunk.ChunkyCharArray.this.fLength = length;
        int firstChunk = length >> 14;
        CharArrayChunk dataChunk = charArrayChunk;
        while (firstChunk != dataChunk.fChunk) {
            dataChunk = dataChunk.fPreviousChunk;
        }
        charArrayChunk.ChunkyCharArray.this.fCurrentChunk = dataChunk;
        charArrayChunk.fCurrentIndex = length & 0x3FFF;
    }

    public void append(char ch) {
        this.fCurrentChunk.append(ch);
    }

    public void append(String s) {
        int slen = s.length();
        int i = 0;
        while (i < slen) {
            this.fCurrentChunk.append(s.charAt(i));
            ++i;
        }
    }

    public void append(char[] ch, int offset, int length) {
        while (length-- > 0) {
            this.fCurrentChunk.append(ch[offset++]);
        }
    }

    public void append(ChunkyCharArray charArray, int offset, int length) {
        this.fCurrentChunk.append(charArray, offset, length);
    }

    public int addString(int offset, int length) {
        if (length == 0) {
            return 0;
        }
        return this.fCurrentChunk.addString(offset, length);
    }

    public int addSymbol(int offset, int length) {
        if (length == 0) {
            return 0;
        }
        return this.fCurrentChunk.addSymbol(offset, length);
    }

    protected final class CharArrayChunk
    implements StringProducer {
        protected StringPool fStringPool = null;
        protected int fChunk = -1;
        protected int fCurrentIndex = 0;
        protected char[] fData = null;
        protected CharArrayChunk fPreviousChunk = null;
        protected CharArrayChunk fNextChunk = null;

        public CharArrayChunk(StringPool stringPool, CharArrayChunk prev) {
            this.fStringPool = stringPool;
            this.fChunk = prev == null ? 0 : prev.fChunk + 1;
            this.fPreviousChunk = prev;
            if (prev != null) {
                prev.fNextChunk = this;
            }
        }

        protected CharArrayChunk(CharArrayChunk proto) {
            this.fStringPool = proto.fStringPool;
            this.fChunk = proto.fChunk;
            this.fData = proto.fData;
            this.fPreviousChunk = null;
            this.fNextChunk = null;
        }

        protected CharArrayChunk chunkFor(int offset) {
            int firstChunk = offset >> 14;
            CharArrayChunk dataChunk = this;
            while (firstChunk != dataChunk.fChunk) {
                dataChunk = dataChunk.fPreviousChunk;
            }
            return dataChunk;
        }

        public void setLength(int length) {
            ChunkyCharArray.this.fLength = length;
            int firstChunk = length >> 14;
            CharArrayChunk dataChunk = this;
            while (firstChunk != dataChunk.fChunk) {
                dataChunk = dataChunk.fPreviousChunk;
            }
            ChunkyCharArray.this.fCurrentChunk = dataChunk;
            this.fCurrentIndex = length & 0x3FFF;
        }

        public void append(char ch) {
            try {
                this.fData[this.fCurrentIndex] = ch;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                if (this.fCurrentIndex == 16384) {
                    ChunkyCharArray.this.fCurrentChunk = new CharArrayChunk(this.fStringPool, this);
                    ChunkyCharArray.this.fCurrentChunk.append(ch);
                    return;
                }
                char[] newData = new char[this.fCurrentIndex * 2];
                System.arraycopy(this.fData, 0, newData, 0, this.fCurrentIndex);
                this.fData = newData;
                this.fData[this.fCurrentIndex] = ch;
            }
            catch (NullPointerException nullPointerException) {
                this.fData = new char[128];
                this.fData[this.fCurrentIndex] = ch;
            }
            ++ChunkyCharArray.this.fLength;
            ++this.fCurrentIndex;
        }

        public void append(ChunkyCharArray charArray, int offset, int length) {
            int firstChunk = offset >> 14;
            CharArrayChunk dataChunk = this;
            while (firstChunk != dataChunk.fChunk) {
                dataChunk = dataChunk.fPreviousChunk;
            }
            CharArrayChunk dataChunk2 = dataChunk;
            int index = offset & 0x3FFF;
            if (index + length <= 16384) {
                charArray.append(dataChunk2.fData, index, length);
                return;
            }
            int nbytes = 16384 - index;
            charArray.append(dataChunk2.fData, index, nbytes);
            length -= nbytes;
            do {
                dataChunk2 = dataChunk2.fNextChunk;
                nbytes = length <= 16384 ? length : 16384;
                charArray.append(dataChunk2.fData, 0, nbytes);
            } while ((length -= nbytes) > 0);
        }

        protected CharArrayChunk createClump(int lastChunk) {
            CharArrayChunk result = new CharArrayChunk(this);
            CharArrayChunk nextChunk = this.fNextChunk;
            CharArrayChunk aChunk = result;
            do {
                CharArrayChunk next;
                aChunk.fNextChunk = next = new CharArrayChunk(nextChunk);
                nextChunk = nextChunk.fNextChunk;
                aChunk = next;
            } while (aChunk.fChunk != lastChunk);
            return result;
        }

        public int addString(int offset, int length) {
            int chunk = offset >> 14;
            if (chunk != this.fChunk) {
                if (this.fPreviousChunk != null) {
                    return this.fPreviousChunk.addString(offset, length);
                }
                System.out.println("fPreviousChunk == null");
                return -1;
            }
            int lastChunk = offset + length - 1 >> 14;
            if (chunk == lastChunk) {
                return this.fStringPool.addString(this, offset & 0x3FFF, length);
            }
            if (this.fNextChunk == null) {
                System.out.println("fNextChunk == null");
            }
            return this.fStringPool.addString(this.createClump(lastChunk), offset & 0x3FFF, length);
        }

        public int addSymbol(int offset, int length) {
            int chunk = offset >> 14;
            if (chunk != this.fChunk) {
                if (this.fPreviousChunk != null) {
                    return this.fPreviousChunk.addSymbol(offset, length);
                }
                System.out.println("fPreviousChunk == null");
                return -1;
            }
            int lastChunk = offset + length - 1 >> 14;
            int index = offset & 0x3FFF;
            if (chunk == lastChunk) {
                int hashcode = 0;
                int i = 0;
                while (i < length) {
                    hashcode = StringHasher.hashChar(hashcode, i, this.fData[index++] & 0xFFFF);
                    ++i;
                }
                hashcode = StringHasher.finishHash(hashcode);
                return this.fStringPool.addSymbol(this, offset & 0x3FFF, length, hashcode);
            }
            int hashcode = 0;
            int position = 0;
            int hlength = length;
            int nbytes = 16384 - index;
            while (index < 16384) {
                hashcode = StringHasher.hashChar(hashcode, position++, this.fData[index++] & 0xFFFF);
            }
            hlength -= nbytes;
            CharArrayChunk aChunk = this.fNextChunk;
            do {
                index = 0;
                nbytes = hlength <= 16384 ? hlength : 16384;
                while (index < nbytes) {
                    hashcode = StringHasher.hashChar(hashcode, position++, aChunk.fData[index++] & 0xFFFF);
                }
                aChunk = aChunk.fNextChunk;
            } while ((hlength -= nbytes) > 0);
            hashcode = StringHasher.finishHash(hashcode);
            return this.fStringPool.addSymbol(this.createClump(lastChunk), offset & 0x3FFF, length, hashcode);
        }

        public String toString(int offset, int length) {
            if (offset + length <= 16384) {
                return new String(this.fData, offset, length);
            }
            StringBuffer sb = new StringBuffer(length);
            int nbytes = 16384 - offset;
            sb.append(this.fData, offset, nbytes);
            length -= nbytes;
            CharArrayChunk aChunk = this.fNextChunk;
            do {
                nbytes = length <= 16384 ? length : 16384;
                sb.append(aChunk.fData, 0, nbytes);
                aChunk = aChunk.fNextChunk;
            } while ((length -= nbytes) > 0);
            String retval = sb.toString();
            sb = null;
            return retval;
        }

        public boolean equalsString(int offset, int length, String str, int strLength) {
            if (length != strLength) {
                return false;
            }
            if (offset + length <= 16384) {
                int i = 0;
                while (i < length) {
                    if (this.fData[offset++] != str.charAt(i)) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            int nbytes = 16384 - offset;
            int index = 0;
            while (index < nbytes) {
                if (this.fData[offset++] == str.charAt(index++)) continue;
                return false;
            }
            length -= nbytes;
            CharArrayChunk aChunk = this.fNextChunk;
            do {
                offset = 0;
                nbytes = length <= 16384 ? length : 16384;
                length -= nbytes;
                while (nbytes-- > 0) {
                    if (aChunk.fData[offset++] == str.charAt(index++)) continue;
                    return false;
                }
                aChunk = aChunk.fNextChunk;
            } while (length > 0);
            return true;
        }
    }
}

