/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.dom;

import com.ibm.xml.dom.AttrImpl;
import com.ibm.xml.dom.DOMExceptionImpl;
import com.ibm.xml.dom.NodeImpl;
import java.util.Enumeration;
import java.util.Vector;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class NamedNodeMapImpl
implements NamedNodeMap {
    protected Vector nodes = new Vector();
    protected Document ownerDoc;
    protected NamedNodeMapImpl defaults;
    protected int changes;
    protected int lastDefaultsChanges = -1;
    protected boolean readOnly = false;
    protected int elementNode = -1;

    protected NamedNodeMapImpl(Document ownerDoc, NamedNodeMapImpl defaults) {
        this.ownerDoc = ownerDoc;
        this.defaults = defaults;
    }

    public int getLength() {
        this.reconcileDefaults();
        if (this.nodes != null) {
            return this.nodes.size();
        }
        return 0;
    }

    public Node item(int index) {
        this.reconcileDefaults();
        if (this.nodes != null && index < this.nodes.size()) {
            return (Node)this.nodes.elementAt(index);
        }
        return null;
    }

    public Node getNamedItem(String name) {
        int i = this.findNamePoint(name);
        if (i < 0) {
            return null;
        }
        return (Node)this.nodes.elementAt(i);
    }

    public Node setNamedItem(Node arg) throws DOMException {
        if (arg.getOwnerDocument() != this.ownerDoc) {
            throw new DOMExceptionImpl(4, null);
        }
        if (arg instanceof AttrImpl && ((AttrImpl)arg).owned) {
            throw new DOMExceptionImpl(10, null);
        }
        int i = this.findNamePoint(arg.getNodeName());
        Node previous = null;
        if (i >= 0) {
            previous = (Node)this.nodes.elementAt(i);
            this.nodes.setElementAt(arg, i);
        } else {
            i = -1 - i;
            if (this.nodes == null) {
                this.nodes = new Vector();
            }
            this.nodes.insertElementAt(arg, i);
        }
        ++this.changes;
        return previous;
    }

    public Node removeNamedItem(String name) throws DOMException {
        Node d;
        int i = this.findNamePoint(name);
        if (i < 0) {
            throw new DOMExceptionImpl(8, null);
        }
        Node n = (Node)this.nodes.elementAt(i);
        if (this.defaults != null && (d = this.defaults.getNamedItem(name)) != null) {
            this.nodes.setElementAt(d, i);
        } else {
            this.nodes.removeElementAt(i);
        }
        ++this.changes;
        return n;
    }

    public NamedNodeMapImpl cloneMap() {
        NamedNodeMapImpl newmap = new NamedNodeMapImpl(this.ownerDoc, this.defaults);
        if (this.nodes != null) {
            newmap.nodes = new Vector(this.nodes.size());
            int i = 0;
            while (i < this.nodes.size()) {
                newmap.nodes.addElement(((NodeImpl)this.nodes.elementAt(i)).cloneNode(true));
                ++i;
            }
        }
        newmap.defaults = this.defaults;
        return newmap;
    }

    void setReadOnly(boolean readOnly, boolean deep) {
        this.readOnly = readOnly;
        if (deep && this.nodes != null) {
            Enumeration e = this.nodes.elements();
            while (e.hasMoreElements()) {
                ((NodeImpl)e.nextElement()).setReadOnly(readOnly, deep);
            }
        }
    }

    private int findNamePoint(String name) {
        this.reconcileDefaults();
        int i = 0;
        if (this.nodes != null) {
            int first = 0;
            int last = this.nodes.size() - 1;
            while (first <= last) {
                i = (first + last) / 2;
                int test2 = name.compareTo(((Node)this.nodes.elementAt(i)).getNodeName());
                if (test2 == 0) {
                    return i;
                }
                if (test2 < 0) {
                    last = i - 1;
                    continue;
                }
                first = i + 1;
            }
            if (first > i) {
                i = first;
            }
        }
        return -1 - i;
    }

    protected void reconcileDefaults() {
        if (this.defaults != null && this.lastDefaultsChanges != this.defaults.changes) {
            int n = 0;
            int d = 0;
            int nsize = this.nodes.size();
            int dsize = this.defaults.nodes.size();
            Attr nnode = nsize == 0 ? null : (Attr)this.nodes.elementAt(0);
            Attr dnode = dsize == 0 ? null : (Attr)this.defaults.nodes.elementAt(0);
            while (n < nsize && d < dsize) {
                nnode = (Attr)this.nodes.elementAt(n);
                dnode = (Attr)this.defaults.nodes.elementAt(d);
                int test2 = nnode.getNodeName().compareTo(dnode.getNodeName());
                if (test2 == 0 && !nnode.getSpecified()) {
                    this.nodes.setElementAt(dnode, n);
                    ++n;
                    ++d;
                    continue;
                }
                if (test2 > 0) {
                    this.nodes.insertElementAt(dnode, n);
                    ++n;
                    ++d;
                    continue;
                }
                if (!nnode.getSpecified()) {
                    this.nodes.removeElementAt(n);
                    continue;
                }
                ++n;
            }
            while (d < dsize) {
                this.nodes.addElement(this.defaults.nodes.elementAt(d++));
            }
            this.lastDefaultsChanges = this.defaults.changes;
        }
    }
}

