/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.dom;

import com.ibm.xml.dom.AttrImpl;
import com.ibm.xml.dom.DOMExceptionImpl;
import com.ibm.xml.dom.DeepNodeListImpl;
import com.ibm.xml.dom.DocumentImpl;
import com.ibm.xml.dom.DocumentTypeImpl;
import com.ibm.xml.dom.ElementDefinitionImpl;
import com.ibm.xml.dom.NamedNodeMapImpl;
import com.ibm.xml.dom.NodeImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class ElementImpl
extends NodeImpl
implements Element {
    protected NamedNodeMapImpl attributes;

    ElementImpl(DocumentImpl ownerDoc, int nodeIndex) {
        super(ownerDoc, nodeIndex);
        this.setupDefaultAttributes(ownerDoc);
        int index = ownerDoc.getAttributeList(nodeIndex);
        while (index != -1) {
            this.setAttributeNode((Attr)((Object)ownerDoc.getNodeObject(index)));
            index = ownerDoc.getNextSibling(index);
        }
    }

    public ElementImpl(DocumentImpl ownerDoc, String name) {
        super(ownerDoc, name, null);
        this.setupDefaultAttributes(ownerDoc);
    }

    protected void setupDefaultAttributes(DocumentImpl ownerDoc) {
        ElementDefinitionImpl eldef;
        NamedNodeMapImpl defaultAttrs = null;
        DocumentTypeImpl doctype = (DocumentTypeImpl)ownerDoc.getDoctype();
        if (doctype != null && (eldef = (ElementDefinitionImpl)doctype.getElements().getNamedItem(this.getNodeName())) != null) {
            defaultAttrs = (NamedNodeMapImpl)eldef.getAttributes();
        }
        this.attributes = new NamedNodeMapImpl(ownerDoc, defaultAttrs);
    }

    public short getNodeType() {
        return 1;
    }

    public String getNodeValue() {
        return null;
    }

    public void setNodeValue(String value) throws DOMException {
        throw new DOMExceptionImpl(7, null);
    }

    public NamedNodeMap getAttributes() {
        return this.attributes;
    }

    public Node cloneNode(boolean deep) {
        ElementImpl newnode = (ElementImpl)super.cloneNode(deep);
        newnode.attributes = this.attributes.cloneMap();
        return newnode;
    }

    public String getValue() {
        return null;
    }

    public String getAttribute(String name) {
        Attr attr = (Attr)this.attributes.getNamedItem(name);
        if (attr == null) {
            return "";
        }
        return attr.getValue();
    }

    public Attr getAttributeNode(String name) {
        return (Attr)this.attributes.getNamedItem(name);
    }

    public NodeList getElementsByTagName(String tagname) {
        return new DeepNodeListImpl(this, tagname);
    }

    public String getTagName() {
        if (this.syncData) {
            this.synchronizeData();
        }
        return this.name;
    }

    public void normalize() {
        Node kid = this.getFirstChild();
        while (kid != null) {
            Node next = kid.getNextSibling();
            if (next != null && kid.getNodeType() == 3 && next.getNodeType() == 3) {
                ((Text)kid).appendData(next.getNodeValue());
                this.removeChild(next);
                next = kid;
            } else if (kid.getNodeType() == 1) {
                ((Element)kid).normalize();
            }
            kid = next;
        }
    }

    public void removeAttribute(String name) {
        if (this.readOnly) {
            throw new DOMExceptionImpl(7, null);
        }
        AttrImpl att = (AttrImpl)this.attributes.getNamedItem(name);
        if (att != null) {
            att.owned = false;
            this.attributes.removeNamedItem(name);
        }
    }

    public Attr removeAttributeNode(Attr oldAttr) throws DOMException {
        if (this.readOnly) {
            throw new DOMExceptionImpl(7, null);
        }
        AttrImpl found = (AttrImpl)this.attributes.getNamedItem(oldAttr.getName());
        if (found == oldAttr) {
            this.attributes.removeNamedItem(oldAttr.getName());
            found.owned = false;
            return found;
        }
        throw new DOMExceptionImpl(8, null);
    }

    public void setAttribute(String name, String value) {
        if (this.readOnly) {
            throw new DOMExceptionImpl(7, null);
        }
        AttrImpl newAttr = (AttrImpl)this.getOwnerDocument().createAttribute(name);
        newAttr.setNodeValue(value);
        this.attributes.setNamedItem(newAttr);
        newAttr.owned = true;
    }

    public Attr setAttributeNode(Attr newAttr) throws DOMException {
        if (this.readOnly) {
            throw new DOMExceptionImpl(7, null);
        }
        if (!(newAttr instanceof AttrImpl)) {
            throw new DOMExceptionImpl(4, null);
        }
        AttrImpl na = (AttrImpl)newAttr;
        AttrImpl oldAttr = (AttrImpl)this.attributes.getNamedItem(newAttr.getName());
        this.attributes.setNamedItem(na);
        na.owned = true;
        return oldAttr;
    }

    public void setReadOnly(boolean readOnly, boolean deep) {
        super.setReadOnly(readOnly, deep);
        this.attributes.setReadOnly(readOnly, true);
    }
}

