/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.dom;

import com.ibm.xml.dom.DOMExceptionImpl;
import com.ibm.xml.dom.DocumentImpl;
import com.ibm.xml.dom.NodeImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

public class AttrImpl
extends NodeImpl
implements Attr {
    protected boolean owned;
    protected boolean specified = true;

    AttrImpl(DocumentImpl ownerDocument, int nodeIndex) {
        super(ownerDocument, nodeIndex);
        this.specified = this.ownerDocument.getIntNodeValue(nodeIndex) == 1;
    }

    public AttrImpl(DocumentImpl ownerDocument, String name) {
        super(ownerDocument, name, null);
    }

    public short getNodeType() {
        return 2;
    }

    public void setNodeValue(String value) throws DOMException {
        this.setValue(value);
    }

    public String getNodeValue() {
        return this.getValue();
    }

    public String getName() {
        if (this.syncData) {
            this.synchronizeData();
        }
        return this.name;
    }

    public void setValue(String value) {
        if (this.readOnly) {
            throw new DOMExceptionImpl(7, null);
        }
        this.firstChild = null;
        this.lastChild = null;
        this.syncChildren = false;
        if (value != null) {
            this.appendChild(this.ownerDocument.createTextNode(value));
        }
        this.specified = true;
        this.changed();
    }

    public String getValue() {
        StringBuffer value = new StringBuffer();
        Node node = this.getFirstChild();
        while (node != null) {
            value.append(node.getNodeValue());
            node = node.getNextSibling();
        }
        return value.toString();
    }

    public boolean getSpecified() {
        return this.specified;
    }

    public void setSpecified(boolean arg) {
        this.specified = arg;
    }

    public String toString() {
        return String.valueOf(this.getName()) + "=" + "\"" + this.getValue() + "\"";
    }
}

