/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.ga.functions;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Random;
import org.biojava.bio.BioError;
import org.biojava.utils.ChangeVetoException;
import org.biojavax.ga.GeneticAlgorithm;
import org.biojavax.ga.Organism;
import org.biojavax.ga.Population;
import org.biojavax.ga.exception.IllegalOrganismException;
import org.biojavax.ga.functions.SelectionFunction;
import org.biojavax.ga.impl.SimplePopulation;

public class TournamentSelection
implements SelectionFunction {
    private int selpressure;

    public TournamentSelection() {
        this.setSelectionPressure(10);
    }

    public void setSelectionPressure(int numberOfIndividuals) {
        this.selpressure = numberOfIndividuals;
    }

    public Population select(Population pop, GeneticAlgorithm genAlg) throws ChangeVetoException {
        return this.selectNIndividuals(pop, genAlg, pop.size());
    }

    public Population selectNIndividuals(Population pop, GeneticAlgorithm ga, int n) {
        SimplePopulation nextgen = new SimplePopulation();
        if (this.selpressure <= 0) {
            System.out.println("Sorry can't select with a selection pressure <= 0");
            return null;
        }
        int q = this.selpressure;
        Random r = new Random();
        for (int i = 0; i < n; ++i) {
            if (q > pop.size()) {
                q = pop.size();
            }
            double bestvalue = Double.MIN_VALUE;
            Organism best = null;
            LinkedList<Organism> subpopulation = new LinkedList<Organism>();
            while (subpopulation.size() < q) {
                Iterator it = pop.organisms();
                Organism current = (Organism)it.next();
                for (int pos = r.nextInt(pop.size()); pos > 0; --pos) {
                    current = (Organism)it.next();
                }
                while (subpopulation.contains(current)) {
                    if (!it.hasNext()) {
                        it = pop.organisms();
                    }
                    current = (Organism)it.next();
                }
                double[] value = current.getFitness();
                if (value[0] >= bestvalue) {
                    best = current;
                    bestvalue = value[0];
                }
                subpopulation.add(current);
            }
            try {
                if (best == null) continue;
                String namesprefix = best.getName().split(":")[0];
                Organism o = best.replicate(namesprefix + ":" + i);
                nextgen.addOrganism(o);
                continue;
            }
            catch (IllegalOrganismException e) {
                e.printStackTrace();
            }
        }
        pop.removeAllOrganisms();
        Iterator it = nextgen.organisms();
        while (it.hasNext()) {
            try {
                pop.addOrganism((Organism)it.next());
            }
            catch (ChangeVetoException e) {
                e.printStackTrace();
            }
            catch (IllegalOrganismException ex) {
                throw new BioError("A previously legal organism is now illegal??", ex);
            }
        }
        pop = nextgen;
        return nextgen;
    }
}

