/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.ga.functions;

import java.util.Iterator;
import org.biojava.bio.BioError;
import org.biojava.utils.ChangeVetoException;
import org.biojavax.ga.GeneticAlgorithm;
import org.biojavax.ga.Organism;
import org.biojavax.ga.Population;
import org.biojavax.ga.exception.IllegalOrganismException;
import org.biojavax.ga.functions.SelectionFunction;
import org.biojavax.ga.util.WeightedSet;

public class ProportionalSelection
implements SelectionFunction {
    public Population select(Population pop, GeneticAlgorithm genAlg) throws ChangeVetoException {
        WeightedSet set = new WeightedSet();
        int size = pop.size();
        Iterator i = pop.organisms();
        while (i.hasNext()) {
            Object item = i.next();
            double[] fit = ((Organism)item).getFitness();
            set.setWeight(item, fit[0]);
        }
        pop.removeAllOrganisms();
        for (int i2 = 0; i2 < size; ++i2) {
            try {
                Organism o = (Organism)set.sample();
                String name = o.getName().split(":")[0];
                if (name.equals("")) {
                    name = o.getName();
                }
                o = o.replicate(name + ":" + i2);
                pop.addOrganism(o);
                continue;
            }
            catch (IllegalOrganismException ex) {
                throw new BioError("A previously legal organism is now illegal??", ex);
            }
        }
        return pop;
    }
}

