/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.bio.seq.io;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.io.ParseException;
import org.biojava.bio.seq.io.SeqIOListener;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.SimpleSymbolList;
import org.biojava.bio.symbol.Symbol;
import org.biojava.utils.ChangeVetoException;
import org.biojavax.CrossRef;
import org.biojavax.DocRef;
import org.biojavax.DocRefAuthor;
import org.biojavax.Namespace;
import org.biojavax.Note;
import org.biojavax.RankedCrossRef;
import org.biojavax.RankedDocRef;
import org.biojavax.RichObjectFactory;
import org.biojavax.SimpleComment;
import org.biojavax.SimpleCrossRef;
import org.biojavax.SimpleDocRef;
import org.biojavax.SimpleRankedCrossRef;
import org.biojavax.SimpleRankedDocRef;
import org.biojavax.SimpleRichAnnotation;
import org.biojavax.bio.seq.CompoundRichLocation;
import org.biojavax.bio.seq.Position;
import org.biojavax.bio.seq.RichFeature;
import org.biojavax.bio.seq.RichLocation;
import org.biojavax.bio.seq.RichSequence;
import org.biojavax.bio.seq.SimplePosition;
import org.biojavax.bio.seq.SimpleRichLocation;
import org.biojavax.bio.seq.io.GenbankLocationParser;
import org.biojavax.bio.seq.io.RichSeqIOListener;
import org.biojavax.bio.seq.io.RichSequenceFormat;
import org.biojavax.bio.taxa.NCBITaxon;
import org.biojavax.bio.taxa.SimpleNCBITaxon;
import org.biojavax.ontology.ComparableTerm;
import org.biojavax.utils.StringTools;

public class GenbankFormat
extends RichSequenceFormat.HeaderlessFormat {
    public static final String GENBANK_FORMAT = "GENBANK";
    protected static final String LOCUS_TAG = "LOCUS";
    protected static final String DEFINITION_TAG = "DEFINITION";
    protected static final String ACCESSION_TAG = "ACCESSION";
    protected static final String VERSION_TAG = "VERSION";
    protected static final String KEYWORDS_TAG = "KEYWORDS";
    protected static final String SOURCE_TAG = "SOURCE";
    protected static final String ORGANISM_TAG = "ORGANISM";
    protected static final String REFERENCE_TAG = "REFERENCE";
    protected static final String AUTHORS_TAG = "AUTHORS";
    protected static final String CONSORTIUM_TAG = "CONSRTM";
    protected static final String TITLE_TAG = "TITLE";
    protected static final String JOURNAL_TAG = "JOURNAL";
    protected static final String PUBMED_TAG = "PUBMED";
    protected static final String MEDLINE_TAG = "MEDLINE";
    protected static final String REMARK_TAG = "REMARK";
    protected static final String COMMENT_TAG = "COMMENT";
    protected static final String FEATURE_TAG = "FEATURES";
    protected static final String BASE_COUNT_TAG_FULL = "BASE COUNT";
    protected static final String BASE_COUNT_TAG = "BASE";
    protected static final String START_SEQUENCE_TAG = "ORIGIN";
    protected static final String END_SEQUENCE_TAG = "//";
    protected static final Pattern lp;
    protected static final Pattern vp;
    protected static final Pattern refRange;
    protected static final Pattern refp;
    protected static final Pattern dbxp;
    protected static final Pattern sectp;
    protected static final Pattern readableFiles;
    protected static final Pattern headerLine;
    private static final HashSet isNotQuoted;
    private String sectionKey = null;
    private NCBITaxon tax = null;
    private String organism = null;
    private String accession = null;
    private String identifier = null;

    public boolean canRead(File file) throws IOException {
        if (readableFiles.matcher(file.getName()).matches()) {
            return true;
        }
        BufferedReader br = new BufferedReader(new FileReader(file));
        String firstLine = br.readLine();
        boolean readable = firstLine != null && headerLine.matcher(firstLine).matches();
        br.close();
        return readable;
    }

    public SymbolTokenization guessSymbolTokenization(File file) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(file));
        String firstLine = br.readLine();
        boolean dna = firstLine.indexOf("DNA") > 0 || firstLine.indexOf("RNA") > 0;
        br.close();
        if (dna) {
            return RichSequence.IOTools.getDNAParser();
        }
        return RichSequence.IOTools.getProteinParser();
    }

    public boolean canRead(BufferedInputStream stream) throws IOException {
        stream.mark(2000);
        BufferedReader br = new BufferedReader(new InputStreamReader(stream));
        String firstLine = br.readLine();
        boolean readable = firstLine != null && headerLine.matcher(firstLine).matches();
        stream.reset();
        return readable;
    }

    public SymbolTokenization guessSymbolTokenization(BufferedInputStream stream) throws IOException {
        stream.mark(2000);
        BufferedReader br = new BufferedReader(new InputStreamReader(stream));
        String firstLine = br.readLine();
        boolean dna = firstLine.indexOf("DNA") > 0 || firstLine.indexOf("RNA") > 0;
        stream.reset();
        if (dna) {
            return RichSequence.IOTools.getDNAParser();
        }
        return RichSequence.IOTools.getProteinParser();
    }

    public boolean readSequence(BufferedReader reader, SymbolTokenization symParser, SeqIOListener listener) throws IllegalSymbolException, IOException, ParseException {
        if (!(listener instanceof RichSeqIOListener)) {
            throw new IllegalArgumentException("Only accepting RichSeqIOListeners today");
        }
        return this.readRichSequence(reader, symParser, (RichSeqIOListener)listener, null);
    }

    public boolean readRichSequence(BufferedReader reader, SymbolTokenization symParser, RichSeqIOListener rlistener, Namespace ns) throws IllegalSymbolException, IOException, ParseException {
        boolean hasAnotherSequence;
        block74: {
            int c;
            this.sectionKey = null;
            this.tax = null;
            this.organism = null;
            this.accession = null;
            this.identifier = null;
            hasAnotherSequence = true;
            rlistener.startSequence();
            if (ns == null) {
                ns = RichObjectFactory.getDefaultNamespace();
            }
            rlistener.setNamespace(ns);
            List section = null;
            try {
                do {
                    section = this.readSection(reader);
                    this.sectionKey = ((String[])section.get(0))[0];
                    if (this.sectionKey == null) {
                        String message = ParseException.newMessage(this.getClass(), this.accession, this.identifier, "Section key was null", this.sectionToString(section));
                        throw new ParseException(message);
                    }
                    if (this.sectionKey.equals(LOCUS_TAG)) {
                        String loc = ((String[])section.get(0))[1];
                        Matcher m = lp.matcher(loc);
                        if (m.matches()) {
                            String stranded;
                            rlistener.setName(m.group(1));
                            this.accession = m.group(1);
                            rlistener.setAccession(this.accession);
                            if (m.group(4) != null) {
                                rlistener.addSequenceProperty(Terms.getMolTypeTerm(), m.group(4));
                            }
                            if ((stranded = m.group(3)) != null && stranded.equals("ss-")) {
                                stranded = "single";
                            } else if (stranded != null && stranded.equals("ms-")) {
                                stranded = "mixed";
                            } else if (stranded != null && stranded.equals("ds-")) {
                                stranded = "double";
                            }
                            String circular = m.group(5);
                            String fifth = m.group(6);
                            String sixth = m.group(7);
                            if (stranded != null) {
                                rlistener.addSequenceProperty(Terms.getStrandedTerm(), stranded);
                            }
                            if (circular != null && circular.equalsIgnoreCase("circular")) {
                                rlistener.setCircular(true);
                            }
                            if (sixth != null) {
                                rlistener.setDivision(fifth);
                                rlistener.addSequenceProperty(Terms.getDateUpdatedTerm(), sixth);
                                continue;
                            }
                            if (fifth == null) continue;
                            rlistener.addSequenceProperty(Terms.getDateUpdatedTerm(), fifth);
                            continue;
                        }
                        String message = ParseException.newMessage(this.getClass(), this.accession, this.identifier, "Bad locus line", this.sectionToString(section));
                        throw new ParseException(message);
                    }
                    if (this.sectionKey.equals(DEFINITION_TAG)) {
                        rlistener.setDescription(((String[])section.get(0))[1]);
                        continue;
                    }
                    if (this.sectionKey.equals(ACCESSION_TAG)) {
                        String[] accs = ((String[])section.get(0))[1].split("\\s+");
                        this.accession = accs[0].trim();
                        rlistener.setAccession(this.accession);
                        for (int i = 1; i < accs.length; ++i) {
                            rlistener.addSequenceProperty(Terms.getAdditionalAccessionTerm(), accs[i].trim());
                        }
                    } else {
                        if (this.sectionKey.equals(VERSION_TAG)) {
                            String ver = ((String[])section.get(0))[1];
                            Matcher m = vp.matcher(ver);
                            if (m.matches()) {
                                String verAcc = m.group(1);
                                if (!this.accession.equals(verAcc)) {
                                    rlistener.addSequenceProperty(Terms.getAdditionalAccessionTerm(), this.accession);
                                    this.accession = verAcc;
                                    rlistener.setAccession(this.accession);
                                }
                                if (m.group(3) != null) {
                                    rlistener.setVersion(Integer.parseInt(m.group(3)));
                                }
                                if (m.group(5) == null) continue;
                                this.identifier = m.group(5);
                                rlistener.setIdentifier(this.identifier);
                                continue;
                            }
                            String message = ParseException.newMessage(this.getClass(), this.accession, this.identifier, "Bad version line", this.sectionToString(section));
                            throw new ParseException(message);
                        }
                        if (this.sectionKey.equals(KEYWORDS_TAG)) {
                            String val = ((String[])section.get(0))[1];
                            if (val.endsWith(".")) {
                                val = val.substring(0, val.length() - 1);
                            }
                            val = val.replace('\n', ' ');
                            String[] kws = val.split(";");
                            for (int i = 0; i < kws.length; ++i) {
                                String kw = kws[i].trim();
                                if (kw.length() == 0) continue;
                                rlistener.addSequenceProperty(Terms.getKeywordTerm(), kw);
                            }
                        } else {
                            if (this.sectionKey.equals(SOURCE_TAG)) continue;
                            if (this.sectionKey.equals(REFERENCE_TAG) && !this.getElideReferences()) {
                                int ref_rank;
                                List baseRangeList = null;
                                String ref = ((String[])section.get(0))[1];
                                Matcher m = refp.matcher(ref);
                                if (m.matches()) {
                                    ref_rank = Integer.parseInt(m.group(1));
                                    if (m.group(3) != null) {
                                        baseRangeList = this.buildBaseRanges(m.group(3));
                                    }
                                } else {
                                    String message = ParseException.newMessage(this.getClass(), this.accession, this.identifier, "Bad reference line", this.sectionToString(section));
                                    throw new ParseException(message);
                                }
                                String authors = null;
                                String consortium = null;
                                String title = null;
                                String journal = null;
                                String medline = null;
                                String pubmed = null;
                                String remark = null;
                                for (int i = 1; i < section.size(); ++i) {
                                    String key = ((String[])section.get(i))[0];
                                    String val = ((String[])section.get(i))[1];
                                    if (key.equals(AUTHORS_TAG)) {
                                        authors = val.replace('\n', ' ');
                                        continue;
                                    }
                                    if (key.equals(CONSORTIUM_TAG)) {
                                        consortium = val.replace('\n', ' ');
                                        continue;
                                    }
                                    if (key.equals(TITLE_TAG)) {
                                        title = val.replace('\n', ' ');
                                        continue;
                                    }
                                    if (key.equals(JOURNAL_TAG)) {
                                        journal = val.replace('\n', ' ');
                                        continue;
                                    }
                                    if (key.equals(MEDLINE_TAG)) {
                                        medline = val;
                                        continue;
                                    }
                                    if (key.equals(PUBMED_TAG)) {
                                        pubmed = val;
                                        continue;
                                    }
                                    if (!key.equals(REMARK_TAG)) continue;
                                    remark = val.replace('\n', ' ');
                                }
                                try {
                                    if (authors == null) {
                                        authors = consortium + " (consortium)";
                                    } else if (consortium != null) {
                                        authors = authors + ", " + consortium + " (consortium)";
                                    }
                                    DocRef dr = null;
                                    if (medline != null) {
                                        dr = (DocRef)RichObjectFactory.getObject(SimpleDocRef.class, new Object[]{DocRefAuthor.Tools.parseAuthorString(authors), journal, title, MEDLINE_TAG, medline, new Integer(0)});
                                        if (dr.getCrossref() == null) {
                                            dr.setCrossref((CrossRef)RichObjectFactory.getObject(SimpleCrossRef.class, new Object[]{MEDLINE_TAG, medline, new Integer(0)}));
                                        }
                                    } else if (pubmed != null) {
                                        dr = (DocRef)RichObjectFactory.getObject(SimpleDocRef.class, new Object[]{DocRefAuthor.Tools.parseAuthorString(authors), journal, title, PUBMED_TAG, pubmed, new Integer(0)});
                                        if (dr.getCrossref() == null) {
                                            dr.setCrossref((CrossRef)RichObjectFactory.getObject(SimpleCrossRef.class, new Object[]{PUBMED_TAG, pubmed, new Integer(0)}));
                                        }
                                    } else {
                                        dr = (DocRef)RichObjectFactory.getObject(SimpleDocRef.class, new Object[]{DocRefAuthor.Tools.parseAuthorString(authors), journal, title});
                                    }
                                    if (!this.getElideComments()) {
                                        dr.setRemark(remark);
                                    }
                                    SimpleRankedDocRef rdr = baseRangeList == null ? new SimpleRankedDocRef(dr, null, null, ref_rank) : (baseRangeList.size() == 1 ? new SimpleRankedDocRef(dr, new Integer(((RichLocation)baseRangeList.get(0)).getMin()), new Integer(((RichLocation)baseRangeList.get(0)).getMax()), ref_rank) : new SimpleRankedDocRef(dr, new CompoundRichLocation(baseRangeList), ref_rank));
                                    rlistener.setRankedDocRef(rdr);
                                }
                                catch (ChangeVetoException e) {
                                    throw new ParseException(e + ", accession:" + this.accession);
                                }
                            } else {
                                if (this.sectionKey.equals(COMMENT_TAG) && !this.getElideComments()) {
                                    rlistener.setComment(((String[])section.get(0))[1]);
                                    continue;
                                }
                                if (this.sectionKey.equals(FEATURE_TAG) && !this.getElideFeatures()) {
                                    boolean seenAFeature = false;
                                    int rcrossrefCount = 0;
                                    boolean skippingBond = false;
                                    for (int i = 1; i < section.size(); ++i) {
                                        String key = ((String[])section.get(i))[0];
                                        String val = ((String[])section.get(i))[1];
                                        if (key.startsWith("/")) {
                                            if (skippingBond) continue;
                                            key = key.substring(1);
                                            if ((val = val.replaceAll("\\s*[\\n\\r]+\\s*", " ").trim()).endsWith("\"")) {
                                                val = val.substring(1, val.length() - 1);
                                            }
                                            if (key.equals("db_xref")) {
                                                Matcher m = dbxp.matcher(val);
                                                if (m.matches()) {
                                                    String dbname = m.group(1);
                                                    String raccession = m.group(2);
                                                    if (dbname.equalsIgnoreCase("taxon")) {
                                                        this.tax = (NCBITaxon)RichObjectFactory.getObject(SimpleNCBITaxon.class, new Object[]{Integer.valueOf(raccession)});
                                                        rlistener.setTaxon(this.tax);
                                                        try {
                                                            if (this.organism == null) continue;
                                                            this.tax.addName("scientific name", this.organism.replace('\n', ' '));
                                                            continue;
                                                        }
                                                        catch (ChangeVetoException e) {
                                                            throw new ParseException(e + ", accession:" + this.accession);
                                                        }
                                                    }
                                                    try {
                                                        CrossRef cr = (CrossRef)RichObjectFactory.getObject(SimpleCrossRef.class, new Object[]{dbname, raccession, new Integer(0)});
                                                        SimpleRankedCrossRef rcr = new SimpleRankedCrossRef(cr, ++rcrossrefCount);
                                                        rlistener.getCurrentFeature().addRankedCrossRef(rcr);
                                                        continue;
                                                    }
                                                    catch (ChangeVetoException e) {
                                                        throw new ParseException(e + ", accession:" + this.accession);
                                                    }
                                                }
                                                String message = ParseException.newMessage(this.getClass(), this.accession, this.identifier, "Bad dbxref", this.sectionToString(section));
                                                throw new ParseException(message);
                                            }
                                            if (key.equalsIgnoreCase("organism")) {
                                                try {
                                                    this.organism = val;
                                                    if (this.tax == null) continue;
                                                    this.tax.addName("scientific name", this.organism.replace('\n', ' '));
                                                    continue;
                                                }
                                                catch (ChangeVetoException e) {
                                                    throw new ParseException(e + ", accession:" + this.accession);
                                                }
                                            }
                                            if (key.equalsIgnoreCase("translation")) {
                                                val = val.replaceAll("\\s+", "");
                                            }
                                            rlistener.addFeatureProperty(RichObjectFactory.getDefaultOntology().getOrCreateTerm(key), val);
                                            continue;
                                        }
                                        if (key.equalsIgnoreCase("bond")) {
                                            skippingBond = true;
                                            continue;
                                        }
                                        skippingBond = false;
                                        if (seenAFeature) {
                                            rlistener.endFeature();
                                        }
                                        RichFeature.Template templ = new RichFeature.Template();
                                        templ.annotation = new SimpleRichAnnotation();
                                        templ.sourceTerm = Terms.getGenBankTerm();
                                        templ.typeTerm = RichObjectFactory.getDefaultOntology().getOrCreateTerm(key);
                                        templ.featureRelationshipSet = new TreeSet();
                                        templ.rankedCrossRefs = new TreeSet();
                                        String tidyLocStr = val.replaceAll("\\s+", "");
                                        templ.location = GenbankLocationParser.parseLocation(ns, this.accession, tidyLocStr);
                                        rlistener.startFeature(templ);
                                        seenAFeature = true;
                                        rcrossrefCount = 0;
                                    }
                                    if (!seenAFeature) continue;
                                    rlistener.endFeature();
                                    continue;
                                }
                                if (this.sectionKey.equals(BASE_COUNT_TAG) || !this.sectionKey.equals(START_SEQUENCE_TAG) || this.getElideSymbols()) continue;
                                StringBuffer seq = new StringBuffer();
                                for (int i = 1; i < section.size(); ++i) {
                                    seq.append(((String[])section.get(i))[1]);
                                }
                                try {
                                    SimpleSymbolList sl = new SimpleSymbolList(symParser, seq.toString().replaceAll("\\s+", "").replaceAll("[\\.|~]", "-"));
                                    rlistener.addSymbols(symParser.getAlphabet(), sl.toList().toArray(new Symbol[0]), 0, sl.length());
                                }
                                catch (IllegalAlphabetException e) {
                                    String message = ParseException.newMessage(this.getClass(), this.accession, this.identifier, "Bad sequence section", this.sectionToString(section));
                                    throw new ParseException(e, message);
                                }
                            }
                        }
                    }
                } while (!this.sectionKey.equals(END_SEQUENCE_TAG));
            }
            catch (RuntimeException e) {
                String message = ParseException.newMessage(this.getClass(), this.accession, this.identifier, "Bad sequence section", this.sectionToString(section));
                throw new ParseException(e, message);
            }
            do {
                reader.mark(1);
                c = reader.read();
                if (c != -1) continue;
                hasAnotherSequence = false;
                break block74;
            } while (Character.isWhitespace((char)c));
            reader.reset();
        }
        rlistener.endSequence();
        return hasAnotherSequence;
    }

    private List readSection(BufferedReader br) throws ParseException {
        ArrayList<String[]> section = new ArrayList<String[]>();
        String currKey = null;
        StringBuffer currVal = new StringBuffer();
        boolean done = false;
        int linecount = 0;
        try {
            while (!done) {
                String firstSecKey;
                br.mark(320);
                String line = br.readLine();
                String string = firstSecKey = section.size() == 0 ? "" : ((String[])section.get(0))[0];
                if (line != null && line.matches("\\p{Space}*")) continue;
                if (line == null || !line.startsWith(" ") && linecount++ > 0 && (!firstSecKey.equals(START_SEQUENCE_TAG) || line.startsWith(END_SEQUENCE_TAG))) {
                    section.add(new String[]{currKey, currVal.toString()});
                    br.reset();
                    done = true;
                    continue;
                }
                Matcher m = sectp.matcher(line);
                if (m.matches()) {
                    if (currKey != null) {
                        section.add(new String[]{currKey, currVal.toString()});
                    }
                    currKey = m.group(2) == null ? (m.group(4) == null ? m.group(6) : m.group(4)) : m.group(2);
                    currVal = new StringBuffer();
                    currVal.append((m.group(2) == null ? (m.group(4) == null ? "" : m.group(5)) : m.group(3)).trim());
                    continue;
                }
                if (line.startsWith(START_SEQUENCE_TAG) || line.startsWith(END_SEQUENCE_TAG)) {
                    currKey = line;
                    continue;
                }
                currVal.append("\n");
                currVal.append(currKey.charAt(0) == '/' ? line.substring(21) : line.substring(12));
            }
        }
        catch (IOException e) {
            String message = ParseException.newMessage(this.getClass(), this.accession, this.identifier, "", this.sectionToString(section));
            throw new ParseException(e, message);
        }
        catch (RuntimeException e) {
            String message = ParseException.newMessage(this.getClass(), this.accession, this.identifier, "Bad section", this.sectionToString(section));
            throw new ParseException(e, message);
        }
        return section;
    }

    private final List buildBaseRanges(String theBaseRangeList) throws ParseException {
        if (theBaseRangeList == null) {
            return null;
        }
        ArrayList<SimpleRichLocation> baseRangeList = new ArrayList<SimpleRichLocation>();
        String[] baseRange = theBaseRangeList.split(";");
        try {
            for (int r = 0; r < baseRange.length; ++r) {
                Matcher rangeMatch = refRange.matcher(baseRange[r]);
                if (!rangeMatch.matches()) {
                    String message = ParseException.newMessage(this.getClass(), this.accession, this.identifier, "Bad reference range found", theBaseRangeList);
                    throw new ParseException(message);
                }
                int rangeStart = Integer.parseInt(rangeMatch.group(1));
                int rangeEnd = Integer.parseInt(rangeMatch.group(2));
                baseRangeList.add(new SimpleRichLocation((Position)new SimplePosition(rangeStart), new SimplePosition(rangeEnd), r));
            }
            return baseRangeList;
        }
        catch (RuntimeException e) {
            String message = ParseException.newMessage(this.getClass(), this.accession, this.identifier, "Bad base range", theBaseRangeList);
            throw new ParseException(e, message);
        }
    }

    public void writeSequence(Sequence seq, PrintStream os) throws IOException {
        if (this.getPrintStream() == null) {
            this.setPrintStream(os);
        }
        this.writeSequence(seq, RichObjectFactory.getDefaultNamespace());
    }

    public void writeSequence(Sequence seq, String format, PrintStream os) throws IOException {
        if (this.getPrintStream() == null) {
            this.setPrintStream(os);
        }
        if (!format.equals(this.getDefaultFormat())) {
            throw new IllegalArgumentException("Unknown format: " + format);
        }
        this.writeSequence(seq, RichObjectFactory.getDefaultNamespace());
    }

    /*
     * WARNING - void declaration
     */
    public void writeSequence(Sequence seq, Namespace ns) throws IOException {
        Comparable c;
        SymbolTokenization tok;
        RichSequence rs;
        try {
            rs = seq instanceof RichSequence ? (RichSequence)seq : RichSequence.Tools.enrich(seq);
        }
        catch (ChangeVetoException e) {
            IOException e2 = new IOException("Unable to enrich sequence");
            e2.initCause(e);
            throw e2;
        }
        try {
            tok = rs.getAlphabet().getTokenization("token");
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to get alphabet tokenizer", e);
        }
        Set notes = rs.getNoteSet();
        String accession = rs.getAccession();
        StringBuffer accessions = new StringBuffer();
        accessions.append(accession);
        String stranded = "";
        String udat = "";
        String moltype = rs.getAlphabet().getName();
        if ("PROTEIN-TERM".equals(moltype) || "PROTEIN".equals(moltype)) {
            moltype = null;
        }
        StringBuffer keywords = new StringBuffer();
        for (Note n : notes) {
            if (n.getTerm().equals(Terms.getStrandedTerm())) {
                String value = n.getValue();
                if (value != null && value.equals("single")) {
                    stranded = "ss-";
                    continue;
                }
                if (value == null || !value.equals("mixed")) continue;
                stranded = "ms-";
                continue;
            }
            if (n.getTerm().equals(Terms.getDateUpdatedTerm())) {
                udat = n.getValue();
                continue;
            }
            if (n.getTerm().equals(Terms.getMolTypeTerm())) {
                moltype = n.getValue();
                continue;
            }
            if (n.getTerm().equals(Terms.getAdditionalAccessionTerm())) {
                accessions.append(" ");
                accessions.append(n.getValue());
                continue;
            }
            if (!n.getTerm().equals(Terms.getKeywordTerm()) || n.getValue() == null) continue;
            if (keywords.length() > 0) {
                keywords.append("; ");
            }
            keywords.append(n.getValue());
        }
        if (moltype != null && moltype.length() > 6) {
            moltype = moltype.indexOf("DNA") != -1 ? "DNA" : (moltype.indexOf("RNA") != -1 ? "RNA" : "NA");
        }
        StringBuffer locusLine = new StringBuffer();
        locusLine.append(StringTools.rightPad(rs.getName(), 16));
        locusLine.append(" ");
        locusLine.append(StringTools.leftPad("" + rs.length(), 11));
        locusLine.append(" " + (moltype == null ? "aa" : "bp") + " ");
        locusLine.append(StringTools.leftPad(stranded, 3));
        locusLine.append(StringTools.rightPad(moltype == null ? "" : moltype, 6));
        locusLine.append("  ");
        locusLine.append(StringTools.rightPad(rs.getCircular() ? "circular" : "linear", 8));
        locusLine.append(" ");
        locusLine.append(StringTools.rightPad(rs.getDivision() == null ? "" : rs.getDivision(), 3));
        locusLine.append(" ");
        locusLine.append(StringTools.rightPad(udat, 11));
        StringTools.writeKeyValueLine(LOCUS_TAG, locusLine.toString(), 12, this.getLineWidth(), this.getPrintStream());
        StringTools.writeKeyValueLine(DEFINITION_TAG, rs.getDescription(), 12, this.getLineWidth(), this.getPrintStream());
        StringTools.writeKeyValueLine(ACCESSION_TAG, accessions.toString(), 12, this.getLineWidth(), this.getPrintStream());
        String version = accession + "." + rs.getVersion();
        if (rs.getIdentifier() != null) {
            version = version + "  GI:" + rs.getIdentifier();
        }
        StringTools.writeKeyValueLine(VERSION_TAG, version, 12, this.getLineWidth(), this.getPrintStream());
        keywords.append(".");
        StringTools.writeKeyValueLine(KEYWORDS_TAG, keywords.toString(), 12, this.getLineWidth() - 1, this.getPrintStream());
        NCBITaxon tax = rs.getTaxon();
        if (tax != null) {
            StringTools.writeKeyValueLine(SOURCE_TAG, (GenbankFormat.isMitochondrial(rs) ? "mitochondrion " : "") + tax.getDisplayName(), 12, this.getLineWidth(), this.getPrintStream());
            StringTools.writeKeyValueLine("  ORGANISM", tax.getDisplayName().split("\\s+\\(")[0] + "\n" + tax.getNameHierarchy(), 12, this.getLineWidth() - 1, this.getPrintStream());
        }
        for (RankedDocRef rdr : rs.getRankedDocRefs()) {
            DocRef docRef = rdr.getDocumentReference();
            StringTools.writeKeyValueLine(REFERENCE_TAG, rdr.getRank() + (rdr.getLocation() == null || rdr.getLocation() == RichLocation.EMPTY_LOCATION ? "" : (moltype == null ? "  (residues " : "  (bases ") + GenbankFormat.makeBaseRange(rdr) + ")"), 12, this.getLineWidth(), this.getPrintStream());
            StringTools.writeKeyValueLine("  AUTHORS", docRef.getAuthors(), 12, this.getLineWidth() - 1, this.getPrintStream());
            StringTools.writeKeyValueLine("  TITLE", docRef.getTitle(), 12, this.getLineWidth(), this.getPrintStream());
            StringTools.writeKeyValueLine("  JOURNAL", docRef.getLocation(), 12, this.getLineWidth(), this.getPrintStream());
            c = docRef.getCrossref();
            if (c != null) {
                StringTools.writeKeyValueLine(StringTools.leftPad(c.getDbname(), 9), c.getAccession(), 12, this.getLineWidth(), this.getPrintStream());
            }
            StringTools.writeKeyValueLine("  REMARK", docRef.getRemark(), 12, this.getLineWidth(), this.getPrintStream());
        }
        Set comments = rs.getComments();
        if (!comments.isEmpty()) {
            StringBuffer sb = new StringBuffer();
            Iterator iterator = comments.iterator();
            while (iterator.hasNext()) {
                c = (SimpleComment)iterator.next();
                sb.append(c.getComment());
                if (!iterator.hasNext()) continue;
                sb.append("\n");
            }
            StringTools.writeKeyValueLine(COMMENT_TAG, sb.toString(), 12, this.getLineWidth(), this.getPrintStream());
        }
        this.getPrintStream().println("FEATURES             Location/Qualifiers");
        for (RichFeature richFeature : rs.getFeatureSet()) {
            StringTools.writeKeyValueLine("     " + richFeature.getTypeTerm().getName(), GenbankLocationParser.writeLocation((RichLocation)richFeature.getLocation()), 21, this.getLineWidth() - 1, ",", this.getPrintStream());
            for (Note n : richFeature.getNoteSet()) {
                if (n.getValue() == null || n.getValue().length() == 0) {
                    StringTools.writeKeyValueLine("", "/" + n.getTerm().getName(), 21, this.getLineWidth(), this.getPrintStream());
                    continue;
                }
                if (GenbankFormat.isNotQuoted(n)) {
                    StringTools.writeKeyValueLine("", "/" + n.getTerm().getName() + "=" + n.getValue(), 21, this.getLineWidth(), this.getPrintStream());
                    continue;
                }
                if (n.getTerm().getName().equals("translation")) {
                    StringTools.writeKeyValueLine("", "/" + n.getTerm().getName() + "=\"" + n.getValue() + "\"", 21, this.getLineWidth() - 1, this.getPrintStream());
                    continue;
                }
                StringTools.writeKeyValueLine("", "/" + n.getTerm().getName() + "=\"" + n.getValue() + "\"", 21, this.getLineWidth(), this.getPrintStream());
            }
            if (richFeature.getType().equals("source") && tax != null) {
                String displayName = tax.getDisplayName();
                if (displayName.indexOf(40) > -1) {
                    displayName = displayName.substring(0, displayName.indexOf(40)).trim();
                }
                StringTools.writeKeyValueLine("", "/organism=\"" + displayName + "\"", 21, this.getLineWidth() - 1, this.getPrintStream());
                for (RankedCrossRef rcr : richFeature.getRankedCrossRefs()) {
                    CrossRef cr = rcr.getCrossRef();
                    StringTools.writeKeyValueLine("", "/db_xref=\"" + cr.getDbname() + ":" + cr.getAccession() + "\"", 21, this.getLineWidth(), this.getPrintStream());
                }
                StringTools.writeKeyValueLine("", "/db_xref=\"taxon:" + tax.getNCBITaxID() + "\"", 21, this.getLineWidth(), this.getPrintStream());
                continue;
            }
            for (RankedCrossRef rcr : richFeature.getRankedCrossRefs()) {
                CrossRef cr = rcr.getCrossRef();
                StringTools.writeKeyValueLine("", "/db_xref=\"" + cr.getDbname() + ":" + cr.getAccession() + "\"", 21, this.getLineWidth(), this.getPrintStream());
            }
        }
        this.getPrintStream().println(START_SEQUENCE_TAG);
        Symbol[] syms = rs.toList().toArray(new Symbol[0]);
        boolean bl = false;
        int symCount = 0;
        for (int i = 0; i < syms.length; ++i) {
            if (symCount % 60 == 0) {
                void var17_26;
                if (var17_26 > 0) {
                    this.getPrintStream().print("\n");
                }
                void lineNum = var17_26 * 60 + true;
                this.getPrintStream().print(StringTools.leftPad("" + (int)lineNum, 9));
                ++var17_26;
            }
            if (symCount % 10 == 0) {
                this.getPrintStream().print(" ");
            }
            try {
                this.getPrintStream().print(tok.tokenizeSymbol(syms[i]));
            }
            catch (IllegalSymbolException e) {
                throw new RuntimeException("Found illegal symbol: " + syms[i]);
            }
            ++symCount;
        }
        if (syms.length > 0) {
            this.getPrintStream().print("\n");
        }
        this.getPrintStream().println(END_SEQUENCE_TAG);
    }

    public String getDefaultFormat() {
        return GENBANK_FORMAT;
    }

    private static final boolean isMitochondrial(RichSequence theSequence) {
        Set<Feature> featureSet = theSequence.getFeatureSet();
        for (RichFeature richFeature : featureSet) {
            if (!richFeature.getType().equals("source")) continue;
            Set noteSet = richFeature.getNoteSet();
            for (Note note : noteSet) {
                if (!note.getTerm().getName().equals("organelle")) continue;
                return note.getValue().equals("mitochondrion");
            }
        }
        return false;
    }

    private static final boolean isNotQuoted(Note theNote) {
        return GenbankFormat.isNotQuoted(theNote.getTerm().getName(), theNote.getValue());
    }

    private static final boolean isNotQuoted(String theName, String theValue) {
        return isNotQuoted.contains(theName);
    }

    private static final String makeBaseRange(RankedDocRef theReference) {
        return theReference.getLocation() == null ? theReference.getStart() + " to " + theReference.getEnd() : GenbankFormat.toString(theReference.getLocation());
    }

    private static final String toString(RichLocation theLocation) {
        StringBuffer list = new StringBuffer();
        Iterator<Location> b = theLocation.blockIterator();
        while (b.hasNext()) {
            RichLocation location = (RichLocation)b.next();
            list.append(location.getMin() + " to " + location.getMax());
            if (!b.hasNext()) continue;
            list.append("; ");
        }
        return list.toString();
    }

    String sectionToString(List section) {
        StringBuffer parseBlock = new StringBuffer();
        ListIterator i = section.listIterator();
        while (i.hasNext()) {
            String[] part = (String[])i.next();
            for (int x = 0; x < part.length; ++x) {
                parseBlock.append(part[x]);
                if (x != 0) continue;
                parseBlock.append("   ");
            }
        }
        return parseBlock.toString();
    }

    static {
        RichSequence.IOTools.registerFormat(GenbankFormat.class);
        lp = Pattern.compile("^(\\S+)\\s+\\d+\\s+(bp|aa)\\s{1,4}([dms]s-)?(\\S+)?\\s+(circular|linear)?\\s*(\\S+)?\\s*(\\S+)?$");
        vp = Pattern.compile("^(\\S*?)(\\.(\\d+))?(\\s+GI:(\\S+))?$");
        refRange = Pattern.compile("^\\s*(\\d+)\\s+to\\s+(\\d+)$");
        refp = Pattern.compile("^(\\d+)\\s*(?:(\\((?:bases|residues)\\s+(\\d+\\s+to\\s+\\d+(\\s*;\\s*\\d+\\s+to\\s+\\d+)*)\\))|\\(sites\\))?");
        dbxp = Pattern.compile("^([^:]+):(\\S+)$");
        sectp = Pattern.compile("^(\\s{0,8}(\\S+)\\s{1,7}(.*)|\\s{21}(/\\S+?)=(.*)|\\s{21}(/\\S+))$");
        readableFiles = Pattern.compile(".*(g[bp]k*$|\\u002eg[bp].*)");
        headerLine = Pattern.compile("^LOCUS.*");
        isNotQuoted = new HashSet();
        isNotQuoted.add("anticodon");
        isNotQuoted.add("citation");
        isNotQuoted.add("codon");
        isNotQuoted.add("codon_start");
        isNotQuoted.add("compare");
        isNotQuoted.add("cons_splice");
        isNotQuoted.add("direction");
        isNotQuoted.add("estimated_length");
        isNotQuoted.add("label");
        isNotQuoted.add("mod_base");
        isNotQuoted.add("number");
        isNotQuoted.add("rpt_type");
        isNotQuoted.add("rpt_unit_range");
        isNotQuoted.add("transl_except");
        isNotQuoted.add("transl_table");
    }

    public static class Terms
    extends RichSequence.Terms {
        public static ComparableTerm getGenBankTerm() {
            return RichObjectFactory.getDefaultOntology().getOrCreateTerm("GenBank");
        }
    }
}

