/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.bio.seq;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.biojava.bio.Annotation;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.RNATools;
import org.biojava.bio.seq.io.ParseException;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.bio.symbol.SymbolListViews;
import org.biojava.utils.AbstractChangeable;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeVetoException;
import org.biojavax.CrossRef;
import org.biojavax.CrossReferenceResolver;
import org.biojavax.Namespace;
import org.biojavax.RichAnnotation;
import org.biojavax.RichObjectFactory;
import org.biojavax.SimpleRichAnnotation;
import org.biojavax.bio.seq.CompoundRichLocation;
import org.biojavax.bio.seq.EmptyRichLocation;
import org.biojavax.bio.seq.MultiSourceCompoundRichLocation;
import org.biojavax.bio.seq.Position;
import org.biojavax.bio.seq.PositionResolver;
import org.biojavax.bio.seq.RichFeature;
import org.biojavax.bio.seq.RichLocation;
import org.biojavax.bio.seq.RichSequence;
import org.biojavax.bio.seq.SimplePosition;
import org.biojavax.bio.seq.io.GenbankLocationParser;
import org.biojavax.ontology.ComparableTerm;

public class SimpleRichLocation
extends AbstractChangeable
implements RichLocation {
    private CrossRef crossRef;
    private RichAnnotation notes = new SimpleRichAnnotation();
    protected ComparableTerm term;
    private Position min;
    private Position max;
    private PositionResolver pr = RichObjectFactory.getDefaultPositionResolver();
    private CrossReferenceResolver crr = RichObjectFactory.getDefaultCrossReferenceResolver();
    private RichLocation.Strand strand;
    private int rank;
    protected int circularLength = 0;
    private RichFeature feature;
    private Integer id;

    public SimpleRichLocation(Position pos, int rank) {
        this(pos, pos, rank, RichLocation.Strand.POSITIVE_STRAND);
    }

    public SimpleRichLocation(Position pos, int rank, RichLocation.Strand strand) {
        this(pos, pos, rank, strand, null);
    }

    public SimpleRichLocation(Position pos, int rank, RichLocation.Strand strand, CrossRef crossRef) {
        this(pos, pos, rank, strand, crossRef);
    }

    public SimpleRichLocation(Position min, Position max, int rank) {
        this(min, max, rank, RichLocation.Strand.POSITIVE_STRAND);
    }

    public SimpleRichLocation(Position min, Position max, int rank, RichLocation.Strand strand) {
        this(min, max, rank, strand, null);
    }

    public SimpleRichLocation(Position min, Position max, int rank, RichLocation.Strand strand, CrossRef crossRef) {
        this.min = min;
        this.max = max;
        this.rank = rank;
        this.strand = strand;
        this.crossRef = crossRef;
        this.feature = null;
    }

    protected SimpleRichLocation() {
    }

    public void sort() {
    }

    public RichFeature getFeature() {
        return this.feature;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFeature(RichFeature feature) throws ChangeVetoException {
        if (!this.hasListeners(RichLocation.FEATURE)) {
            this.feature = feature;
        } else {
            ChangeSupport cs;
            ChangeEvent ce = new ChangeEvent(this, RichLocation.FEATURE, feature, this.feature);
            ChangeSupport changeSupport = cs = this.getChangeSupport(RichLocation.FEATURE);
            synchronized (changeSupport) {
                cs.firePreChangeEvent(ce);
                this.feature = feature;
                cs.firePostChangeEvent(ce);
            }
        }
    }

    public CrossRef getCrossRef() {
        return this.crossRef;
    }

    protected void setCrossRef(CrossRef crossRef) {
        this.crossRef = crossRef;
    }

    public Annotation getAnnotation() {
        return this.getRichAnnotation();
    }

    public RichAnnotation getRichAnnotation() {
        return this.notes;
    }

    public Set getNoteSet() {
        return this.notes.getNoteSet();
    }

    public void setNoteSet(Set notes) throws ChangeVetoException {
        this.notes.setNoteSet(notes);
    }

    public ComparableTerm getTerm() {
        return this.term;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTerm(ComparableTerm term) throws ChangeVetoException {
        if (!this.hasListeners(RichLocation.TERM)) {
            this.term = term;
        } else {
            ChangeSupport cs;
            ChangeEvent ce = new ChangeEvent(this, RichLocation.TERM, term, this.term);
            ChangeSupport changeSupport = cs = this.getChangeSupport(RichLocation.TERM);
            synchronized (changeSupport) {
                cs.firePreChangeEvent(ce);
                this.term = term;
                cs.firePostChangeEvent(ce);
            }
        }
    }

    public int getCircularLength() {
        return this.circularLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCircularLength(int circularLength) throws ChangeVetoException {
        if (!this.hasListeners(RichLocation.CIRCULAR)) {
            this.circularLength = circularLength;
        } else {
            ChangeSupport cs;
            ChangeEvent ce = new ChangeEvent(this, RichLocation.CIRCULAR, new Integer(circularLength), new Integer(this.circularLength));
            ChangeSupport changeSupport = cs = this.getChangeSupport(RichLocation.CIRCULAR);
            synchronized (changeSupport) {
                cs.firePreChangeEvent(ce);
                this.circularLength = circularLength;
                cs.firePostChangeEvent(ce);
            }
        }
    }

    public RichLocation.Strand getStrand() {
        return this.strand;
    }

    protected void setStrand(RichLocation.Strand strand) {
        this.strand = strand;
    }

    int getStrandNum() {
        return this.strand.intValue();
    }

    void setStrandNum(int token) {
        this.strand = RichLocation.Strand.forValue(token);
    }

    public int getRank() {
        return this.rank;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRank(int rank) throws ChangeVetoException {
        if (!this.hasListeners(RichLocation.RANK)) {
            this.rank = rank;
        } else {
            ChangeSupport cs;
            ChangeEvent ce = new ChangeEvent(this, RichLocation.RANK, new Integer(rank), new Integer(this.rank));
            ChangeSupport changeSupport = cs = this.getChangeSupport(RichLocation.RANK);
            synchronized (changeSupport) {
                cs.firePreChangeEvent(ce);
                this.rank = rank;
                cs.firePostChangeEvent(ce);
            }
        }
    }

    public int getMax() {
        if (this.max.equals(this.min)) {
            return this.getMin();
        }
        return this.pr.getMax(this.max);
    }

    void setMax(int max) {
        this.max = new SimplePosition(false, false, max);
    }

    public int getMin() {
        return this.pr.getMin(this.min);
    }

    void setMin(int min) {
        this.min = new SimplePosition(false, false, min);
    }

    public Position getMinPosition() {
        return this.min;
    }

    protected void setMinPosition(Position min) {
        this.min = min;
    }

    public Position getMaxPosition() {
        return this.max;
    }

    protected void setMaxPosition(Position max) {
        this.max = max;
    }

    public void setPositionResolver(PositionResolver p) {
        this.pr = p;
    }

    public Iterator blockIterator() {
        return Collections.singleton(this).iterator();
    }

    public boolean isContiguous() {
        return true;
    }

    public boolean contains(int p) {
        int modStart = this.getMin();
        int modEnd = this.getMax();
        if (this.circularLength > 0) {
            p = RichLocation.Tools.modulateCircularIndex(p, this.circularLength);
            int[] ourModParts = RichLocation.Tools.modulateCircularLocation(modStart, modEnd, this.circularLength);
            modStart = ourModParts[0];
            modEnd = ourModParts[1];
            if (modEnd > this.circularLength && p < modStart) {
                p += this.circularLength;
            }
        }
        return p >= modStart && p <= modEnd;
    }

    public Location getDecorator(Class decoratorClass) {
        return null;
    }

    public Location newInstance(Location loc) {
        return loc;
    }

    public Location translate(int dist) {
        return new SimpleRichLocation(this.min.translate(dist), this.max.translate(dist), 0, this.strand, this.crossRef);
    }

    public boolean contains(Location l) {
        if (!(l instanceof RichLocation)) {
            l = RichLocation.Tools.enrich(l);
        }
        if (l instanceof EmptyRichLocation) {
            return false;
        }
        RichLocation rl = (RichLocation)l;
        if (!this.overlaps(rl)) {
            return false;
        }
        if (!this.getStrand().equals(rl.getStrand())) {
            return false;
        }
        if (this.circularLength > 0) {
            int[] parts = RichLocation.Tools.modulateCircularLocationPair(this, rl, this.circularLength);
            int ourModStart = parts[0];
            int ourModEnd = parts[1];
            int theirModStart = parts[2];
            int theirModEnd = parts[3];
            return ourModStart <= theirModStart && ourModEnd >= theirModEnd;
        }
        return this.getMin() <= rl.getMin() && this.getMax() >= rl.getMax();
    }

    public boolean overlaps(Location l) {
        if (!(l instanceof RichLocation)) {
            l = RichLocation.Tools.enrich(l);
        }
        if (l instanceof EmptyRichLocation) {
            return false;
        }
        if (l instanceof CompoundRichLocation) {
            return l.overlaps(this);
        }
        RichLocation rl = (RichLocation)l;
        if (rl.getCrossRef() != null || this.crossRef != null) {
            if (rl.getCrossRef() != null && this.crossRef != null) {
                if (!this.crossRef.equals(rl.getCrossRef())) {
                    return false;
                }
            } else {
                return false;
            }
        }
        if (this.circularLength != rl.getCircularLength()) {
            return false;
        }
        if (this.circularLength > 0) {
            int[] parts = RichLocation.Tools.modulateCircularLocationPair(this, rl, this.circularLength);
            int ourModStart = parts[0];
            int ourModEnd = parts[1];
            int theirModStart = parts[2];
            int theirModEnd = parts[3];
            return ourModStart <= theirModEnd && ourModEnd >= theirModStart;
        }
        return this.getMin() <= rl.getMax() && this.getMax() >= rl.getMin();
    }

    public Location union(Location l) {
        if (!(l instanceof RichLocation)) {
            l = RichLocation.Tools.enrich(l);
        }
        if (l instanceof EmptyRichLocation) {
            return this;
        }
        if (l instanceof CompoundRichLocation) {
            return l.union(this);
        }
        RichLocation rl = (RichLocation)l;
        if (this.overlaps(rl) && this.getStrand().equals(rl.getStrand())) {
            if (this.circularLength > 0) {
                int[] parts = RichLocation.Tools.modulateCircularLocationPair(this, rl, this.circularLength);
                int ourModStart = parts[0];
                int ourModEnd = parts[1];
                int theirModStart = parts[2];
                int theirModEnd = parts[3];
                Position startPos = ourModStart < theirModStart ? this.min : rl.getMinPosition();
                Position endPos = ourModEnd > theirModEnd ? this.max : rl.getMaxPosition();
                return new SimpleRichLocation(startPos, endPos, 0, this.strand, this.crossRef);
            }
            return new SimpleRichLocation(this.posmin(this.min, rl.getMinPosition()), this.posmax(this.max, rl.getMaxPosition()), 0, this.strand, this.crossRef);
        }
        ArrayList<Location> members = new ArrayList<Location>();
        members.add(this);
        members.add(l);
        if (RichLocation.Tools.isMultiSource(members)) {
            return new MultiSourceCompoundRichLocation(members);
        }
        return new CompoundRichLocation(members);
    }

    public Location intersection(Location l) {
        if (!(l instanceof RichLocation)) {
            l = RichLocation.Tools.enrich(l);
        }
        if (l instanceof EmptyRichLocation) {
            return l;
        }
        if (l instanceof CompoundRichLocation) {
            return l.intersection(this);
        }
        RichLocation rl = (RichLocation)l;
        if (this.overlaps(l)) {
            if (this.getStrand().equals(rl.getStrand())) {
                if (this.circularLength > 0) {
                    int[] parts = RichLocation.Tools.modulateCircularLocationPair(this, rl, this.circularLength);
                    int ourModStart = parts[0];
                    int ourModEnd = parts[1];
                    int theirModStart = parts[2];
                    int theirModEnd = parts[3];
                    Position startPos = ourModStart > theirModStart ? this.min : rl.getMinPosition();
                    Position endPos = ourModEnd < theirModEnd ? this.max : rl.getMaxPosition();
                    return new SimpleRichLocation(startPos, endPos, 0, this.strand, this.crossRef);
                }
                return new SimpleRichLocation(this.posmax(this.min, rl.getMinPosition()), this.posmin(this.max, rl.getMaxPosition()), 0, this.strand, this.crossRef);
            }
            ArrayList<Location> members = new ArrayList<Location>();
            members.add(new SimpleRichLocation(this.posmax(this.min, rl.getMinPosition()), this.posmin(this.max, rl.getMaxPosition()), 0, this.strand, this.crossRef));
            members.add(new SimpleRichLocation(this.posmax(this.min, rl.getMinPosition()), this.posmin(this.max, rl.getMaxPosition()), 0, rl.getStrand(), this.crossRef));
            if (RichLocation.Tools.isMultiSource(members)) {
                return new MultiSourceCompoundRichLocation(members);
            }
            return new CompoundRichLocation(members);
        }
        return RichLocation.EMPTY_LOCATION;
    }

    protected Position posmin(Position a, Position b) {
        int br;
        int ar = this.pr.getMin(a);
        if (ar <= (br = this.pr.getMin(b))) {
            return a;
        }
        return b;
    }

    protected Position posmax(Position a, Position b) {
        int br;
        int ar = this.pr.getMax(a);
        if (ar > (br = this.pr.getMax(b))) {
            return a;
        }
        return b;
    }

    public void setCrossRefResolver(CrossReferenceResolver r) {
        if (r == null) {
            throw new IllegalArgumentException("Resolver cannot be null");
        }
        this.crr = r;
    }

    public SymbolList symbols(SymbolList seq) {
        if (seq == null) {
            throw new IllegalArgumentException("Sequence cannot be null");
        }
        if (seq instanceof RichSequence) {
            RichSequence rs = (RichSequence)seq;
            if (this.getCircularLength() > 0) {
                if (!rs.getCircular()) {
                    throw new IllegalArgumentException("Attempt to apply circular location to non-circular sequence");
                }
                if (rs.length() != this.getCircularLength()) {
                    throw new IllegalArgumentException("Attempt to apply circular location to circular sequence of different length");
                }
            }
        }
        if (this.getCrossRef() != null) {
            CrossRef cr = this.getCrossRef();
            if (seq instanceof RichSequence) {
                RichSequence rs = (RichSequence)seq;
                String accession = rs.getAccession();
                Namespace ns = rs.getNamespace();
                String raccession = cr.getAccession();
                String rnamespace = cr.getDbname();
                if (!accession.equals(raccession) || !ns.getName().equals(rnamespace)) {
                    seq = this.crr.getRemoteSymbolList(cr, seq.getAlphabet());
                }
            } else {
                seq = this.crr.getRemoteSymbolList(this.getCrossRef(), seq.getAlphabet());
            }
        }
        seq = seq.subList(this.getMin(), this.getMax());
        try {
            if (this.strand == RichLocation.Strand.NEGATIVE_STRAND) {
                Alphabet a = seq.getAlphabet();
                seq = a == AlphabetManager.alphabetForName("DNA") ? DNATools.reverseComplement(seq) : (a == AlphabetManager.alphabetForName("RNA") ? RNATools.reverseComplement(seq) : SymbolListViews.reverse(seq));
            }
        }
        catch (IllegalAlphabetException e) {
            IllegalArgumentException ex = new IllegalArgumentException("Could not understand alphabet of passed sequence");
            ex.initCause(e);
            throw ex;
        }
        return seq;
    }

    public int hashCode() {
        int code = 17;
        if (this.strand == null) {
            return code;
        }
        if (this.term != null) {
            code = 31 * code + this.term.hashCode();
        }
        code = 31 * code + this.getMin();
        code = 31 * code + this.getMax();
        code = 31 * code + this.strand.hashCode();
        code = 31 * code + this.rank;
        if (this.crossRef != null) {
            code = 31 * code + this.crossRef.hashCode();
        }
        return code;
    }

    public boolean equals(Object o) {
        if (!(o instanceof RichLocation)) {
            return false;
        }
        if (this.strand == null) {
            return false;
        }
        RichLocation fo = (RichLocation)o;
        if (this.term != null || fo.getTerm() != null) {
            if (this.term != null && fo.getTerm() != null) {
                if (!this.term.equals(fo.getTerm())) {
                    return false;
                }
            } else {
                return false;
            }
        }
        if (this.getMin() != fo.getMin()) {
            return false;
        }
        if (this.getMax() != fo.getMax()) {
            return false;
        }
        if (!this.strand.equals(fo.getStrand())) {
            return false;
        }
        if (this.crossRef != null || fo.getCrossRef() != null) {
            if (this.crossRef != null && fo.getCrossRef() != null) {
                if (!this.crossRef.equals(fo.getCrossRef())) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return this.rank == fo.getRank();
    }

    public int compareTo(Object o) {
        if (o == this) {
            return 0;
        }
        if (this.strand == null) {
            return -1;
        }
        if (!(o instanceof RichLocation)) {
            return -1;
        }
        RichLocation fo = (RichLocation)o;
        if (this.rank != fo.getRank()) {
            return this.rank - fo.getRank();
        }
        if (this.crossRef != null || fo.getCrossRef() != null) {
            if (this.crossRef != null && fo.getCrossRef() != null) {
                return this.crossRef.compareTo(fo.getCrossRef());
            }
            return -1;
        }
        if (!this.strand.equals(fo.getStrand())) {
            return this.strand.compareTo(fo.getStrand());
        }
        if (this.term != null || fo.getTerm() != null) {
            if (this.term != null && fo.getTerm() != null && !this.term.equals(fo.getTerm())) {
                return this.term.compareTo(fo.getTerm());
            }
            return -1;
        }
        if (this.getMin() != fo.getMin()) {
            return this.getMin() - fo.getMin();
        }
        return this.getMax() - fo.getMax();
    }

    public String toString() {
        if (this.max.equals(this.min)) {
            return this.min.toString();
        }
        return this.min + ".." + this.max;
    }

    void setLocationText(String theLocation) throws ParseException {
        if (theLocation == null) {
            this.setMinPosition(RichLocation.EMPTY_LOCATION.getMinPosition());
            this.setMaxPosition(RichLocation.EMPTY_LOCATION.getMaxPosition());
        } else {
            RichLocation location = GenbankLocationParser.parseLocation(RichObjectFactory.getDefaultNamespace(), null, theLocation);
            this.setMinPosition(location.getMinPosition());
            this.setMaxPosition(location.getMaxPosition());
        }
    }

    String getLocationText() {
        return GenbankLocationParser.writeLocation(new SimpleRichLocation(this.getMinPosition(), this.getMaxPosition(), this.getRank()));
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }
}

